/*
This is a class file for segatex_cui1.7.0
Copyright(C)Shintaro Fujiwara.All rights reserved.
This code is dedicated to my daughter,mone.
*/

#ifndef __SEGATE_H
#define __SEGATE_H

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#include <iostream>
#include <fstream>
#include <string.h>
#include <vector>
#include <algorithm>
#include <map>
#include <boost/regex.hpp>
#include <selinux/selinux.h>
/*for Solve_problem()*/
#include <sys/io.h>
#include <boost/tokenizer.hpp>

/*These should be globals.*/

const int MAX_LOG = 8460;
const int PS_SIZE = 28460;

using namespace std;
using namespace boost;

class Segate
{
protected:
        const char* message;
public:
	Segate()
	{
		message = "This is segate.";
	}
	~Segate()
	{
		if(message){
			delete message;
		}
	}
        const char* GetMessage(){return message;}
        void SetMessage(const char* a){message = a;}
	virtual void se_on() = 0;
};

class ShowMacro:public Segate
{
public:
	ShowMacro(){};
	virtual ~ShowMacro(){};
	virtual void se_on();
};

class SolveProblem:public Segate
{
public:
	SolveProblem(){};
	virtual ~SolveProblem(){};
	virtual void se_on();
};

void ShowMacro::se_on()
{
        const char* filename="/var/log/audit/audit.log";
        const char* filename_new="./segatex_audit_denied.log";
        const char* filename_policy="./segatex_policy";
        const char* filename_policy_macro="./segatex_policy_macro";

        ifstream is;
        char buffer_c[MAX_LOG];
        is.open(filename);
	if(!is.getline(buffer_c, sizeof buffer_c)){
		cout << "no-data" << endl;
		is.close();
	}
        if(is)
        {
                vector<string> v2;
                vector<string>::iterator p2_v, p2_v_end;
	  	multimap<string ,string>::iterator p2,p2_end;
		multimap<string ,string>::iterator p2_m,p2_m_end;

                ofstream os;
                os.open(filename_new);
                ofstream os_policy;
                os_policy.open(filename_policy);
                if((os_policy)&&(os))
                {
                        char buffer[MAX_LOG];
                        const char* words="denied";
                        vector<string> v;
                        vector<string>::iterator p, p_end;


                        while(is.getline(buffer, sizeof buffer))
                        {
                                if(strstr(buffer,words)){
                                        os << buffer << endl;
                                        v.push_back(buffer);
                                }
				if(!os)
				break;
                        }
                        os.close();
                        const char* den = "denied";
                        //const char* dom = "r:([^[:space:]]*)([:space:])?";
                        const char* dom = "r:([^[:space:]]*)_t?";
/*first type(ordinary)*/
//type=AVC msg=audit(1141561509.988:974): avc:  denied  { search } for  pid=3404 comm="httpd" name="policy" dev=dm-0 ino=7734210 scontext=root:system_r:httpd_t tcontext=system_u:object_r:policy_src_t tclass=dir

/*second type(rare)*/
//type=AVC msg=audit(1141561510.376:975): avc:  denied  { execmem } for  pid=3407 comm="httpd" scontext=root:system_r:httpd_t tcontext=root:system_r:httpd_t tclass=process
/*second2 type(very rare)*/
//type=AVC msg=audit(1141561510.376:975): avc:  denied  { execmem } for  pid=3407 comm="httpd" scontext=system_u:system_r:httpd_t tcontext=root:system_r:httpd_t tclass=process
                        //const char* res = "object_r([^[:space:]]*)([:space:])?";//for first type
                        const char* res = "object_r([^[:space:]]*)_t?";//for first type
                        //const char* res2 = "tcontext=root:system_r:([^[:space:]]*)([:space:])?";//for second type
                        const char* res2 = "tcontext=root:system_r:([^[:space:]]*)_t?";//for second type
                        //const char* res3 = "tcontext=system_u:system_r:([^[:space:]]*)([:space:])?";//for second2 type
                        const char* res3 = "tcontext=system_u:system_r:([^[:space:]]*)_t?";//for second2 type
                        const char* objc = "tclass(.*)";
                        const char* acc = "\\{(.*)\\}";
                        regex denied_exp(den);
                        regex domain_exp(dom);
                        regex resource_exp(res);
                        regex resource_exp2(res2);
                        regex resource_exp3(res3);
                        regex object_class_exp(objc);
                        regex access_vector_exp(acc);

                        string policy_selinux = "";
                        string allow_pre = "allow";
                        string blank_w = " ";
                        string colon = ":";
                        string semicolon = ";";
                        string domain = "";
                        string resource = "";
                        string object_class = "";
                        string access_vector = "";
			multimap<string, string>macro_pre;

                        for(p=v.begin(); p<v.end();p++){
                                string source_ready = *p;
                                const char* source = source_ready.c_str();
                        	resource = "";
                                cmatch what;
                                if(regex_search(source,what,denied_exp)){
                                        if(regex_search(source,what,domain_exp)){
                                                domain = what[0];
                                                domain = domain.substr(2);
                                        }
					//check for second type and next first
                                        if(regex_search(source,what,resource_exp3)){
                                                resource = what[0];
                                                resource = resource.substr(27);
                                        }else{
                                        	if(regex_search(source,what,resource_exp2)){
                                                	resource = what[0];
                                                	resource = resource.substr(23);
						}
                                        	if(regex_search(source,what,resource_exp)){
                                                	resource = what[0];
                                                	resource = resource.substr(9);
                                        	}
					}
                                        if(regex_search(source,what,object_class_exp)){
                                                object_class = what[0];
                                                object_class = object_class.substr(7);
                                        }
                                        if(regex_search(source,what,access_vector_exp)){
                                                access_vector = what[0];
                                        }
                                        policy_selinux = allow_pre + blank_w +
                                                domain + blank_w + resource + colon + object_class + blank_w + access_vector;
                                        v2.push_back(policy_selinux.c_str());
	                          }
                        }
                        sort(v2.begin(),v2.end());
                        p2_v_end = unique(v2.begin(),v2.end());
			const char* m_pre = "(.*):([^[:space:]]*)([:space:])?";
                        const char* m_acc = "\\{(.*)\\}";
			const char* m_blank = "[a-z](.*)[a-z]";
			regex m_pre_exp(m_pre);
                        regex m_access_vector_exp(m_acc);
                        regex m_blank_exp(m_blank);
			string source_macro_pre="";
                        string access_vector_m = "";
                        string blank_m = "";
			for(p2_v=v2.begin();p2_v<p2_v_end;p2_v++){
				string source_macro = *p2_v;
				const char* source_m = source_macro.c_str();
				cmatch what;
				if(regex_search(source_m,what,m_pre_exp)){
					source_macro_pre  = what[0];
				} 
				if(regex_search(source_m,what,m_access_vector_exp)){
					access_vector_m  = what[0];
				}
				if(regex_search(access_vector_m.c_str(),what,m_blank_exp)){
					blank_m  = what[0];
				} 
				macro_pre.insert(pair<string, string>(source_macro_pre, blank_m));					
			}
			p2=macro_pre.begin();
			p2_end =macro_pre.end();
			string p2_tmp="";
			do{
				p2_m = macro_pre.find(p2->first);
				if(p2_tmp==p2->first){
					os_policy << " " << p2->second;
				}else{
					if(p2 !=macro_pre.begin()){
						os_policy << " };" <<endl;
					}
					os_policy << p2_m->first << " { " <<p2->second ;
				}
				p2_tmp=p2->first;
				p2++;
			}while(p2 != p2_end);
			is.close();
			os_policy << " };" ;
			os_policy.close();
		}
        	ifstream is_policy;
        	is_policy.open(filename_policy);
        	if(is_policy){
                	ofstream os_policy_macro;
                	os_policy_macro.open(filename_policy_macro);
                	if(os_policy_macro){
				char buffer2[MAX_LOG];
                		vector<string> v3;
                		vector<string>::iterator p3_v, p3_v_end;
	  			multimap<string ,string>::iterator p3,p3_end;
				multimap<string ,string>::iterator p3_m,p3_m_end;

				while (is_policy.getline(buffer2,sizeof buffer2)) {
					os_policy_macro << buffer2 << endl;
                                        v3.push_back(buffer2);
				}
				//generating macro in a very primitive way

                        	sort(v3.begin(),v3.end());
				p3_v_end = unique(v3.begin(),v3.end());
				const char* m_pre2 = "(.*)\\_t:";
                        	const char* m_acc2 = ":(.*)\\{(.*)\\}";
				const char* m_blank2 = "[a-z](.*)[a-z]";
				regex m_pre_exp2(m_pre2);
                        	regex m_access_vector_exp2(m_acc2);
                        	regex m_blank_exp2(m_blank2);
				string source_macro_pre2="";
                        	string access_vector_m2 = "";
                        	string blank_m2 = "";
				multimap<string, string>macro_pre2;
				for(p3_v=v3.begin();p3_v<p3_v_end;p3_v++){
					string source_macro2 = *p3_v;
					const char* source_m2 = source_macro2.c_str();
					cmatch what;
					if(regex_search(source_m2,what,m_pre_exp2)){
						source_macro_pre2  = what[0];
					} 
					if(regex_search(source_m2,what,m_access_vector_exp2)){
						access_vector_m2  = what[0];
                                                access_vector_m2 = access_vector_m2.substr(1);
					}
					if(regex_search(access_vector_m2.c_str(),what,m_blank_exp2)){
						blank_m2  = what[0];
					} 
					macro_pre2.insert(pair<string, string>(source_macro_pre2, access_vector_m2));	
				}
/*
define(`r_dir_perms', `{ read getattr lock search ioctl }')
define(`rw_dir_perms', `{ read getattr lock search ioctl add_name remove_name write }')
define(`ra_dir_perms', `{ read getattr lock search ioctl add_name write }')
define(`create_dir_perms', `{ create read getattr lock setattr ioctl link unlink rename search add_name remove_name reparent write rmdir }')
*/
/*
define(`stat_file_perms', `{ getattr }')
define(`x_file_perms', `{ getattr execute }')
define(`r_file_perms', `{ read getattr lock ioctl }')
define(`rx_file_perms', `{ read getattr lock execute ioctl }')
define(`rw_file_perms', `{ ioctl read getattr lock write append }')
define(`ra_file_perms', `{ ioctl read getattr lock append }')
define(`link_file_perms', `{ getattr link unlink rename }')
define(`create_file_perms', `{ create ioctl read getattr lock write setattr append link unlink rename }')
*/
/*
define(`mount_fs_perms', `{ mount remount unmount getattr }')
*/
/*
define(`socket_class_set', `{ tcp_socket udp_socket rawip_socket netlink_socket packet_socket unix_stream_socket unix_dgram_socket netlink_route_socket netlink_firewall_socket netlink_tcpdiag_socket netlink_nflog_socket netlink_xfrm_socket netlink_selinux_socket netlink_audit_socket netlink_ip6fw_socket netlink_dnrt_socket netlink_kobject_uevent_socket }')
define(`dgram_socket_class_set', `{ udp_socket unix_dgram_socket }')
define(`stream_socket_class_set', `{ tcp_socket unix_stream_socket }')
define(`unpriv_socket_class_set', `{ tcp_socket udp_socket unix_stream_socket unix_dgram_socket }')
define(`rw_socket_perms', `{ ioctl read getattr write setattr append bind connect getopt setopt shutdown }')
define(`create_socket_perms', `{ create rw_socket_perms }')
define(`rw_stream_socket_perms', `{ rw_socket_perms listen accept }')
define(`create_stream_socket_perms', `{ create_socket_perms listen accept }')
define(`connected_socket_perms', `{ create ioctl read getattr write setattr append bind getopt setopt shutdown }')
define(`connected_stream_socket_perms', `{ connected_socket_perms listen accept }')
define(`create_netlink_socket_perms', `{ create_socket_perms nlmsg_read nlmsg_write }')
define(`rw_netlink_socket_perms', `{ create_socket_perms nlmsg_read nlmsg_write }')
define(`r_netlink_socket_perms', `{ create_socket_perms nlmsg_read }')
*/
/*
define(`r_sem_perms', `{ associate getattr read unix_read }')
define(`rw_sem_perms', `{ associate getattr read write unix_read unix_write }')
define(`create_sem_perms', `{ associate getattr setattr create destroy read write unix_read unix_write }')
define(`r_msgq_perms', `{ associate getattr read unix_read }')
define(`rw_msgq_perms', `{ associate getattr read write enqueue unix_read unix_write }')
define(`create_msgq_perms', `{ associate getattr setattr create destroy read write enqueue unix_read unix_write }')
define(`r_shm_perms', `{ associate getattr read unix_read }')
define(`rw_shm_perms', `{ associate getattr read write lock unix_read unix_write }')
define(`create_shm_perms', `{ associate getattr setattr create destroy read write lock unix_read unix_write }')
*/


				p3=macro_pre2.begin();
				p3_end =macro_pre2.end();
				string p3_tmp="";
/* define object_classes for regex */
//dir
				const char* dir_mac = "\\<dir";
//file
				const char* file_mac = "\\<file";
				const char* chr_file_mac = "\\<chr_file";
				const char* blk_file_mac = "\\<blk_file";
				const char* lnk_file_mac = "\\<lnk_file";
				const char* sock_file_mac = "\\<sock_file";
				const char* fifo_file_mac = "\\<fifo_file";
//filesystem
				const char* filesystem_mac = "\\<filesystem";
//socket
				const char* tcp_socket_mac= "\\<tcp_socket";
				const char* udp_socket_mac= "\\<udp_socket";
				const char* rawip_socket_mac= "\\<rawip_socket";
				const char* netlink_socket_mac= "\\<netlink_socket";
				const char* packet_socket_mac= "\\<packet_socket";
				const char* unix_stream_socket_mac= "\\<unix_stream_socket";
				const char* unix_dgram_socket_mac= "\\<unix_dgram_socket";
				const char* netlink_route_socket_mac= "\\<netlink_route_socket";
				const char* netlink_firewall_socket_mac= "\\<netlink_firewall_socket";
				const char* netlink_tcpdiag_socket_mac= "\\<netlink_tcpdiag_socket";
				const char* netlink_nflog_socket_mac= "\\<netlink_nflog_socket";
				const char* netlink_xfrm_socket_mac= "\\<netlink_xfrm_socket";
				const char* netlink_selinux_socket_mac= "\\<netlink_selinux_socket";
				const char* netlink_audit_socket_mac= "\\<netlink_audit_socket";
				const char* netlink_ip6fw_socket_mac= "\\<netlink_ip6fw_socket";
				const char* netlink_dnrt_socket_mac= "\\<netlink_dnrt_socket";
				const char* netlink_kobject_uevent_socket_mac= "\\<netlink_kobject_uevent_socket";
//process
                                const char* sem_mac= "\\<sem";
                                const char* msgq_mac= "\\<msgq";
                                const char* shm_mac= "\\<shm";

/* define access_vectors for regex each should be unieque */
//for dir
				const char* create_mac = "create ";
				const char* create_mac2 = "link ";
				const char* create_mac3 = "unlink ";
				const char* create_mac4 = "rename ";
				const char* create_mac5 = "reparent ";
				const char* create_mac6 = "rmdir ";
				const char* rw_mac = "remove_name ";
				const char* ra_mac = "write ";
				const char* ra_mac2 = "add_name ";
				const char* r_mac = "read ";
//for file
				const char* create_macf = "lock ";
				const char* create_macf2 = "setattr ";
				const char* create_macf3 = "create ";
				const char* link_macf = "link ";
				const char* link_macf2 = "unlink ";
				const char* link_macf3 = "rename ";
				const char* rw_macf = "write ";
				const char* x_macf = "execute ";
				const char* ra_macf = "append ";
				const char* r_macf = "read ";
				const char* stat_macf = "getattr ";
//for filesystem
				const char* mount_fs_macfs = "mount ";
				const char* mount_fs_macfs2 = "remount ";
				const char* mount_fs_macfs3 = "unmount ";
//for sockets
				const char* bind_socket_mac = "bind ";
				const char* connect_socket_mac = "connect ";
				const char* getopt_socket_mac = "getopt ";
				const char* setopt_socket_mac = "setopt ";
				const char* shutdown_socket_mac = "shutdown ";
				const char* listen_stream_socket_mac = "listen ";
				const char* accept_stream_socket_mac = "accept ";
				const char* nlmsg_read_netlink_socket_mac = "nlmsg_read ";
				const char* nlmsg_write_netlink_socket_mac = "nlmsg_write ";
//for process
                                const char* destroy_mac = "destroy ";
                                const char* associate_mac = "associate ";
                                const char* unix_write_mac = "unix_write ";
                                const char* unix_read_mac = "unix_read ";

/* defining regex both object_classes and access_vectors */
//regex for dir
				regex m_dir_exp(dir_mac);
//regex for file
				regex m_file_exp(file_mac);
				regex m_chr_file_exp(chr_file_mac);
				regex m_blk_file_exp(blk_file_mac);
				regex m_lnk_file_exp(lnk_file_mac);
				regex m_sock_file_exp(sock_file_mac);
				regex m_fifo_file_exp(fifo_file_mac);
//regex for filesystem
				regex m_filesystem_exp(filesystem_mac);
//regex for socket
				regex m_tcp_socket_exp(tcp_socket_mac);
				regex m_udp_socket_exp(udp_socket_mac);
				regex m_rawip_socket_exp(rawip_socket_mac);
				regex m_netlink_socket_exp(netlink_socket_mac);
				regex m_packet_socket_exp(packet_socket_mac);
				regex m_unix_stream_socket_exp(unix_stream_socket_mac);
				regex m_unix_dgram_socket_exp(unix_dgram_socket_mac);
				regex m_netlink_route_socket_exp(netlink_route_socket_mac);
				regex m_netlink_firewall_socket_exp(netlink_firewall_socket_mac);
				regex m_netlink_tcpdiag_socket_exp(netlink_tcpdiag_socket_mac);
				regex m_netlink_nflog_socket_exp(netlink_nflog_socket_mac);
				regex m_netlink_xfrm_socket_exp(netlink_xfrm_socket_mac);
				regex m_netlink_selinux_socket_exp(netlink_selinux_socket_mac);
				regex m_netlink_audit_socket_exp(netlink_audit_socket_mac);
				regex m_netlink_ip6fw_socket_exp(netlink_ip6fw_socket_mac);
				regex m_netlink_dnrt_socket_exp(netlink_dnrt_socket_mac);
				regex m_netlink_kobject_uevent_socket_exp(netlink_kobject_uevent_socket_mac);
//regex for process
                                regex sem_exp(sem_mac);
                                regex msgq_exp(msgq_mac);
                                regex shm_exp(shm_mac);

//regex for access_vectors
	//for dir
				regex m_create_exp(create_mac);
				regex m_create_exp2(create_mac2);
				regex m_create_exp3(create_mac3);
				regex m_create_exp4(create_mac4);
				regex m_create_exp5(create_mac5);
				regex m_create_exp6(create_mac6);
				regex m_rw_exp(rw_mac);
				regex m_ra_exp(ra_mac);
				regex m_ra_exp2(ra_mac2);
				regex m_r_exp(r_mac);
	//for file
				regex mf_create_exp(create_macf);
				regex mf_create_exp2(create_macf2);
				regex mf_create_exp3(create_macf3);
				regex mf_link_exp(link_macf);
				regex mf_link_exp2(link_macf2);
				regex mf_link_exp3(link_macf3);
				regex mf_x_exp(x_macf);
				regex mf_rw_exp(rw_macf);
				regex mf_ra_exp(ra_macf);
				regex mf_r_exp(r_macf);
				regex mf_stat_exp(stat_macf);
	//for filesystem
				regex mfs_mount_fs_exp(mount_fs_macfs);
				regex mfs_mount_fs_exp2(mount_fs_macfs2);
				regex mfs_mount_fs_exp3(mount_fs_macfs3);
	//for sockets
				regex msoc_bind_exp(bind_socket_mac);
				regex msoc_connect_exp(connect_socket_mac);
				regex msoc_getopt_exp(getopt_socket_mac);
				regex msoc_setopt_exp(setopt_socket_mac);
				regex msoc_shutdown_exp(shutdown_socket_mac);
				regex msoc_listen_stream_exp(listen_stream_socket_mac);
				regex msoc_accept_stream_exp(accept_stream_socket_mac);
				regex msoc_nlmsg_read_exp(nlmsg_read_netlink_socket_mac);
				regex msoc_nlmsg_write_exp(nlmsg_write_netlink_socket_mac);
        //for process
                                regex mproc_destroy_exp(destroy_mac);
                                regex mproc_associate_exp(associate_mac);
                                regex mproc_unix_write_exp(unix_write_mac);
                                regex mproc_unix_read_exp(unix_read_mac);

/* I'm trying to generate macros in this manner */
				//dir { link||unlink||rename||reparent||rmdir||create }::dir create_dir_perms;
				//dir { remove_name }::dir rw_dir_perms;
				//dir { write }::dir ra_dir_perms;
				//dir { add_name }::dir ra_dir_perms;
				//dir { read }::dir r_dir_perms;
				//file same as chr_file,blk_file,lnk_file,sock_file,fifo_file
				//file { create||setattr||lock }::file create_file_perms;
				//file { link||unlink||rename }::file link_file_perms;
				//file { read&&execute }::file rx_file_perms;
				//file { execute }::file x_file_perms;
				//file { write }::file rw_file_perms;
				//file { append }::file ra_file_perms;
				//file { read }::file r_file_perms;
				//file { getattr }::file stat_file_perms;
				//filesystem { getattr||mount||remount||unmount }::filesystem mount_fs_perms;
				//tcp_socket same as udp_socket, rawip_socket,netlink_socket packet_socket,unix_stream_socket,unix_dgram_socket,netlink_route_socket,netlink_firewall_socket,netlink_tcpdiag_socket,netlink_nflog_socket,netlink_xfrm_socket,netlink_selinux_socket,netlink_audit_socket,netlink_ip6fw_socket,netlink_dnrt_socket,netlink_kobject_uevent_socket 
				//tcp_socket { create&&(listen||accept)}::tcp_socket create_stream_socket_perms;
				//tcp_socket { create }::tcp_socket create_socket_perms;
				//tcp_socket { connect }::tcp_socket rw_socket_perms;
				//tcp_socket { (listen||accept)&&(read||write||setattr||append||bind||getopt||setopt||shutdown) }::tcp_socket connected_stream_socket_perms;
				//tcp_socket { read||write||setattr||append||bind||getopt||setopt||shutdown }::tcp_socket connected_socket_perms;
				//tcp_socket { nlmsg_write }::tcp_socket rw_netlink_socket_perms;
				//tcp_socket { nlmsg_read }::tcp_socket r_netlink_socket_perms;
                                //sem same as msgq, shm
                                //sem { create||destroy }::sem create_sem_perms;
                                //sem { write||unix_write }::sem rw_sem_perms;
                                //sem { associate||getattr||read||unix_read }::sem r_sem_perms;

/* let's generate macros using regex above defined */
				do{
					if(p3_tmp != p3->first){
						p3_m = macro_pre2.find(p3->first);
						do{
							os_policy_macro << p3_m->first;
							cout << p3_m->first;
							string macro_d = p3_m->second;
							const char* source_macro_d = macro_d.c_str();
							cmatch what;
							if(regex_search(source_macro_d,what,m_dir_exp)&&
							(regex_search(source_macro_d,what,m_create_exp)||regex_search(source_macro_d,what,m_create_exp2)||
							regex_search(source_macro_d,what,m_create_exp3)||regex_search(source_macro_d,what,m_create_exp4)||
							regex_search(source_macro_d,what,m_create_exp5)||regex_search(source_macro_d,what,m_create_exp6)||
							regex_search(source_macro_d,what,mf_create_exp2)
							)){
								os_policy_macro << "dir create_dir_perms";
								cout << "dir create_dir_perms";
							}
							else if(regex_search(source_macro_d,what,m_dir_exp)&&
							regex_search(source_macro_d,what,m_rw_exp)
							){
								os_policy_macro << "dir rw_dir_perms";
								cout << "dir rw_dir_perms";
							}
							else if(regex_search(source_macro_d,what,m_dir_exp)&&
							(regex_search(source_macro_d,what,m_ra_exp)||regex_search(source_macro_d,what,m_ra_exp2)
							)){
								os_policy_macro << "dir ra_dir_perms";
								cout << "dir ra_dir_perms";
							}
							else if(regex_search(source_macro_d,what,m_dir_exp)&&
							regex_search(source_macro_d,what,m_r_exp)
							){
								os_policy_macro << "dir r_dir_perms";
								cout << "dir r_dir_perms";
							}
							else if(regex_search(source_macro_d,what,m_file_exp)&&(
							regex_search(source_macro_d,what,mf_create_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_create_exp3)
							)){
								os_policy_macro << "file create_file_perms";
								cout << "file create_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_file_exp)&&(
							regex_search(source_macro_d,what,mf_link_exp)||
							regex_search(source_macro_d,what,mf_link_exp2)||
							regex_search(source_macro_d,what,mf_link_exp3)
							)){
								os_policy_macro << "file link_file_perms";
								cout << "file link_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_file_exp)&&
							regex_search(source_macro_d,what,mf_r_exp)&&regex_search(source_macro_d,what,mf_x_exp)
							){
								os_policy_macro << "file rx_file_perms";
								cout << "file rx_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_file_exp)&&
							regex_search(source_macro_d,what,mf_x_exp)
							){
								os_policy_macro << "file x_file_perms";
								cout << "file x_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_file_exp)&&
							regex_search(source_macro_d,what,mf_rw_exp)
							){
								os_policy_macro << "file rw_file_perms";
								cout << "file rw_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_file_exp)&&
							regex_search(source_macro_d,what,mf_ra_exp)
							){
								os_policy_macro << "file ra_file_perms";
								cout << "file ra_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_file_exp)&&
							regex_search(source_macro_d,what,mf_r_exp)
							){
								os_policy_macro << "file r_file_perms";
								cout << "file r_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_file_exp)&&
							regex_search(source_macro_d,what,mf_stat_exp)
							){
								os_policy_macro << "file stat_file_perms";
								cout << "file stat_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_chr_file_exp)&&(
							regex_search(source_macro_d,what,mf_create_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_create_exp3)
							)){
								os_policy_macro << "chr_file create_file_perms";
								cout << "chr_file create_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_chr_file_exp)&&(
							regex_search(source_macro_d,what,mf_link_exp)||
							regex_search(source_macro_d,what,mf_link_exp2)||
							regex_search(source_macro_d,what,mf_link_exp3)
							)){
								os_policy_macro << "chr_file link_file_perms";
								cout << "chr_file link_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_chr_file_exp)&&
							regex_search(source_macro_d,what,mf_r_exp)&&regex_search(source_macro_d,what,mf_x_exp)
							){
								os_policy_macro << "chr_file rx_file_perms";
								cout << "chr_file rx_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_chr_file_exp)&&
							regex_search(source_macro_d,what,mf_x_exp)
							){
								os_policy_macro << "chr_file x_file_perms";
								cout << "chr_file x_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_chr_file_exp)&&
							regex_search(source_macro_d,what,mf_rw_exp)
							){
								os_policy_macro << "chr_file rw_file_perms";
								cout << "chr_file rw_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_chr_file_exp)&&
							regex_search(source_macro_d,what,mf_ra_exp)
							){
								os_policy_macro << "chr_file ra_file_perms";
								cout << "chr_file ra_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_chr_file_exp)&&
							regex_search(source_macro_d,what,mf_r_exp)
							){
								os_policy_macro << "chr_file r_file_perms";
								cout << "chr_file r_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_chr_file_exp)&&
							regex_search(source_macro_d,what,mf_stat_exp)
							){
								os_policy_macro << "chr_file stat_file_perms";
								cout << "chr_file stat_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_blk_file_exp)&&(
							regex_search(source_macro_d,what,mf_create_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_create_exp3)
							)){
								os_policy_macro << "blk_file create_file_perms";
								cout << "blk_file create_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_blk_file_exp)&&(
							regex_search(source_macro_d,what,mf_link_exp)||
							regex_search(source_macro_d,what,mf_link_exp2)||
							regex_search(source_macro_d,what,mf_link_exp3)
							)){
								os_policy_macro << "blk_file link_file_perms";
								cout << "blk_file link_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_blk_file_exp)&&
							regex_search(source_macro_d,what,mf_r_exp)&&regex_search(source_macro_d,what,mf_x_exp)
							){
								os_policy_macro << "blk_file rx_file_perms";
								cout << "blk_file rx_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_blk_file_exp)&&
							regex_search(source_macro_d,what,mf_x_exp)
							){
								os_policy_macro << "blk_file x_file_perms";
								cout << "blk_file x_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_blk_file_exp)&&
							regex_search(source_macro_d,what,mf_rw_exp)
							){
								os_policy_macro << "blk_file rw_file_perms";
								cout << "blk_file rw_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_blk_file_exp)&&
							regex_search(source_macro_d,what,mf_ra_exp)
							){
								os_policy_macro << "blk_file ra_file_perms";
								cout << "blk_file ra_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_blk_file_exp)&&
							regex_search(source_macro_d,what,mf_r_exp)
							){
								os_policy_macro << "blk_file r_file_perms";
								cout << "blk_file r_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_blk_file_exp)&&
							regex_search(source_macro_d,what,mf_stat_exp)
							){
								os_policy_macro << "blk_file stat_file_perms";
								cout << "blk_file stat_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_lnk_file_exp)&&(
							regex_search(source_macro_d,what,mf_create_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_create_exp3)
							)){
								os_policy_macro << "lnk_file create_file_perms";
								cout << "lnk_file create_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_lnk_file_exp)&&(
							regex_search(source_macro_d,what,mf_link_exp)||
							regex_search(source_macro_d,what,mf_link_exp2)||
							regex_search(source_macro_d,what,mf_link_exp3)
							)){
								os_policy_macro << "lnk_file link_file_perms";
								cout << "lnk_file link_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_lnk_file_exp)&&
							regex_search(source_macro_d,what,mf_r_exp)&&regex_search(source_macro_d,what,mf_x_exp)
							){
								os_policy_macro << "lnk_file rx_file_perms";
								cout << "lnk_file rx_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_lnk_file_exp)&&
							regex_search(source_macro_d,what,mf_x_exp)
							){
								os_policy_macro << "lnk_file x_file_perms";
								cout << "lnk_file x_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_lnk_file_exp)&&
							regex_search(source_macro_d,what,mf_rw_exp)
							){
								os_policy_macro << "lnk_file rw_file_perms";
								cout << "lnk_file rw_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_lnk_file_exp)&&
							regex_search(source_macro_d,what,mf_ra_exp)
							){
								os_policy_macro << "lnk_file ra_file_perms";
								cout << "lnk_file ra_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_lnk_file_exp)&&
							regex_search(source_macro_d,what,mf_r_exp)
							){
								os_policy_macro << "lnk_file r_file_perms";
								cout << "lnk_file r_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_lnk_file_exp)&&
							regex_search(source_macro_d,what,mf_stat_exp)
							){
								os_policy_macro << "lnk_file stat_file_perms";
								cout << "lnk_file stat_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_sock_file_exp)&&(
							regex_search(source_macro_d,what,mf_create_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_create_exp3)
							)){
								os_policy_macro << "sock_file create_file_perms";
								cout << "sock_file create_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_sock_file_exp)&&(
							regex_search(source_macro_d,what,mf_link_exp)||
							regex_search(source_macro_d,what,mf_link_exp2)||
							regex_search(source_macro_d,what,mf_link_exp3)
							)){
								os_policy_macro << "sock_file link_file_perms";
								cout << "sock_file link_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_sock_file_exp)&&
							regex_search(source_macro_d,what,mf_r_exp)&&regex_search(source_macro_d,what,mf_x_exp)
							){
								os_policy_macro << "sock_file rx_file_perms";
								cout << "sock_file rx_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_sock_file_exp)&&
							regex_search(source_macro_d,what,mf_x_exp)
							){
								os_policy_macro << "sock_file x_file_perms";
								cout << "sock_file x_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_sock_file_exp)&&
							regex_search(source_macro_d,what,mf_rw_exp)
							){
								os_policy_macro << "sock_file rw_file_perms";
								cout << "sock_file rw_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_sock_file_exp)&&
							regex_search(source_macro_d,what,mf_ra_exp)
							){
								os_policy_macro << "sock_file ra_file_perms";
								cout << "sock_file ra_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_sock_file_exp)&&
							regex_search(source_macro_d,what,mf_r_exp)
							){
								os_policy_macro << "sock_file r_file_perms";
								cout << "sock_file r_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_sock_file_exp)&&
							regex_search(source_macro_d,what,mf_stat_exp)
							){
								os_policy_macro << "sock_file stat_file_perms";
								cout << "sock_file stat_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_fifo_file_exp)&&(
							regex_search(source_macro_d,what,mf_create_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_create_exp3)
							)){
								os_policy_macro << "fifo_file create_file_perms";
								cout << "fifo_file create_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_fifo_file_exp)&&(
							regex_search(source_macro_d,what,mf_link_exp)||
							regex_search(source_macro_d,what,mf_link_exp2)||
							regex_search(source_macro_d,what,mf_link_exp3)
							)){
								os_policy_macro << "fifo_file link_file_perms";
								cout << "fifo_file link_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_fifo_file_exp)&&
							regex_search(source_macro_d,what,mf_r_exp)&&regex_search(source_macro_d,what,mf_x_exp)
							){
								os_policy_macro << "fifo_file rx_file_perms";
								cout << "fifo_file rx_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_fifo_file_exp)&&
							regex_search(source_macro_d,what,mf_x_exp)
							){
								os_policy_macro << "fifo_file x_file_perms";
								cout << "fifo_file x_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_fifo_file_exp)&&
							regex_search(source_macro_d,what,mf_rw_exp)
							){
								os_policy_macro << "fifo_file rw_file_perms";
								cout << "fifo_file rw_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_fifo_file_exp)&&
							regex_search(source_macro_d,what,mf_ra_exp)
							){
								os_policy_macro << "fifo_file ra_file_perms";
								cout << "fifo_file ra_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_fifo_file_exp)&&
							regex_search(source_macro_d,what,mf_r_exp)
							){
								os_policy_macro << "fifo_file r_file_perms";
								cout << "fifo_file r_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_fifo_file_exp)&&
							regex_search(source_macro_d,what,mf_stat_exp)
							){
								os_policy_macro << "fifo_file stat_file_perms";
								cout << "fifo_file stat_file_perms";
							}
							else if(regex_search(source_macro_d,what,m_filesystem_exp)&&
							(regex_search(source_macro_d,what,mfs_mount_fs_exp)||
							regex_search(source_macro_d,what,mfs_mount_fs_exp2)||
							regex_search(source_macro_d,what,mfs_mount_fs_exp3))
							){
								os_policy_macro << "filesystem mount_fs_perms";
								cout << "filesystem mount_fs_perms";
							}
							else if(regex_search(source_macro_d,what,m_tcp_socket_exp)&&
							(regex_search(source_macro_d,what,m_create_exp)&&
							(regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp)))
							){
								os_policy_macro << "tcp_socket create_stream_socket_perms";
								cout << "tcp_socket create_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_tcp_socket_exp)&&
							regex_search(source_macro_d,what,m_create_exp)
							){
								os_policy_macro << "tcp_socket create_socket_perms";
								cout << "tcp_socket create_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_tcp_socket_exp)&&
							regex_search(source_macro_d,what,msoc_connect_exp)
							){
								os_policy_macro << "tcp_socket rw_socket_perms";
								cout << "tcp_socket rw_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_tcp_socket_exp)&&
							((regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp))&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp)))
							){
								os_policy_macro << "tcp_socket connected_stream_socket_perms";
								cout << "tcp_socket connected_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_tcp_socket_exp)&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp))
							){
								os_policy_macro << "tcp_socket connected_socket_perms";
								cout << "tcp_socket connected_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_tcp_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_write_exp)
							){
								os_policy_macro << "tcp_socket rw_netlink_socket_perms";
								cout << "tcp_socket rw_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_tcp_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_read_exp)
							){
								os_policy_macro << "tcp_socket r_netlink_socket_perms";
								cout << "tcp_socket r_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_udp_socket_exp)&&
							(regex_search(source_macro_d,what,m_create_exp)&&
							(regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp)))
							){
								os_policy_macro << "udp_socket create_stream_socket_perms";
								cout << "udp_socket create_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_udp_socket_exp)&&
							regex_search(source_macro_d,what,m_create_exp)
							){
								os_policy_macro << "udp_socket create_socket_perms";
								cout << "udp_socket create_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_udp_socket_exp)&&
							regex_search(source_macro_d,what,msoc_connect_exp)
							){
								os_policy_macro << "udp_socket rw_socket_perms";
								cout << "udp_socket rw_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_udp_socket_exp)&&
							((regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp))&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp)))
							){
								os_policy_macro << "udp_socket connected_stream_socket_perms";
								cout << "udp_socket connected_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_udp_socket_exp)&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp))
							){
								os_policy_macro << "udp_socket connected_socket_perms";
								cout << "udp_socket connected_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_udp_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_write_exp)
							){
								os_policy_macro << "udp_socket rw_netlink_socket_perms";
								cout << "udp_socket rw_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_udp_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_read_exp)
							){
								os_policy_macro << "udp_socket r_netlink_socket_perms";
								cout << "udp_socket r_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_rawip_socket_exp)&&
							(regex_search(source_macro_d,what,m_create_exp)&&
							(regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp)))
							){
								os_policy_macro << "rawip_socket create_stream_socket_perms";
								cout << "rawip_socket create_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_rawip_socket_exp)&&
							regex_search(source_macro_d,what,m_create_exp)
							){
								os_policy_macro << "rawip_socket create_socket_perms";
								cout << "rawip_socket create_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_rawip_socket_exp)&&
							regex_search(source_macro_d,what,msoc_connect_exp)
							){
								os_policy_macro << "rawip_socket rw_socket_perms";
								cout << "rawip_socket rw_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_rawip_socket_exp)&&
							((regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp))&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp)))
							){
								os_policy_macro << "rawip_socket connected_stream_socket_perms";
								cout << "rawip_socket connected_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_rawip_socket_exp)&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp))
							){
								os_policy_macro << "rawip_socket connected_socket_perms";
								cout << "rawip_socket connected_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_rawip_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_write_exp)
							){
								os_policy_macro << "rawip_socket rw_netlink_socket_perms";
								cout << "rawip_socket rw_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_rawip_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_read_exp)
							){
								os_policy_macro << "rawip_socket r_netlink_socket_perms";
								cout << "rawip_socket r_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_socket_exp)&&
							(regex_search(source_macro_d,what,m_create_exp)&&
							(regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp)))
							){
								os_policy_macro << "netlink_socket create_stream_socket_perms";
								cout << "netlink_socket create_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_socket_exp)&&
							regex_search(source_macro_d,what,m_create_exp)
							){
								os_policy_macro << "netlink_socket create_socket_perms";
								cout << "netlink_socket create_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_socket_exp)&&
							regex_search(source_macro_d,what,msoc_connect_exp)
							){
								os_policy_macro << "netlink_socket rw_socket_perms";
								cout << "netlink_socket rw_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_socket_exp)&&
							((regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp))&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp)))
							){
								os_policy_macro << "netlink_socket connected_stream_socket_perms";
								cout << "netlink_socket connected_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_socket_exp)&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp))
							){
								os_policy_macro << "netlink_socket connected_socket_perms";
								cout << "netlink_socket connected_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_write_exp)
							){
								os_policy_macro << "netlink_socket rw_netlink_socket_perms";
								cout << "netlink_socket rw_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_read_exp)
							){
								os_policy_macro << "netlink_socket r_netlink_socket_perms";
								cout << "netlink_socket r_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_packet_socket_exp)&&
							(regex_search(source_macro_d,what,m_create_exp)&&
							(regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp)))
							){
								os_policy_macro << "packet_socket create_stream_socket_perms";
								cout << "packet_socket create_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_packet_socket_exp)&&
							regex_search(source_macro_d,what,m_create_exp)
							){
								os_policy_macro << "packet_socket create_socket_perms";
								cout << "packet_socket create_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_packet_socket_exp)&&
							regex_search(source_macro_d,what,msoc_connect_exp)
							){
								os_policy_macro << "packet_socket rw_socket_perms";
								cout << "packet_socket rw_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_packet_socket_exp)&&
							((regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp))&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp)))
							){
								os_policy_macro << "packet_socket connected_stream_socket_perms";
								cout << "packet_socket connected_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_packet_socket_exp)&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp))
							){
								os_policy_macro << "packet_socket connected_socket_perms";
								cout << "packet_socket connected_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_packet_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_write_exp)
							){
								os_policy_macro << "packet_socket rw_netlink_socket_perms";
								cout << "packet_socket rw_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_packet_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_read_exp)
							){
								os_policy_macro << "packet_socket r_netlink_socket_perms";
								cout << "packet_socket r_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_unix_stream_socket_exp)&&
							(regex_search(source_macro_d,what,m_create_exp)&&
							(regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp)))
							){
								os_policy_macro << "unix_stream_socket create_stream_socket_perms";
								cout << "unix_stream_socket create_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_unix_stream_socket_exp)&&
							regex_search(source_macro_d,what,m_create_exp)
							){
								os_policy_macro << "unix_stream_socket create_socket_perms";
								cout << "unix_stream_socket create_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_unix_stream_socket_exp)&&
							regex_search(source_macro_d,what,msoc_connect_exp)
							){
								os_policy_macro << "unix_stream_socket rw_socket_perms";
								cout << "unix_stream_socket rw_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_unix_stream_socket_exp)&&
							((regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp))&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp)))
							){
								os_policy_macro << "unix_stream_socket connected_stream_socket_perms";
								cout << "unix_stream_socket connected_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_unix_stream_socket_exp)&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp))
							){
								os_policy_macro << "unix_stream_socket connected_socket_perms";
								cout << "unix_stream_socket connected_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_unix_stream_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_write_exp)
							){
								os_policy_macro << "unix_stream_socket rw_netlink_socket_perms";
								cout << "unix_stream_socket rw_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_unix_stream_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_read_exp)
							){
								os_policy_macro << "unix_stream_socket r_netlink_socket_perms";
								cout << "unix_stream_socket r_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_unix_dgram_socket_exp)&&
							(regex_search(source_macro_d,what,m_create_exp)&&
							(regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp)))
							){
								os_policy_macro << "unix_dgram_socket create_stream_socket_perms";
								cout << "unix_dgram_socket create_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_unix_dgram_socket_exp)&&
							regex_search(source_macro_d,what,m_create_exp)
							){
								os_policy_macro << "unix_dgram_socket create_socket_perms";
								cout << "unix_dgram_socket create_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_unix_dgram_socket_exp)&&
							regex_search(source_macro_d,what,msoc_connect_exp)
							){
								os_policy_macro << "unix_dgram_socket rw_socket_perms";
								cout << "unix_dgram_socket rw_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_unix_dgram_socket_exp)&&
							((regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp))&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp)))
							){
								os_policy_macro << "unix_dgram_socket connected_stream_socket_perms";
								cout << "unix_dgram_socket connected_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_unix_dgram_socket_exp)&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp))
							){
								os_policy_macro << "unix_dgram_socket connected_socket_perms";
								cout << "unix_dgram_socket connected_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_unix_dgram_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_write_exp)
							){
								os_policy_macro << "unix_dgram_socket rw_netlink_socket_perms";
								cout << "unix_dgram_socket rw_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_unix_dgram_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_read_exp)
							){
								os_policy_macro << "unix_dgram_socket r_netlink_socket_perms";
								cout << "unix_dgram_socket r_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_route_socket_exp)&&
							(regex_search(source_macro_d,what,m_create_exp)&&
							(regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp)))
							){
								os_policy_macro << "netlink_route_socket create_stream_socket_perms";
								cout << "netlink_route_socket create_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_route_socket_exp)&&
							regex_search(source_macro_d,what,m_create_exp)
							){
								os_policy_macro << "netlink_route_socket create_socket_perms";
								cout << "netlink_route_socket create_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_route_socket_exp)&&
							regex_search(source_macro_d,what,msoc_connect_exp)
							){
								os_policy_macro << "netlink_route_socket rw_socket_perms";
								cout << "netlink_route_socket rw_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_route_socket_exp)&&
							((regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp))&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp)))
							){
								os_policy_macro << "netlink_route_socket connected_stream_socket_perms";
								cout << "netlink_route_socket connected_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_route_socket_exp)&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp))
							){
								os_policy_macro << "netlink_route_socket connected_socket_perms";
								cout << "netlink_route_socket connected_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_route_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_write_exp)
							){
								os_policy_macro << "netlink_route_socket rw_netlink_socket_perms";
								cout << "netlink_route_socket rw_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_route_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_read_exp)
							){
								os_policy_macro << "netlink_route_socket r_netlink_socket_perms";
								cout << "netlink_route_socket r_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_firewall_socket_exp)&&
							(regex_search(source_macro_d,what,m_create_exp)&&
							(regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp)))
							){
								os_policy_macro << "netlink_firewall_socket create_stream_socket_perms";
								cout << "netlink_firewall_socket create_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_firewall_socket_exp)&&
							regex_search(source_macro_d,what,m_create_exp)
							){
								os_policy_macro << "netlink_firewall_socket create_socket_perms";
								cout << "netlink_firewall_socket create_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_firewall_socket_exp)&&
							regex_search(source_macro_d,what,msoc_connect_exp)
							){
								os_policy_macro << "netlink_firewall_socket rw_socket_perms";
								cout << "netlink_firewall_socket rw_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_firewall_socket_exp)&&
							((regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp))&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp)))
							){
								os_policy_macro << "netlink_firewall_socket connected_stream_socket_perms";
								cout << "netlink_firewall_socket connected_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_firewall_socket_exp)&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp))
							){
								os_policy_macro << "netlink_firewall_socket connected_socket_perms";
								cout << "netlink_firewall_socket connected_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_firewall_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_write_exp)
							){
								os_policy_macro << "netlink_firewall_socket rw_netlink_socket_perms";
								cout << "netlink_firewall_socket rw_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_firewall_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_read_exp)
							){
								os_policy_macro << "netlink_firewall_socket r_netlink_socket_perms";
								cout << "netlink_firewall_socket r_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_tcpdiag_socket_exp)&&
							(regex_search(source_macro_d,what,m_create_exp)&&
							(regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp)))
							){
								os_policy_macro << "netlink_tcpdiag_socket create_stream_socket_perms";
								cout << "netlink_tcpdiag_socket create_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_tcpdiag_socket_exp)&&
							regex_search(source_macro_d,what,m_create_exp)
							){
								os_policy_macro << "netlink_tcpdiag_socket create_socket_perms";
								cout << "netlink_tcpdiag_socket create_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_tcpdiag_socket_exp)&&
							regex_search(source_macro_d,what,msoc_connect_exp)
							){
								os_policy_macro << "netlink_tcpdiag_socket rw_socket_perms";
								cout << "netlink_tcpdiag_socket rw_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_tcpdiag_socket_exp)&&
							((regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp))&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp)))
							){
								os_policy_macro << "netlink_tcpdiag_socket connected_stream_socket_perms";
								cout << "netlink_tcpdiag_socket connected_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_tcpdiag_socket_exp)&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp))
							){
								os_policy_macro << "netlink_tcpdiag_socket connected_socket_perms";
								cout << "netlink_tcpdiag_socket connected_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_tcpdiag_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_write_exp)
							){
								os_policy_macro << "netlink_tcpdiag_socket rw_netlink_socket_perms";
								cout << "netlink_tcpdiag_socket rw_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_tcpdiag_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_read_exp)
							){
								os_policy_macro << "netlink_tcpdiag_socket r_netlink_socket_perms";
								cout << "netlink_tcpdiag_socket r_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_nflog_socket_exp)&&
							(regex_search(source_macro_d,what,m_create_exp)&&
							(regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp)))
							){
								os_policy_macro << "netlink_nflog_socket create_stream_socket_perms";
								cout << "netlink_nflog_socket create_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_nflog_socket_exp)&&
							regex_search(source_macro_d,what,m_create_exp)
							){
								os_policy_macro << "netlink_nflog_socket create_socket_perms";
								cout << "netlink_nflog_socket create_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_nflog_socket_exp)&&
							regex_search(source_macro_d,what,msoc_connect_exp)
							){
								os_policy_macro << "netlink_nflog_socket rw_socket_perms";
								cout << "netlink_nflog_socket rw_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_nflog_socket_exp)&&
							((regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp))&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp)))
							){
								os_policy_macro << "netlink_nflog_socket connected_stream_socket_perms";
								cout << "netlink_nflog_socket connected_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_nflog_socket_exp)&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp))
							){
								os_policy_macro << "netlink_nflog_socket connected_socket_perms";
								cout << "netlink_nflog_socket connected_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_nflog_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_write_exp)
							){
								os_policy_macro << "netlink_nflog_socket rw_netlink_socket_perms";
								cout << "netlink_nflog_socket rw_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_nflog_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_read_exp)
							){
								os_policy_macro << "netlink_nflog_socket r_netlink_socket_perms";
								cout << "netlink_nflog_socket r_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_xfrm_socket_exp)&&
							(regex_search(source_macro_d,what,m_create_exp)&&
							(regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp)))
							){
								os_policy_macro << "netlink_xfrm_socket create_stream_socket_perms";
								cout << "netlink_xfrm_socket create_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_xfrm_socket_exp)&&
							regex_search(source_macro_d,what,m_create_exp)
							){
								os_policy_macro << "netlink_xfrm_socket create_socket_perms";
								cout << "netlink_xfrm_socket create_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_xfrm_socket_exp)&&
							regex_search(source_macro_d,what,msoc_connect_exp)
							){
								os_policy_macro << "netlink_xfrm_socket rw_socket_perms";
								cout << "netlink_xfrm_socket rw_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_xfrm_socket_exp)&&
							((regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp))&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp)))
							){
								os_policy_macro << "netlink_xfrm_socket connected_stream_socket_perms";
								cout << "netlink_xfrm_socket connected_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_xfrm_socket_exp)&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp))
							){
								os_policy_macro << "netlink_xfrm_socket connected_socket_perms";
								cout << "netlink_xfrm_socket connected_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_xfrm_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_write_exp)
							){
								os_policy_macro << "netlink_xfrm_socket rw_netlink_socket_perms";
								cout << "netlink_xfrm_socket rw_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_xfrm_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_read_exp)
							){
								os_policy_macro << "netlink_xfrm_socket r_netlink_socket_perms";
								cout << "netlink_xfrm_socket r_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_selinux_socket_exp)&&
							(regex_search(source_macro_d,what,m_create_exp)&&
							(regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp)))
							){
								os_policy_macro << "netlink_selinux_socket create_stream_socket_perms";
								cout << "netlink_selinux_socket create_stream_socket_perms";

							}
							else if(regex_search(source_macro_d,what,m_netlink_selinux_socket_exp)&&
							regex_search(source_macro_d,what,m_create_exp)
							){
								os_policy_macro << "netlink_selinux_socket create_socket_perms";
								cout << "netlink_selinux_socket create_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_selinux_socket_exp)&&
							regex_search(source_macro_d,what,msoc_connect_exp)
							){
								os_policy_macro << "netlink_selinux_socket rw_socket_perms";
								cout << "netlink_selinux_socket rw_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_selinux_socket_exp)&&
							((regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp))&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp)))
							){
								os_policy_macro << "netlink_selinux_socket connected_stream_socket_perms";
								cout << "netlink_selinux_socket connected_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_selinux_socket_exp)&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp))
							){
								os_policy_macro << "netlink_selinux_socket connected_socket_perms";
								cout << "netlink_selinux_socket connected_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_selinux_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_write_exp)
							){
								os_policy_macro << "netlink_selinux_socket rw_netlink_socket_perms";
								cout << "netlink_selinux_socket rw_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_selinux_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_read_exp)
							){
								os_policy_macro << "netlink_selinux_socket r_netlink_socket_perms";
								cout << "netlink_selinux_socket r_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_audit_socket_exp)&&
							(regex_search(source_macro_d,what,m_create_exp)&&
							(regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp)))
							){
								os_policy_macro << "netlink_audit_socket create_stream_socket_perms";
								cout << "netlink_audit_socket create_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_audit_socket_exp)&&
							regex_search(source_macro_d,what,m_create_exp)
							){
								os_policy_macro << "netlink_audit_socket create_socket_perms";
								cout << "netlink_audit_socket create_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_audit_socket_exp)&&
							regex_search(source_macro_d,what,msoc_connect_exp)
							){
								os_policy_macro << "netlink_audit_socket rw_socket_perms";
								cout << "netlink_audit_socket rw_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_audit_socket_exp)&&
							((regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp))&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp)))
							){
								os_policy_macro << "netlink_audit_socket connected_stream_socket_perms";
								cout << "netlink_audit_socket connected_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_audit_socket_exp)&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp))
							){
								os_policy_macro << "netlink_audit_socket connected_socket_perms";
								cout << "netlink_audit_socket connected_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_audit_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_write_exp)
							){
								os_policy_macro << "netlink_audit_socket rw_netlink_socket_perms";
								cout << "netlink_audit_socket rw_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_audit_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_read_exp)
							){
								os_policy_macro << "netlink_audit_socket r_netlink_socket_perms";
								cout << "netlink_audit_socket r_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_ip6fw_socket_exp)&&
							(regex_search(source_macro_d,what,m_create_exp)&&
							(regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp)))
							){
								os_policy_macro << "netlink_ip6fw_socket create_stream_socket_perms";
								cout << "netlink_ip6fw_socket create_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_ip6fw_socket_exp)&&
							regex_search(source_macro_d,what,m_create_exp)
							){
								os_policy_macro << "netlink_ip6fw_socket create_socket_perms";
								cout << "netlink_ip6fw_socket create_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_ip6fw_socket_exp)&&
							regex_search(source_macro_d,what,msoc_connect_exp)
							){
								os_policy_macro << "netlink_ip6fw_socket rw_socket_perms";
								cout << "netlink_ip6fw_socket rw_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_ip6fw_socket_exp)&&
							((regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp))&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp)))
							){
								os_policy_macro << "netlink_ip6fw_socket connected_stream_socket_perms";
								cout << "netlink_ip6fw_socket connected_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_ip6fw_socket_exp)&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp))
							){
								os_policy_macro << "netlink_ip6fw_socket connected_socket_perms";
								cout << "netlink_ip6fw_socket connected_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_ip6fw_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_write_exp)
							){
								os_policy_macro << "netlink_ip6fw_socket rw_netlink_socket_perms";
								cout << "netlink_ip6fw_socket rw_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_ip6fw_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_read_exp)
							){
								os_policy_macro << "netlink_ip6fw_socket r_netlink_socket_perms";
								cout << "netlink_ip6fw_socket r_netlink_socket_perms";
							}

							else if(regex_search(source_macro_d,what,m_netlink_dnrt_socket_exp)&&
							(regex_search(source_macro_d,what,m_create_exp)&&
							(regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp)))
							){
								os_policy_macro << "netlink_dnrt_socket create_stream_socket_perms";
								cout << "netlink_dnrt_socket create_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_dnrt_socket_exp)&&
							regex_search(source_macro_d,what,m_create_exp)
							){
								os_policy_macro << "netlink_dnrt_socket create_socket_perms";
								cout << "netlink_dnrt_socket create_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_dnrt_socket_exp)&&
							regex_search(source_macro_d,what,msoc_connect_exp)
							){
								os_policy_macro << "netlink_dnrt_socket rw_socket_perms";
								cout << "netlink_dnrt_socket rw_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_dnrt_socket_exp)&&
							((regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp))&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp)))
							){
								os_policy_macro << "netlink_dnrt_socket connected_stream_socket_perms";
								cout << "netlink_dnrt_socket connected_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_dnrt_socket_exp)&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp))
							){
								os_policy_macro << "netlink_dnrt_socket connected_socket_perms";
								cout << "netlink_dnrt_socket connected_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_dnrt_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_write_exp)
							){
								os_policy_macro << "netlink_dnrt_socket rw_netlink_socket_perms";
								cout << "netlink_dnrt_socket rw_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_dnrt_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_read_exp)
							){
								os_policy_macro << "netlink_dnrt_socket r_netlink_socket_perms";
								cout << "netlink_dnrt_socket r_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_kobject_uevent_socket_exp)&&
							(regex_search(source_macro_d,what,m_create_exp)&&
							(regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp)))
							){
								os_policy_macro << "netlink_kobject_uevent_socket create_stream_socket_perms";
								cout << "netlink_kobject_uevent_socket create_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_kobject_uevent_socket_exp)&&
							regex_search(source_macro_d,what,m_create_exp)
							){
								os_policy_macro << "netlink_kobject_uevent_socket create_socket_perms";
								cout << "netlink_kobject_uevent_socket create_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_kobject_uevent_socket_exp)&&
							regex_search(source_macro_d,what,msoc_connect_exp)
							){
								os_policy_macro << "netlink_kobject_uevent_socket rw_socket_perms";
								cout << "netlink_kobject_uevent_socket rw_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_kobject_uevent_socket_exp)&&
							((regex_search(source_macro_d,what,msoc_listen_stream_exp)||
							regex_search(source_macro_d,what,msoc_accept_stream_exp))&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp)))
							){
								os_policy_macro << "netlink_kobject_uevent_socket connected_stream_socket_perms";
								cout << "netlink_kobject_uevent_socket connected_stream_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_kobject_uevent_socket_exp)&&
							(regex_search(source_macro_d,what,mf_r_exp)||
							regex_search(source_macro_d,what,m_ra_exp)||
							regex_search(source_macro_d,what,mf_create_exp2)||
							regex_search(source_macro_d,what,mf_ra_exp)||
							regex_search(source_macro_d,what,msoc_bind_exp)||
							regex_search(source_macro_d,what,msoc_getopt_exp)||
							regex_search(source_macro_d,what,msoc_setopt_exp)||
							regex_search(source_macro_d,what,msoc_shutdown_exp))
							){
								os_policy_macro << "netlink_kobject_uevent_socket connected_socket_perms";
								cout << "netlink_kobject_uevent_socket connected_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_kobject_uevent_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_write_exp)
							){
								os_policy_macro << "netlink_kobject_uevent_socket rw_netlink_socket_perms";
								cout << "netlink_kobject_uevent_socket rw_netlink_socket_perms";
							}
							else if(regex_search(source_macro_d,what,m_netlink_kobject_uevent_socket_exp)&&
							regex_search(source_macro_d,what,msoc_nlmsg_read_exp)
							){
								os_policy_macro << "netlink_kobject_uevent_socket r_netlink_socket_perms";
								cout << "netlink_kobject_uevent_socket r_netlink_socket_perms";
							}
                                                        else if(regex_search(source_macro_d,what,sem_exp)&&
                                                        (regex_search(source_macro_d,what,m_create_exp)||
                                                        regex_search(source_macro_d,what,mproc_destroy_exp))
                                                        ){
                                                                os_policy_macro << "sem create_sem_perms";
                                                                cout << "sem create_sem_perms";
                                                        }
                                                        else if(regex_search(source_macro_d,what,sem_exp)&&
                                                        (regex_search(source_macro_d,what,mf_rw_exp)||
                                                        regex_search(source_macro_d,what,mproc_unix_write_exp))
                                                        ){
                                                                os_policy_macro << "sem rw_sem_perms";
                                                                cout << "sem rw_sem_perms";
                                                        }
                                                        else if(regex_search(source_macro_d,what,sem_exp)&&
                                                        (regex_search(source_macro_d,what,mf_rw_exp)||
                                                        regex_search(source_macro_d,what,mproc_unix_write_exp))
                                                        ){
                                                                os_policy_macro << "sem rw_sem_perms";
                                                                cout << "sem rw_sem_perms";
                                                        }
                                                        else if(regex_search(source_macro_d,what,sem_exp)&&
                                                        (regex_search(source_macro_d,what,mproc_associate_exp)||
                                                        regex_search(source_macro_d,what,mf_stat_exp)||
                                                        regex_search(source_macro_d,what,mf_r_exp)||
                                                        regex_search(source_macro_d,what,mproc_unix_read_exp))
                                                        ){
                                                                os_policy_macro << "sem r_sem_perms";
                                                                cout << "sem r_sem_perms";
							}
                                                        else if(regex_search(source_macro_d,what,msgq_exp)&&
                                                        (regex_search(source_macro_d,what,m_create_exp)||
                                                        regex_search(source_macro_d,what,mproc_destroy_exp))
                                                        ){
                                                                os_policy_macro << "msgq create_msgq_perms";
                                                                cout << "msgq create_msgq_perms";
                                                        }
                                                        else if(regex_search(source_macro_d,what,msgq_exp)&&
                                                        (regex_search(source_macro_d,what,mf_rw_exp)||
                                                        regex_search(source_macro_d,what,mproc_unix_write_exp))
                                                        ){
                                                                os_policy_macro << "msgq rw_msgq_perms";
                                                                cout << "msgq rw_msgq_perms";
                                                        }
                                                        else if(regex_search(source_macro_d,what,msgq_exp)&&
                                                        (regex_search(source_macro_d,what,mf_rw_exp)||
                                                        regex_search(source_macro_d,what,mproc_unix_write_exp))
                                                        ){
                                                                os_policy_macro << "msgq rw_msgq_perms";
                                                                cout << "msgq rw_msgq_perms";
                                                        }
                                                        else if(regex_search(source_macro_d,what,msgq_exp)&&
                                                        (regex_search(source_macro_d,what,mproc_associate_exp)||
                                                        regex_search(source_macro_d,what,mf_stat_exp)||
                                                        regex_search(source_macro_d,what,mf_r_exp)||
                                                        regex_search(source_macro_d,what,mproc_unix_read_exp))
                                                        ){
                                                                os_policy_macro << "msgq r_msgq_perms";
                                                                cout << "msgq r_msgq_perms";
                                                        }
                                                        else if(regex_search(source_macro_d,what,shm_exp)&&
                                                        (regex_search(source_macro_d,what,m_create_exp)||
                                                        regex_search(source_macro_d,what,mproc_destroy_exp))
                                                        ){
                                                                os_policy_macro << "shm create_shm_perms";
                                                                cout << "shm create_shm_perms";
                                                        }
                                                        else if(regex_search(source_macro_d,what,shm_exp)&&
                                                        (regex_search(source_macro_d,what,mf_rw_exp)||
                                                        regex_search(source_macro_d,what,mproc_unix_write_exp))
                                                        ){
                                                                os_policy_macro << "shm rw_shm_perms";
                                                                cout << "shm rw_shm_perms";
                                                        }
                                                        else if(regex_search(source_macro_d,what,shm_exp)&&
                                                        (regex_search(source_macro_d,what,mf_rw_exp)||
                                                        regex_search(source_macro_d,what,mproc_unix_write_exp))
                                                        ){
                                                                os_policy_macro << "shm rw_shm_perms";
                                                                cout << "shm rw_shm_perms";
                                                        }
                                                        else if(regex_search(source_macro_d,what,shm_exp)&&
                                                        (regex_search(source_macro_d,what,mproc_associate_exp)||
                                                        regex_search(source_macro_d,what,mf_stat_exp)||
                                                        regex_search(source_macro_d,what,mf_r_exp)||
                                                        regex_search(source_macro_d,what,mproc_unix_read_exp))
                                                        ){
                                                                os_policy_macro << "shm r_shm_perms";
                                                                cout << "shm r_shm_perms";
                                                        }
							else{
								os_policy_macro << p3_m->second;
								cout << p3_m->second;
							}
							os_policy_macro << ";" << endl;
							cout << ";" << endl;
							p3_m++;
						}while(p3_m != macro_pre2.upper_bound(p3->first));
					}
					p3_tmp=p3->first;
					p3++;
				}while(p3 != p3_end);

				//end of generating macro in a very primitive way
			}
			os_policy_macro.close();
		}
		is_policy.close();
		is.close();
	}
	cout << endl;
}

void SolveProblem::se_on()
{
        char buffer_c[MAX_LOG];
        const char* filename="/var/log/audit/audit.log";
        const char* filename_new="./segatex_solve_problem_data";
        const char* filename_solve_problem="./segatex_solve_problem";

        ifstream is;
        is.open(filename);
	if(!is.getline(buffer_c, sizeof buffer_c)){
		cout << "no-data" << endl;
		is.close();
	}
/*
	if(log_state == 0){
		log_from_time_int = segatex::segatex_set_time_all_real(); 
	}
	else if(log_state == 1){
		log_from_time_int = segatex::segatex_set_time_real();
	}
*/
        if(is)
        {
	string please_wait = "Checking problems on this machine.Please wait...";
	cout << please_wait << endl << endl;

	vector<string> v_bin;
	vector<string>::iterator p_bin, p_bin_end;
	string buffer_string="";
	string token_ary[100];
	int i_solve_problem_global=0;

	FILE* read_fp;
	char buffer[BUFSIZ + 1];
	int chars_read;
	memset(buffer, '\0', sizeof(buffer));
	read_fp = popen("find / -type d -name \"bin\"", "r");
	if (read_fp != NULL){
		chars_read = fread(buffer, sizeof(char), PS_SIZE, read_fp);
		while(chars_read>0){
			buffer[chars_read -1] = '\0';
			chars_read= fread(buffer, sizeof(char), PS_SIZE, read_fp);
			buffer_string = buffer;
			v_bin.push_back(buffer);
			char_separator<char>    sep(" \t\n");
			tokenizer< char_separator<char> > tokens( buffer_string, sep);
			typedef tokenizer< char_separator<char> >::iterator Iter;
			int i=0;
			for( Iter it=tokens.begin(); it !=tokens.end(); ++it ){
				token_ary[i]= *it;
				/*for debug
				cout << "TOKEN:" << *it << endl;
				*/
				i++;
				i_solve_problem_global=i;
			}	
		}
	}
	pclose(read_fp);


                vector<string> v2;
                vector<string>::iterator p2, p2_end;

                ofstream os;
                os.open(filename_new);
                ofstream os_solve_problem;
                os_solve_problem.open(filename_solve_problem);

                if((os_solve_problem)&&(os))
                {
                        char buffer[MAX_LOG];
                        const char* words="denied";
                        const char* problem_key="scontext=system_u:system_r:initrc_t";
                        vector<string> v;
                        vector<string>::iterator p, p_end;

                        while(is.getline(buffer, sizeof buffer))
                        {
                                if((strstr(buffer,words))&&(strstr(buffer,problem_key))){
                                        os << buffer << endl;
                                        v.push_back(buffer);
                                }
                                if(!os)
                                        break;
                        }
                        os.close();
                        const char* log_time = "audit\\([0-9]{10}";
                        const char* comm = "comm([^[:space:]]*)[a-z]";
                        regex log_time_exp(log_time);
                        regex comm_exp(comm);

                        string log_time_string = "";
                        int log_time_int = 0;
                        string comm_str = "";
                        string ok_str = "Your system has no SELinux problems at present.";
                        string alert_str = "Found SELinux problems.These should be domain-transed from initrc_t.";
                        for(p=v.begin(); p<v.end();p++){
                                string source_ready = *p;
                                const char* source = source_ready.c_str();
                                cmatch what;
				if(regex_search(source,what,comm_exp)){
					comm_str = what[0];
					comm_str = comm_str.substr(6);
				}
				if(regex_search(source,what,log_time_exp)){
					log_time_string = what[0];
					log_time_string = log_time_string.substr(6);
					log_time_int = atoi(log_time_string.c_str());
				}
			//	if(log_from_time_int <= log_time_int){
					v2.push_back(comm_str.c_str());
			//	}
			}
                        sort(v2.begin(),v2.end());
                        p2_end = unique(v2.begin(),v2.end());

			int v2_size = v2.size();


			if(v2_size == 0){
				os_solve_problem << ok_str << endl << endl;
				cout << ok_str << endl << endl;
			}else{
				os_solve_problem << alert_str << endl << endl;
				cout << alert_str << endl << endl;
			}

                        for(p2=v2.begin();p2<p2_end;p2++){
                        	for(int i=0;i<i_solve_problem_global;i++){
					string comm2 = *p2;
					//making fc file
					string new_file_fc_str = *p2 + ".fc";
					const char* new_file_fc = new_file_fc_str.c_str(); 
        			        ofstream os_new_file_fc;
					os_new_file_fc.open(new_file_fc);
					os_new_file_fc << "#fc file for " << *p2 << " generated by segatex." << endl;
					os_new_file_fc << "#[...'s_bin_directory's_files] should be written .../bin(/.*)?" << endl;
					os_new_file_fc << "#[...'s_data_directory_and_their_files] should be written .../data(/.*)?" << endl;
					os_new_file_fc << "/path/to/" << *p2 << "'s_home_directory" << "    -d" << "    " << "system_u:object_r:" << *p2 << "_home_t" << endl;
					os_new_file_fc << "/path/to/" << *p2 << "'s_bin_directory" << "    -d" << "    " << "system_u:object_r:" << *p2 << "_bin_t" << endl;
					os_new_file_fc << "/path/to/" << *p2 << "'s_bin_directory's_files" << "    --" << "    " << "system_u:object_r:" << *p2 << "_exec_t" << endl;
					os_new_file_fc << "/path/to/" << *p2 << "'s_data_directory_and_their_files" << "    " << "system_u:object_r:" << *p2 << "_data_t" << endl;
					os_new_file_fc << "/path/to/" << *p2 << "'s_doc_directory_and_their_files" << "    " << "system_u:object_r:" << *p2 << "_doc_t" << endl;
					os_new_file_fc << "/path/to/" << *p2 << "'s_include_directory_and_their_files" << "    " << "system_u:object_r:" << *p2 << "_include_t" << endl;
					os_new_file_fc << "/path/to/" << *p2 << "'s_lib_directory_and_their_files" << "    " << "system_u:object_r:" << *p2 << "_lib_t" << endl;
					os_new_file_fc << "/path/to/" << *p2 << "'s_man_directory_and_their_files" << "    " << "system_u:object_r:" << *p2 << "_man_t" << endl;
					os_new_file_fc << "/path/to/" << *p2 << "'s_share_directory_and_their_files" << "    " << "system_u:object_r:" << *p2 << "_share_t" << endl;
					os_new_file_fc.close();
					//end making fc file
					const char* comm2_char = comm2.c_str(); 
					string dir_bin_str = token_ary[i] + "/";
					string full_path_bin_str = dir_bin_str + comm2;
					const char* full_path_bin_char=full_path_bin_str.c_str();

					int file_exists=0;
					file_exists = access(full_path_bin_char,00);
					if(file_exists == 0){
						os_solve_problem << *p2 << "::fullpath is:" << full_path_bin_char << endl;
						cout << *p2 << "::fullpath is:" << full_path_bin_char << endl;
					}else{					
						os_solve_problem << *p2 << "::fullpath is unnkown." << endl;
						cout << *p2 << "::fullpath is unnkown." << endl;

						os_solve_problem << "You should find / -type f -name \"" << comm2_char << " \" on console..." << endl;
						cout << "You should find / -type f -name \"" << comm2_char << " \" on console..." << endl;
						break;
					}
				}
			}
			cout << endl;
			cout << "fc file(s) are created in this folder. Please check." << endl << endl;
                is.close();
                os_solve_problem.close();
                }
        }
}

#endif
