/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */
//for debug
//#include <iostream>
//using namespace std;

#include <qaction.h>
#include <qapplication.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qmenubar.h>
#include <qmessagebox.h>
#include <qstatusbar.h>
#include <qworkspace.h>
//newly added
#include <qsplitter.h>
#include <qpushbutton.h>
#include <qtextedit.h>

#include "editor.h"
#include "parselines.h"
#include "parselines_admin.h"
#include "parselines_apps.h"
#include "parselines_kernel.h"
#include "parselines_services.h"
#include "parselines_system.h"
#include "parselines_misc.h"
#include "parselines_selpaw.h"
#include "selpaw.h"
#include "selpaw_adjust.h"
#include "segatex_state.h"
#include "segatex_apply.h"
#include "segatex_setenforce.h"
#include "segatex_yum.h"
#include "segatex_yum_process.h"
#include "segatex_audit2allow.h"
#include "segatex_core.h"
#include "semodule_core_process.h"
#include "mainwindow.h"

MainWindow::MainWindow(QWidget *parent, const char *name)
	: QMainWindow(parent, name)
{
	//newly added
	horizontalSplitter = new QSplitter(Horizontal, this);
	setCentralWidget(horizontalSplitter);
	//declare workspace as a child of horizontalSplitter
	workspace = new QWorkspace(horizontalSplitter);

	parse1 = new ParseLinesAdmin();
	parse2 = new ParseLinesApps();
	parse3 = new ParseLinesKernel();
	parse4 = new ParseLinesServices();
	parse5 = new ParseLinesSystem();
	parse6 = new ParseLinesMisc();
	parse9 = new ParseLinesAdmin();
	parse10 = new ParseLinesApps();
	parse11 = new ParseLinesKernel();
	parse12 = new ParseLinesServices();
	parse13 = new ParseLinesSystem();    
	parse14 = new ParseLinesSelpaw();
	selpaw1 = new Selpaw();
	selpawadjust1 = new SelpawAdjust();
	segatex_state = new SegatexState();
	//needs here to be declared when opening a new window unless segmentation fualt happens...
	segatex_apply = 0;
	selinux_yum = 0;
	selinux_audit2allow = 0;
	segatex_core_o = 0;
	semodule_core_process_o = 0;

	//connect SIGNAL to objects    

	connect(workspace, SIGNAL(windowActivated(QWidget *)),
	    this, SLOT(updateMenus()));
	connect(workspace, SIGNAL(windowActivated(QWidget *)),
	    this, SLOT(updateModIndicator()));
	connect(workspace, SIGNAL(windowActivated(QWidget *)),
	    this, SLOT(updateSegatexStateIndicator()));

	createActions();
	createMenus();
	createToolBars();
	createStatusBar();

	setCaption(tr("segatex_suite-2.3(for F7)"));
	setIcon(QPixmap::fromMimeSource("icon.png"));
}

void MainWindow::createActions()
{
	newAct = new QAction(tr("&New"), tr("Ctrl+N"), this);
	newAct->setIconSet(QPixmap::fromMimeSource("new.png"));
	newAct->setStatusTip(tr("Create a new file"));
	connect(newAct, SIGNAL(activated()), this, SLOT(newFile()));
	connect(newAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	openAct = new QAction(tr("&Open..."), tr("Ctrl+O"), this);
	openAct->setIconSet(QPixmap::fromMimeSource("open.png"));
	openAct->setStatusTip(tr("Open an existing file"));
	connect(openAct, SIGNAL(activated()), this, SLOT(open()));
	connect(openAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	saveAct = new QAction(tr("&Save"), tr("Ctrl+S"), this);
	saveAct->setIconSet(QPixmap::fromMimeSource("save.png"));
	saveAct->setStatusTip(tr("Save the file to disk"));
	connect(saveAct, SIGNAL(activated()), this, SLOT(save()));
	connect(saveAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	saveAsAct = new QAction(tr("Save &As..."), 0, this);
	saveAsAct->setStatusTip(tr("Save the file under a new name"));
	connect(saveAsAct, SIGNAL(activated()), this, SLOT(saveAs()));
	connect(saveAsAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	exitAct = new QAction(tr("E&xit"), tr("Ctrl+Q"), this);
	exitAct->setStatusTip(tr("Exit the application"));
	connect(exitAct, SIGNAL(activated()), this, SLOT(close()));
	connect(exitAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	cutAct = new QAction(tr("Cu&t"), tr("Ctrl+X"), this);
	cutAct->setIconSet(QPixmap::fromMimeSource("cut.png"));
	cutAct->setStatusTip(tr("Cut the current selection to the "
			    "clipboard"));
	connect(cutAct, SIGNAL(activated()), this, SLOT(cut()));
	connect(cutAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	copyAct = new QAction(tr("&Copy"), tr("Ctrl+C"), this);
	copyAct->setIconSet(QPixmap::fromMimeSource("copy.png"));
	copyAct->setStatusTip(tr("Copy the current selection to the "
			     "clipboard"));
	connect(copyAct, SIGNAL(activated()), this, SLOT(copy()));
	connect(copyAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	pasteAct = new QAction(tr("&Paste"), tr("Ctrl+V"), this);
	pasteAct->setIconSet(QPixmap::fromMimeSource("paste.png"));
	pasteAct->setStatusTip(tr("Paste the clipboard's contents at "
			      "the cursor position"));
	connect(pasteAct, SIGNAL(activated()), this, SLOT(paste()));
	connect(pasteAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	deleteAct = new QAction(tr("&Delete"), tr("Del"), this);
	deleteAct->setIconSet(QPixmap::fromMimeSource("delete.png"));
	deleteAct->setStatusTip(tr("Delete the current selection"));
	connect(deleteAct, SIGNAL(activated()), this, SLOT(del()));
	connect(deleteAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	closeAct = new QAction(tr("Cl&ose"), tr("Ctrl+F4"), this);
	closeAct->setStatusTip(tr("Close the active window"));
	connect(closeAct, SIGNAL(activated()),
		workspace, SLOT(closeActiveWindow()));
	connect(closeAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	closeAllAct = new QAction(tr("Close &All"), 0, this);
	closeAllAct->setStatusTip(tr("Close all the windows"));
	connect(closeAllAct, SIGNAL(activated()),
		workspace, SLOT(closeAllWindows()));
	connect(closeAllAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	tileAct = new QAction(tr("&Tile"), 0, this);
	tileAct->setStatusTip(tr("Tile the windows"));
	connect(tileAct, SIGNAL(activated()), workspace, SLOT(tile()));
	connect(tileAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	cascadeAct = new QAction(tr("&Cascade"), 0, this);
	cascadeAct->setStatusTip(tr("Cascade the windows"));
	connect(cascadeAct, SIGNAL(activated()),
		workspace, SLOT(cascade()));
	connect(cascadeAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	nextAct = new QAction(tr("Ne&xt"), tr("Ctrl+F6"), this);
	nextAct->setStatusTip(tr("Move the focus to the next window"));
	connect(nextAct, SIGNAL(activated()),
		workspace, SLOT(activateNextWindow()));
	connect(nextAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	previousAct = new QAction(tr("Pre&vious"),
			      tr("Ctrl+Shift+F6"), this);
	previousAct->setStatusTip(tr("Move the focus to the previous "
				 "window"));
	connect(previousAct, SIGNAL(activated()),
		workspace, SLOT(activatePreviousWindow()));
	connect(previousAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	aboutAct = new QAction(tr("&About"), 0, this);
	aboutAct->setStatusTip(tr("Show the application's About box"));
	connect(aboutAct, SIGNAL(activated()), this, SLOT(about()));
	connect(aboutAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));


	aboutQtAct = new QAction(tr("About &Qt"), 0, this);
	aboutQtAct->setStatusTip(tr("Show the Qt library's About box"));
	connect(aboutQtAct, SIGNAL(activated()), qApp, SLOT(aboutQt()));
	connect(aboutQtAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	//newly added-1:create action
	parse_adminAct = new QAction(tr("Parse &Admin"), 0, this);
	parse_adminAct->setStatusTip(tr("Parse .if files in admin layer"));
	connect(parse_adminAct, SIGNAL(activated()), parse1, SLOT(parse_admin()));
	connect(parse_adminAct, SIGNAL(activated()), this, SLOT(open_interfaces_admin_txt()));
	connect(parse_adminAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	parse_appsAct = new QAction(tr("Parse A&pps"), 0, this);
	parse_appsAct->setStatusTip(tr("Parse .if files in apps layer"));
	connect(parse_appsAct, SIGNAL(activated()), parse2, SLOT(parse_apps()));
	connect(parse_appsAct, SIGNAL(activated()), this, SLOT(open_interfaces_apps_txt()));
	connect(parse_appsAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	parse_kernelAct = new QAction(tr("Parse &Kernel"), 0, this);
	parse_kernelAct->setStatusTip(tr("Parse .if files in kernel layer"));
	connect(parse_kernelAct, SIGNAL(activated()), parse3, SLOT(parse_kernel()));
	connect(parse_kernelAct, SIGNAL(activated()), this, SLOT(open_interfaces_kernel_txt()));
	connect(parse_kernelAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	parse_servicesAct = new QAction(tr("Parse &Services"), 0, this);
	parse_servicesAct->setStatusTip(tr("Parse .if files in services layer"));
	connect(parse_servicesAct, SIGNAL(activated()), parse4, SLOT(parse_services()));
	connect(parse_servicesAct, SIGNAL(activated()), this, SLOT(open_interfaces_services_txt()));
	connect(parse_servicesAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	parse_systemAct = new QAction(tr("Parse S&ystem"), 0, this);
	parse_systemAct->setStatusTip(tr("Parse .if files in system layer"));
	connect(parse_systemAct, SIGNAL(activated()), parse5, SLOT(parse_system()));
	connect(parse_systemAct, SIGNAL(activated()), this, SLOT(open_interfaces_system_txt()));
	connect(parse_systemAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	obj_perm_setsAct = new QAction(tr("&Obj perm sets"), 0, this);
	obj_perm_setsAct->setStatusTip(tr("Parse obj_perm_sets file"));
	connect(obj_perm_setsAct, SIGNAL(activated()), parse6, SLOT(obj_perm_sets()));
	connect(obj_perm_setsAct, SIGNAL(activated()), this, SLOT(open_obj_perm_sets_prepare_txt()));
	connect(obj_perm_setsAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	ipc_patternsAct = new QAction(tr("&Ipc patterns"), 0, this);
	ipc_patternsAct->setStatusTip(tr("Parse ipc patterns file"));
	connect(ipc_patternsAct, SIGNAL(activated()), parse6, SLOT(ipc_patterns()));
	connect(ipc_patternsAct, SIGNAL(activated()), this, SLOT(open_ipc_patterns_prepare_txt()));
	connect(ipc_patternsAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	misc_patternsAct = new QAction(tr("&Misc patterns"), 0, this);
	misc_patternsAct->setStatusTip(tr("Parse misc patterns file"));
	connect(misc_patternsAct, SIGNAL(activated()), parse6, SLOT(misc_patterns()));
	connect(misc_patternsAct, SIGNAL(activated()), this, SLOT(open_misc_patterns_prepare_txt()));
	connect(misc_patternsAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	break_adminAct = new QAction(tr("Break &Admin"), 0, this);
	break_adminAct->setStatusTip(tr("Break .if files in admin layer"));
	connect(break_adminAct, SIGNAL(activated()), this, SLOT(notice()));
	connect(break_adminAct, SIGNAL(activated()), parse9, SLOT(break_admin()));
	connect(break_adminAct, SIGNAL(activated()), this, SLOT(open_interfaces_admin_broken_up_txt()));
	connect(break_adminAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	break_appsAct = new QAction(tr("Break A&pps"), 0, this);
	break_appsAct->setStatusTip(tr("Break .if files in apps layer"));
	connect(break_appsAct, SIGNAL(activated()), this, SLOT(notice()));
	connect(break_appsAct, SIGNAL(activated()), parse10, SLOT(break_apps()));
	connect(break_appsAct, SIGNAL(activated()), this, SLOT(open_interfaces_apps_broken_up_txt()));
	connect(break_appsAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	break_kernelAct = new QAction(tr("Break &Kernel"), 0, this);
	break_kernelAct->setStatusTip(tr("Break .if files in kernel layer"));
	connect(break_kernelAct, SIGNAL(activated()), this, SLOT(notice()));
	connect(break_kernelAct, SIGNAL(activated()), parse11, SLOT(break_kernel()));
	connect(break_kernelAct, SIGNAL(activated()), this, SLOT(open_interfaces_kernel_broken_up_txt()));
	connect(break_kernelAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	break_servicesAct = new QAction(tr("Break &Services"), 0, this);
	break_servicesAct->setStatusTip(tr("Break .if files in services layer"));
	connect(break_servicesAct, SIGNAL(activated()), this, SLOT(notice()));
	connect(break_servicesAct, SIGNAL(activated()), parse12, SLOT(break_services()));
	connect(break_servicesAct, SIGNAL(activated()), this, SLOT(open_interfaces_services_broken_up_txt()));
	connect(break_servicesAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	break_systemAct = new QAction(tr("Break S&ystem"), 0, this);
	break_systemAct->setStatusTip(tr("Break .if files in system layer"));
	connect(break_systemAct, SIGNAL(activated()), this, SLOT(notice()));
	connect(break_systemAct, SIGNAL(activated()), parse13, SLOT(break_system()));
	connect(break_systemAct, SIGNAL(activated()), this, SLOT(open_interfaces_system_broken_up_txt()));
	connect(break_systemAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	selpaw_adminAct = new QAction(tr("Selpaw &Admin"), 0, this);
	selpaw_adminAct->setStatusTip(tr("parse .if files into .csv file in admin layer"));
	connect(selpaw_adminAct, SIGNAL(activated()), this, SLOT(notice()));
	connect(selpaw_adminAct, SIGNAL(activated()), parse14, SLOT(selpaw_admin()));
	connect(selpaw_adminAct, SIGNAL(activated()), this, SLOT(open_selpaw_admin_txt()));
	connect(selpaw_adminAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	selpaw_appsAct = new QAction(tr("Selpaw A&pps"), 0, this);
	selpaw_appsAct->setStatusTip(tr("parse .if files into .csv file in apps layer"));
	connect(selpaw_appsAct, SIGNAL(activated()), this, SLOT(notice()));
	connect(selpaw_appsAct, SIGNAL(activated()), parse14, SLOT(selpaw_apps()));
	connect(selpaw_appsAct, SIGNAL(activated()), this, SLOT(open_selpaw_apps_txt()));
	connect(selpaw_appsAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	selpaw_kernelAct = new QAction(tr("Selpaw &Kernel"), 0, this);
	selpaw_kernelAct->setStatusTip(tr("parse .if files into .csv file in kernel layer"));
	connect(selpaw_kernelAct, SIGNAL(activated()), this, SLOT(notice()));
	connect(selpaw_kernelAct, SIGNAL(activated()), parse14, SLOT(selpaw_kernel()));
	connect(selpaw_kernelAct, SIGNAL(activated()), this, SLOT(open_selpaw_kernel_txt()));
	connect(selpaw_kernelAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	selpaw_servicesAct = new QAction(tr("Selpaw &Services"), 0, this);
	selpaw_servicesAct->setStatusTip(tr("parse .if files into .csv file in services layer"));
	connect(selpaw_servicesAct, SIGNAL(activated()), this, SLOT(notice()));
	connect(selpaw_servicesAct, SIGNAL(activated()), parse14, SLOT(selpaw_services()));
	connect(selpaw_servicesAct, SIGNAL(activated()), this, SLOT(open_selpaw_services_txt()));
	connect(selpaw_servicesAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	selpaw_systemAct = new QAction(tr("Selpaw S&ystem"), 0, this);
	selpaw_systemAct->setStatusTip(tr("parse .if files into .csv file in system layer"));
	connect(selpaw_systemAct, SIGNAL(activated()), this, SLOT(notice()));
	connect(selpaw_systemAct, SIGNAL(activated()), parse14, SLOT(selpaw_system()));
	connect(selpaw_systemAct, SIGNAL(activated()), this, SLOT(open_selpaw_system_txt()));
	connect(selpaw_systemAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	selpaw_interface_rawAct = new QAction(tr("Selpaw_interface_&raw.csv"), 0, this);
	selpaw_interface_rawAct->setStatusTip(tr("Make selpaw_interface_raw.csv"));
	connect(selpaw_interface_rawAct, SIGNAL(activated()), this, SLOT(notice()));
	connect(selpaw_interface_rawAct, SIGNAL(activated()), selpaw1, SLOT(make_refine_selpaw()));
	connect(selpaw_interface_rawAct, SIGNAL(activated()), this, SLOT(open_selpaw_interface_raw_csv()));
	connect(selpaw_interface_rawAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	selpaw_eliminated_interfacesAct = new QAction(tr("Selpaw_&eliminated_interfaces.csv"), 0, this);
	selpaw_eliminated_interfacesAct->setStatusTip(tr("Make selpaw_eliminated_interfaces.csv"));
	connect(selpaw_eliminated_interfacesAct, SIGNAL(activated()), this, SLOT(notice()));
	connect(selpaw_eliminated_interfacesAct, SIGNAL(activated()), selpawadjust1, SLOT(adjust_selpaw_ready()));
	connect(selpaw_eliminated_interfacesAct, SIGNAL(activated()), this, SLOT(open_selpaw_eliminated_interfaces_csv()));
	connect(selpaw_eliminated_interfacesAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	selpaw_interface_readyAct = new QAction(tr("Selpaw_interface_rea&dy.csv"), 0, this);
	selpaw_interface_readyAct->setStatusTip(tr("Make selpaw_interface_ready.csv"));
	connect(selpaw_interface_readyAct, SIGNAL(activated()), this, SLOT(notice()));
	connect(selpaw_interface_readyAct, SIGNAL(activated()), selpawadjust1, SLOT(adjust_selpaw()));
	connect(selpaw_interface_readyAct, SIGNAL(activated()), this, SLOT(open_selpaw_interface_ready_csv()));
	connect(selpaw_interface_readyAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	selpaw_interface_csvAct = new QAction(tr("Selpaw_&interface.csv"), 0, this);
	selpaw_interface_csvAct->setStatusTip(tr("Make selpaw_interface.csv"));
	connect(selpaw_interface_csvAct, SIGNAL(activated()), this, SLOT(notice()));
	connect(selpaw_interface_csvAct, SIGNAL(activated()), selpawadjust1, SLOT(refine_selpaw()));
	connect(selpaw_interface_csvAct, SIGNAL(activated()), this, SLOT(open_selpaw_interface_csv()));
	connect(selpaw_interface_csvAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	howtouseAct = new QAction(tr("&How to use"), 0, this);
	howtouseAct->setStatusTip(tr("Show the application's How to use box"));
	connect(howtouseAct, SIGNAL(activated()), this, SLOT(howtouse()));
	connect(howtouseAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	enforcingAct = new QAction(tr("Change SELinux &state"), 0, this);
	enforcingAct->setStatusTip(tr("Change Enforcing / Permissive"));
	connect(enforcingAct, SIGNAL(activated()), this, SLOT(enforcing()));
	connect(enforcingAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	check_selinuxAct = new QAction(tr("&Check SELinux state"), 0, this);
	check_selinuxAct->setStatusTip(tr("Check SELinux State at present"));
	connect(check_selinuxAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	default_policyAct = new QAction(tr("&Default SELinux policy type"), 0, this);
	default_policyAct->setStatusTip(tr("Check SELinux default policy type"));
	connect(default_policyAct, SIGNAL(activated()), segatex_state, SLOT(default_policy_type()));
	connect(default_policyAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	selinuxYumAct = new QAction(tr("&Yum install/update"), 0, this);
	selinuxYumAct->setStatusTip(tr("Yum install/update SELinux related RPMs."));
	connect(selinuxYumAct, SIGNAL(activated()), this, SLOT(yum_selinux()));
	connect(selinuxYumAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	audit2allowAct = new QAction(tr("&Audit2allow"), 0, this);
	audit2allowAct->setStatusTip(tr("audit2allow"));
	connect(audit2allowAct, SIGNAL(activated()), this, SLOT(audit2allow()));
	connect(audit2allowAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	segatex_coreAct = new QAction(tr("Analize audit.&log"), 0, this);
	segatex_coreAct->setStatusTip(tr("Analize audit.log in many ways."));
	connect(segatex_coreAct, SIGNAL(activated()), this, SLOT(segatex_core()));
	connect(segatex_coreAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	semodule_core_processAct = new QAction(tr("&Modules"), 0, this);
	semodule_core_processAct->setStatusTip(tr("Modules."));
	connect(semodule_core_processAct, SIGNAL(activated()), this, SLOT(semodule_core_process()));
	connect(semodule_core_processAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));
}

void MainWindow::createMenus()
{
	fileMenu = new QPopupMenu(this);
	newAct->addTo(fileMenu);
	openAct->addTo(fileMenu);
	saveAct->addTo(fileMenu);
	saveAsAct->addTo(fileMenu);
	fileMenu->insertSeparator();
	exitAct->addTo(fileMenu);

	editMenu = new QPopupMenu(this);
	cutAct->addTo(editMenu);
	copyAct->addTo(editMenu);
	pasteAct->addTo(editMenu);
	deleteAct->addTo(editMenu);

	windowsMenu = new QPopupMenu(this);
	createWindowsMenu();

	helpMenu = new QPopupMenu(this);
	//newly added
	howtouseAct->addTo(helpMenu);
	aboutAct->addTo(helpMenu);
	aboutQtAct->addTo(helpMenu);

	//newly added-2:add actino to menu
	parselinesMenu = new QPopupMenu(this);

	parse_adminAct->addTo(parselinesMenu);
	parse_appsAct->addTo(parselinesMenu);
	parse_kernelAct->addTo(parselinesMenu);
	parse_servicesAct->addTo(parselinesMenu);
	parse_systemAct->addTo(parselinesMenu);
	obj_perm_setsAct->addTo(parselinesMenu);
	ipc_patternsAct->addTo(parselinesMenu);
	misc_patternsAct->addTo(parselinesMenu);
	break_adminAct->addTo(parselinesMenu);
	break_appsAct->addTo(parselinesMenu);
	break_kernelAct->addTo(parselinesMenu);
	break_servicesAct->addTo(parselinesMenu);
	break_systemAct->addTo(parselinesMenu);

	selpawMenu = new QPopupMenu(this);

	selpaw_adminAct->addTo(selpawMenu);
	selpaw_appsAct->addTo(selpawMenu);
	selpaw_kernelAct->addTo(selpawMenu);
	selpaw_servicesAct->addTo(selpawMenu);
	selpaw_systemAct->addTo(selpawMenu);

	refineMenu = new QPopupMenu(this);

	selpaw_interface_rawAct->addTo(refineMenu);
	selpaw_eliminated_interfacesAct->addTo(refineMenu);
	selpaw_interface_readyAct->addTo(refineMenu);
	selpaw_interface_csvAct->addTo(refineMenu);

	//newly added
	policyMenu = new QPopupMenu(this);

	segatex_coreAct->addTo(policyMenu);
	audit2allowAct->addTo(policyMenu);
	selinuxYumAct->addTo(policyMenu);
	enforcingAct->addTo(policyMenu);
	check_selinuxAct->addTo(policyMenu);
	default_policyAct->addTo(policyMenu);

	manageMenu = new QPopupMenu(this);
	semodule_core_processAct->addTo(manageMenu);

	menuBar()->insertItem(tr("&File"), fileMenu);
	menuBar()->insertItem(tr("&Edit"), editMenu);
	menuBar()->insertItem(tr("&Windows"), windowsMenu);

	//newly added-3:add action to menubar
	menuBar()->insertSeparator();
	menuBar()->insertItem(tr("&Policy"), policyMenu);
	menuBar()->insertItem(tr("&Modules"), manageMenu);

	menuBar()->insertSeparator();
	menuBar()->insertItem(tr("Parse&Lines"), parselinesMenu);
	menuBar()->insertItem(tr("&Selpaw"), selpawMenu);
	menuBar()->insertItem(tr("&Refine"), refineMenu);

	menuBar()->insertSeparator();
	menuBar()->insertItem(tr("&Help"), helpMenu);
}

void MainWindow::createToolBars()
{
	fileToolBar = new QToolBar(tr("File"), this);
	newAct->addTo(fileToolBar);
	openAct->addTo(fileToolBar);
	saveAct->addTo(fileToolBar);

	editToolBar = new QToolBar(tr("Edit"), this);
	cutAct->addTo(editToolBar);
	copyAct->addTo(editToolBar);
	pasteAct->addTo(editToolBar);
}

void MainWindow::createStatusBar()
{
	readyLabel = new QLabel(tr(" Ready"), this);

	modLabel = new QLabel(tr(" MOD "), this);

	//newly added
	selinux_policy = segatex_state->loaded_policy();
	enabled_or_not_str = segatex_state->is_selinux_enabled_segatex();
	getenforce_str = segatex_state->getenforce_segatex();
	if(enabled_or_not_str == "disabled")
	selinux_policy = "SELinux is " + enabled_or_not_str + ".";
	else
	selinux_policy = "SELinux is " + enabled_or_not_str + " and policy " + selinux_policy + " is moving in " + getenforce_str + " mode.";
	segatexStateLabel = new QLabel(tr(selinux_policy), this);
	segatexStateLabel->setAlignment(AlignHCenter);

	modLabel->setAlignment(AlignHCenter);
	modLabel->setMinimumSize(modLabel->sizeHint());
	modLabel->clear();

	statusBar()->addWidget(readyLabel, 1);
	statusBar()->addWidget(modLabel);
	statusBar()->addWidget(segatexStateLabel, 1);
}

void MainWindow::updateSegatexStateIndicator()
{
	selinux_policy = segatex_state->loaded_policy();
	enabled_or_not_str = segatex_state->is_selinux_enabled_segatex();
	getenforce_str = segatex_state->getenforce_segatex();
	if(enabled_or_not_str == "disabled")
	{
	selinux_policy = "SELinux is fully " + enabled_or_not_str + ".";
	segatexStateLabel->setPaletteBackgroundColor(QColor(255, 122, 162));
	}
	else
	{
	selinux_policy = "SELinux is " + enabled_or_not_str + " and policy " + selinux_policy + " " + getenforce_str + " is in use.";
		if(getenforce_str == "enforcing")
			segatexStateLabel->setPaletteBackgroundColor(QColor(155, 155, 255));
		if(getenforce_str == "permissive")
			segatexStateLabel->setPaletteBackgroundColor(QColor(255, 251, 126));
	}
	segatexStateLabel->clear();
	segatexStateLabel->setText(tr(selinux_policy));
}

void MainWindow::newFile()
{
	Editor *editor = createEditor();
	editor->newFile();
	editor->show();
}

Editor *MainWindow::createEditor()
{
	Editor *editor = new Editor(workspace);
	connect(editor, SIGNAL(copyAvailable(bool)),
	    this, SLOT(copyAvailable(bool)));
	connect(editor, SIGNAL(modificationChanged(bool)),
	    this, SLOT(updateModIndicator()));
	return editor;
}

void MainWindow::open()
{
	Editor *editor = createEditor();
	if (editor->open())
	editor->show();
	else
	editor->close();
}

//4:newly added
void MainWindow::open_interfaces_admin_txt()
{
	Editor *editor = createEditor();
	if (editor->openFile("interfaces_admin.txt"))
	editor->show();
	else
	editor->close();
}
void MainWindow::open_interfaces_apps_txt()
{
	Editor *editor = createEditor();
	if (editor->openFile("interfaces_apps.txt"))
	editor->show();
	else
	editor->close();
}
void MainWindow::open_interfaces_kernel_txt()
{
	Editor *editor = createEditor();
	if (editor->openFile("interfaces_kernel.txt"))
	editor->show();
	else
	editor->close();
}
void MainWindow::open_interfaces_services_txt()
{
    Editor *editor = createEditor();
    if (editor->openFile("interfaces_services.txt"))
        editor->show();
    else
        editor->close();
}
void MainWindow::open_interfaces_system_txt()
{
    Editor *editor = createEditor();
    if (editor->openFile("interfaces_system.txt"))
        editor->show();
    else
        editor->close();
}
void MainWindow::open_obj_perm_sets_prepare_txt()
{
    Editor *editor = createEditor();
    if (editor->openFile("obj_perm_sets_prepare.txt"))
        editor->show();
    else
        editor->close();
}
void MainWindow::open_ipc_patterns_prepare_txt()
{
    Editor *editor = createEditor();
    if (editor->openFile("ipc_patterns_prepare.txt"))
        editor->show();
    else
        editor->close();
}
void MainWindow::open_misc_patterns_prepare_txt()
{
    Editor *editor = createEditor();
    if (editor->openFile("misc_patterns_prepare.txt"))
        editor->show();
    else
        editor->close();
}
void MainWindow::open_interfaces_admin_broken_up_txt()
{
    Editor *editor = createEditor();
    if (editor->openFile("interfaces_admin_broken_up.txt"))
        editor->show();
    else
        editor->close();
}
void MainWindow::open_interfaces_apps_broken_up_txt()
{
    Editor *editor = createEditor();
    if (editor->openFile("interfaces_apps_broken_up.txt"))
        editor->show();
    else
        editor->close();
}
void MainWindow::open_interfaces_kernel_broken_up_txt()
{
    Editor *editor = createEditor();
    if (editor->openFile("interfaces_kernel_broken_up.txt"))
        editor->show();
    else
        editor->close();
}
void MainWindow::open_interfaces_services_broken_up_txt()
{
    Editor *editor = createEditor();
    if (editor->openFile("interfaces_services_broken_up.txt"))
        editor->show();
    else
        editor->close();
}
void MainWindow::open_interfaces_system_broken_up_txt()
{
    Editor *editor = createEditor();
    if (editor->openFile("interfaces_system_broken_up.txt"))
        editor->show();
    else
        editor->close();
}
void MainWindow::open_selpaw_admin_txt()
{
    Editor *editor = createEditor();
    if (editor->openFile("selpaw_admin.txt"))
        editor->show();
    else
        editor->close();
}
void MainWindow::open_selpaw_apps_txt()
{
    Editor *editor = createEditor();
    if (editor->openFile("selpaw_apps.txt"))
        editor->show();
    else
        editor->close();
}
void MainWindow::open_selpaw_kernel_txt()
{
    Editor *editor = createEditor();
    if (editor->openFile("selpaw_kernel.txt"))
        editor->show();
    else
        editor->close();
}
void MainWindow::open_selpaw_services_txt()
{
    Editor *editor = createEditor();
    if (editor->openFile("selpaw_services.txt"))
        editor->show();
    else
        editor->close();
}
void MainWindow::open_selpaw_system_txt()
{
    Editor *editor = createEditor();
    if (editor->openFile("selpaw_system.txt"))
        editor->show();
    else
        editor->close();
}
void MainWindow::open_selpaw_interface_raw_csv()
{
    Editor *editor = createEditor();
    if (editor->openFile("selpaw_interface_raw.csv"))
        editor->show();
    else
        editor->close();
}
void MainWindow::open_selpaw_eliminated_interfaces_csv()
{
    Editor *editor = createEditor();
    if (editor->openFile("selpaw_eliminated_interfaces.csv"))
        editor->show();
    else
        editor->close();
}
void MainWindow::open_selpaw_interface_ready_csv()
{
    Editor *editor = createEditor();
    if (editor->openFile("selpaw_interface_ready.csv"))
        editor->show();
    else
        editor->close();
}
void MainWindow::open_selpaw_interface_csv()
{
    Editor *editor = createEditor();
    if (editor->openFile("selpaw_interface.csv"))
        editor->show();
    else
        editor->close();
}


void MainWindow::openFile(const QString &fileName)
{
    Editor *editor = createEditor();
    if (editor->openFile(fileName))
        editor->show();
    else
        editor->close();
}

void MainWindow::save()
{
    if (activeEditor()) {
        activeEditor()->save();
        updateModIndicator();
    }
}

Editor *MainWindow::activeEditor()
{
    return (Editor *)workspace->activeWindow();
}

void MainWindow::saveAs()
{
    if (activeEditor()) {
        activeEditor()->saveAs();
        updateModIndicator();
    }
}

void MainWindow::cut()
{
    if (activeEditor())
        activeEditor()->cut();
}

void MainWindow::copy()
{
    if (activeEditor())
        activeEditor()->copy();
}

void MainWindow::paste()
{
    if (activeEditor())
        activeEditor()->paste();
}

void MainWindow::del()
{
    if (activeEditor())
        activeEditor()->del();
}

void MainWindow::notice()
{
    QMessageBox::about(this, tr("Notice on breaking .if files"),
            tr("<p>Breaking .if files takes long time,"
               "<p>especially, kernel."
               "<p>Please break yourself by drinking coffee."));
}

void MainWindow::about()
{
	QMessageBox::about(this, tr("About segatex_suite"),
		tr("<h2>segatex_suite-2.3(for F7)</h2>"
		"<p>Copyright &copy; 2007"
		"<p>Shintaro Fujiwara."
		"<p>segatex_suite is a SELinux tool"
		"<p><b>written with Qt</b>."));
}
//newly added
void MainWindow::howtouse()
{
	QMessageBox::about(this, tr("How to use"),
		tr("<h2>How to use segatex_suite</h2>"
		"<p><font color=\"blue\">[segatex]</font>"
		"<p>You can set selinux enforcing"
		" and permissive just pushing button."
		" You can install/update SELinux related"
		" RPMs.You can audit2allow -m local -a"
		" with other options,-l -R -v -e."
		" You can analize audit log."
		" You can generate interfaced policy,by "
		" Analize audit.log-generate policy."
		"<p><font color=\"blue\">[segatex_editor]</font>"
		"<p>Push Parselines,Selpaw,Refine"
		" one by one orderly."
		"<p>If you could get three selpaw files,"
		"i.e."
		"selpaw_interface.csv,"
		"selpaw_interface_types.csv,"
		"selpaw_interface_summary.csv,"
		" that is a success."
		"<p>Break kernel may take 30 minutes, and"
		" Refine selpaw takes 10 minutes;)</p>"));
}


void MainWindow::updateMenus()
{
    bool hasEditor = (activeEditor() != 0);
    saveAct->setEnabled(hasEditor);
    saveAsAct->setEnabled(hasEditor);
    pasteAct->setEnabled(hasEditor);
    deleteAct->setEnabled(hasEditor);
    copyAvailable(activeEditor()
                  && activeEditor()->hasSelectedText());
    closeAct->setEnabled(hasEditor);
    closeAllAct->setEnabled(hasEditor);
    tileAct->setEnabled(hasEditor);
    cascadeAct->setEnabled(hasEditor);
    nextAct->setEnabled(hasEditor);
    previousAct->setEnabled(hasEditor);

    windowsMenu->clear();
    createWindowsMenu();
}

void MainWindow::createWindowsMenu()
{
    closeAct->addTo(windowsMenu);
    closeAllAct->addTo(windowsMenu);
    windowsMenu->insertSeparator();
    tileAct->addTo(windowsMenu);
    cascadeAct->addTo(windowsMenu);
    windowsMenu->insertSeparator();
    nextAct->addTo(windowsMenu);
    previousAct->addTo(windowsMenu);

    if (activeEditor()) {
        windowsMenu->insertSeparator();
        windows = workspace->windowList();
        int numVisibleEditors = 0;

        for (int i = 0; i < (int)windows.count(); ++i) {
            QWidget *win = windows.at(i);
            if (!win->isHidden()) {
                QString text = tr("%1 %2")
                               .arg(numVisibleEditors + 1)
                               .arg(win->caption());
                if (numVisibleEditors < 9)
                    text.prepend("&");
                int id = windowsMenu->insertItem(
                              text, this, SLOT(activateWindow(int)));
                bool isActive = (activeEditor() == win);
                windowsMenu->setItemChecked(id, isActive);
                windowsMenu->setItemParameter(id, i);
                ++numVisibleEditors;
            }
        }
    }
}

void MainWindow::activateWindow(int param)
{
    QWidget *win = windows.at(param);
    win->show();
    win->setFocus();
}

void MainWindow::copyAvailable(bool available)
{
    cutAct->setEnabled(available);
    copyAct->setEnabled(available);
}

void MainWindow::updateModIndicator()
{
    if (activeEditor() && activeEditor()->isModified())
        modLabel->setText(tr("MOD"));
    else
        modLabel->clear();
}

void MainWindow::closeEvent(QCloseEvent *event)
{
    workspace->closeAllWindows();
    if (activeEditor())
        event->ignore();
    else
        event->accept();
}
//newly added
void MainWindow::enforcing()
{
	if(!segatex_apply) {
		segatex_apply = new SegatexApply(this);
		connect(segatex_apply, SIGNAL(enforcingOn()), segatex_apply, SLOT(setenforce_enforcing())); 
		connect(segatex_apply, SIGNAL(permissiveOn()), segatex_apply, SLOT(setenforce_permissive())); 
		//connect(segatex_apply, SIGNAL(disabledOn()), segatex_apply, SLOT(setenforce_disabled())); 
	}
	segatex_apply->show();
	segatex_apply->raise();
	segatex_apply->setActiveWindow();
}
//newly added
void MainWindow::yum_selinux()
{
	if(!selinux_yum) {
		selinux_yum = new SegatexYum(this);
	}
	selinux_yum->show();
	selinux_yum->raise();
	selinux_yum->setActiveWindow();
}
void MainWindow::audit2allow()
{
	if(!selinux_audit2allow) {
		selinux_audit2allow = new SegatexAudit2allow(this);
	}
	selinux_audit2allow->show();
	selinux_audit2allow->raise();
	selinux_audit2allow->setActiveWindow();
}
void MainWindow::segatex_core()
{
	if(!segatex_core_o) {
		segatex_core_o = new SegatexCore(this);
	}
	segatex_core_o->show();
	segatex_core_o->raise();
	segatex_core_o->setActiveWindow();
}
void MainWindow::semodule_core_process()
{
	if(!semodule_core_process_o) {
		semodule_core_process_o = new SemoduleCoreProcess(this);
	}
	semodule_core_process_o->show();
	semodule_core_process_o->raise();
	semodule_core_process_o->setActiveWindow();
}
