/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2008 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qpushbutton.h>
#include <qlineedit.h>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "ausearch.h"
#include "ausearch_process.h"

#include <iostream>
using namespace std;

//default constructor
Ausearch::Ausearch(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Ausearch"));

	ausearchLabel = new QLabel(tr("Search about"),this);
        optionButtonGroup = new QButtonGroup(this);
        optionButtonGroup->resize( 650, 350 );
        eventRadioButton = new QRadioButton(tr("events (audit-event-id)"), optionButtonGroup);
        eventRadioButton->setGeometry( 10, 10, 400, 20 );//-a
        commnameRadioButton = new QRadioButton(tr("come name (comm-name)"), optionButtonGroup);
        commnameRadioButton->setGeometry( 10, 30, 400, 20 );//-c
        filenameRadioButton = new QRadioButton(tr("filename (file-name)"), optionButtonGroup);
        filenameRadioButton->setGeometry( 10, 50, 400, 20 );//-f
        allgroupidRadioButton = new QRadioButton(tr("group ID (all-group-id)"), optionButtonGroup);
        allgroupidRadioButton->setGeometry( 10, 70, 400, 20 );//-ga
        effectivegroupidRadioButton = new QRadioButton(tr("effective group ID (effective-group-id)"), optionButtonGroup);
        effectivegroupidRadioButton->setGeometry( 10, 90, 400, 20 );//-ga
        groupidRadioButton = new QRadioButton(tr("group ID (group-id)"), optionButtonGroup);
        groupidRadioButton->setGeometry( 10, 110, 400, 20 );//-ga
        helpRadioButton = new QRadioButton(tr("help"), optionButtonGroup);
        helpRadioButton->setGeometry( 10, 130, 400, 20 );//-ga
        hostnameRadioButton = new QRadioButton(tr("host name (host-name)"), optionButtonGroup);
        hostnameRadioButton->setGeometry( 10, 150, 400, 20 );//-ga
        keystringRadioButton = new QRadioButton(tr("key string (key-string)"), optionButtonGroup);
        keystringRadioButton->setGeometry( 10, 170, 400, 20 );//-ga
        nodenameRadioButton = new QRadioButton(tr("node (node-name)"), optionButtonGroup);
        nodenameRadioButton->setGeometry( 10, 190, 400, 20 );//-ga

	eventRadioButton->setChecked(true);

	ausearchEditLineEdit = new QLineEdit( this );
        ausearchEditLineEdit->setText("");
        ausearchEditLineEdit->setPaletteBackgroundColor(QColor(200,200,140));

	ausearchButton = new QPushButton(tr("Search"), this);
	ausearchButton->setPaletteBackgroundColor(QColor(250,180,200));
	connect(ausearchButton, SIGNAL(clicked()), this, SLOT(ausearch_button_clicked()));

	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	mainLayout = new QVBoxLayout(this);
	middleLayout = new QVBoxLayout;
	firstLayout = new QVBoxLayout;
	secondLayout = new QVBoxLayout;
	thirdLayout = new QHBoxLayout;
	fourthLayout = new QHBoxLayout;
	footLayout = new QHBoxLayout;
	
	mainLayout->setMargin(11);
	secondLayout->addWidget(ausearchLabel);
	secondLayout->addWidget(optionButtonGroup);
	thirdLayout->addStretch();
	thirdLayout->addWidget(ausearchEditLineEdit);
	thirdLayout->addStretch();
	fourthLayout->addStretch();
	fourthLayout->addWidget(ausearchButton);
	fourthLayout->addStretch();

	firstLayout->addLayout(secondLayout);
	firstLayout->addLayout(thirdLayout);

	middleLayout->addLayout(firstLayout);
	middleLayout->addLayout(fourthLayout);

	footLayout->addStretch();
	footLayout->addWidget(closeButton);

	mainLayout->addLayout(middleLayout);
	mainLayout->addLayout(footLayout);

	ausearch_process = 0;

	resize(1000,480);
}

/*signal and slot should have same argument pattern so I had to pass to another slot*/
void Ausearch::ausearch_button_clicked()
{
        if(eventRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch -a " + ausearchEditLineEdit_str;
	}
        if(commnameRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --comm " + ausearchEditLineEdit_str;
	}
        if(filenameRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --file " + ausearchEditLineEdit_str;
	}
        if(allgroupidRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --gid-all " + ausearchEditLineEdit_str;
	}
        if(effectivegroupidRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --gid-effective " + ausearchEditLineEdit_str;
	}
        if(groupidRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --gid " + ausearchEditLineEdit_str;
	}
        if(helpRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --help";
	}
        if(hostnameRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --host " + ausearchEditLineEdit_str;
	}
        if(keystringRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --key " + ausearchEditLineEdit_str;
	}
        if(nodenameRadioButton->isChecked()){
		ausearchEditLineEdit_str = ausearchEditLineEdit->text();
                ausearch_str_pp_str = "ausearch --node " + ausearchEditLineEdit_str;
	}

	ausearch_process = new AusearchProcess(this);
	//connect(ausearch_process, SIGNAL(ausearch_process_close_button_clicked()), this, SLOT(close()));
	connect(closeButton, SIGNAL(clicked()), ausearch_process, SLOT(close()));
	ausearch_process->setCaption(tr(ausearch_str_pp_str));
	ausearch_process->show();
	ausearch_process->raise();
	ausearch_process->setActiveWindow();

	ausearch_process->ausearch_base_process(ausearch_str_pp_str);

}
