/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2009 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#ifndef SEMODULEDONTAUDIT_H
#define SEMODULEDONTAUDIT_H

#include <q3textedit.h>
#include <q3process.h>
#include <qdialog.h>
#include <qlayout.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <QButtonGroup>
#include <QPushButton>
#include <QGroupBox>
#include <qradiobutton.h>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QDateTime>
#include <QString>

class QLayout;
class QMessageBox;
class Q3TextEdit;
class SemoduleDontauditProcess;

class SemoduleDontaudit: public QDialog
{
	Q_OBJECT
public:
	SemoduleDontaudit(QWidget *parent = 0, const char *name = 0);
	int y;
	int semodule_dontaudit_common_int;
	SemoduleDontauditProcess *semodule_dontaudit_process;
	QLabel *dontauditLabel;
        QString dontaudit_present_state_str;
public slots:
signals:
protected:
private slots:
	void dontaudit_clicked();
	void semodule_dontaudit_base_process();
	void processExited();
	void readFromStdout();
	int readFromOutputFile_and_return_str();
private:
	int check_int;
	Q3Process *process;
	Q3Process *process2;
	Q3TextEdit *textEdit1;
        QDir dir;
        QString test_str;
        QString path;
        QString name;
        QString dir_name;
        QString forward_slash;
        QString file_interface_name;
        QString line_analized;
        QString outputfile_str;
	QPushButton *dontauditButton;
	QPushButton *closeButton;
	QGroupBox *optionButtonGroupBox;
	QGroupBox *createFirstExclusiveGroup();

	QRadioButton *auditAllRadioButton;
	QRadioButton *dontauditSomeRadioButton;

	QVBoxLayout *leftLayout;
	QVBoxLayout *vbox;
	QVBoxLayout *rightLayout;
	QHBoxLayout *mainLayout;

	QMessageBox *waning;
	int return_value;
	QLabel *datetimeLabel;
	QDateTime *date_time_obj;
	QDateTime currentDateTime;
	QString currentDateTime_str;
	QString date_time_str;

        QStringList::Iterator it_d;
        QStringList files;
	int set_int;
};

#endif
