#
# segatex SELinux tool.
#
# Copyright (C) 2007-2013 Shintaro Fujiwara 
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

#!/bin/sh 

ERROR=0
LINE=
SOURCEFILE=
INCLUDEIFFILE="../allif.txt"
INCLUDESPTFILE="../allspt.txt"
INCLUDEFILE="include_if"
BROKENUPPREPAREFILE="broken_up_prepare"
BROKENUPPREPAREFILE2="broken_up_prepare2"
BROKENUPPREPAREFILE3="broken_up_prepare3"
BROKENUPPREPAREFILE4="broken_up_prepare4"
BROKENUPFILE="broken_up"
BROKENUPFILE2="broken_up2"
NEWFILE="prepare"
CSPLITFILE="xx00"
CSPLITFILE2="xx01"
BLANK=""
TAB="	"

FILELISTPREPARE="filelist_prepare.txt"
FILELIST="filelist.txt"


BREAK_TE(){
	find . \( -type f -name "*.te" \) -print | sort > $FILELISTPREPARE && awk -F/ '{print $2}' $FILELISTPREPARE > $FILELIST

	IFS=
	while read LINE
	do
			SOURCEFILE="$LINE"
		if [ ! -r "$SOURCEFILE" ]; then
			echo "Cannot find file $SOURCEFILE" 1>&2
			ERROR=1
		else
			#echo ""
			#echo ""
			#echo "SOURCEFILE:"$SOURCEFILE
	########### write include(`all.if') first line of the source file#######################################
			cat $INCLUDEIFFILE $SOURCEFILE > $INCLUDEFILE
			m4 $INCLUDEFILE > $BROKENUPPREPAREFILE
			####interface to define
			sed 's/interface/define/g' $BROKENUPPREPAREFILE > $BROKENUPPREPAREFILE2
			####make preparaton
			m4 $BROKENUPPREPAREFILE2 > $BROKENUPPREPAREFILE3
	########### write include(`all.spt') first line of the brokenupprepare file number#######################################
			cat $INCLUDESPTFILE $BROKENUPPREPAREFILE3 > $BROKENUPPREPAREFILE4
			####put this to first line
			m4 $BROKENUPPREPAREFILE4 > $BROKENUPFILE
			####this is done
			#echo "Success making "$BROKENUPFILE
			#echo "NOW MAKING RAWFILE PLEASE WAIT!"
	########### make broken .te_raw#######################################
			sed 's/# Declarations/Declarations/g' $BROKENUPFILE > $BROKENUPFILE2
			COMP_STR="Declarations"
			csplit $BROKENUPFILE2 /^$COMP_STR/ {*}
			sed 's/Declarations/# Declarations/g' xx01 > $NEWFILE
	########### eliminate blank lines#######################################
			NEWFILE_NEW=$SOURCEFILE"_raw"
			grep [a-zA-Z#{}] "$NEWFILE" > "$NEWFILE_NEW"
			echo "Made "$NEWFILE_NEW
		fi

		unlink $BROKENUPPREPAREFILE
		unlink $BROKENUPPREPAREFILE2
		unlink $BROKENUPPREPAREFILE3
		unlink $BROKENUPPREPAREFILE4
		unlink $BROKENUPFILE
		unlink $BROKENUPFILE2
		unlink $NEWFILE
		unlink $CSPLITFILE
		unlink $CSPLITFILE2

	done < "$FILELIST"

	unlink $FILELISTPREPARE
	unlink $FILELIST
}

cd /usr/share/segatex/raw_te_files

### Get directory name under current directory and put into var.
DICNAME=`find ./ -type d -name "*" | awk -F/ '{ print $2 }'`
### Do something in every directory.

for CHECKDIC in $DICNAME
do
	(\
	cd $CHECKDIC; \
	echo ""
	echo Breaking .te files in $CHECKDIC directory !; \
	echo ""
	BREAK_TE; \
	)
done

echo "Breaking .te scripts Successfully finished."
echo ""
echo "You can see raw .te files in /usr/share/segatex/raw_te_files/"layers" as te_raw files."
echo "You can understand fully the meaning of type enforcement process of SELinx."

exit $ERROR
