/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <QPushButton>
#include <QTextStream>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QDebug>
#include <QScrollBar>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fstream>

#include "aureport_process.h"

#include <iostream>
using namespace std;

//constructor
AureportProcess::AureportProcess(QString aureport_str_pp_str, QWidget *parent, const char *name): QDialog(parent, name)
{
        //this will not freeze GUI
	this->setEnabled(true);

	setCaption(tr("Aureport Process"));
	textEdit1 = new QTextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(250,180,200));
        textEdit1->resize( 600, 100 );

	closeButton = new QPushButton(tr("close"), this);
	closeButton->setDefault(true);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	//connect(closeButton, SIGNAL(clicked()), this, SLOT(close_button_clicked()));

	upperLayout = new QVBoxLayout;
	upperLayout->addWidget(textEdit1);

	footLayout = new QHBoxLayout;
	footLayout->addStretch(1);
	footLayout->addWidget(closeButton);

	mainLayout = new QVBoxLayout(this);
	mainLayout->setMargin(11);
	mainLayout->setSpacing(6);

	mainLayout->addLayout(upperLayout);
	mainLayout->addLayout(footLayout);
	resize(1000,600);

        readFromStdout3(aureport_str_pp_str);

}
void AureportProcess::readFromStdout3(QString aureport_str_pp_str)
{
                #define SIZE_TMP 8200
                char buffer[SIZE_TMP];
                FILE* read_fp;
                aureport_str_pp_str = "export LANG=C&&" + aureport_str_pp_str;
                read_fp = popen(aureport_str_pp_str, "r");
                memset(buffer, '\0', sizeof(buffer));
                if (read_fp == NULL) {
                  //error occurred;
                }

                int chars_read;
                chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                while(chars_read>0){
                    buffer[chars_read -1] = '\0';
                    chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
	            textEdit1->append(buffer);
                }
		pclose(read_fp);
                //jump to the top
                textEdit1->moveCursor(QTextCursor::Start) ;
                textEdit1->ensureCursorVisible() ;
}
