/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <QLayout>
#include <QLineEdit>
#include <QPushButton>
#include <QRadioButton>
#include <QTextEdit>
#include <QMessageBox>
#include <QTextStream>
#include <fstream>

#include "breakif.h"

#include <iostream>
using namespace std;

//default constructor
BreakIf::BreakIf(QWidget *parent, const char *name): QDialog(parent, name)
{
		setCaption(tr("break .if files"));
		textEdit1 = new QTextEdit(this);
		textEdit1->setPaletteBackgroundColor(QColor(174,187,255));
		closeButton = new QPushButton(tr("&Close"), this);
		breakifButton = new QPushButton(tr("break .if files"), this);
		breakifButton->setPaletteBackgroundColor(QColor(255, 155, 155));
		breakifButton->setDefault(true);

		connect(breakifButton, SIGNAL(clicked()), this, SLOT(breakif_clicked()));
		connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));

		firstLayout = new QVBoxLayout;
		leftLayout = new QHBoxLayout;

		rightLayout = new QVBoxLayout;
		rightLayout->addWidget(breakifButton);
		rightLayout->addWidget(closeButton);

		firstLayout->addLayout(leftLayout);
		firstLayout->addWidget(textEdit1);

		mainLayout = new QHBoxLayout(this);
		mainLayout->setMargin(11);
		mainLayout->setSpacing(6);
		mainLayout->addLayout(firstLayout);
		mainLayout->addLayout(rightLayout);

		resize(1000,600);
}

void BreakIf::processExited(int exitCode, QProcess::ExitStatus exitStatus)
{
	if ( exitStatus == QProcess::CrashExit )
	{
		//QMessageBox::warning( this, tr("Error"), tr("Crashed") );
		textEdit1->append(tr("Error, Crashed !"));
		textEdit1->append(tr("\n"));
	}
	else if ( exitCode != 0 )
	{
		//QMessageBox::warning( this, tr("Error"), tr("Failed") );
		textEdit1->append(tr("Error, Failed !"));
		textEdit1->append(tr("\n"));
	}
	else
	{
		textEdit1->append(tr("breakif  process ended !"));
		textEdit1->append(tr("\n"));
        }
	delete process;
	process = 0;
	this->setEnabled(true);
}

void BreakIf::breakif_clicked()
{
		breakif_base_process();
}
////////////////////////////////////////////
void BreakIf::readFromStdout()
{
        QByteArray data = process->readAllStandardOutput();
        QString text = textEdit1->text() + QString(data);
        textEdit1->setText(text);
}
void BreakIf::updateOutputTextEdit()
{
	QByteArray data = process->readAllStandardError();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}
void BreakIf::breakif_base_process()
{
	this->setEnabled(false);
	process = new QProcess(this);

	connect(process, SIGNAL(readyReadStandardOutput()),this,SLOT(readFromStdout()));
	connect(process, SIGNAL(readyReadStandardError()),this,SLOT(updateOutputTextEdit()));
	connect(process, SIGNAL(finished(int, QProcess::ExitStatus)),this,SLOT(processExited(int, QProcess::ExitStatus)));
	process->start("/bin/bash", QStringList() << "-c" << "export LANG=C;/usr/share/segatex/raw_if_files/breakif.sh");

}
