/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <QLayout>
#include <QPushButton>
#include <QLineEdit>
#include <QTextEdit>
#include <QMessageBox>
#include <QWorkspace>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fstream>

#include "downloader.h"
#include "downloader_process.h"

#include <iostream>
using namespace std;


//constructor
Downloader::Downloader(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Download fedora"));

        optionButtonGroup = new Q3ButtonGroup(this);
        optionButtonGroup->resize( 400, 50 );
        usRadioButton = new QRadioButton(tr("us ftp site (mirrors.kernel.org)"), optionButtonGroup);
        usRadioButton->setGeometry( 10, 10, 320, 20 );
        jpRadioButton = new QRadioButton(tr("jp ftp site (ftp.riken.jp)"), optionButtonGroup);
        jpRadioButton->setGeometry( 10, 30, 320, 20 );
        deRadioButton = new QRadioButton(tr("german ftp site (ftp.uni-kl.de)"), optionButtonGroup);
        deRadioButton->setGeometry( 10, 50, 320, 20 );
        frRadioButton = new QRadioButton(tr("french ftp site (ftp.lip6.fr)"), optionButtonGroup);
        frRadioButton->setGeometry( 10, 70, 320, 20 );
        auRadioButton = new QRadioButton(tr("Australian ftp site (mirror.aarnet.edu.au)"), optionButtonGroup);
        auRadioButton->setGeometry( 10, 90, 320, 20 );

	usRadioButton->setChecked(true);

        fedoraVersionButtonGroup = new Q3ButtonGroup(this);
        fedoraVersionButtonGroup->resize( 150, 70 );
        new4RadioButton = new QRadioButton(tr("version 18"), fedoraVersionButtonGroup);
        new4RadioButton->setGeometry( 10, 10, 300, 20 );
        new3RadioButton = new QRadioButton(tr("version 19"), fedoraVersionButtonGroup);
        new3RadioButton->setGeometry( 10, 30, 300, 20 );
        new2RadioButton = new QRadioButton(tr("version 20"), fedoraVersionButtonGroup);
        new2RadioButton->setGeometry( 10, 50, 300, 20 );
        newRadioButton = new QRadioButton(tr("version 21"), fedoraVersionButtonGroup);
        newRadioButton->setGeometry( 10, 70, 300, 20 );

	newRadioButton->setChecked(true);

	downloadButton = new QPushButton(tr("Download Fedora"), this);
	downloadButton->setPaletteBackgroundColor(QColor(100,200,200));

	connect(downloadButton, SIGNAL(clicked()), this, SLOT(download_button_clicked()));

	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	mainLayout = new QVBoxLayout(this);
	mainLayout->setMargin(11);

	middleLayout = new QVBoxLayout;

	firstLayout = new QHBoxLayout;
	secondLayout = new QVBoxLayout;
	thirdLayout = new QVBoxLayout;

	rightLayout = new QHBoxLayout;
	
	secondLayout->addWidget(optionButtonGroup);
	thirdLayout->addWidget(fedoraVersionButtonGroup);
	firstLayout->addLayout(secondLayout);
	firstLayout->addLayout(thirdLayout);

	rightLayout->addWidget(downloadButton);
	rightLayout->addStretch();

	middleLayout->addLayout(firstLayout);
	middleLayout->addLayout(rightLayout);


	footLayout = new QHBoxLayout;
	footLayout->addStretch();
	footLayout->addWidget(closeButton);

	mainLayout->addLayout(middleLayout);
	mainLayout->addLayout(footLayout);
	resize(660,250);
}

void Downloader::download_button_clicked()
{
	//QUrl url_for_fedora("ftp://mirrors.kernel.org");
	if(usRadioButton->isChecked()){
                url_for_fedora.setUrl("ftp://mirrors.kernel.org");
		url_for_fedora.setPort(21);
		mirror = 1;
		if(new4RadioButton->isChecked()){
			version = "new4";
		}
		if(new3RadioButton->isChecked()){
			version = "new3";
		}
		if(new2RadioButton->isChecked()){
			version = "new2";
		}
		if(newRadioButton->isChecked()){
			version = "new";
		}
	}
	if(jpRadioButton->isChecked()){
                url_for_fedora.setUrl("ftp://ftp.riken.jp");
		url_for_fedora.setPort(21);
		mirror = 2;
		if(new4RadioButton->isChecked()){
			version = "new4";
		}
		if(new3RadioButton->isChecked()){
			version = "new3";
		}
		if(new2RadioButton->isChecked()){
			version = "new2";
		}
		if(newRadioButton->isChecked()){
			version = "new";
		}
	}
	if(deRadioButton->isChecked()){
                url_for_fedora.setUrl("ftp://ftp.uni-kl.de");
		url_for_fedora.setPort(21);
		mirror = 2;
		if(new4RadioButton->isChecked()){
			version = "new4";
		}
		if(new3RadioButton->isChecked()){
			version = "new3";
		}
		if(new2RadioButton->isChecked()){
			version = "new2";
		}
		if(newRadioButton->isChecked()){
			version = "new";
		}
	}
	if(frRadioButton->isChecked()){
                url_for_fedora.setUrl("ftp://ftp.lip6.fr");
		url_for_fedora.setPort(21);
		mirror = 2;
		if(new4RadioButton->isChecked()){
			version = "new4";
		}
		if(new3RadioButton->isChecked()){
			version = "new3";
		}
		if(new2RadioButton->isChecked()){
			version = "new2";
		}
		if(newRadioButton->isChecked()){
			version = "new";
		}
	}
	if(auRadioButton->isChecked()){
                url_for_fedora.setUrl("ftp://mirror.aarnet.edu.au");
		url_for_fedora.setPort(21);
		mirror = 2;
		if(new4RadioButton->isChecked()){
			version = "new4";
		}
		if(new3RadioButton->isChecked()){
			version = "new3";
		}
		if(new2RadioButton->isChecked()){
			version = "new2";
		}
		if(newRadioButton->isChecked()){
			version = "new";
		}
	}

	downloader_process_o = 0;
	downloader_process_o = new DownloaderProcess(url_for_fedora, version);

	connect(downloader_process_o, SIGNAL(downloader_process_close_button_clicked()), this, SLOT(close()));
	connect(closeButton, SIGNAL(clicked()), downloader_process_o, SLOT(close()));
	downloader_process_o->show();
	downloader_process_o->raise();
	downloader_process_o->setActiveWindow();
}
void Downloader::updateOutputTextEdit()
{
	QByteArray data = process->readAllStandardError();
}
void Downloader::readFromStdout()
{
	QByteArray data = process->readAllStandardOutput();
}
void Downloader::processExited(int exitCode, QProcess::ExitStatus exitStatus)
{
	if ( exitStatus == QProcess::CrashExit )
	{
		//QMessageBox::warning( this, tr("Error"), tr("Crashed") );
		QMessageBox::warning(0, tr("Downloader Fedora"),
				     tr("Downloader Fedora process crashed."));
		return;
	}
	else if ( exitCode != 0 )
	{
		//QMessageBox::warning( this, tr("Error"), tr("Failed") );
		QMessageBox::warning(0, tr("Downloader Fedora"),
				     tr("Downloader Fedora process had an error."));
		return;
	}
	else
	{
		QMessageBox::warning(0, tr("Downloader Fedora"),
				     tr("Downloader Fedora process was a success"));
        }
	delete process;
	process = 0;
	this->setEnabled(true);
}

