/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#ifndef DOWNLOADERPROCESS_H
#define DOWNLOADERPROCESS_H

#include <QProcess> 
#include <QVBoxLayout> 
#include <QHBoxLayout> 

#include "downloader.h" 


class DownloaderProcess: public QDialog 
{
	Q_OBJECT
public:
	DownloaderProcess(QUrl &url_for_fedora, QString version,QWidget *parent = 0, const char *name = 0);
    
public slots:
signals:
	void downloader_process_close_button_clicked();
protected:

private slots:
	void close_button_clicked();
	void downloader_base_process(QUrl&, QString);
	void readFromStdout();
	void updateOutputTextEdit();
        void processExited(int, QProcess::ExitStatus);
private:
	QPushButton *closeButton;
	QTextEdit *textEdit1;
	QProcess *process;
	QVBoxLayout *headLayout;
	QHBoxLayout *footLayout;
	QVBoxLayout *mainLayout;
	//SegatexYum *selinux_yum_on;
	DownloaderProcess *downloader_process_o;
	DownloaderProcess *downloader_process_progress;
	int a,b,c;
};

#endif
