/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <QLayout>
#include <QPushButton>
//#include <q3process.h>
#include <QRadioButton>
#include <q3buttongroup.h>
#include <qlineedit.h>
#include <QTextEdit>
#include <QTextStream>
#include <QLabel>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fstream>
#include <QMessageBox>

#include "policygeneration.h"
#include "policygeneration_process.h"

#include <iostream>
using namespace std;

//default constructor
Policygeneration::Policygeneration(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Policygeneration Process"));
	textEdit1 = new QTextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(0,254,100));
	semanageEditLabel = new QLabel(tr("policy_module name:"), this );
	semanageEditLabel2 = new QLabel(tr("executable path:"), this );
	semanageEditLabel3 = new QLabel(tr("pid file path:"), this );
	semanageEditLabel4 = new QLabel(tr("log file(s) path:"), this );
	semanageEditLabel5 = new QLabel(tr("var/lib file(s) path:"), this );
	semanageEditLineEdit = new QLineEdit( this );
	semanageEditLineEdit2 = new QLineEdit( this );
	semanageEditLineEdit3 = new QLineEdit( this );
	semanageEditLineEdit4 = new QLineEdit( this );
	semanageEditLineEdit5 = new QLineEdit( this );
	semanageEditLineEdit->setText("");
	semanageEditLineEdit->setPaletteBackgroundColor(QColor(255,100,200));
	semanageEditLineEdit2->setText("");
	semanageEditLineEdit2->setPaletteBackgroundColor(QColor(255,100,200));
	semanageEditLineEdit3->setText("");
	semanageEditLineEdit3->setPaletteBackgroundColor(QColor(255,100,200));
	semanageEditLineEdit4->setText("");
	semanageEditLineEdit4->setPaletteBackgroundColor(QColor(255,100,200));
	semanageEditLineEdit5->setText("");
	semanageEditLineEdit5->setPaletteBackgroundColor(QColor(255,100,200));
	initscriptCheckBox = new QCheckBox(tr("module have a init script"), this);
	networkCheckBox = new QCheckBox(tr("module use the network"), this);
	initscriptCheckBox->setChecked(true);
	networkCheckBox->setChecked(true);
	policygenerationButton = new QPushButton(tr("Generate policy_module"), this);
	policygenerationButton->setPaletteBackgroundColor(QColor(200,157,100));
	connect(policygenerationButton, SIGNAL(clicked()), this, SLOT(policygeneration_button_clicked()));

	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	//set textEdit smanage such and such -l
	policygeneration_base_process(semanageEditLineEdit_str);

	mainLayout = new QVBoxLayout(this);
	mainLayout->setMargin(11);

	upperLayout = new QVBoxLayout;
	upperLayout->addWidget(textEdit1);

	middleLayout = new QVBoxLayout;
	leftLayout = new QVBoxLayout;
	
	leftLayout->addWidget(semanageEditLabel);
	leftLayout->addWidget(semanageEditLineEdit);
	leftLayout->addWidget(semanageEditLabel2);
	leftLayout->addWidget(semanageEditLineEdit2);
	leftLayout->addWidget(semanageEditLabel3);
	leftLayout->addWidget(semanageEditLineEdit3);
	leftLayout->addWidget(semanageEditLabel4);
	leftLayout->addWidget(semanageEditLineEdit4);
	leftLayout->addWidget(semanageEditLabel5);
	leftLayout->addWidget(semanageEditLineEdit5);
	leftLayout->addWidget(initscriptCheckBox);
	leftLayout->addWidget(networkCheckBox);

	rightLayout = new QHBoxLayout;
	rightLayout->addStretch();
	rightLayout->addWidget(policygenerationButton);

	middleLayout->addLayout(leftLayout);

	footLayout = new QHBoxLayout;
	footLayout->addStretch();
	footLayout->addWidget(closeButton);

	mainLayout->addLayout(upperLayout);
	mainLayout->addLayout(middleLayout);
	mainLayout->addLayout(rightLayout);
	mainLayout->addLayout(footLayout);
	resize(900,600);
}

void Policygeneration::policygeneration_button_clicked()
{
	semanageEditLineEdit_str = semanageEditLineEdit->text();
	semanageEditLineEdit2_str = semanageEditLineEdit2->text();
	semanageEditLineEdit3_str = semanageEditLineEdit3->text();
	semanageEditLineEdit4_str = semanageEditLineEdit4->text();
	semanageEditLineEdit5_str = semanageEditLineEdit5->text();
	file_exists();
}
void Policygeneration::file_exists()
{
	policy_module_name = "/usr/share/segatex/" + semanageEditLineEdit_str + ".te";
	QFileInfo fi( policy_module_name );
	if((fi.exists())||(semanageEditLineEdit_str =="")||(semanageEditLineEdit2_str =="")){	
		policygeneration_process = new PolicygenerationProcess(this);
		connect(closeButton, SIGNAL(clicked()), policygeneration_process, SLOT(close()));
		policygeneration_process->show();
		policygeneration_process->raise();
		policygeneration_process->setActiveWindow();
	}else{
		policygeneration_button_clicked_ok();
	}
}
void Policygeneration::policygeneration_button_clicked_ok()
{
	policygeneration_button_clicked_process(semanageEditLineEdit_str,semanageEditLineEdit2_str,semanageEditLineEdit3_str,semanageEditLineEdit4_str,semanageEditLineEdit5_str);
}
void Policygeneration::policygeneration_button_clicked_process(QString semanageEditLineEdit_str, QString semanageEditLineEdit2_str, QString semanageEditLineEdit3_str,QString semanageEditLineEdit4_str, QString semanageEditLineEdit5_str)
{
        this->setEnabled(false);
        process = new QProcess(this);
        policygeneration_str_base = "/usr/share/segatex/policygeneration_script";
        policygeneration_str_option1 = " -m " + semanageEditLineEdit_str + " -e " + semanageEditLineEdit2_str + " -p " + semanageEditLineEdit3_str + " -l " + semanageEditLineEdit4_str + " -v " + semanageEditLineEdit5_str + " -i " ;
	if(initscriptCheckBox->isOn()){
                policygeneration_str_option2 = " on ";
	}else{
                policygeneration_str_option2 = " off ";
	}
        policygeneration_str_option3 = " -n ";
	if(networkCheckBox->isOn()){
                policygeneration_str_option4 = " on ";
	}else{
                policygeneration_str_option4 = " off ";
	}
        policygeneration_str = policygeneration_str_base + policygeneration_str_option1 + policygeneration_str_option2 + policygeneration_str_option3 + policygeneration_str_option4;
        connect(process, SIGNAL(processExited()),this,SLOT(processExited()));
        process->start(policygeneration_str);

	policygeneration_base_process(semanageEditLineEdit_str);
        QMessageBox::information(0, tr("Wrote module files !"),
                tr("Wrote " + semanageEditLineEdit_str + ".te, " + semanageEditLineEdit_str + ".fc, " + semanageEditLineEdit_str + ".if in /usr/share/segatex"));
}
void Policygeneration::processExited()
{
        delete process;
        process = 0;
        this->setEnabled(true);
}

void Policygeneration::policygeneration_base_process(QString semanageEditLineEdit_str)
{
        #define PWD_BUF 8600
        const char* semanage_login_list_file="/usr/share/segatex/semanage/1_policy_module";
        ofstream os;
        os.open(semanage_login_list_file);
        if(os){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));

                read_fp = popen("/usr/sbin/semodule -l", "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
			}
			pclose(read_fp);
                }
       }
	os.close();
	readFromOutputFile();

}

//this slot should be called from above slot
void Policygeneration::readFromOutputFile()
{
	/////////////////////////////////////////////////////////////
	path = "/usr/share/segatex/semanage";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("*policy_module");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	int order_x;
	order_x = 1;
	//first clear it all, unless double the file.
	textEdit1->clear();
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			QRegExp rx_nologin("nologin");
			QRegExp rx_shutdown("shutdown");
			QRegExp rx_halt("halt");
			QRegExp rx_news("news");
			QRegExp rx_false("false");
			QRegExp rx_sync("sync");
			if ( file.open( QIODevice::ReadOnly ) ) {
				QTextStream stream( &file );
				////////////////////////////////////////////
				int i,j,k,l,m,n;	
				if(order_x == 1)
					textEdit1->append("#########module list#########");
					textEdit1->append("");
				if(order_x == 2)
					textEdit1->append("#########user list#########");
					textEdit1->append("");
				if(order_x == 3)
					textEdit1->append("#########etc passwd list#########");
					textEdit1->append("");
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					//buttons.push_back(line_analized);
					i = line_analized.find( rx_nologin, 0);
					j = line_analized.find( rx_shutdown, 0);
					k = line_analized.find( rx_halt, 0);
					l = line_analized.find( rx_news, 0);
					m = line_analized.find( rx_false, 0);
					n = line_analized.find( rx_sync, 0);
                                        if((i != -1)||(j != -1)||(k != -1)||(l != -1)||(m != -1)||(n != -1)){
						//do nothing
					}else{
						textEdit1->append(line_analized);
					}
				}
				file.close();
				order_x++;
				++it_d;
			}else{
				//do nothing
			}
		}
}
