/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#ifndef POLICYGENERATION_H
#define POLICYGENERATION_H

#include <QDialog>
#include <QLayout>
#include <QDir> 
#include <QFile> 
#include <QRegExp> 
#include <QLabel> 
#include <QTextEdit>
#include <QCheckBox>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QProcess>

#include "policygeneration_process.h" 

class QTextEdit;
class QLineEdit;
class QPushButton;
class QProcess;

class Policygeneration: public QDialog 
{
	Q_OBJECT
public:
	Policygeneration(QWidget *parent = 0, const char *name = 0);
        QString semanageEditLineEdit_str;
        QString semanageEditLineEdit2_str;
        QString semanageEditLineEdit3_str;
        QString semanageEditLineEdit4_str;
        QString semanageEditLineEdit5_str;
public slots:
signals:
protected:
private slots:
	void policygeneration_base_process(QString semanageEditLineEdit_str);
	void policygeneration_button_clicked();
	void policygeneration_button_clicked_ok();
	void processExited();
	void file_exists();
	void policygeneration_button_clicked_process(QString textEdit1_str, QString textEdit2_str, QString textEdit3_str,QString textEdit4_str, QString textEdit5_str);
	void readFromOutputFile();
public:
private:
	QPushButton *policygenerationButton;
	QPushButton *closeButton;
	QTextEdit *textEdit1;
	QCheckBox *initscriptCheckBox;
	QCheckBox *networkCheckBox;

	QVBoxLayout *mainLayout;
	QVBoxLayout *upperLayout;
	QVBoxLayout *underLayout;
	QVBoxLayout *leftLayout;
	QHBoxLayout *rightLayout;
	QVBoxLayout *middleLayout;
	QHBoxLayout *footLayout;

        QDir dir;
        QString path;
        QString name;
        QString dir_name;
        QString forward_slash;
        QString file_interface_name;
        QString line_analized;
        QString outputfile_str;

        QStringList::Iterator it_d;
        QStringList files;

        QString radiobutton_obj_str;
        QLabel *semanageEditLabel;
        QLabel *semanageEditLabel2;
        QLabel *semanageEditLabel3;
        QLabel *semanageEditLabel4;
        QLabel *semanageEditLabel5;
        QLineEdit *semanageEditLineEdit;
        QLineEdit *semanageEditLineEdit2;
        QLineEdit *semanageEditLineEdit3;
        QLineEdit *semanageEditLineEdit4;
        QLineEdit *semanageEditLineEdit5;
        QString policy_module_name;
        QString semanageEditLineEdit_str_pp;
        QString policygeneration_str;
        QString policygeneration_str_base;
        QString policygeneration_str_option1;
        QString policygeneration_str_option2;
        QString policygeneration_str_option3;
        QString policygeneration_str_option4;
        QString policygeneration_str_option5;

        QProcess *process;
	PolicygenerationProcess *policygeneration_process;
};

#endif
