/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#ifndef SEGATEXAPPLY_H
#define SEGATEXAPPLY_H

#include <QRegExp>
#include <QDialog>
#include <QTextEdit>
#include <QHBoxLayout>
#include <QVBoxLayout>

#include <selinux/selinux.h>
#include <selinux/get_default_type.h>

class QLayout;
class QMessageBox;
class QRadioButton;
class Q3ButtonGroup;
class QTextEdit;
class QPushButton;
class MainWindow;

class SegatexApply: public QDialog
{
	Q_OBJECT
public:
	SegatexApply(QWidget *parent = 0, const char *name = 0);
    
public slots:
signals:
	void enforcingOn();
	void permissiveOn();
	void disabledOn();
	void sestateChanged();
protected:

private slots:
	void apply_clicked();
	int setenforce_enforcing();
	int setenforce_permissive();
private:
        QVBoxLayout *leftLayout;
        QVBoxLayout *rightLayout;
        QHBoxLayout *mainLayout;
	Q3ButtonGroup *agroup;
	QRadioButton *enforcingRadioButton;
	QRadioButton *permissiveRadioButton;
	QMessageBox *waning;
	QPushButton *applyButton;
	QPushButton *closeButton;
	int return_value;
	MainWindow *mainWindow;
};

#endif
