/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <QLayout>
#include <QPushButton>
#include <QProcess>
#include <QLineEdit>
#include <QTextEdit>
#include <QRegExp>
#include <QTextStream>
#include <QLabel>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fstream>

#include "semanage_core_fcontext_process.h"

#include <iostream>
using namespace std;

//default constructor
SemanageCoreFcontextProcess::SemanageCoreFcontextProcess(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Semanage Fcontext Process"));
	textEdit1 = new QTextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(250,180,200));

	semanageEditLabel = new QLabel(tr("fcontext:"), this );
	semanageEditLabel2 = new QLabel(tr("file_spec:"), this );
	semanageEditLabel7 = new QLabel(tr("range:"), this );
	semanageEditLineEdit = new QLineEdit( this );
	semanageEditLineEdit2 = new QLineEdit( this );
	semanageEditLineEdit7 = new QLineEdit( this );
	semanageEditLineEdit->setText("");
	semanageEditLineEdit->setPaletteBackgroundColor(QColor(200,100,80));
	semanageEditLineEdit2->setText("write path here");
	semanageEditLineEdit2->setPaletteBackgroundColor(QColor(200,100,80));
	semanageEditLineEdit7->setText("s0");
	semanageEditLineEdit7->setPaletteBackgroundColor(QColor(200,100,80));
	addButton = new QPushButton(tr("Add"), this);
	addButton->setPaletteBackgroundColor(QColor(100,200,200));
	connect(addButton, SIGNAL(clicked()), this, SLOT(add_button_clicked()));

	semanageEditLabel3 = new QLabel(tr("fcontext:"), this );
	semanageEditLabel6 = new QLabel(tr("file_spec:"), this );
	semanageEditLabel8 = new QLabel(tr("range:"), this );
	semanageEditLineEdit3 = new QLineEdit( this );
	semanageEditLineEdit6 = new QLineEdit( this );
	semanageEditLineEdit8 = new QLineEdit( this );
	semanageEditLineEdit3->setText("");
	semanageEditLineEdit3->setPaletteBackgroundColor(QColor(200,100,80));
	semanageEditLineEdit6->setText("write path here");
	semanageEditLineEdit6->setPaletteBackgroundColor(QColor(200,100,80));
	semanageEditLineEdit8->setText("s0");
	semanageEditLineEdit8->setPaletteBackgroundColor(QColor(200,100,80));
	deleteButton = new QPushButton(tr("Delete"), this);
	deleteButton->setPaletteBackgroundColor(QColor(100,200,200));
	connect(deleteButton, SIGNAL(clicked()), this, SLOT(delete_button_clicked()));

	semanageEditLabel4 = new QLabel(tr("fcontext:"), this );
	semanageEditLabel5 = new QLabel(tr("file_spec:"), this );
	semanageEditLabel9 = new QLabel(tr("range:"), this );
	semanageEditLineEdit4 = new QLineEdit( this );
	semanageEditLineEdit5 = new QLineEdit( this );
	semanageEditLineEdit9 = new QLineEdit( this );
	semanageEditLineEdit4->setText("");
	semanageEditLineEdit4->setPaletteBackgroundColor(QColor(200,100,80));
	semanageEditLineEdit5->setText("write path here");
	semanageEditLineEdit5->setPaletteBackgroundColor(QColor(200,100,80));
	semanageEditLineEdit9->setText("s0");
	semanageEditLineEdit9->setPaletteBackgroundColor(QColor(200,100,80));
	modifyButton = new QPushButton(tr("Modify"), this);
	modifyButton->setPaletteBackgroundColor(QColor(100,200,200));
	connect(modifyButton, SIGNAL(clicked()), this, SLOT(modify_button_clicked()));

        filetypeButtonGroup = new Q3ButtonGroup(this);
        filetypeButtonGroup->resize( 400, 400 );
        allfilesRadioButton = new QRadioButton(tr("all files"), filetypeButtonGroup);
        regularfileRadioButton = new QRadioButton(tr("regular file"), filetypeButtonGroup);
        directoryRadioButton = new QRadioButton(tr("directory"), filetypeButtonGroup);
        blockdeviceRadioButton = new QRadioButton(tr("block device"), filetypeButtonGroup);
        characterdeviceRadioButton = new QRadioButton(tr("character device"), filetypeButtonGroup);
        socketRadioButton = new QRadioButton(tr("socket"), filetypeButtonGroup);
        symboliclinkRadioButton = new QRadioButton(tr("symbolic link"), filetypeButtonGroup);
        namedpipeRadioButton = new QRadioButton(tr("named pipe"), filetypeButtonGroup);
        allfilesRadioButton->setGeometry( 10, 10, 200, 20 );
        regularfileRadioButton->setGeometry( 10, 30, 200, 20 );
        directoryRadioButton->setGeometry( 10, 50, 200, 20 );
        blockdeviceRadioButton->setGeometry( 10, 70, 200, 20 );
        characterdeviceRadioButton->setGeometry( 10, 90, 200, 20 );
        socketRadioButton->setGeometry( 10, 110, 200, 20 );
        symboliclinkRadioButton->setGeometry( 10, 130, 200, 20 );
        namedpipeRadioButton->setGeometry( 10, 150, 200, 20 );
        allfilesRadioButton->setChecked(true);

	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	//set textEdit smanage such and such -l
	semanage_core_base_fcontext_process();

	mainLayout = new QVBoxLayout(this);
	mainLayout->setMargin(15);

	upperLayout = new QVBoxLayout;
	upperLayout->addWidget(textEdit1);

	middleLayout = new QVBoxLayout;
	leftLayout = new QHBoxLayout;
	rightLayout = new QHBoxLayout;
	thirdLayout = new QHBoxLayout;
	fourthLayout = new QHBoxLayout;
	
	leftLayout->addWidget(semanageEditLabel);
	leftLayout->addWidget(semanageEditLineEdit);
	leftLayout->addWidget(semanageEditLabel2);
	leftLayout->addWidget(semanageEditLineEdit2);
	leftLayout->addWidget(semanageEditLabel7);
	leftLayout->addWidget(semanageEditLineEdit7);
	leftLayout->addWidget(addButton);
	rightLayout->addWidget(semanageEditLabel3);
	rightLayout->addWidget(semanageEditLineEdit3);
	rightLayout->addWidget(semanageEditLabel6);
	rightLayout->addWidget(semanageEditLineEdit6);
	rightLayout->addWidget(semanageEditLabel8);
	rightLayout->addWidget(semanageEditLineEdit8);
	rightLayout->addWidget(deleteButton);
	thirdLayout->addWidget(semanageEditLabel4);
	thirdLayout->addWidget(semanageEditLineEdit4);
	thirdLayout->addWidget(semanageEditLabel5);
	thirdLayout->addWidget(semanageEditLineEdit5);
	thirdLayout->addWidget(semanageEditLabel9);
	thirdLayout->addWidget(semanageEditLineEdit9);
	thirdLayout->addWidget(modifyButton);
	fourthLayout->addWidget(filetypeButtonGroup);

	middleLayout->addLayout(leftLayout);
	middleLayout->addLayout(rightLayout);
	middleLayout->addLayout(thirdLayout);
	middleLayout->addLayout(fourthLayout);

	footLayout = new QHBoxLayout;
	footLayout->addStretch();
	footLayout->addWidget(closeButton);

	mainLayout->addLayout(upperLayout);
	mainLayout->addLayout(middleLayout);
	mainLayout->addLayout(footLayout);
	resize(1000,700);
}

/*signal and slot should have same argument pattern so I had to pass to another slot*/
void SemanageCoreFcontextProcess::add_button_clicked()
{
	semanageEditLineEdit_str = semanageEditLineEdit->text();
	semanageEditLineEdit2_str = semanageEditLineEdit2->text();
	semanageEditLineEdit7_str = semanageEditLineEdit7->text();
	add_button_clicked_process(semanageEditLineEdit_str, semanageEditLineEdit2_str, semanageEditLineEdit7_str);
}
/*signal and slot should have same argument pattern so I had to pass to another slot*/
void SemanageCoreFcontextProcess::delete_button_clicked()
{
	semanageEditLineEdit3_str = semanageEditLineEdit3->text();
	semanageEditLineEdit6_str = semanageEditLineEdit6->text();
	semanageEditLineEdit8_str = semanageEditLineEdit8->text();
	delete_button_clicked_process(semanageEditLineEdit3_str, semanageEditLineEdit6_str, semanageEditLineEdit8_str);
}
/*signal and slot should have same argument pattern so I had to pass to another slot*/
void SemanageCoreFcontextProcess::modify_button_clicked()
{
	semanageEditLineEdit4_str = semanageEditLineEdit4->text();
	semanageEditLineEdit5_str = semanageEditLineEdit5->text();
	semanageEditLineEdit9_str = semanageEditLineEdit9->text();
	modify_button_clicked_process(semanageEditLineEdit4_str, semanageEditLineEdit5_str, semanageEditLineEdit9_str);
}
/* this slot does just make .pp file */
void SemanageCoreFcontextProcess::add_button_clicked_process(QString semanageEditLineEdit_str, QString semanageEditLineEdit2_str, QString semanageEditLineEdit7_str)
{
	semanageEditLineEdit2_str_for_check = semanageEditLineEdit2_str;
	semanageEditLineEdit2_str_for_check.replace( QChar('"'), "" );
	s_first = semanageEditLineEdit2_str_for_check.section('/', 1, 1 );
	int i_first = s_first.find( QRegExp("[^a-zA-Z0-9_]"), 0 );    // i == 1
	//cout << "s_second:" << s_second << endl;
	//cout << "i_second:" << i_second << endl;
	restorecon_str = "default";
	if(i_first < 0 ){
		s_first_for_restorecon_str = s_first.mid(0,i_first);
		restorecon_str_first = "/" + s_first_for_restorecon_str;
	}

	s_second = semanageEditLineEdit2_str_for_check.section('/', 2, 2 );
	int i_second = s_second.find( QRegExp("[^a-zA-Z0-9_]"), 0 );    // i == 1
	//cout << "s_second:" << s_second << endl;
	//cout << "i_second:" << i_second << endl;
	if(i_second < 0 ){
		s_second_for_restorecon_str = s_second.mid(0,i_second);
		restorecon_str_second = "/" + s_first + "/" + s_second_for_restorecon_str;
	}

	s_third = semanageEditLineEdit2_str_for_check.section('/', 3, 3 );
	int i_third = s_third.find( QRegExp("[^a-zA-Z0-9_]"), 0 );    // i == 1
	//cout << "s_third:" << s_third << endl;
	//cout << "i_third:" << i_third << endl;
	if(i_third < 0 ){
		s_third_for_restorecon_str = s_third.mid(0,i_third);
		restorecon_str_third = "/" + s_first + "/" + s_second + "/" + s_third_for_restorecon_str;
	}

	s_fourth = semanageEditLineEdit2_str_for_check.section('/', 4, 4 );
	int i_fourth = s_fourth.find( QRegExp("[^a-zA-Z0-9_]"), 0 );    // i == 1
	//cout << "s_fourth:" << s_fourth << endl;
	//cout << "i_fourth:" << i_fourth << endl;
	if(i_fourth < 0 ){
		s_fourth_for_restorecon_str = s_fourth.mid(0,i_fourth);
		restorecon_str_fourth = "/" + s_first + "/" + s_second + "/" + s_third + "/" + s_fourth_for_restorecon_str;
	}
	if(i_first < 0)
		restorecon_str = restorecon_str_first;
	if(i_second < 0)
		restorecon_str = restorecon_str_first;
	if(i_third < 0)
		restorecon_str = restorecon_str_second;
	if(i_fourth < 0)
		restorecon_str = restorecon_str_third;



if(allfilesRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -a -f \"\" -r " + semanageEditLineEdit7_str + " -t " + semanageEditLineEdit_str + " \"" + semanageEditLineEdit2_str + "\"";
}
if(regularfileRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -a -f -- -r " + semanageEditLineEdit7_str + " -t " + semanageEditLineEdit_str + " \"" + semanageEditLineEdit2_str + "\"";
}
if(directoryRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -a -f -d -r " + semanageEditLineEdit7_str + " -t " + semanageEditLineEdit_str + " \"" + semanageEditLineEdit2_str + "\"";
}
if(blockdeviceRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -a -f -b -r " + semanageEditLineEdit7_str + " -t " + semanageEditLineEdit_str + " \"" + semanageEditLineEdit2_str + "\"";
}
if(characterdeviceRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -a -f -c -r " + semanageEditLineEdit7_str + " -t " + semanageEditLineEdit_str + " \"" + semanageEditLineEdit2_str + "\"";
}
if(socketRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -a -f -s -r " + semanageEditLineEdit7_str + " -t " + semanageEditLineEdit_str + " \"" + semanageEditLineEdit2_str + "\"";
}
if(symboliclinkRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -a -f -l -r " + semanageEditLineEdit7_str + " -t " + semanageEditLineEdit_str + " \"" + semanageEditLineEdit2_str + "\"";
}
if(namedpipeRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -a -f -p -r " + semanageEditLineEdit7_str + " -t " + semanageEditLineEdit_str + " \"" + semanageEditLineEdit2_str + "\"";
}
        #define PWD_BUF 8600
        const char* make_module_file="/usr/share/segatex/semanage/add_fcontexted";
        ofstream os_add;
        os_add.open(make_module_file);
        if(os_add){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(semanageEditLineEdit_str_pp, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os_add << buffer << endl;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os_add.close();
	
	//Now, let's restorecon path
	semanageEditLineEdit_str_add_restorecon = "restorecon -R -v " + restorecon_str;
	//for debug
	//cout << "semanageEditLineEdit_str_add_restorecon:" << semanageEditLineEdit_str_add_restorecon << endl;
	//
        #define PWD_BUF 8600
        const char* restorecon_file="/usr/share/segatex/semanage/add_fcontexted_restorecon";
        ofstream os_add_restorecon;
        os_add_restorecon.open(restorecon_file);
        if(os_add_restorecon){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(semanageEditLineEdit_str_add_restorecon, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os_add_restorecon << buffer << endl;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os_add_restorecon.close();

	//set textEdit semanage -l
	semanage_core_base_fcontext_process();
	//outputfile_str_common2 = make_module_file;
}
/* this slot does just make .pp file */
void SemanageCoreFcontextProcess::delete_button_clicked_process(QString semanageEditLineEdit3_str, QString semanageEditLineEdit6_str, QString semanageEditLineEdit8_str)
{
	semanageEditLineEdit6_str_for_check = semanageEditLineEdit6_str;
	semanageEditLineEdit6_str_for_check.replace( QChar('"'), "" );
	s_first = semanageEditLineEdit6_str_for_check.section('/', 1, 1 );
	int i_first = s_first.find( QRegExp("[^a-zA-Z0-9_]"), 0 );    // i == 1
	//cout << "s_first:" << s_first << endl;
	//cout << "i_first:" << i_first << endl;
	restorecon_str = "default";
	if(i_first < 0 ){
		s_first_for_restorecon_str = s_first.mid(0,i_first);
		restorecon_str_first = "/" + s_first_for_restorecon_str;
	}

	s_second = semanageEditLineEdit6_str_for_check.section('/', 2, 2 );
	int i_second = s_second.find( QRegExp("[^a-zA-Z0-9_]"), 0 );    // i == 1
	//cout << "s_second:" << s_second << endl;
	//cout << "i_second:" << i_second << endl;
	if(i_second < 0 ){
		s_second_for_restorecon_str = s_second.mid(0,i_second);
		restorecon_str_second = "/" + s_first + "/" + s_second_for_restorecon_str;
	}

	s_third = semanageEditLineEdit6_str_for_check.section('/', 3, 3 );
	int i_third = s_third.find( QRegExp("[^a-zA-Z0-9_]"), 0 );    // i == 1
	//cout << "s_third:" << s_third << endl;
	//cout << "i_third:" << i_third << endl;
	if(i_third < 0 ){
		s_third_for_restorecon_str = s_third.mid(0,i_third);
		restorecon_str_third = "/" + s_first + "/" + s_second + "/" + s_third_for_restorecon_str;
	}

	s_fourth = semanageEditLineEdit6_str_for_check.section('/', 4, 4 );
	int i_fourth = s_fourth.find( QRegExp("[^a-zA-Z0-9_]"), 0 );    // i == 1
	//cout << "s_fourth:" << s_fourth << endl;
	//cout << "i_fourth:" << i_fourth << endl;
	if(i_fourth < 0 ){
		s_fourth_for_restorecon_str = s_fourth.mid(0,i_fourth);
		restorecon_str_fourth = "/" + s_first + "/" + s_second + "/" + s_third + "/" + s_fourth_for_restorecon_str;
	}
	if(i_first < 0)
		restorecon_str = restorecon_str_first;
	if(i_second < 0)
		restorecon_str = restorecon_str_first;
	if(i_third < 0)
		restorecon_str = restorecon_str_second;
	if(i_fourth < 0)
		restorecon_str = restorecon_str_third;

if(allfilesRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -d -f \"\" -r " + semanageEditLineEdit8_str + " -t " + semanageEditLineEdit3_str + " \"" + semanageEditLineEdit6_str + "\"";
}
if(regularfileRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -d -f -- -r " + semanageEditLineEdit8_str + " -t " + semanageEditLineEdit3_str + " \"" + semanageEditLineEdit6_str + "\"";
}
if(directoryRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -d -f -d -r " + semanageEditLineEdit8_str + " -t " + semanageEditLineEdit3_str + " \"" + semanageEditLineEdit6_str + "\"";
}
if(blockdeviceRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -d -f -b -r " + semanageEditLineEdit8_str + " -t " + semanageEditLineEdit3_str + " \"" + semanageEditLineEdit6_str + "\"";
}
if(characterdeviceRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -d -f -c -r " + semanageEditLineEdit8_str + " -t " + semanageEditLineEdit3_str + " \"" + semanageEditLineEdit6_str + "\"";
}
if(socketRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -d -f -s -r " + semanageEditLineEdit8_str + " -t " + semanageEditLineEdit3_str + " \"" + semanageEditLineEdit6_str + "\"";
}
if(symboliclinkRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -d -f -l -r " + semanageEditLineEdit8_str + " -t " + semanageEditLineEdit3_str + " \"" + semanageEditLineEdit6_str + "\"";
}
if(namedpipeRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -d -f -p -r " + semanageEditLineEdit8_str + " -t " + semanageEditLineEdit3_str + " \"" + semanageEditLineEdit6_str + "\"";
}
        #define PWD_BUF 8600
        const char* make_module_file="/usr/share/segatex/semanage/delete_fcontexted";
        ofstream os_delete;
        os_delete.open(make_module_file);
        if(os_delete){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(semanageEditLineEdit_str_pp, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os_delete << buffer << endl;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os_delete.close();

	//Now, let's restorecon path
	semanageEditLineEdit_str_delete_restorecon = "restorecon -R -v " + restorecon_str;
        #define PWD_BUF 8600
        const char* restorecon_file="/usr/share/segatex/semanage/delete_fcontexted_restorecon";
        ofstream os_delete_restorecon;
        os_delete_restorecon.open(restorecon_file);
        if(os_delete_restorecon){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(semanageEditLineEdit_str_delete_restorecon, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os_delete_restorecon << buffer << endl;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os_delete_restorecon.close();

	//set textEdit semanage -l
	semanage_core_base_fcontext_process();
	//outputfile_str_common2 = make_module_file;
}
/* this slot does just make .pp file */
void SemanageCoreFcontextProcess::modify_button_clicked_process(QString semanageEditLineEdit4_str, QString semanageEditLineEdit5_str, QString semanageEditLineEdit9_str)
{

	semanageEditLineEdit5_str_for_check = semanageEditLineEdit5_str;
	semanageEditLineEdit5_str_for_check.replace( QChar('"'), "" );
	s_first = semanageEditLineEdit5_str_for_check.section('/', 1, 1 );
	int i_first = s_first.find( QRegExp("[^a-zA-Z0-9_]"), 0 );    // i == 1
	//cout << "s_first:" << s_first << endl;
	//cout << "i_first:" << i_first << endl;
	restorecon_str = "default";
	if(i_first < 0 ){
		s_first_for_restorecon_str = s_first.mid(0,i_first);
		restorecon_str_first = "/" + s_first_for_restorecon_str;
	}

	s_second = semanageEditLineEdit5_str_for_check.section('/', 2, 2 );
	int i_second = s_second.find( QRegExp("[^a-zA-Z0-9_]"), 0 );    // i == 1
	//cout << "s_second:" << s_second << endl;
	//cout << "i_second:" << i_second << endl;
	if(i_second < 0 ){
		s_second_for_restorecon_str = s_second.mid(0,i_second);
		restorecon_str_second = "/" + s_first + "/" + s_second_for_restorecon_str;
	}

	s_third = semanageEditLineEdit5_str_for_check.section('/', 3, 3 );
	int i_third = s_third.find( QRegExp("[^a-zA-Z0-9_]"), 0 );    // i == 1
	//cout << "s_third:" << s_third << endl;
	//cout << "i_third:" << i_third << endl;
	if(i_third < 0 ){
		s_third_for_restorecon_str = s_third.mid(0,i_third);
		restorecon_str_third = "/" + s_first + "/" + s_second + "/" + s_third_for_restorecon_str;
	}

	s_fourth = semanageEditLineEdit5_str_for_check.section('/', 4, 4 );
	int i_fourth = s_fourth.find( QRegExp("[^a-zA-Z0-9_]"), 0 );    // i == 1
	//cout << "s_fourth:" << s_fourth << endl;
	//cout << "i_fourth:" << i_fourth << endl;
	if(i_fourth < 0 ){
		s_fourth_for_restorecon_str = s_fourth.mid(0,i_fourth);
		restorecon_str_fourth = "/" + s_first + "/" + s_second + "/" + s_third + "/" + s_fourth_for_restorecon_str;
	}
	if(i_first < 0)
		restorecon_str = restorecon_str_first;
	if(i_second < 0)
		restorecon_str = restorecon_str_first;
	if(i_third < 0)
		restorecon_str = restorecon_str_second;
	if(i_fourth < 0)
		restorecon_str = restorecon_str_third;

if(allfilesRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -m -f \"\" -r " + semanageEditLineEdit9_str + " -t " + semanageEditLineEdit4_str + " \"" + semanageEditLineEdit5_str + "\"";
}
if(regularfileRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -m -f -- -r " + semanageEditLineEdit9_str + " -t " + semanageEditLineEdit4_str + " \"" + semanageEditLineEdit5_str + "\"";
}
if(directoryRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -m -f -d -r " + semanageEditLineEdit9_str + " -t " + semanageEditLineEdit4_str + " \"" + semanageEditLineEdit5_str + "\"";
}
if(blockdeviceRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -m -f -b -r " + semanageEditLineEdit9_str + " -t " + semanageEditLineEdit4_str + " \"" + semanageEditLineEdit5_str + "\"";
}
if(characterdeviceRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -m -f -c -r " + semanageEditLineEdit9_str + " -t " + semanageEditLineEdit4_str + " \"" + semanageEditLineEdit5_str + "\"";
}
if(socketRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -m -f -s -r " + semanageEditLineEdit9_str + " -t " + semanageEditLineEdit4_str + " \"" + semanageEditLineEdit5_str + "\"";
}
if(symboliclinkRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -m -f -l -r " + semanageEditLineEdit9_str + " -t " + semanageEditLineEdit4_str + " \"" + semanageEditLineEdit5_str + "\"";
}
if(namedpipeRadioButton->isChecked()){
	semanageEditLineEdit_str_pp = "semanage fcontext -m -f -p -r " + semanageEditLineEdit9_str + " -t " + semanageEditLineEdit4_str + " \"" + semanageEditLineEdit5_str + "\"";
}
        #define PWD_BUF 8600
        const char* make_module_file="/usr/share/segatex/semanage/modify_fcontexted";
        ofstream os_modify;
        os_modify.open(make_module_file);
        if(os_modify){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(semanageEditLineEdit_str_pp, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os_modify << buffer << endl;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os_modify.close();

	//Now, let's restorecon path
	semanageEditLineEdit_str_modify_restorecon = "restorecon -R -v " + restorecon_str;
        #define PWD_BUF 8600
        const char* restorecon_file="/usr/share/segatex/semanage/modify_fcontexted_restorecon";
        ofstream os_modify_restorecon;
        os_modify_restorecon.open(restorecon_file);
        if(os_modify_restorecon){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(semanageEditLineEdit_str_modify_restorecon, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os_modify_restorecon << buffer << endl;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os_modify_restorecon.close();

	//set textEdit semanage -l
	semanage_core_base_fcontext_process();
}

// {boolean|login|user|port|interface|fcontext|translation}

void SemanageCoreFcontextProcess::semanage_core_base_fcontext_process()
{
        #define PWD_BUF 8600
        const char* semanage_fcontext_list_file="/usr/share/segatex/semanage/1_fcontext";
        ofstream os;
        os.open(semanage_fcontext_list_file);
        if(os){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));

                read_fp = popen("export LANG=C;/usr/sbin/semanage fcontext -l", "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
			}
			pclose(read_fp);
                }
        }
	os.close();
	//outputfile_str_common = "fcontext_list";
	readFromOutputFile();
}

//this slot should be called from above slot
void SemanageCoreFcontextProcess::readFromOutputFile()
{
	/////////////////////////////////////////////////////////////
	path = "/usr/share/segatex/semanage";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("*fcontext");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	int order_x;
	order_x = 1;
	//first clear it all, unless double the file.
	textEdit1->clear();
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( QIODevice::ReadOnly ) ) {
				QTextStream stream( &file );
				////////////////////////////////////////////
				//int i,j,k,l,m,n;	
				if(order_x == 1)
					textEdit1->append("#########fcontext list#########");
					textEdit1->append("");
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					textEdit1->append(line_analized);
				}
				//textEdit1->setCursorPosition(0,0);
				file.close();
				order_x++;
				++it_d;
			}else{
				//do nothing
			}
		}
}
