/********************************************
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2009 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
//########by me#######
#include <sepol/sepol.h>
#include <selinux/get_context_list.h>
//########end by me#######
#include <unistd.h>
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>


void usage(char *progname)
{
	printf("usage:  %s seuser(system_u) \n", progname);
	exit(1);
}

int main(int argc, char **argv)
{
	security_context_t fromcon;
	security_context_t *list;
	fromcon = NULL;

	if(argc != 2)
		usage(argv[0]);

	if(get_ordered_context_list(argv[1],fromcon,&list) < 0) {
		fprintf(stderr, "%s is not a valid seuser \n", argv[1]);
		exit(1);
	}
	while(**&list){
		//printf("%s's context is %s \n", argv[1],**&list);
		printf("%s's context is %s \n", argv[1],*list);
		list++;
	}
	//freecon(*list);
	exit(0);
}
