/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 * shintaro.fujiwara@gmail.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */
#include <QMessageBox>
#include <QtGui>
#include <QtNetwork>
#include <QLayout>

#include "downloader.h"

#include <iostream>
using namespace std;


//Downloader::Downloader(QUrl &url, QString version)
Downloader::Downloader(QUrl &url, QString version, QWidget *parent)
     : QDialog(parent), ftp(0), networkSession(0)
{
//url = "ftp://ftp.riken.jp";
//version="new";

    if (url.scheme() != "ftp") {
        QMessageBox::warning(0, tr("Downloader"),
                             tr("Protocol must be 'ftp'."));
        emit finished();
        return;
    }

    int port = 21;
    if (url.port() != -1)
        port = url.port();

    connect(&ftp, SIGNAL(listInfo(const QUrlInfo &)),
        this, SLOT(listInfo(const QUrlInfo &)));

    dir_str = getImageStr(url, version);
    host_str = url.host();

    ftp.connectToHost(url.host(), port);
    ftp.login();
    ftp.cd(dir_str);
    ftp.list(); 
    connect(&ftp, SIGNAL(dataTransferProgress(qint64,qint64)),
        this, SLOT(updateDataTransferProgress(qint64,qint64)));

    //textLineEdit1 = new QLineEdit(this);
    label1 = new QLabel(this);
    //label1->setFrameStyle(QFrame::Panel | QFrame::Sunken);
    //label->setText("first line\nsecond line");
    // label->setAlignment(Qt::AlignBottom | Qt::AlignRight);

    //textLineEdit1->setStyleSheet("background-color: lightblue");
    label1->setStyleSheet("background-color: lightblue");
    //textLineEdit1->setText("Downloading files from \n" + host_str + "/" + dir_str + "\nto your homedirectory.");
    label1->setText("Downloading files from \n" + host_str + "/" + dir_str + "\nto your homedirectory.");

    connect(&ftp, SIGNAL(commandFinished(int,bool)),
        this, SLOT(checkState()));

    progressDialog = new QProgressDialog(this);
    connect(progressDialog, SIGNAL(canceled()), this, SLOT(cancelDownload()));
    progressDialog->exec();

    closeButton = new QPushButton(tr("close"), this);
    closeButton->setDefault(true);
    //closing process button
    connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
    //connect(closeButton, SIGNAL(clicked()), this, SLOT(close_button_clicked()));

    upperLayout = new QVBoxLayout;
    //upperLayout->addWidget(textLineEdit1);
    upperLayout->addWidget(label1);

    footLayout = new QHBoxLayout;
    footLayout->addStretch(1);
    footLayout->addWidget(closeButton);

    mainLayout = new QVBoxLayout(this);
    mainLayout->setMargin(11);
    mainLayout->setSpacing(6);

    mainLayout->addLayout(upperLayout);
    mainLayout->addLayout(footLayout);
    resize(300,100);
    this->show(); 
}

void Downloader::cancelDownload()
{
    ftp.abort();
    //textLineEdit1->clear();
    label1->clear();
    //textLineEdit1->setText("Download had been canceld.");
    label1->setText("Download had been canceld.");
/*
    if (file->exists()) {
        file->close();
        file->remove();
    }
    delete file;
*/
}
//void Downloader::checkState(QFtp ftp)
void Downloader::checkState()
{
     QString messages;
     if (ftp.currentCommand() == QFtp::ConnectToHost) {
         //if (QFtp::NoError!=0) {
         /*
             QMessageBox::information(this, tr("FTP"),
                                      tr("Unable to connect to the FTP server "
                                         "at ... Please check that the host "
                                         "name is correct."));
*/
             /*
             QMessageBox::information(this, tr("FTP"),
                                      tr("Unable to connect to the FTP server "
                                         "at %1. Please check that the host "
                                         "name is correct.")
                                      .arg(ftpServerLineEdit->text()));
             */
             //connectOrDisconnect();
          //   return;
         //}
         messages = "Logged onto " + host_str;
         //textLineEdit1->clear();
         //textLineEdit1->setText("Logged ");
         label1->clear();
         label1->setText("Logged ");
         /*
         textEdit1->setText(tr("Logged onto %1.")
                              .arg(ftpServerLineEdit->text()));
         */
         //fileList->setFocus();
         //downloadButton->setDefault(true);
         //connectButton->setEnabled(true);
         //return;
     }

     if (ftp.currentCommand() == QFtp::Login) {
         messages = "Logged in " + host_str;
         //textLineEdit1->clear();
         //textLineEdit1->setText("Logged in ");
         label1->clear();
         label1->setText("Logged in ");
         //ftp.list();
     }

     if (ftp.currentCommand() == QFtp::Get) {
         //if (QFtp::NoError!=0) {
             //textEdit1->setText(tr("Canceled download of ..."));
             /*
             textEdit1->setText(tr("Canceled download of %1.")
                                  .arg(file->fileName()));
             */
             //file->close();
             //file->remove();
         //} else {
             messages = "Downloaded "+ host_str + "/" + dir_str + "to home dir.";
             //textLineEdit1->clear();
             //textLineEdit1->setText("Downloaded ");
             label1->clear();
             label1->setText("Downloaded ");
             /*
             textEdit1->setText(tr("Downloaded %1 to current directory.")
                                  .arg(file->fileName()));
             */
             //file->close();
         }
         //delete file;
         //enableDownloadButton();
         //progressDialog->hide();
     //} else if (ftp.currentCommand() == QFtp::List) {
     if (ftp.currentCommand() == QFtp::List) {
/*
         if (isDirectory.isEmpty()) {
             textEdit1->setText(tr("is Empty..."));
             //fileList->addTopLevelItem(new QTreeWidgetItem(QStringList() << tr("<empty>")));
             //fileList->setEnabled(false);
         }
*/
     }
}
QString Downloader::getImageStr(QUrl &url, QString version)
{
    QString image_str = "";
	if(url.host() == "ftp.riken.jp"){
		if(version == "new4")
                        image_str = "Linux/fedora/releases/18/Fedora/i386/iso";
		if(version == "new3")
                        image_str = "Linux/fedora/releases/19/Fedora/i386/iso";
		if(version == "new2")
                        image_str = "Linux/fedora/releases/20/Fedora/x86_64/iso";
		if(version == "new")
                        image_str = "Linux/fedora/releases/21/Workstation/x86_64/iso";
	}
	if(url.host() == "mirrors.kernel.org"){
		if(version == "new4")
                        image_str = "fedora/releases/18/Fedora/i386/iso";
		if(version == "new3")
                        image_str = "fedora/releases/19/Fedora/i386/iso";
		if(version == "new2")
                        image_str = "fedora/releases/20/Fedora/x86_64/iso";
		if(version == "new")
                        image_str = "fedora/releases/21/Workstation/x86_64/iso";
	}
	if(url.host() == "ftp.uni-kl.de"){
		if(version == "new4")
                        image_str = "pub/linux/fedora/linux/releases/18/Fedora/i386/iso";
		if(version == "new3")
                        image_str = "pub/linux/fedora/linux/releases/19/Fedora/i386/iso";
		if(version == "new2")
                        image_str = "pub/linux/fedora/linux/releases/20/Fedora/x86_64/iso";
		if(version == "new")
                        image_str = "pub/linux/fedora/linux/releases/21/Workstation/x86_64/iso";
	}
	if(url.host() == "ftp.lip6.fr"){
		if(version == "new4")
                        image_str = "pub/linux/distributions/fedora/releases/18/Fedora/i386/iso";
		if(version == "new3")
                        image_str = "pub/linux/distributions/fedora/releases/19/Fedora/i386/iso";
		if(version == "new2")
                        image_str = "pub/linux/distributions/fedora/releases/20/Fedora/x86_64/iso";
		if(version == "new")
                        image_str = "pub/linux/distributions/fedora/releases/21/Workstation/x86_64/iso";
	}
	if(url.host() == "mirror.aarnet.edu.au"){
		if(version == "new4")
                        image_str = "pub/fedora/linux/releases/18/Fedora/i386/iso";
		if(version == "new3")
                        image_str = "pub/fedora/linux/releases/19/Fedora/i386/iso";
		if(version == "new2")
                        image_str = "pub/fedora/linux/releases/20/Fedora/x86_64/iso";
		if(version == "new")
                        image_str = "pub/fedora/linux/releases/21/Workstation/x86_64/iso";
	}
        return image_str;
}

void Downloader::updateDataTransferProgress(qint64 readBytes,
                                            qint64 totalBytes)
{
     progressDialog->setMaximum(totalBytes);
     progressDialog->setValue(readBytes);
}
void Downloader::processExited()
{
        QMessageBox::warning(0, tr("Downloader"),
                             tr("Process exited."));
        return;
}
void Downloader::listInfo(const QUrlInfo &urlInfo)
{
    if (urlInfo.isFile() && urlInfo.isReadable()) {
        QFile *file = new QFile(urlInfo.name());
        if (!file->open(QIODevice::WriteOnly)) {
            QMessageBox::warning(0, tr("Downloader"),
                                 tr("Error: Cannot open file "
                                    "%1:\n%2.")
                                 .arg(file->fileName())
                                 .arg(file->errorString()));
            emit finished();
            return;
        }

        ftp.get(urlInfo.name(), file);
        openedFiles.push_back(file);
   }
}
/*
void Downloader::ftpDone(bool error)
{
    if (error)
        QMessageBox::warning(0, tr("Downloader"),
                             tr("Error: %1.")
                             .arg(ftp.errorString()));

    for (int i = 0; i < (int)openedFiles.size(); ++i)
        delete openedFiles[i];
    emit finished();
}
*/
