/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 * shintaro.fujiwara@gmail.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */
#ifndef DOWNLOADER_H
#define DOWNLOADER_H

#include <QFile>
#include <QFtp>
#include <QStringList>
#include <QUrl>
#include <QDialog>
#include <QHash>
#include <QNetworkConfigurationManager>
#include <vector>
#include <QHBoxLayout> 
#include <QVBoxLayout> 
#include <QTextEdit> 
#include <QLineEdit> 
#include <QLabel> 

class QDialogButtonBox;
class QFile;
class QFtp;
class QLabel;
class QLineEdit;
class QTreeWidget;
class QTreeWidgetItem;
class QProgressDialog;
class QPushButton;
class QUrlInfo;
class QNetworkSession;

//class Downloader : public QObject
class Downloader : public QDialog
//class FtpWindow : public QDialog
{
    Q_OBJECT
public:
    //Downloader(QUrl &url, QString version);
/*
    FtpWindow(QWidget *parent = 0);
     QSize sizeHint() const;
*/
    Downloader(QUrl &url, QString version, QWidget *parent = 0);
    //QSize sizeHint() const;
    //QLineEdit *textLineEdit1;
    QLabel *label1;
    QFtp ftp;
    QString host_str;
    QString dir_str;

signals:
    void finished();

private slots:
    //void checkState(QFtp ftp);
    void checkState();
    //void ftpDone(bool error);
    void listInfo(const QUrlInfo &urlInfo);
    //void processExited();
    QString getImageStr(QUrl &url, QString version);
    void processExited();
    void updateDataTransferProgress(qint64 readBytes,
                                     qint64 totalBytes);
    void cancelDownload();

private:
    std::vector<QFile *> openedFiles;
////////////////////////////////////////////////
    QPushButton *closeButton;
    //QTextEdit *textEdit1;

    QVBoxLayout *mainLayout;
    QVBoxLayout *upperLayout;
    QHBoxLayout *footLayout;
////////////////////////////////////////////////

    QLabel *ftpServerLabel;
    QLineEdit *ftpServerLineEdit;
    QLabel *statusLabel;
    QTreeWidget *fileList;
    QPushButton *cdToParentButton;
    QPushButton *connectButton;
    QPushButton *downloadButton;
    QPushButton *quitButton;
    QDialogButtonBox *buttonBox;
    QProgressDialog *progressDialog;

    QHash<QString, bool> isDirectory;
    QString currentPath;
//    QFtp *ftp;
    QFile *file;

    QNetworkSession *networkSession;
    QNetworkConfigurationManager manager;
};

#endif
