/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <QLayout>
#include <QPushButton>
#include <QTextStream>
#include <QHBoxLayout>
#include <QVBoxLayout>

#include "segatex_audit2allow_process.h"
#include "segatex_audit2why_process.h"

#include <fstream>

#include <iostream>
using namespace std;

SegatexAudit2allowProcess::SegatexAudit2allowProcess(QWidget *parent, const char *name): QDialog(parent, name)
{
	textEdit1 = new QTextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(174,187,255));
	closeButton = new QPushButton(tr("close"), this);
	closeButton->setDefault(true);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close_button_clicked()));
	//connect to checkboxes

	headLayout = new QVBoxLayout;
	headLayout->addWidget(textEdit1);

	footLayout = new QHBoxLayout;
	footLayout->addStretch(1);
	footLayout->addWidget(closeButton);

	mainLayout = new QVBoxLayout(this);
	mainLayout->setMargin(11);
	mainLayout->setSpacing(6);
	mainLayout->addLayout(headLayout);
	mainLayout->addLayout(footLayout);
	resize(600,500);
	segatex_audit2why_process = 0;

	segatex_audit2why_process = new SegatexAudit2whyProcess(this);
	segatex_audit2why_process->show();
	segatex_audit2why_process->raise();
	segatex_audit2why_process->setActiveWindow();
	segatex_audit2why_process->setCaption(tr("audit2why -i /var/log/audit/audit.log"));

}
void SegatexAudit2allowProcess::close_button_clicked()
{
	emit audit2allow_prosess_close_button_clicked();
}

void SegatexAudit2allowProcess::audit2allow_base_process(int log_file, QString outputfile_str, int g, QString moduleName_str, QString grepLineEdit_str)
{
	outputfile_str_common = outputfile_str;
	rm_outputfile_str_common();

	x = g / 1000;
	y = g % 1000;

	xx = g / 100;
	yy = g % 100;

	xxx= g / 10;
	yyy = g % 10;

	xxxx= g / 1;
	yyyy = g % 1;
	//devide by 1000  eq 1 and % eq 111 option -lRve
	//devide by 1000  eq 1 and % eq 110 option -lRv
	//devide by 1000  eq 1 and % eq 101 option -lRe
	//devide by 1000  eq 1 and % eq 100 option -lR
	//devide by 1000  eq 1 and % eq  11 option -lve
	//devide by 1000  eq 1 and % eq   1 option -le
	//devide by 1000  eq 1 and % eq  10 option -lv
	//devide by 1000  eq 1 and % eq   0 option -l
	//
	//devide by  100  eq 1 and % eq 11 option -Rve
	//devide by  100  eq 1 and % eq 10 option -Rv
	//devide by  100  eq 1 and % eq 1 option -Re
	//devide by  100  eq 1 and % eq 0 option -R
	//
	//devide by  10  eq 1 and % eq  1 option -ve
	//devide by  10  eq 1 and % eq  0 option -v
	//
	//devide by   1  eq 1 and % eq  0 option -e
	//devide by 1000  eq 0 and % eq   0 option -no_option

	path = "/usr/share/segatex";
	forward_slash = "/";
	outputfile_str = path + forward_slash + outputfile_str;

	//grep fusefs /var/log/audit/audit.log | audit2allow -M mycvs
	
	process_command = "";
	
	if((grepLineEdit_str !="")&&(log_file == 2)){
		process_command = "grep " + grepLineEdit_str + " /var/log/audit/audit.log | ";
	}
	if((grepLineEdit_str !="")&&(log_file == 1)){
		process_command = "grep " + grepLineEdit_str + " /var/log/messages | ";
	}

	process_command = process_command + "audit2allow";

	if((x == 1)&&(y == 111)){
		process_command = process_command + " -l -R -v -e"; 
	}
	if((x == 1)&&(y == 110)){
		process_command = process_command + " -l -R -v"; 
	}
	if((x == 1)&&(y == 101)){
		process_command = process_command + " -l -R -e"; 
	}
	if((x == 1)&&(y == 100)){
		process_command = process_command + " -l -R"; 
	}
	if((x == 1)&&(y == 11)){
		process_command = process_command + " -l -v -e"; 
	}
	if((x == 1)&&(y == 1)){
		process_command = process_command + " -l -e"; 
	}
	if((x == 1)&&(y == 10)){
		process_command = process_command + " -l -v"; 
	}
	if((x == 1)&&(y == 0)){
		process_command = process_command + " -l"; 
	}
	if((xx == 1)&&(yy == 11)){
		process_command = process_command + " -R -v -e"; 
	}
	if((xx == 1)&&(yy == 10)){
		process_command = process_command + " -R -v"; 
	}
	if((xx == 1)&&(yy == 1)){
		process_command = process_command + " -R -e"; 
	}
	if((xx == 1)&&(yy == 0)){
		process_command = process_command + " -R"; 
	}
	if((xxx == 1)&&(yyy == 1)){
		process_command = process_command + " -v -e"; 
	}
	if((xxx == 1)&&(yyy == 0)){
		process_command = process_command + " -v"; 
	}
	if((xxxx == 1)&&(yyyy == 0)){
		process_command = process_command + " -e"; 
	}
	if((x == 0)&&(y == 0)){
		//do nothing
	}
	process_command = process_command + " -m " + moduleName_str; 

	if(log_file == 3){
		process_command = process_command + " -a "; 
	}

	if((grepLineEdit_str == "")&&(log_file == 2)){
		process_command = process_command + " -i /var/log/audit/audit.log"; 
	}
	if((grepLineEdit_str == "")&&(log_file == 1)){
		process_command = process_command + " -i /var/log/messages"; 
	}

	process_command = process_command + " -o " + outputfile_str; 

        #define PWD_BUF 8600
        ofstream os_add;
        os_add.open(outputfile_str);
        if(os_add){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(process_command, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os_add << buffer << endl;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os_add.close();

	//read from .te file
	readFromOutputFile();
}
//this slot should be called from above slot
void SegatexAudit2allowProcess::readFromOutputFile()
{
	/////////////////////////////////////////////////////////////
	path = "/usr/share/segatex";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList(outputfile_str_common);
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			//cout << "file_interface_name" << file_interface_name << endl;
			QFile file( file_interface_name );
			if ( file.open( QIODevice::ReadOnly ) ) {
				QTextStream stream( &file );
				////////////////////////////////////////////
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					textEdit1->append(line_analized);
				}
				file.close();
				++it_d;
			}else{
				//do nothing
			}
		}
	//textEdit1->setCursorPosition(0,0);
}
/*basic pattern*/
void SegatexAudit2allowProcess::rm_outputfile_str_common()
{
	outputfile_str_common_real = "/usr/share/segatex/" + outputfile_str_common;

        #define PWD_BUF 8600
	rmcommand = "rm " + outputfile_str_common_real;

        ofstream os_rm;
        os_rm.open(outputfile_str_common_real);
        if(os_rm){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(rmcommand, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os_rm << buffer << endl;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os_rm.close();
}

