/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#ifndef SEGATEXSTATE_H
#define SEGATEXSTATE_H

#include <QRegExp>
#include <QTextEdit>

#include <selinux/selinux.h>
#include <selinux/get_default_type.h>

class QMessageBox;

class SegatexState: public QTextEdit
{
	Q_OBJECT
public:
	SegatexState();
public slots:
	QString loaded_policy();
	QString is_selinux_enabled_segatex();
	QString getenforce_segatex();
	QString default_policy_type();
	QString default_getenforcemode();
	QString segatex_selinux_policy_root();
	int segatex_security_policyvers();
	int segatex_selinux_path();
signals:
protected:
private slots:
private:
	QString pol_root;
	QString loaded_policy_str;
	QString policy_targeted;
	QString policy_minimum;
	QString policy_mls;
	int enabled_or_not;
	QString enabled_or_not_str;
	int getenforce;
	QString getenforce_str;
	QString default_policy_type_str;
	QString default_policy_type_str_tr;
	QString default_getenforcemode_str;
	QString default_getenforcemode_str_final;
	QString selinux_binary_policy_path_str;
	QString selinux_failsafe_context_path_str;
	QString selinux_removable_context_path_str;
	QString selinux_default_context_path_str;
	QString selinux_user_contexts_path_str;
	QString selinux_file_context_path_str;
	QString selinux_file_context_homedir_path_str;
	QString selinux_file_context_local_path_str;
	QString selinux_file_context_subs_path_str;
	QString selinux_homedir_context_path_str;
	QString selinux_media_context_path_str;
	QString selinux_virtual_domain_context_path_str;
	QString selinux_virtual_image_context_path_str;
	QString selinux_x_context_path_str;
	QString selinux_contexts_path_str;
	QString selinux_securetty_types_path_str;
	QString selinux_booleans_path_str;
	QString selinux_customizable_types_path_str;
	QString selinux_users_path_str;
	QString selinux_usersconf_path_str;
	QString selinux_translations_path_str;
	QString selinux_colors_path_str;
	QString selinux_netfilter_context_path_str;
	QString selinux_path_str;
	QString linuxuser_str;
	QString seuser_str;
	QString level_str;
	QString segatex_selinux_policy_root_str;
	int segatex_security_policyvers_int;
};

#endif
