/*
 * Decompiled with CFR 0.152.
 */
package net.jsunit;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.jsunit.Utility;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import sun.net.www.protocol.http.HttpURLConnection;

public class DistributedTest
extends TestCase {
    public static final String REMOTE_MACHINE_URLS = "remoteMachineURLs";
    private List remoteMachineURLs;

    public DistributedTest(String string) {
        super(string);
        String string2 = System.getProperty(REMOTE_MACHINE_URLS);
        this.remoteMachineURLs = Utility.listFromCommaDelimitedString(string2);
    }

    public void testCollectResults() {
        Iterator iterator = this.remoteMachineURLs.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.submitRequestTo(string);
            Element element = null;
            try {
                Document document = new SAXBuilder().build((Reader)new StringReader(string2));
                element = document.getRootElement();
                if (!"result".equals(element.getName())) {
                    Assert.fail((String)("Unrecognized response from " + string + ": " + string2));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Assert.fail((String)("Could not parse XML response from " + string + ": " + string2));
            }
            Assert.assertEquals((String)(string + " failed"), (String)"success", (String)element.getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String submitRequestTo(String string) {
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(string + "/jsunit/runner");
            httpURLConnection = new HttpURLConnection(uRL, "", 0);
            InputStream inputStream = httpURLConnection.getInputStream();
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            inputStream.close();
            String string2 = new String(byArray);
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)("Could not submit request to " + string));
            String string3 = null;
            return string3;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }
}

