/*
 * Decompiled with CFR 0.152.
 */
package net.jsunit;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.jsunit.Configuration;
import net.jsunit.ConfigurationException;
import net.jsunit.TestSuiteResult;
import net.jsunit.Utility;
import net.jsunit.servlet.JsUnitServlet;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpServer;
import org.mortbay.http.handler.ResourceHandler;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.start.Monitor;
import org.mortbay.util.MultiException;

public class JsUnitServer
extends HttpServer {
    private List results = new ArrayList();
    private int port;
    private File resourceBase;
    private File logsDirectory;
    private List localBrowserFileNames;
    private URL testURL;
    private boolean initialized;
    static /* synthetic */ Class class$net$jsunit$servlet$ResultAcceptorServlet;
    static /* synthetic */ Class class$net$jsunit$servlet$ResultDisplayerServlet;
    static /* synthetic */ Class class$net$jsunit$servlet$TestRunnerServlet;

    public static void main(String[] stringArray) {
        JsUnitServer jsUnitServer = new JsUnitServer();
        try {
            jsUnitServer.initialize(stringArray);
            jsUnitServer.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initialize(String[] stringArray) throws ConfigurationException {
        try {
            Configuration configuration = Configuration.resolve(stringArray);
            configuration.configure(this);
            this.initialized = true;
        }
        catch (ConfigurationException configurationException) {
            System.err.println("Server initialization failed because property \"" + configurationException.getPropertyInError() + "\" has an invalid value of \"" + configurationException.getInvalidValue() + "\"");
            throw configurationException;
        }
    }

    public void start() throws MultiException {
        if (!this.initialized) {
            System.err.println("Cannot start server: not initialized");
            return;
        }
        try {
            this.setUpHttpServer();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        super.start();
        Utility.log(this.asString());
    }

    private void setUpHttpServer() throws IOException {
        this.addListener(":" + this.port);
        HttpContext httpContext = this.getContext("/jsunit");
        ServletHandler servletHandler = new ServletHandler();
        servletHandler.addServlet("JsUnitResultAcceptor", "/acceptor", (class$net$jsunit$servlet$ResultAcceptorServlet == null ? (class$net$jsunit$servlet$ResultAcceptorServlet = JsUnitServer.class$("net.jsunit.servlet.ResultAcceptorServlet")) : class$net$jsunit$servlet$ResultAcceptorServlet).getName());
        servletHandler.addServlet("JsUnitResultDisplayer", "/displayer", (class$net$jsunit$servlet$ResultDisplayerServlet == null ? (class$net$jsunit$servlet$ResultDisplayerServlet = JsUnitServer.class$("net.jsunit.servlet.ResultDisplayerServlet")) : class$net$jsunit$servlet$ResultDisplayerServlet).getName());
        servletHandler.addServlet("JsUnitTestRunner", "/runner", (class$net$jsunit$servlet$TestRunnerServlet == null ? (class$net$jsunit$servlet$TestRunnerServlet = JsUnitServer.class$("net.jsunit.servlet.TestRunnerServlet")) : class$net$jsunit$servlet$TestRunnerServlet).getName());
        httpContext.addHandler((HttpHandler)servletHandler);
        httpContext.setResourceBase(this.resourceBase.toString());
        httpContext.addHandler((HttpHandler)new ResourceHandler());
        this.addContext(httpContext);
        JsUnitServlet.setServer(this);
        Monitor.monitor();
    }

    public void initialize() throws ConfigurationException {
        this.initialize(new String[0]);
    }

    public TestSuiteResult accept(HttpServletRequest httpServletRequest) {
        TestSuiteResult testSuiteResult = TestSuiteResult.fromRequest(httpServletRequest, this.logsDirectory);
        TestSuiteResult testSuiteResult2 = this.findResultWithId(testSuiteResult.getId());
        if (testSuiteResult2 != null) {
            this.results.remove(testSuiteResult2);
        }
        this.results.add(testSuiteResult);
        testSuiteResult.writeLog();
        return testSuiteResult;
    }

    public List getResults() {
        return this.results;
    }

    public void clearResults() {
        this.results.clear();
    }

    public TestSuiteResult findResultWithId(String string) {
        TestSuiteResult testSuiteResult = this.findResultWithIdInResultList(string);
        if (testSuiteResult == null) {
            testSuiteResult = TestSuiteResult.findResultWithIdInResultLogs(this.logsDirectory, string);
        }
        return testSuiteResult;
    }

    private TestSuiteResult findResultWithIdInResultList(String string) {
        Iterator iterator = this.getResults().iterator();
        while (iterator.hasNext()) {
            TestSuiteResult testSuiteResult = (TestSuiteResult)iterator.next();
            if (!testSuiteResult.hasId(string)) continue;
            return testSuiteResult;
        }
        return null;
    }

    public TestSuiteResult lastResult() {
        List list = this.getResults();
        return list.isEmpty() ? null : (TestSuiteResult)list.get(list.size() - 1);
    }

    public int resultsCount() {
        return this.getResults().size();
    }

    public String asString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("port").append(": ").append(this.port).append("\n");
        stringBuffer.append("resourceBase").append(": ").append(this.resourceBase.getAbsolutePath()).append("\n");
        stringBuffer.append("logsDirectory").append(": ").append(this.logsDirectory.getAbsolutePath()).append("\n");
        stringBuffer.append("browserFileNames").append(": ").append(this.localBrowserFileNames).append("\n");
        stringBuffer.append("url").append(": ").append(this.testURL);
        return stringBuffer.toString();
    }

    public String toString() {
        return "JsUnit Server";
    }

    public void setResourceBase(File file) {
        this.resourceBase = file;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setLogsDirectory(File file) {
        this.logsDirectory = file;
    }

    public List getLocalBrowserFileNames() {
        return this.localBrowserFileNames;
    }

    public void setLocalBrowserFileNames(List list) {
        this.localBrowserFileNames = list;
    }

    public void setTestURL(URL uRL) {
        this.testURL = uRL;
    }

    public URL getTestURL() {
        return this.testURL;
    }

    public File getLogsDirectory() {
        return this.logsDirectory;
    }

    public int getPort() {
        return this.port;
    }

    public File getResourceBase() {
        return this.resourceBase;
    }

    public void finalize() throws Exception {
        this.stop();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

