/*
 * Decompiled with CFR 0.152.
 */
package net.jsunit;

import net.jsunit.TestCaseResult;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class TestCaseResultWriter {
    public static final String TEST_CASE = "testcase";
    public static final String NAME = "name";
    public static final String TIME = "time";
    public static final String FAILURE = "failure";
    public static final String ERROR = "error";
    public static final String MESSAGE = "message";
    private TestCaseResult result;

    public TestCaseResultWriter(TestCaseResult testCaseResult) {
        this.result = testCaseResult;
    }

    public void addXmlTo(Element element) {
        element.addContent(this.createTestCaseElement());
    }

    public Element createTestCaseElement() {
        Element element = new Element(TEST_CASE);
        try {
            element.setAttribute(NAME, this.result.getName().replace('\u0000', ' '));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        element.setAttribute(TIME, String.valueOf(this.result.getTime()));
        if (this.result.hadFailure()) {
            Element element2 = new Element(FAILURE);
            try {
                element2.setAttribute(MESSAGE, this.result.getFailure().replace('\u0000', ' '));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            element.addContent(element2);
        } else if (this.result.hadError()) {
            Element element3 = new Element(ERROR);
            try {
                element3.setAttribute(MESSAGE, this.result.getError().replace('\u0000', ' '));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            element.addContent(element3);
        }
        return element;
    }

    public String writeProblemSummary() {
        if (this.result.hadFailure()) {
            return this.result.getName() + " failed:\n" + this.result.getFailure();
        }
        if (this.result.hadError()) {
            return this.result.getName() + " had an error:\n" + this.result.getError();
        }
        return null;
    }

    public String writeXmlFragment() {
        return new XMLOutputter().outputString(this.createTestCaseElement());
    }
}

