/*
 * Decompiled with CFR 0.152.
 */
package net.jsunit;

import java.util.Iterator;
import net.jsunit.TestCaseResult;
import net.jsunit.TestCaseResultWriter;
import net.jsunit.TestSuiteResult;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class TestSuiteResultWriter {
    public static final String ID = "id";
    public static final String USER_AGENT = "userAgent";
    public static final String TIME = "time";
    public static final String TEST_CASES = "testCases";
    public static final String JSUNIT_VERSION = "JsUnitVersion";
    public static final String TEST_COUNT = "tests";
    public static final String REMOTE_ADDRESS = "remoteAddress";
    public static final String PROPERTIES = "properties";
    public static final String PROPERTY = "property";
    public static final String PROPERTY_KEY = "name";
    public static final String PROPERTY_VALUE = "value";
    public static final String BASE_URL = "baseURL";
    TestSuiteResult result;

    public TestSuiteResultWriter(TestSuiteResult testSuiteResult) {
        this.result = testSuiteResult;
    }

    public String writeXml() {
        Element element = this.createRootElement();
        Document document = new Document(element);
        return new XMLOutputter().outputString(document);
    }

    public String writeXmlFragment() {
        return new XMLOutputter().outputString(this.createRootElement());
    }

    private Element createRootElement() {
        Element element = new Element("testsuite");
        element.setAttribute(ID, this.result.getId());
        element.setAttribute("errors", "" + this.result.errorCount());
        element.setAttribute("failures", "" + this.result.failureCount());
        element.setAttribute(PROPERTY_KEY, "JsUnitTestCase");
        element.setAttribute(TEST_COUNT, "" + this.result.count());
        element.setAttribute(TIME, String.valueOf(this.result.getTime()));
        this.addPropertiesElementTo(element);
        this.addTestResultElementsTo(element);
        return element;
    }

    private void addPropertiesElementTo(Element element) {
        Element element2 = new Element(PROPERTIES);
        element.addContent(element2);
        this.addProperty(element2, JSUNIT_VERSION, this.result.getJsUnitVersion());
        this.addProperty(element2, USER_AGENT, this.result.getUserAgent());
        this.addProperty(element2, REMOTE_ADDRESS, this.result.getRemoteAddress());
        this.addProperty(element2, BASE_URL, this.result.getBaseURL());
    }

    private void addProperty(Element element, String string, String string2) {
        Element element2 = new Element(PROPERTY);
        element2.setAttribute(PROPERTY_KEY, string);
        element2.setAttribute(PROPERTY_VALUE, string2 == null ? "" : string2);
        element.addContent(element2);
    }

    private void addTestResultElementsTo(Element element) {
        Iterator iterator = this.result.getTestCaseResults().iterator();
        while (iterator.hasNext()) {
            TestCaseResult testCaseResult = (TestCaseResult)iterator.next();
            new TestCaseResultWriter(testCaseResult).addXmlTo(element);
        }
    }

    public String writeProblems() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.result.getTestCaseResults().iterator();
        while (iterator.hasNext()) {
            TestCaseResult testCaseResult = (TestCaseResult)iterator.next();
            if (testCaseResult.hadSuccess()) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\n");
            }
            String string = testCaseResult.writeProblemSummary();
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

