/*
 * Decompiled with CFR 0.152.
 */
package net.jsunit.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import net.jsunit.JsUnitServer;
import net.jsunit.PropertiesFileConfiguration;
import net.jsunit.Utility;

public class PropertiesConfigurationTest
extends TestCase {
    public void testNoFile() throws Exception {
        PropertiesFileConfiguration propertiesFileConfiguration = new PropertiesFileConfiguration("nosuch.file");
        try {
            propertiesFileConfiguration.configure(new JsUnitServer());
            Assert.fail((String)"Should have through a Runtime because no properties file exists");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testSimple() throws Exception {
        this.writePropertiesFile("temp.file");
        PropertiesFileConfiguration propertiesFileConfiguration = new PropertiesFileConfiguration("temp.file");
        propertiesFileConfiguration.initialize();
        Assert.assertEquals((String)"aaa", (String)propertiesFileConfiguration.browserFileNames());
        Assert.assertEquals((String)"bbb", (String)propertiesFileConfiguration.logsDirectory());
        Assert.assertEquals((String)"1234", (String)propertiesFileConfiguration.port());
        Assert.assertEquals((String)"ccc", (String)propertiesFileConfiguration.resourceBase());
        Assert.assertEquals((String)"ddd", (String)propertiesFileConfiguration.url());
    }

    public void tearDown() throws Exception {
        Utility.deleteFile("temp.file");
        super.tearDown();
    }

    private void writePropertiesFile(String string) {
        String string2 = "browserFileNames=aaa\nlogsDirectory=bbb\nport=1234\nresourceBase=ccc\nurl=ddd";
        Utility.writeFile(string2, string);
    }
}

