/*
 * Decompiled with CFR 0.152.
 */
package net.jsunit.test;

import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.jsunit.JsUnitServer;
import net.jsunit.TestSuiteResult;
import net.jsunit.Utility;
import net.jsunit.test.DummyHttpRequest;

public class ResultAcceptorTest
extends TestCase {
    protected Map requestMap;
    private JsUnitServer server;

    public ResultAcceptorTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.server = new JsUnitServer();
        System.setProperty("browserFileNames", "foo");
        System.setProperty("url", "http://bar");
        this.server.initialize();
        Utility.setLogToStandardOut(false);
        this.requestMap = new HashMap();
        this.requestMap.put("id", "ID_foo");
        this.requestMap.put("userAgent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)");
        this.requestMap.put("time", "4.3");
        this.requestMap.put("JsUnitVersion", "2.5");
        this.requestMap.put("testCases", this.dummyTestCaseStrings());
    }

    public void tearDown() throws Exception {
        ((Hashtable)System.getProperties()).remove("browserFileNames");
        ((Hashtable)System.getProperties()).remove("url");
        File file = TestSuiteResult.logFileForId(this.server.getLogsDirectory(), "ID_foo");
        if (file.exists()) {
            file.delete();
        }
        super.tearDown();
    }

    protected String[] dummyTestCaseStrings() {
        return new String[]{"file:///dummy/path/dummyPage.html:testFoo|1.3|S||", "testFoo|1.3|E|Test Error Message|", "testFoo|1.3|F|Test Failure Message|"};
    }

    protected void submit() {
        DummyHttpRequest dummyHttpRequest = new DummyHttpRequest(this.requestMap);
        this.server.accept(dummyHttpRequest);
    }

    public void testSubmitResults() {
        Assert.assertEquals((int)0, (int)this.server.getResults().size());
        this.submit();
        Assert.assertEquals((int)1, (int)this.server.getResults().size());
        this.submit();
        Assert.assertEquals((int)1, (int)this.server.getResults().size());
    }

    public void testSubmittedResultHeaders() {
        this.submit();
        TestSuiteResult testSuiteResult = (TestSuiteResult)this.server.getResults().get(0);
        Assert.assertEquals((String)"ID_foo", (String)testSuiteResult.getId());
        Assert.assertEquals((String)"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", (String)testSuiteResult.getUserAgent());
        Assert.assertEquals((String)"2.5", (String)testSuiteResult.getJsUnitVersion());
        Assert.assertEquals((int)1, (int)testSuiteResult.errorCount());
        Assert.assertEquals((int)1, (int)testSuiteResult.failureCount());
        Assert.assertEquals((int)3, (int)testSuiteResult.count());
        Assert.assertEquals((double)4.3, (double)testSuiteResult.getTime(), (double)0.001);
    }

    public void testSubmittedTestCaseResults() {
        this.submit();
        TestSuiteResult testSuiteResult = (TestSuiteResult)this.server.getResults().get(0);
        Assert.assertEquals((int)3, (int)testSuiteResult.getTestCaseResults().size());
    }

    public void testFindResultById() {
        Assert.assertNull((Object)this.server.findResultWithId("ID_foo"));
        this.submit();
        Assert.assertNotNull((Object)this.server.findResultWithId("ID_foo"));
        Assert.assertNull((Object)this.server.findResultWithId("Invalid ID"));
        this.server.clearResults();
        Assert.assertNotNull((Object)this.server.findResultWithId("ID_foo"));
        Assert.assertNull((Object)this.server.findResultWithId("Invalid ID"));
    }

    public void testLog() {
        File file = TestSuiteResult.logFileForId(this.server.getLogsDirectory(), "ID_foo");
        Assert.assertFalse((boolean)file.exists());
        this.submit();
        Assert.assertTrue((boolean)file.exists());
    }
}

