/*
 * Decompiled with CFR 0.152.
 */
package net.jsunit.test;

import java.io.File;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.jsunit.TestCaseResult;
import net.jsunit.TestSuiteResult;
import net.jsunit.Utility;

public class TestSuiteResultTest
extends TestCase {
    private TestSuiteResult result;
    private String expectedXmlFragment = "<testsuite id=\"An ID\" errors=\"1\" failures=\"1\" name=\"JsUnitTestCase\" tests=\"3\" time=\"4.3\"><properties><property name=\"JsUnitVersion\" value=\"2.5\" /><property name=\"userAgent\" value=\"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\" /><property name=\"remoteAddress\" value=\"Dummy Remote Address\" /><property name=\"baseURL\" value=\"about:mozilla\" /></properties><testcase name=\"testFoo\" time=\"1.3\" /><testcase name=\"testFoo\" time=\"1.3\"><error message=\"Test Error Message\" /></testcase><testcase name=\"testFoo\" time=\"1.3\"><failure message=\"Test Failure Message\" /></testcase></testsuite>";

    public TestSuiteResultTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.result = new TestSuiteResult(null);
        this.result.setJsUnitVersion("2.5");
        this.result.setId("An ID");
        this.result.setUserAgent("Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)");
        this.result.setRemoteAddress("Dummy Remote Address");
        this.result.setBaseURL("about:mozilla");
        this.result.setTime(4.3);
        this.result.setTestCaseStrings(new String[]{"testFoo|1.3|S||", "testFoo|1.3|E|Test Error Message|", "testFoo|1.3|F|Test Failure Message|"});
    }

    public void testId() {
        Assert.assertNotNull((Object)this.result.getId());
        this.result = new TestSuiteResult(null);
        this.result.setId("foo");
        Assert.assertEquals((String)"foo", (String)this.result.getId());
    }

    public void testFields() {
        this.assertFields(this.result);
    }

    private void assertFields(TestSuiteResult testSuiteResult) {
        Assert.assertEquals((String)"2.5", (String)testSuiteResult.getJsUnitVersion());
        Assert.assertEquals((String)"An ID", (String)testSuiteResult.getId());
        Assert.assertEquals((String)"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)", (String)testSuiteResult.getUserAgent());
        Assert.assertEquals((String)"Dummy Remote Address", (String)testSuiteResult.getRemoteAddress());
        Assert.assertEquals((double)4.3, (double)testSuiteResult.getTime(), (double)0.001);
        Assert.assertEquals((int)3, (int)testSuiteResult.getTestCaseResults().size());
        Iterator iterator = testSuiteResult.getTestCaseResults().iterator();
        while (iterator.hasNext()) {
            TestCaseResult testCaseResult = (TestCaseResult)iterator.next();
            Assert.assertNotNull((Object)testCaseResult);
        }
    }

    public void testXml() {
        Assert.assertEquals((String)this.expectedXmlFragment, (String)this.result.writeXmlFragment());
    }

    public void testSuccess() {
        Assert.assertFalse((boolean)this.result.hadSuccess());
    }

    public void testBuildFromXml() {
        Utility.writeFile(this.result.writeXml(), "resultXml.xml");
        File file = new File("resultXml.xml");
        TestSuiteResult testSuiteResult = TestSuiteResult.fromXmlFile(file);
        this.assertFields(testSuiteResult);
        file.delete();
    }
}

