#line 1 "tmp/program_used_flags.te"


























#line 1 "tmp/all_macros.te"
#
# Macros for all admin domains.
#

#
# admin_domain(domain_prefix)
#
# Define derived types and rules for an administrator domain.
#
# The type declaration and role authorization for the domain must be
# provided separately.  Likewise, domain transitions into this domain
# must be specified separately.  If the every_domain() rules are desired,
# then these rules must also be specified separately.
#

#line 149


##############################
#
# core macros for the type enforcement (TE) configuration.
#
#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
#           Howard Holm (NSA), <hdholm@epoch.ncsc.mil>
#           Russell Coker <russell@coker.com.au>
#

#################################
# 
# Macros for groups of classes and 
# groups of permissions.
#

#
# All directory and file classes
#


#
# All non-directory file classes.
#


#
# Non-device file classes.
#


#
# Device file classes.
#


#
# All socket classes.
#


#
# Datagram socket classes.
# 


#
# Stream socket classes.
#


#
# Unprivileged socket classes (exclude rawip, netlink, packet).
#



# 
# Permissions for getting file attributes.
#


# 
# Permissions for executing files.
#


# 
# Permissions for reading files and their attributes.
#


# 
# Permissions for reading and executing files.
#


# 
# Permissions for reading and writing files and their attributes.
#


# 
# Permissions for reading and appending to files.
#


#
# Permissions for linking, unlinking and renaming files.
# 


#
# Permissions for creating and using files.
# 


# 
# Permissions for reading directories and their attributes.
#


# 
# Permissions for reading and writing directories and their attributes.
#


# 
# Permissions for reading and adding names to directories.
#



#
# Permissions for creating and using directories.
# 


#
# Permissions to mount and unmount file systems.
#


#
# Permissions for using sockets.
# 


#
# Permissions for creating and using sockets.
# 


#
# Permissions for using stream sockets.
# 


#
# Permissions for creating and using stream sockets.
# 



#
# Permissions for sending all signals.
#


#
# Permissions for sending and receiving network packets.
#


#
# Permissions for using System V IPC
#










#################################
# 
# Macros for type transition rules and
# access vector rules.
#

#
# Simple combinations for reading and writing both
# directories and files.
# 
#line 331


#line 336


#line 341


#line 346


#line 351


#line 356


#line 361


##################################
#
# can_getsecurity(domain)
#
# Authorize a domain to get security policy decisions.
#
#line 373


##################################
#
# can_setenforce(domain)
#
# Authorize a domain to set the enforcing flag.
# Due to its sensitivity, always audit this permission.
#
#line 387


##################################
#
# can_loadpol(domain)
#
# Authorize a domain to load a policy configuration.
# Due to its sensitivity, always audit this permission.
#
#line 401


#################################
#
# domain_trans(parent_domain, program_type, child_domain)
#
# Permissions for transitioning to a new domain.
#

#line 453


#################################
#
# domain_auto_trans(parent_domain, program_type, child_domain)
#
# Define a default domain transition and allow it.
#
#line 464


#################################
#
# can_ptrace(domain, domain)
#
# Permissions for running ptrace (strace or gdb) on another domain
#
#line 475


#################################
#
# can_exec(domain, type)
#
# Permissions for executing programs with
# a specified type without changing domains.
#
#line 486


#################################
#
# file_type_trans(domain, dir_type, file_type)
#
# Permissions for transitioning to a new file type.
#

#line 516


#################################
#
# file_type_auto_trans(creator_domain, parent_directory_type, file_type, object_class)
#
# the object class will default to notdevfile_class_set if not specified as
# the fourth parameter
#
# Define a default file type transition and allow it.
#
#line 537



#################################
#
# can_unix_connect(client, server)
#
# Permissions for establishing a Unix stream connection.
#
#line 548


#################################
#
# can_unix_send(sender, receiver)
#
# Permissions for sending Unix datagrams.
#
#line 558


#################################
#
# can_tcp_connect(client, server)
#
# Permissions for establishing a TCP connection.
#
#line 571


#################################
#
# can_udp_send(sender, receiver)
#
# Permissions for sending/receiving UDP datagrams.
#
#line 582



##################################
#
# base_pty_perms(domain_prefix)
#
# Base permissions used for can_create_pty() and can_create_other_pty()
#
#line 602



##################################
#
# pty_slave_label(domain_prefix, attributes)
#
# give access to a slave pty but do not allow creating new ptys
#
#line 622



##################################
#
# can_create_pty(domain_prefix, attributes)
#
# Permissions for creating ptys.
#
#line 634



##################################
#
# can_create_other_pty(domain_prefix,other_domain)
#
# Permissions for creating ptys for another domain.
#
#line 650



#
# general_domain_access(domain)
#
# Grant permissions within the domain.
# This includes permissions to processes, /proc/PID files,
# file descriptors, pipes, Unix sockets, and System V IPC objects
# labeled with the domain.
#
#line 687

##############################
#
# Global macros for the type enforcement (TE) configuration.
#

#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser  
#           Howard Holm (NSA) <hdholm@epoch.ncsc.mil>
#           Russell Coker <russell@coker.com.au>
#
#
#

##################################
#
# can_setexec(domain)
#
# Authorize a domain to set its exec context
# (via /proc/pid/attr/exec).
#
#line 714


##################################
#
# can_setfscreate(domain)
#
# Authorize a domain to set its fscreate context
# (via /proc/pid/attr/fscreate).
#
#line 729


#################################
#
# uses_shlib(domain)
#
# Permissions for using shared libraries.
#
#line 748


#################################
#
# can_exec_any(domain)
#
# Permissions for executing a variety
# of executable types.
#
#line 766



#################################
#
# can_network(domain)
#
# Permissions for accessing the network.
# See types/network.te for the network types.
# See net_contexts for security contexts for network entities.
#
#line 845


#################################
#
# can_sysctl(domain)
#
# Permissions for modifying sysctl parameters.
#
#line 869



##################################
#
# read_locale(domain)
#
# Permissions for reading the locale data,
# /etc/localtime and the files that it links to
#
#line 882



#
# general_proc_read_access(domain)
#
# Grant read/search permissions to most of /proc, excluding
# the /proc/PID directories and the /proc/kmsg and /proc/kcore files.
# The general_domain_access macro grants access to the domain /proc/PID
# directories, but not to other domains.  Only permissions to stat
# are granted for /proc/kmsg and /proc/kcore, since these files are more
# sensitive.
# 
#line 918


#
# base_file_read_access(domain)
#
# Grant read/search permissions to a few system file types.
#
#line 942


#######################
# daemon_core_rules(domain_prefix, attribs)
#
# Define the core rules for a daemon, used by both daemon_base_domain() and
# init_service_domain().
# Attribs is the list of attributes which must start with "," if it is not empty
#
# Author:  Russell Coker <russell@coker.com.au>
#
#line 973

#######################
# init_service_domain(domain_prefix, attribs)
#
# Define a domain for a program that is run from init
# Attribs is the list of attributes which must start with "," if it is not empty
#
# Author:  Russell Coker <russell@coker.com.au>
#
#line 987

#######################
# daemon_base_domain(domain_prefix, attribs)
#
# Define a daemon domain with a base set of type declarations
# and permissions that are common to most daemons.
# attribs is the list of attributes which must start with "," if it is not empty
#
# Author:  Russell Coker <russell@coker.com.au>
#
#line 1005

# allow a domain to create its own files under /var/run and to create files
# in directories that are created for it.  For sock_file etc you need to add
# your own rules
#line 1013


#line 1031

#line 1037


# define a sub-domain, $1_t is the parent domain, $2 is the name
# of the sub-domain.
#
#line 1064



#line 1070


#line 1077


#line 1083


#line 1088


#line 1093


#line 1098


#######################
# application_domain(domain_prefix)
#
# Define a domain with a base set of type declarations
# and permissions that are common to simple applications.
#
# Author:  Russell Coker <russell@coker.com.au>
#
#line 1114


#line 1120


#line 1128


#
# Macros for all user login domains.
#

#
# user_domain(domain_prefix)
#
# Define derived types and rules for an ordinary user domain.
#
# The type declaration and role authorization for the domain must be
# provided separately.  Likewise, domain transitions into this domain
# must be specified separately.  
#

#line 1409



###########################################################################
#
# Domains for ordinary users.
#

#line 1505



#line 1511


#########################################################
#
# Ugly macros that give way too much access until we can
# go over the http policy more carefully.

#########################################################
#
# apache_domain_read_access(domain)
#
# This is a temporary measure to remove the every_domain,
# general_file_read_access and general_file_write_access macros.
# This macro gives far too much access.  The access needs to
# be trimmed down where this macro is used in this file and
# then destroyed.
#
#line 1657


#########################################################
#
# apache_domain_write_access(domain)
#
# This is a temporary measure to remove the every_domain,
# general_file_read_access and general_file_write_access macros.
# This macro gives far too much access.  The access needs to
# be trimmed down where this macro is used in this file and
# then destroyed.
#
#line 1676


#########################################################
#
# apache_domain_general_access(domain)
#
# This is a temporary measure to remove the every_domain,
# general_file_read_access and general_file_write_access macros.
# This macro gives far too much access.  The access needs to
# be trimmed down where this macro is used in this file and
# then destroyed.
#
#line 1712

#
# Macros for chkpwd domains.
#

#
# chkpwd_domain(domain_prefix)
#
# Define a derived domain for the *_chkpwd program when executed
# by a user domain.
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/su.te. 
#

#line 1772

#line 1772

#line 1772

#line 1772


# macro for chroot environments
# Author Russell Coker

# chroot(initial_domain, basename, role, tty_device_type)
#line 1902

#
# Macros for clamscan
#
# Author:  Brian May <bam@snoopy.apana.org.au>
#

#
# can_clamd_connect(domain_prefix)
#
# Define a domain that can access clamd
#
#line 1917


# clamscan_domain(domain_prefix)
#
# Define a derived domain for the clamscan program when executed
#
#line 1946


#line 1959


#line 1994


#line 2004


#
# Macros for crond domains.
#

#
# Authors:  Jonathan Crowley (MITRE) <jonathan@mitre.org>,
#	    Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser
#

#
# crond_domain(domain_prefix)
#
# Define a derived domain for cron jobs executed by crond on behalf 
# of a user domain.  These domains are separate from the top-level domain
# defined for the crond daemon and the domain defined for system cron jobs,
# which are specified in domains/program/crond.te.
#

#line 2101


# When system_crond_t domain executes a type $1 executable then transition to
# domain $2, allow $2 to interact with crond_t as well.
#line 2111

#
# Macros for crontab domains.
#

#
# Authors:  Jonathan Crowley (MITRE) <jonathan@mitre.org>
# Revised by Stephen Smalley <sds@epoch.ncsc.mil>
#

#
# crontab_domain(domain_prefix)
#
# Define a derived domain for the crontab program when executed by
# a user domain.  
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/crontab.te. 
#

#line 2202

#
# Macro for fingerd
#
# Author:  Russell Coker <russell@coker.com.au>
#

#
# fingerd_macro(domain_prefix)
#
# allow fingerd to create a fingerlog file in the user home dir
#
#line 2217

#
# Macros for gpg and pgp
#
# Author:  Russell Coker <russell@coker.com.au>
#
# based on the work of:
# Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser
#

#
# gpg_domain(domain_prefix)
#
# Define a derived domain for the gpg/pgp program when executed by
# a user domain.
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/gpg.te.
#
#line 2304

#
# Macros for gnome-pty-helper domains.
#

#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser 
#

#
# gph_domain(domain_prefix)
#
# Define a derived domain for the gnome-pty-helper program when
# executed by a user domain.
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/gnome-pty-helper.te. 
#
# The *_gph_t domains are for the gnome_pty_helper program.
# This program is executed by gnome-terminal to handle
# updates to utmp and wtmp.  In this regard, it is similar
# to utempter.  However, unlike utempter, gnome-pty-helper
# also creates the pty file for the terminal program.
# There is one *_gph_t domain for each user domain.  
#

#line 2376


#
# Macros for irc domains.
#

#
# Author:  Russell Coker <russell@coker.com.au>
#

#
# irc_domain(domain_prefix)
#
# Define a derived domain for the irc program when executed
# by a user domain.
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/irc.te. 
#

#line 2464

#line 2464

#line 2464

#line 2464

#line 2464

#
# Macros for lpr domains.
#

#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser 
#

#
# lpr_domain(domain_prefix)
#
# Define a derived domain for the lpr/lpq/lprm programs when executed
# by a user domain.
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/lpr.te. 
#

#line 2571

#
# Macros for mount
#
# Author:  Brian May <bam@snoopy.apana.org.au>
# Extended by Russell Coker <russell@coker.com.au>
#

#
# mount_domain(domain_prefix,dst_domain_prefix)
#
# Define a derived domain for the mount program for anyone.
#
#line 2621

#
# Macros for MTA domains.
#

#
# Author:   Russell Coker <russell@coker.com.au>
# Based on the work of: Stephen Smalley <sds@epoch.ncsc.mil>
#                       Timothy Fraser 
#

#
# mail_domain(domain_prefix)
#
# Define a derived domain for the sendmail program when executed by
# a user domain to send outgoing mail.  These domains are separate and
# independent of the domain used for the sendmail daemon process.
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/mta.te. 
#

#line 2732

#
# Macros for netscape/mozilla (or other browser) domains.
#

#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser 
#

#
# netscape_domain(domain_prefix)
#
# Define a derived domain for the netscape/mozilla program when executed by
# a user domain.  
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/netscape.te. 
#
#line 2794

# $1 is the source domain (or domains), $2 is the source role (or roles) and $3
# is the base name for the domain to run.  $1 is normally sysadm_t, and $2 is
# normally sysadm_r.  $4 is the type of program to run and $5 is the domain to
# transition to.
# sample usage:
# run_program(sysadm_t, sysadm_r, init, etc_t, initrc_t)
#
# if you have several users who run the same run_init type program for
# different purposes (think of a run_db program used by several database
# administrators to start several databases) then you can list all the source
# domains in $1, all the source roles in $2, but you may not want to list all
# types of programs to run in $4 and target domains in $5 (as that may permit
# entering a domain from the wrong type).  In such a situation just specify
# one value for each of $4 and $5 and have some rules such as the following:
# domain_trans(run_whatever_t, whatever_exec_t, whatever_t)

#line 2850

#
# Macros for screen domains.
#

#
# Author: Russell Coker <russell@coker.com.au>
# Based on the work of Stephen Smalley <sds@epoch.ncsc.mil>
# and Timothy Fraser
#

#
# screen_domain(domain_prefix)
#
# Define a derived domain for the screen program when executed
# by a user domain.
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/screen.te. 
#

#line 2944

#line 2944

#line 2944

#line 2944

#line 2944

#
# Macros for sendmail domains.
#

#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser 
#           Russell Coker <russell@coker.com.au>
#

#
# sendmail_user_domain(domain_prefix)
#
# Define a derived domain for the sendmail program when executed by
# a user domain to send outgoing mail.  These domains are separate and
# independent of the domain used for the sendmail daemon process.
#

#line 2978


#
# Macros for ssh domains.
#

#
# Author:  Stephen Smalley <sds@epoch.ncsc.mil>
#

# 
# ssh_domain(domain_prefix)
#
# Define a derived domain for the ssh program when executed
# by a user domain.
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/ssh.te. 
#

#line 3148

#line 3148

#line 3148

#line 3148

#
# Macros for su domains.
#

#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser
#

#
# su_domain(domain_prefix)
#
# Define a derived domain for the su program when executed
# by a user domain.
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/su.te. 
#


#line 3241

#line 3241

#line 3241

#line 3241

#
# Macros for X client programs ($2 etc)
#

#
# Author: Russell Coker <russell@coker.com.au>
# Based on the work of Stephen Smalley <sds@epoch.ncsc.mil>
# and Timothy Fraser 
#

#
# x_client_domain(domain_prefix)
#
# Define a derived domain for an X program when executed by
# a user domain.  
#
# The type declaration for the executable type for this program ($2_exec_t)
# must be provided separately!
#
# The first parameter is the base name for the domain/role (EG user or sysadm)
# The second parameter is the program name (EG $2)
# The third parameter is the attributes for the domain (if any)
#
#line 3405
#
# Macros for xauth domains.
#

#
# Author:  Russell Coker <russell@coker.com.au>
#

#
# xauth_domain(domain_prefix)
#
# Define a derived domain for the xauth program when executed
# by a user domain.
#
# The type declaration for the executable type for this program is
# provided separately in domains/program/xauth.te. 
#

#line 3492

#line 3492

#line 3492

#line 3492

#line 3492

#
# Macros for X server domains.
#

#
# Authors:  Stephen Smalley <sds@epoch.ncsc.mil> and Timothy Fraser
#

#################################
#
# xserver_domain(domain_prefix)
#
# Define a derived domain for the X server when executed
# by a user domain (e.g. via startx).  See the xdm_t domain
# in domains/program/xdm.te if using an X Display Manager.
#
# The type declarations for the executable type for this program 
# and the log type are provided separately in domains/program/xserver.te. 
#
# FIXME!  The X server requires far too many privileges.
#

#line 3670

#line 3670

#line 3670

#line 3670

#line 3670


#line 1 "constraints"
#
# Define m4 macros for the constraints
#

#
# Define the constraints
#
# constrain class_set perm_set expression ;
#
# expression : ( expression ) 
#	     | not expression
#	     | expression and expression
#	     | expression or expression
#	     | u1 op u2
#	     | r1 role_op r2
#	     | t1 op t2
#	     | u1 op names
#	     | u2 op names
#	     | r1 op names
#	     | r2 op names
#	     | t1 op names
#	     | t2 op names
#
# op : == | != 
# role_op : == | != | eq | dom | domby | incomp
#
# names : name | { name_list }
# name_list : name | name_list name#		
#

#
# Restrict the ability to transition to other users
# or roles to a few privileged types.
#

constrain process transition
	( u1 == u2 or t1 == privuser
#line 40

#line 40
         or (t1 == crond_t and t2 == user_crond_domain)
#line 40

        );

constrain process transition 
	( r1 == r2 or t1 == privrole) ;

#
# Restrict the ability to label objects with other
# user identities to a few privileged types.
#

constrain { dir file lnk_file sock_file fifo_file chr_file blk_file } { create relabelto relabelfrom } 
	( u1 == u2 or t1 == privowner );

constrain { tcp_socket udp_socket rawip_socket netlink_socket packet_socket unix_stream_socket unix_dgram_socket } { create relabelto relabelfrom } 
	( u1 == u2 or t1 == privowner );
#line 1 "initial_sid_contexts"
# FLASK

#
# Define the security context for each initial SID
# sid sidname   context

sid kernel	system_u:system_r:kernel_t
sid security	system_u:object_r:security_t
sid unlabeled	system_u:object_r:unlabeled_t
sid fs		system_u:object_r:fs_t
sid file	system_u:object_r:file_t
sid file_labels	system_u:object_r:file_labels_t
sid init	system_u:system_r:init_t
sid any_socket 	system_u:system_r:any_socket_t
sid port	system_u:object_r:port_t
sid netif	system_u:object_r:netif_t
sid netmsg	system_u:object_r:netmsg_t
sid node	system_u:object_r:node_t
sid igmp_packet system_u:system_r:igmp_packet_t
sid icmp_socket system_u:system_r:icmp_socket_t
sid tcp_socket  system_u:system_r:tcp_socket_t
sid sysctl_modprobe	system_u:object_r:sysctl_modprobe_t
sid sysctl	system_u:object_r:sysctl_t
sid sysctl_fs	system_u:object_r:sysctl_fs_t
sid sysctl_kernel	system_u:object_r:sysctl_kernel_t
sid sysctl_net	system_u:object_r:sysctl_net_t
sid sysctl_net_unix	system_u:object_r:sysctl_net_unix_t
sid sysctl_vm	system_u:object_r:sysctl_vm_t
sid sysctl_dev	system_u:object_r:sysctl_dev_t
sid kmod	system_u:system_r:kernel_t
sid policy	system_u:object_r:policy_config_t
sid scmp_packet	system_u:system_r:scmp_packet_t

# FLASK
#line 1 "fs_use"
#
# Define the labeling behavior for inodes in particular filesystem types.
# This information was formerly hardcoded in the SELinux module.

# Use xattrs for the following filesystem types.
# Requires that a security xattr handler exist for the filesystem.
fs_use_xattr ext2 system_u:object_r:fs_t;
fs_use_xattr ext3 system_u:object_r:fs_t;

# Use the allocating task SID to label inodes in the following filesystem
# types, and label the filesystem itself with the specified context.
# This is appropriate for pseudo filesystems that represent objects
# like pipes and sockets, so that these objects are labeled with the same
# type as the creating task.  
fs_use_task pipefs system_u:object_r:fs_t;
fs_use_task sockfs system_u:object_r:fs_t;

# Use a transition SID based on the allocating task SID and the
# filesystem SID to label inodes in the following filesystem types,
# and label the filesystem itself with the specified context.
# This is appropriate for pseudo filesystems like devpts and tmpfs
# where we want to label objects with a derived type.
fs_use_trans devpts system_u:object_r:devpts_t;
fs_use_trans tmpfs system_u:object_r:tmpfs_t;
fs_use_trans shm system_u:object_r:tmpfs_t;

# The separate genfs_contexts configuration can be used for filesystem 
# types that cannot support persistent label mappings or use
# one of the fixed label schemes specified here.  
#line 1 "genfs_contexts"
# FLASK

#
# Security contexts for files in filesystems that
# cannot support xattr or use one of the fixed labeling schemes 
# specified in fs_use.
#
# Each specifications has the form:
# 	genfscon fstype pathname-prefix [ -type ] context
#
# The entry with the longest matching pathname prefix is used.
# / refers to the root directory of the file system, and
# everything is specified relative to this root directory.
# If there is no entry with a matching pathname prefix, then 
# the unlabeled initial SID is used.
#
# The optional type field specifies the file type as shown in the mode
# field by ls, e.g. use -c to match only character device files, -b
# to match only block device files.
#
# Except for proc, other filesystems are limited to a single entry (/)
# that covers all entries in the filesystem with a default file context.
# For proc, a pathname can be reliably generated from the proc_dir_entry
# tree.  The proc /sys entries are used for both proc inodes and for sysctl(2)
# calls. /proc/PID entries are automatically labeled based on the associated
# process.
#
# Support for other filesystem types requires corresponding code to be
# added to the kernel, either as an xattr handler in the filesystem 
# implementation (preferred, and necessary if you want to access the labels
# from userspace) or as logic in the SELinux module.

# proc (excluding /proc/PID)
genfscon proc /				system_u:object_r:proc_t
genfscon proc /kmsg			system_u:object_r:proc_kmsg_t
genfscon proc /kcore			system_u:object_r:proc_kcore_t
genfscon proc /sysvipc			system_u:object_r:proc_t
genfscon proc /sys			system_u:object_r:sysctl_t
genfscon proc /sys/kernel		system_u:object_r:sysctl_kernel_t
genfscon proc /sys/kernel/modprobe	system_u:object_r:sysctl_modprobe_t
genfscon proc /sys/net			system_u:object_r:sysctl_net_t
genfscon proc /sys/net/unix		system_u:object_r:sysctl_net_unix_t
genfscon proc /sys/vm			system_u:object_r:sysctl_vm_t
genfscon proc /sys/dev			system_u:object_r:sysctl_dev_t

# rootfs
genfscon rootfs /			system_u:object_r:root_t

# sysfs
genfscon sysfs /			system_u:object_r:sysfs_t

# selinuxfs
genfscon selinuxfs /			system_u:object_r:security_t

# autofs
#line 58


# iso9660
genfscon iso9660 /			system_u:object_r:iso9660_t

# vfat, msdos
genfscon vfat /				system_u:object_r:dosfs_t
genfscon msdos /			system_u:object_r:dosfs_t

# nfs
genfscon nfs /				system_u:object_r:nfs_t
#line 1 "net_contexts"
# FLASK

#
# Security contexts for network entities
# If no context is specified, then a default initial SID is used.
#

# Modified by Reino Wallin <reino@oribium.com>
# Multi NIC, and IPSEC features

# Modified by Russell Coker
# ifdefs to encapsulate domains, and many additional port contexts

#
# Port numbers (default = initial SID "port")
# 
# protocol number context
# protocol low-high context
#
#line 33



#line 39

portcon tcp 22 system_u:object_r:ssh_port_t


#line 44





#line 52

#line 57

#line 61


#line 71


#line 77






#line 86



#line 93


#line 98


#line 103




#line 128



#line 135



#line 141



# Network interfaces (default = initial SID "netif" and "netmsg")
#
# interface netif_context default_msg_context
#
netifcon lo system_u:object_r:netif_lo_t system_u:object_r:netmsg_lo_t
netifcon eth0 system_u:object_r:netif_eth0_t system_u:object_r:netmsg_eth0_t
netifcon eth1 system_u:object_r:netif_eth1_t system_u:object_r:netmsg_eth1_t
netifcon eth2 system_u:object_r:netif_eth2_t system_u:object_r:netmsg_eth2_t
netifcon ippp0 system_u:object_r:netif_ippp0_t system_u:object_r:netmsg_ippp0_t
netifcon ipsec0 system_u:object_r:netif_ipsec0_t system_u:object_r:netmsg_ipsec0_t
netifcon ipsec1 system_u:object_r:netif_ipsec1_t system_u:object_r:netmsg_ipsec1_t
netifcon ipsec2 system_u:object_r:netif_ipsec2_t system_u:object_r:netmsg_ipsec2_t

# Nodes (default = initial SID "node")
#
# address mask context
#
# The first matching entry is used.
#
nodecon 127.0.0.1 255.255.255.255 system_u:object_r:node_lo_t

# FLASK
