Summary: SELinux example policy configuration
Name: policy
Version: 1.2
Release: 1
License: GPL
Group: System Environment/Base
Source: http://www.nsa.gov/selinux/archives/policy-1.2.tgz
Prefix: %{_prefix}
BuildRoot: %{_tmppath}/%{name}-buildroot
BuildArch: noarch
BuildRequires: checkpolicy m4

%description
Security-enhanced Linux is a patch of the Linux® kernel and a number
of utilities with enhanced security functionality designed to add
mandatory access controls to Linux.  The Security-enhanced Linux
kernel contains new architectural components originally developed to
improve the security of the Flask operating system. These
architectural components provide general support for the enforcement
of many kinds of mandatory access control policies, including those
based on the concepts of Type Enforcement®, Role-based Access
Control, and Multi-level Security.

This package contains the SELinux example policy configuration along
with the Flask configuration information and the application
configuration files.  

%prep
%setup -q

%build
make policy

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}%{_sysconfdir}/security/
mkdir -p ${RPM_BUILD_ROOT}%{_sysconfdir}/security/selinux
make DESTDIR="${RPM_BUILD_ROOT}" install
make DESTDIR="${RPM_BUILD_ROOT}" install-src

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%{_sysconfdir}/security/selinux/policy.*
%{_sysconfdir}/security/default_contexts
%{_sysconfdir}/security/default_type
%{_sysconfdir}/security/initrc_context

%package sources
Summary: SELinux example policy configuration source files 
Group: System Environment/Base

%description sources
This subpackage includes the source files used to build the policy
configuration.  Includes policy.conf and the Makefiles, macros and
source files for it.

%files sources
%defattr(-,root,root)
%{_sysconfdir}/security/selinux/src/policy.conf
%{_sysconfdir}/security/selinux/src/policy/*

%changelog
* Mon Aug 18 2003 Paul Nasrat <pauln@truemesh.com> 1.2-1
- Enable non-root build

* Mon Jun 2 2003 Dan Walsh <dwalsh@redhat.com> 1.0-1
- Initial version








