/* Copyright(C) 2007 Brazil

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "senna_in.h"
#include "ql.h"
#include "sym.h"

sen_ctx *
sen_ctx_open(sen_db *s, sen_rbuf *outbuf)
{
  sen_ctx *c = SEN_MALLOC(sizeof(sen_ctx));
  if (c) {
    c->phs = NIL;
    c->doing = NULL;
    c->code = NIL;
    c->dump = NIL;
    c->op = 1; // OP_T0LVL
    c->args = NIL;
    c->envir = NIL;
    c->seqno = 0;
    c->lseqno = 0;
    c->nbinds = 0;
    c->nunbinds = 0;
    c->feed_mode = sen_ql_atonce;
    c->stat = SEN_QL_TOPLEVEL;
    c->cur = NULL;
    c->str_end = NULL;
    c->batchmode = 0;
    c->gc_verbose = 0;
    c->db = s;
    c->encoding = s->keys->encoding;
    c->inbuf = NULL;
    c->outbuf = outbuf;
    c->co.mode = 0;
    if (!(c->objects = sen_set_open(sizeof(int), sizeof(sen_obj), 0))) {
      SEN_FREE(c);
      c = NULL;
      goto exit;
    }
    if (!(c->symbols = sen_set_open(0, sizeof(sen_obj), 0))) {
      sen_set_close(c->objects);
      SEN_FREE(c);
      c = NULL;
      goto exit;
    }
    sen_ql_def_db_methods(c);
    sen_ql_init_globals(c);
  }
exit :
  return c;
}

sen_rc
sen_ctx_close(sen_ctx *c)
{
  sen_obj *o;
  sen_set_cursor *sc;
  if ((sc = sen_set_cursor_open(c->objects))) {
    while (sen_set_cursor_next(sc, NULL, (void **) &o)) { sen_obj_clear(o); }
    sen_set_cursor_close(sc);
  }
  sen_set_close(c->objects);
  sen_set_close(c->symbols);
  SEN_FREE(c);
  return sen_success;
}

sen_obj *
sen_obj_new(sen_ctx *c)
{
  sen_obj *o;
  do {
    if (!sen_set_get(c->objects, &c->seqno, (void **) &o)) {
      /* todo : must be handled */
    }
    c->seqno++;
  } while (o->type);
  o->flags = 0;
  o->nrefs = 0;
  return o;
}

sen_obj *
sen_obj_alloc(sen_ctx *c, uint32_t size)
{
  sen_obj *o;
  void *value = SEN_MALLOC(size + 1);
  if (!value) { return NULL; }
  o = sen_obj_new(c);
  o->flags = SEN_OBJ_ALLOCATED;
  o->type = sen_ql_bulk;
  o->u.b.size = size;
  o->u.b.value = value;
  return o;
}

sen_obj *
sen_obj_clear(sen_obj *o)
{
  if (o->flags & SEN_OBJ_ALLOCATED) {
    switch (o->type) {
    case sen_ql_records :
      if (o->u.r.records) { sen_records_close(o->u.r.records); }
      break;
    case sen_ql_bulk :
      if (o->u.b.value) { SEN_FREE(o->u.b.value); }
      break;
    case sen_ql_query :
      if (o->u.q.query) { sen_query_close(o->u.q.query); }
      break;
    default :
      break;
    }
  }
  o->flags = 0;
  return o;
}

