<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Services_Hatena /󥯥饹
 *
 * PHP version 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license/3_0.txt.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     gooooooogle
 * @copyright  2006 gooooooogle
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */

/**
 * Services_Hatena 쥯饹
 *
 * Υ饹ϳƥ֥ӥѥ饹δȤʤ륯饹Ǥ.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     gooooooogle
 * @copyright  2006 gooooooogle
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */
class Services_Hatena_base {
    /**
     * Ƽ¹Դؿη̤Ǽޤ.
     *
     * @see getResult, getResultTotalNum
     */
    protected $result = null;

    /**
     * ϤƤʥѥ饹֥ȤǼޤ.
     *
     * @see hatena_login
     */
    protected $_login = null;

    /**
     * ϤƤʥɬפWSSEǧʸǼޤ.
     *
     * @see getWSSEAuth
     */
    protected $_wsse  = null;

    /**
     * 󥹥ȥ饯
     *
     * @access  public
     */
    public function Services_Hatena_base() {}

    /**
     * ̤֤ޤ
     *
     * @access  public
     * @return  string 
     */
    public function getResult() {
        return $this->result;
    }

    /**
     * ̤֤ޤ
     *
     * @access  public
     * @return  integer ̤Υ
     */
    public function getResultTotalNum() {
        if ( is_array($this->result) ) {
          return count($this->result);
        }
        else {
          return strlen($this->result);
        }
    }

    /**
     * ϤƤʤ˥󤹤뤿δؿ
     *
     * @param   string $user 桼̾
     * @param   string $pass ѥ
     * @access  public
     */
    public function hatena_login($user, $pass) {
        $this->_login = new Services_Hatena_login();
        $this->_wsse  = $this->_login->setWSSEAuth($user, $pass);
    }

    /**
     * WSSEǧѤʸ֤ޤ
     *
     * @access  public
     * @return  string WSSEǧʸ
     */
    public function getWSSEAuth() {
        return $this->_wsse;
    }
}

/**
 * ѥ饹
 *
 * Υ饹ϤϤƤʥӥ˥󤹤뤿Υ饹Ǥ
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     gooooooogle
 * @copyright  2006 shoma, gooooooogle
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */
require_once 'HTTP/Request.php';
class Services_Hatena_login extends HTTP_Request
{
    /**
     * 󥹥ȥ饯
     *
     * @access  public
     */
    function Services_Hatena_login() {}

    /**
     * WSSEǧѤʸޤ
     *
     * @access  public
     * @param   string $user 桼̾
     * @param   string $pass ѥ
     * @return  string WSSEǧʸ
     */
    function setWSSEAuth($user, $pass, $sha1 = false)
    {
         $nowtime = date('Y-m-d\TH:i:s\Z');
         $nonce   = pack('H*', sha1(md5(time())));
         $digest  = base64_encode(pack('H*', sha1($nonce.$nowtime.$pass)));
         $wsse = 'UsernameToken Username="'.$user.'", PasswordDigest="'.$digest.'", Created="'.$nowtime.'", Nonce="'.base64_encode($nonce).'"';

         return $wsse;
     }
}
?>
