<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * 
 *
 * PHP version 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license/3_0.txt.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     gooooooogle
 * @copyright  2006 gooooooogle
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */

/**
 * 饹
 *
 * Υ饹ϤϤƤʸAPIѥ饹Ǥ.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     gooooooogle
 * @copyright  2006 gooooooogle
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */
class Services_Hatena_search extends Services_Hatena_base {
    /**
     * OpenSearch Description Document Ǽޤ.
     *
     * @see Services_Hatena_search
     */
    protected $osxml_url = "http://search.hatena.ne.jp/osxml";

    /**
     * OpenSearch֥ȤǼޤ.
     *
     * @see Services_Hatena_search
     */
    protected $os     = null;

    /**
     * 󥹥ȥ饯
     *
     * OpenSearch֥Ȥޤ.
     *
     * @access  public
     */
    public function Services_Hatena_search() {
        require_once 'Services/OpenSearch.php';
        $this->os    = new Services_OpenSearch($this->osxml_url);
    }

    /**
     * ¹Դؿ
     *
     * ϤƤʸԤؿǤ.
     *
     * @access public
     * @param  string $keyword 
     * @return array 
     */
    public function execute($keyword) {
        $keyword = mb_convert_encoding($keyword, "UTF-8", "ASCII,JIS,UTF-8,EUC-JP,SJIS");
        $this->result = $this->os->search($keyword);
        return $this->getResult();
    }

    /**
     * ̿ؿ
     *
     * ҥåȿ֤ޤ.
     *
     * @access  public
     * @return  intger ҥåȿ
     */
    public function getTotalSearchResult() {
        return $this->os->getTotalResults();
    }

    /**
     * ϥڡåȴؿ
     *
     * 򳫻Ϥڡֹ򥻥åȤޤ.
     *
     * @access  public
     * @param integer $p ڡֹ
     */
    public function setStartPage($p) {
        $this->os->setStartPage($p);
    }

    /**
     * ϥڡؿ
     *
     * 򳫻Ϥڡֹޤ.
     *
     * @access  public
     * @return  intger ڡֹ
     */
    public function getStartPage() {
        return $this->os->getStartPage();
    }

    /**
     * ȥؿ
     *
     * 1ڡΥȥޤ.
     *
     * @access  public
     * @return  intger ȥ
     */
    public function getCount() {
        return $this->os->getCount();
    }

    /**
     * ȥåȴؿ(̤)
     *
     * 1ڡΥȥ򥻥åȤޤ.
     *
     * @access  public
     * @param integer $c ȥ
     */
    public function setCount($c) {
        //! @todo i have a bug.
        // return $this->os->setCount($c);
    }

    /**
     * ڡؿ
     *
     * ڡֹ֤ޤ.
     *
     * @access  public
     * @return ڡֹ
     */
    public function getPrevPage() {
        $s = $this->getStartPage();
        $r = $this->getTotalSearchResult();
        $c = $this->getCount();
  
        if ( $s >= 2 ) {
           return $s - 1;
        }
        else {
          // ⤷ޤ
        }
    }
    /**
     * ڡؿ
     *
     * ڡֹ֤ޤ.
     *
     * @access  public
     * @return ڡֹ
     */
    public function getNextPage() {
        $s = $this->getStartPage();
        $r = $this->getTotalSearchResult();
        $c = $this->getCount();
  
        if ( ($r / $c) >= $s ) {
           return $s + 1;
        }
        else {
          // ⤷ޤ
        }
    }
}
