#include <windows.h>

//COMDATA class definition
#define MALLOC_PERMANENT 0
#define MALLOC_TEMPORARY 1
#define MALLOC_KEEP      2

class COMDATA
{
public:
	//General
	int COM_ID;
	IDispatch* ParentComClass;
	void*  Address;
	int Size;
	int BuffNum;
	char** Buff;
	int* BuffTemp;
	int* BuffLen;
	COMDATA(int com_id,IDispatch* addr);
	~COMDATA();
	void Reset();
	void Copy(COMDATA* dataOrg);
	void* Malloc(unsigned int bSize, int temporary=MALLOC_PERMANENT);
	void MallocDelTemp();
	void MallocFree(void* address);
	//DynaCall
	int eax,edx;
	int* Stack;
	int cArgs;
	BOOL IsUnicode;
	HINSTANCE* hDlls;
	int hDllNum;
	void** Procs;
	int ProcNum;
	int ReservedCallBackFunction;
	//Structure
	int CompoNum;
	LPWSTR* ComponentNames;
	int* Types;
	int* VarNums;
	int* Positions;
	IDispatch** ChildComClass;
	void RedimComponents(int cNum);
	BOOL Temporary;
	COMDATA* ParentData;
	COMDATA* GrandParentData;
	//MachineCode
	int CodePoint;
	void* MachineCodeAddress;
	char* MachineCodeDllPath;
	HINSTANCE MachineCodehDLL;
	//tools
	IDispatch* pDisp;
	int rgDispId;
	int CallBackParamNum;
	//ClassEx
	IDispatch* pDisp2;
	BOOL UseDisp2;
};

static const int COM_NUM=5;

// {1303599D-3028-4eac-97BB-D9370B88B2DA}
static const GUID CLSID_COM0 =
{ 0x1303599d, 0x3028, 0x4eac, { 0x97, 0xbb, 0xd9, 0x37, 0xb, 0x88, 0xb2, 0xda } };
static const LPCSTR PRODKEY0   = "SfcMini.DynaCall";

// {F5B4E399-F606-41fc-B049-D247156F8F3E}
static const GUID CLSID_COM1 = 
{ 0xf5b4e399, 0xf606, 0x41fc, { 0xb0, 0x49, 0xd2, 0x47, 0x15, 0x6f, 0x8f, 0x3e } };
static const LPCSTR PRODKEY1   = "SfcMini.Structure";

// {4D2C1575-A55B-418f-A25C-ECEB45FC5FD2}
static const GUID CLSID_COM2 = 
{ 0x4d2c1575, 0xa55b, 0x418f, { 0xa2, 0x5c, 0xec, 0xeb, 0x45, 0xfc, 0x5f, 0xd2 } };
static const LPCSTR PRODKEY2   = "SfcMini.MachineCode";

// {6F5E1721-E8A4-48bb-B29F-A549EDA82CC7}
static const GUID CLSID_COM3 = 
{ 0x6f5e1721, 0xe8a4, 0x48bb, { 0xb2, 0x9f, 0xa5, 0x49, 0xed, 0xa8, 0x2c, 0xc7 } };
static const LPCSTR PRODKEY3   = "SfcMini.tools";

// {DC430254-87C0-4800-8C45-8B0C2BED1A53}
static const GUID CLSID_COM4 = 
{ 0xdc430254, 0x87c0, 0x4800, { 0x8c, 0x45, 0x8b, 0xc, 0x2b, 0xed, 0x1a, 0x53 } };
static const LPCSTR PRODKEY4   = "SfcMini.ClassEx";


inline const GUID CLSID_COM(int COM_ID) {
	switch (COM_ID) {
	case 1:
		return CLSID_COM1;
	case 2:
		return CLSID_COM2;
	case 3:
		return CLSID_COM3;
	case 4:
		return CLSID_COM4;
	case 0:
	default:
		return CLSID_COM0;
	}
}
inline const LPCSTR PRODKEY(int COM_ID) {
	switch (COM_ID) {
	case 1:
		return PRODKEY1;
	case 2:
		return PRODKEY2;
	case 3:
		return PRODKEY3;
	case 4:
		return PRODKEY4;
	case 0:
	default:
		return PRODKEY0;
	}
}

IDispatch* NewComClass(int COM_ID);
COMDATA* GetDataFromComClass(IDispatch* pDisp);

DWORD COM_GetIDsOfNames(LPOLESTR* rgszNames, UINT cNames, DISPID* rgDispId,COMDATA *data);
DWORD DynaCall_GetIDsOfNames(LPOLESTR* rgszNames, UINT cNames, DISPID* rgDispId,COMDATA *data);
DWORD Structure_GetIDsOfNames(LPOLESTR* rgszNames, UINT cNames, DISPID* rgDispId,COMDATA *data);
DWORD Machine_GetIDsOfNames(LPOLESTR* rgszNames, UINT cNames, DISPID* rgDispId,COMDATA *data);
DWORD Tools_GetIDsOfNames(LPOLESTR* rgszNames, UINT cNames, DISPID* rgDispId,COMDATA *data);
DWORD ClassEx_GetIDsOfNames(LPOLESTR* rgszNames, UINT cNames, DISPID* rgDispId,COMDATA *data);

DWORD COM_Invoke(DISPID dispIdMember, REFIID riid, LCID lcid, WORD wFlags,
            DISPPARAMS* pDispParams, VARIANT* pVarResult,
            EXCEPINFO* pExcepInfo, UINT *puArgErr,COMDATA *data);
DWORD DynaCall_Invoke(DISPID dispIdMember, REFIID riid, LCID lcid, WORD wFlags,
            DISPPARAMS* pDispParams, VARIANT* pVarResult,
            EXCEPINFO* pExcepInfo, UINT *puArgErr,COMDATA *data);
DWORD Structure_Invoke(DISPID dispIdMember, REFIID riid, LCID lcid, WORD wFlags,
            DISPPARAMS* pDispParams, VARIANT* pVarResult,
            EXCEPINFO* pExcepInfo, UINT *puArgErr,COMDATA *data);
DWORD Machine_Invoke(DISPID dispIdMember, REFIID riid, LCID lcid, WORD wFlags,
            DISPPARAMS* pDispParams, VARIANT* pVarResult,
            EXCEPINFO* pExcepInfo, UINT *puArgErr,COMDATA *data);
DWORD Tools_Invoke(DISPID dispIdMember, REFIID riid, LCID lcid, WORD wFlags,
            DISPPARAMS* pDispParams, VARIANT* pVarResult,
            EXCEPINFO* pExcepInfo, UINT *puArgErr,COMDATA *data);
DWORD ClassEx_Invoke(DISPID dispIdMember, REFIID riid, LCID lcid, WORD wFlags,
            DISPPARAMS* pDispParams, VARIANT* pVarResult,
            EXCEPINFO* pExcepInfo, UINT *puArgErr,COMDATA *data);
