#include "common.h"
#pragma comment(linker, "/EXPORT:GetSfcVersion=_GetSfcVersion@0,PRIVATE")

char* ModulePath();

STDAPI GetSfcVersion(void)
{
	return 0x1010;
}

//Method definition
DWORD Tools_GetIDsOfNames(LPOLESTR* rgszNames, UINT cNames, DISPID* rgDispId,COMDATA *data)
{
  int i;
  for (i=0;i<(int)cNames;i++)
  {
	rgDispId[i] = DISPID_UNKNOWN;
    if      (!lstrcmpiW(rgszNames[i],L"Include"))         rgDispId[i]=1;
    else if (!lstrcmpiW(rgszNames[i],L"Initialize"))      rgDispId[i]=2;
    else if (!lstrcmpiW(rgszNames[i],L"Len"))             rgDispId[i]=3;
    else if (!lstrcmpiW(rgszNames[i],L"GetSfcVersion"))   rgDispId[i]=4;
    else if (!lstrcmpiW(rgszNames[i],L"FloatToInt32"))    rgDispId[i]=5;
    else if (!lstrcmpiW(rgszNames[i],L"Int32ToFloat"))    rgDispId[i]=6;
    else if (!lstrcmpiW(rgszNames[i],L"DoubleToInt32H"))  rgDispId[i]=7;
    else if (!lstrcmpiW(rgszNames[i],L"DoubleToInt32L"))  rgDispId[i]=8;
    else if (!lstrcmpiW(rgszNames[i],L"Int32ToDouble"))   rgDispId[i]=9;
	else return DISP_E_MEMBERNOTFOUND;
  }
  return S_OK;
}

//Method Invoke
DWORD Tools_Invoke(DISPID dispIdMember, REFIID riid, LCID lcid, WORD wFlags,
            DISPPARAMS* pDispParams, VARIANT* pVarResult,
            EXCEPINFO* pExcepInfo, UINT *puArgErr,COMDATA *data)
{
	int vInt,i,j,*pInt;
	double vDouble;
	float vFloat,*pFloat;
	COMDATA* dataOrg;
	DWORD fSize;
	HANDLE fHandle;
	LPWSTR Unicode;
	LPSTR ANSI,ANSI2;
	int cArgs = pDispParams->cArgs;
	VARIANTARG* rgvarg = pDispParams->rgvarg;

	if (wFlags & (DISPATCH_METHOD|DISPATCH_PROPERTYGET) ) 
		switch (dispIdMember)
		{
		case 1: //Function Include(fileName as String) as String
		case 2: //Function Initialize() as String
			if (dispIdMember==1) {
				if (cArgs!=1) return DISP_E_BADPARAMCOUNT;
				if (!ResolveUnicode(&rgvarg[0],&Unicode)) return DISP_E_BADPARAMCOUNT;
			} else {
				if (cArgs!=0) return DISP_E_BADPARAMCOUNT;
				Unicode=L"<Initialize.vbs>";
			}
			if (!pVarResult) return S_OK;
			ANSI=CreateAnsiString(Unicode,data,MALLOC_TEMPORARY);
			for (i=0;ANSI[i]!=0;i++);
			if (ANSI[0]=='<' && ANSI[i-1]=='>') {
				ANSI2=ModulePath();//Resolve "lib" directory
				i=0;
				for (j=0;ANSI2[j]!=0;j++) if (ANSI2[j]=='\\') i=j+1;
				for (j=0;j<4;j++) ANSI2[i++]="lib\\"[j];
				for (j=1;ANSI[j]!='>';j++) ANSI2[i++]=ANSI[j];
				ANSI2[i]=0;
				ANSI=ANSI2;
			}
			fHandle=CreateFileA(ANSI,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_FLAG_SEQUENTIAL_SCAN,NULL);
			if (fHandle==INVALID_HANDLE_VALUE) return COMADMIN_E_APP_FILE_READFAIL;
			fSize=GetFileSize(fHandle,NULL);
			ANSI2=new char[fSize+1];
			ANSI2[fSize]=0;
			if (!ReadFile(fHandle,ANSI2,fSize,(DWORD*)&vInt,NULL)) delete ANSI2;
			if (fSize!=(DWORD)vInt) delete ANSI2;
			CloseHandle(fHandle);
			if (ANSI2==0) return COMADMIN_E_APP_FILE_READFAIL;
			pVarResult->vt=VT_BSTR;               //return as Unicode
			pVarResult->bstrVal=CreateUnicode(ANSI2,data,MALLOC_TEMPORARY);
			delete ANSI2;
			return S_OK;
		case 3: //Function Len(obj as Structure) as int32
			if (cArgs!=1) return DISP_E_BADPARAMCOUNT;
			//Resolve COMDATA structure
			if (rgvarg[0].vt & VT_BYREF) {
				if (rgvarg[0].pvarVal->vt!=VT_DISPATCH) return DISP_E_BADPARAMCOUNT;
				dataOrg=GetDataFromComClass(rgvarg[0].pvarVal->pdispVal);
			} else if (rgvarg[0].vt==VT_DISPATCH) {
				dataOrg=GetDataFromComClass(rgvarg[0].pdispVal);
			} else return DISP_E_BADPARAMCOUNT;
			if (dataOrg->COM_ID!=1) return DISP_E_BADPARAMCOUNT; //Must be "SfcMini.Structure"
			if (!pVarResult) return S_OK;
			pVarResult->vt=VT_I4;
			pVarResult->lVal=dataOrg->Size;
			MSG* msg;
			msg=(MSG*)dataOrg->Address;
			return S_OK;
		case 4: //Function GetSfcVersion as int32
			if (cArgs!=0) return DISP_E_BADPARAMCOUNT;
			if (!pVarResult) return S_OK;
			pVarResult->vt=VT_I4;
			pVarResult->lVal=GetSfcVersion();
			return S_OK;
		case 5: //FloatToInt32
			if (cArgs!=1) return DISP_E_BADPARAMCOUNT;
			if (!pVarResult) return S_OK;
			if (!ResolveFloat(&rgvarg[0],&vDouble)) return DISP_E_BADPARAMCOUNT;
			vFloat=(float)vDouble;
			pInt=(int*)&vFloat;
			pVarResult->vt=VT_I4;
			pVarResult->lVal=*pInt;
			return S_OK;
		case 6: //Int32ToFloat
			if (cArgs!=1) return DISP_E_BADPARAMCOUNT;
			if (!pVarResult) return S_OK;
			if (!ResolveInt(&rgvarg[0],&vInt)) return DISP_E_BADPARAMCOUNT;
			pFloat=(float*)&vInt;
			pVarResult->vt=VT_R4;
			pVarResult->fltVal=*pFloat;
			return S_OK;
		case 7: //DoubleToInt32H
			if (cArgs!=1) return DISP_E_BADPARAMCOUNT;
			if (!pVarResult) return S_OK;
			if (!ResolveFloat(&rgvarg[0],&vDouble)) return DISP_E_BADPARAMCOUNT;
			pInt=(int*)&vDouble;
			pInt++;
			pVarResult->vt=VT_I4;
			pVarResult->lVal=*pInt;
			return S_OK;
		case 8: //DoubleToInt32L
			if (cArgs!=1) return DISP_E_BADPARAMCOUNT;
			if (!pVarResult) return S_OK;
			if (!ResolveFloat(&rgvarg[0],&vDouble)) return DISP_E_BADPARAMCOUNT;
			pInt=(int*)&vDouble;
			pVarResult->vt=VT_I4;
			pVarResult->lVal=*pInt;
			return S_OK;
		case 9: //Int32ToDouble
			if (cArgs!=2) return DISP_E_BADPARAMCOUNT;
			if (!pVarResult) return S_OK;
			if (!ResolveInt(&rgvarg[0],&vInt)) return DISP_E_BADPARAMCOUNT;
			pInt=(int*)&vDouble;
			*pInt=vInt;
			if (!ResolveInt(&rgvarg[1],&vInt)) return DISP_E_BADPARAMCOUNT;
			pInt++;
			*pInt=vInt;
			pVarResult->vt=VT_R8;
			pVarResult->dblVal=vDouble;
			return S_OK;
		default:
			return (DWORD)DISPID_UNKNOWN;
	} else if (wFlags & DISPATCH_PROPERTYPUT) {
			return DISP_E_BADPARAMCOUNT;
	} else return DISP_E_BADPARAMCOUNT;

}
