/*************************
  Coppermine Photo Gallery
  ************************
  Copyright (c) 2003-2010 Coppermine Dev Team
  v1.0 originally written by Gregory Demar

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 3
  as published by the Free Software Foundation.
  
  ********************************************
  Coppermine version: 1.5.10
  $HeadURL: https://coppermine.svn.sourceforge.net/svnroot/coppermine/trunk/cpg1.5.x/docs/fr/script.js $
  $Revision: 8107 $
**********************************************/

var linebreak = '\n';

$(function() {
    $("#toc_overall").treeview({
        collapsed: true,
        animated: "medium",
        control:"#sidetreecontrol"
    });
    $(".cpg_zebra tr:even").addClass("tableb");
	$(".cpg_zebra tr:odd").addClass("tableb_alternate");
});

function cpgDocToc() {
  if (getUrlParameters('hide_nav') == 1) {
  	$('#toc').replaceWith('');
	return;
  }
var doc_toc = '';
doc_toc += '<div id="toc_collapsed">\n';
doc_toc += '<h6><a href="toc.htm">Table des matières</a></h6>\n';
doc_toc += 'Passez votre souris ici pour dérouler\n';
doc_toc += '<div align="center"><img src="../../images/icons/downdown.png" border="0" width="10" height="10" alt="" /></div>\n';
doc_toc += '</div>\n';
doc_toc += '<div id="toc_expanded" style="display:none;">\n';
doc_toc += '<h6>Table des matières (<a href="../index.htm">Sélection de la langue de la documentation</a>)</h6>\n';
doc_toc += '<ul id="tree">\n';
doc_toc += '  <li><a href="index.htm">Documentation de Coppermine</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="index.htm#about">A Propos de Coppermine</a></li>\n';
doc_toc += '      <li><a href="index.htm#about_documentation">A propos de cette documentation</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="index.htm#about_documentation_conventions">Conventions de la documentation</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="index.htm?expand_all=1#features">Fonctions</a></li>\n';
doc_toc += '      <li><a href="quickstart.htm#about">Guide de démarrage rapide</a></li>\n';
doc_toc += '      <li><a href="toc.htm">Table des matières</a></li>\n';
doc_toc += '      <li><a href="requirements.htm">Minimum requis</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="requirements.htm#what_minimum">Minimum requis côté serveur</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="requirements.htm#what_minimum_webserver">Serveur Web</a></li>\n';
doc_toc += '              <li><a href="requirements.htm#what_minimum_php">Support PHP</a></li>\n';
doc_toc += '              <li><a href="requirements.htm#what_minimum_mysql">Base de données MySQL</a></li>\n';
doc_toc += '              <li><a href="requirements.htm#what_minimum_image_library">Librairie graphique</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="requirements.htm#what_minimum_self-hosting">Auto-hébergement &amp; paramétrage du serveur web</a></li>\n';
doc_toc += '          <li><a href="requirements.htm#personal">Requis personnels</a></li>\n';
doc_toc += '          <li><a href="requirements.htm#requirements_faq">FAQ du minimum requis</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="testing.htm">Test</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="testing.htm#testing_support">Pas d\'aide pour les versions alpha et beta</a></li>\n';
doc_toc += '          <li><a href="testing.htm#testing_areas">Parties à regarder de manière particulièrement précise</a></li>\n';
doc_toc += '          <li><a href="testing.htm#testing_feature_list">Liste des fonctions</a></li>\n';
doc_toc += '          <li><a href="testing.htm#testing_report">Format des rapports</a></li>\n';
doc_toc += '          <li><a href="testing.htm#testing_availability">Disponibilité</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="languages.htm">Langues</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="languages.htm#how">Comment les langues fonctionnent dans Coppermine</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="languages.htm#how_remove_language">Se débarrasser d\'une langue particulière</a></li>\n';
doc_toc += '              <li><a href="languages.htm#how_language_fallback">Langue de remplacement</a></li>\n';
doc_toc += '              <li><a href="languages.htm#how_scope">Champ d\'application de l\'internationalisation</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="languages.htm#language_manager">Le gestionnaire de langue</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="languages.htm#language_manager_controls">Contrôles</a></li>\n';
doc_toc += '              <li><a href="languages.htm#language_manager_columns">Colonnes</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="languages.htm#language_manager_columns_default">Défaut</a></li>\n';
doc_toc += '                  <li><a href="languages.htm#language_manager_columns_name">Nom de la langue</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="languages.htm#language_manager_columns_name_english">Anglais</a>\n';
doc_toc += '                      <li><a href="languages.htm#language_manager_columns_name_native">Original</a>\n';
doc_toc += '                      <li><a href="languages.htm#language_manager_columns_name_custom">Personnalisé</a>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="languages.htm#language_manager_columns_flag">Drapeau</a></li>\n';
doc_toc += '                  <li><a href="languages.htm#language_manager_columns_file">Fichier langue</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="languages.htm#language_manager_columns_file_available">Disponible</a>\n';
doc_toc += '                      <li><a href="languages.htm#language_manager_columns_file_complete">Complet</a>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="languages.htm#language_manager_columns_file">Activé</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="translation.htm">Guide de traduction</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="translation.htm#translation_translators_wanted">Nous recherchons des traducteurs !</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_why_translate">Pourquoi traduire ?</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_which_languages">Pour quelles langues a t\'on pour besoin d\'une traduction ?</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_who">Qui peut faire une traduction ?</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_char_encoding">Encodage des caractères</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_editors">Éditeurs &amp; Outils</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_full_translation">Traduction complète uniquement</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_step_by_step">Pas à pas</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_special_issues">Problèmes particuliers</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_versions">Version du fichier langue</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_work_in_progress">Travail en constante progression</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_initial_translation">Traduction initiale pour publication</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_older_language_files">Utilisation d\'anciens fichiers langue</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_documentation">Traduction de la documentation</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="translation.htm#translation_documentation_steps">Étapes pour la traduction de la documentation dans votre langue</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_not_exist">Assurez-vous que la traduction n\'existe pas encore</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_structure">Créez la structure</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_copy_core">Copiez le noyau des fichiers langues</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_start_translating">Commencer la traduction</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_attention">Parties où il faut faire attention</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_toc">Faites attention à la table des matières</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_zip">Compressez votre traduction</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="translation.htm#translation_links">Lectures complémentaires</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="credits.htm">Credits</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="credits.htm#developers">L\'équipe de Coppermine</a></li>\n';
doc_toc += '          <li><a href="credits.htm#contributors">Contributeurs</a></li>\n';
doc_toc += '          <li><a href="credits.htm#translators">Traducteurs</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="credits.htm#translators_language_file">Fichiers langue</a></li>\n';
doc_toc += '              <li><a href="credits.htm#translators_documentation">Documentation</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="credits.htm#codebase">Codes libres utilisés</a></li>\n';
doc_toc += '          <li><a href="credits.htm#acknowledgements">Remerciements</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="credits.htm#acknowledgements_thanks">Merci beaucoup</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="copyrights.htm">Licence &amp; droits d\'auteur</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="copyrights.htm#copyright_copyright">droits d\'auteur</a></li>\n';
doc_toc += '          <li><a href="copyrights.htm#copyright_license">Licence</a></li>\n';
doc_toc += '          <li><a href="copyrights.htm#copyrights_previous_versions">Précédentes versions</a></li>\n';
doc_toc += '          <li><a href="copyrights.htm#copyright_additional">Termes additionnels (ajouts à la licence)</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="copyrights.htm#copyright_additional_preservation">Préservation des droits d\'auteur</a></li>\n';
doc_toc += '              <li><a href="copyrights.htm#copyright_additional_marking">Marquage des versions modifiées</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="copyrights.htm#copyright_freedom">Liberté</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="known_issues.htm">Problèmes connus</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="install.htm">Installation et configuration</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="install.htm#how">Comment installer le script</a></li>\n';
doc_toc += '      <li><a href="install.htm#what">Ce que fait l\'installeur</a></li>\n';
doc_toc += '      <li><a href="install.htm#install_related">Informations Complémentaires</a></li>\n';
doc_toc += '      <li><a href="install.htm#install_server_config">Configuration du serveur</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="install.htm#install_server_config_register_globals">register_globals</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="install_permissions.htm">Configurer les permissions</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="install_permissions.htm#permissions_webserver">Permissions sur les types de serveur web différents</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="install_permissions.htm#chmod">Apache sur Unix/Linux (CHMOD)</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_basics">Notions de base</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_groups">Groupes dans Lunix</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_daemon">"Diablotins" des serveurs Web</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_binary_arithmetics">Arithmétique binaire</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_benefit">A quoi bon tout cela ?</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_ftp">Application FTP</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_website_control_panel">Panneau de contrôle de l\'hébergement</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_shell_access">Accès Shell</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_chown">Ownership (CHOWN)</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="install_permissions.htm#apache_windows">Apache sur Windows</a></li>\n';
doc_toc += '              <li><a href="install_permissions.htm#iis">IIS sur Windows</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="install_permissions.htm#support">Demander de l\'aide à propose de problèmes liés aux permissions</a></li>\n';
doc_toc += '          <li><a href="install_permissions.htm#permissions_folders">Permissions, sur le niveau des dossiers</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="install_screen.htm#install_screen_start">L\'écran d\'installation</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="install_screen.htm#install_screen_classic">L\'installateur classique</a></li>\n';
doc_toc += '          <li><a href="install_screen.htm#install_screen_wizard">L\'assistant d\'installation</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="auto-installers.htm">Les auto-installateurs</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="auto-installers.htm#definition">Que sont les auto-installateurs ?</a></li>\n';
doc_toc += '          <li><a href="auto-installers.htm#sad_story">La triste histoire</a></li>\n';
doc_toc += '          <li><a href="auto-installers.htm#">Pourquoi il ne faut pas utiliser d\'auto-installateurs</a></li>\n';
doc_toc += '          <li><a href="auto-installers.htm#no_support">Pas d\'aide</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="install_faq.htm">FAQ d\'installation</a></li>\n';
doc_toc += '      <li><a href="uninstall.htm">Désinstallation</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="upgrading.htm">Mise à jour</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="upgrading.htm#upgrade_why">Pourquoi mettre à jour ?</a>\n';
doc_toc += '          <ul>\n';
doc_toc += '              <li><a href="upgrading.htm#upgrade_why_reasons">Raisons de publication des paquetages</a></li>\n';
doc_toc += '              <li><a href="upgrading.htm#upgrade_why_changelog">Changelog</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upgrading.htm#upgrade_any">Étapes nécessaires lors de la mise à jour de Coppermine</a></li>\n';
doc_toc += '      <li><a href="upgrading.htm#upgrade_particular">Action supplémentaires pour la mise à jour depuis une version particulière</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="upgrading.htm#upgrade_10">Mise à jour depuis une version de cpg1.0, cpg1.1, cpg1.2.x ou cpg1.3.x vers cpg1.5.x</a></li>\n';
doc_toc += '          <li><a href="upgrading.htm#upgrade_14">Mise à jour depuis cpg1.4.x vers cpg1.5.x</a>\n';
doc_toc += '              <ul>\n';
doc_toc += '                  <li><a href="upgrading.htm#upgrade_14_plugins">Plugins</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#upgrade_14_custom_theme">Thème personnalisé</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#upgrade_14_language_files">Fichiers de langue</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#upgrade_14_password_encryption">Cryptage du mot de passe</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#upgrade_14_faq">Affichage de la FAQ</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#upgrade_14_outdated_files">Fichiers obsolètes</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#upgrade_14_safe_mode">Safe mode</a></li>\n';
doc_toc += '              </ul>\n';
doc_toc += '          <li><a href="upgrading.htm#upgrade_15">Mise à jour depuis d’une ancienne version de cpg1.5.x vers la version la plus récente de cpg1.5.x</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upgrading.htm#updater">Mise à jour du script</a>\n';
doc_toc += '          <ul>\n';
doc_toc += '              <li><a href="upgrading.htm#updater_what_it_does">Ce qu\'il fait</a></li>\n';
doc_toc += '              <li><a href="upgrading.htm#updater_purpose">Objectif</a></li>\n';
doc_toc += '              <li><a href="upgrading.htm#updater_authorization">Vérification des autorisation</a></li>\n';
doc_toc += '              <li><a href="upgrading.htm#updater_when">Quand faut-il lancer le script de mise à jour ?</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upgrading.htm#versioncheck">L\'outil de vérification de version</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_description_start">Que fait t’il</a></li>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_first_run">Première utilisation</a></li>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_options_start">Options</a>\n';
doc_toc += '              <ul>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_options_display_output">Afficher la sortie</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_options_only_show_potential_errors">Montrer uniquement les erreurs potentielles</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_options_hide_images">Cacher les images</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_options_no_modification_check">Ne pas vérifier les fichiers modifiés</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_options_no_connect_online_repository">Ne pas se connecter au référentiel en ligne</a></li>\n';
doc_toc += '              </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_comparison_start">Comparaison de version</a>\n';
doc_toc += '              <ul>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_path">Chemin</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_missing">Manquant</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_permissions">Permissions</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_version">Version</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_revision">Révision</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_modified">Modifié</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_comment">Commentaires</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_repository_link">Lien vers le référentiel</a></li>\n';
doc_toc += '              </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_problems">Choses pouvant mal se passer avec le vérificateur de version</a></li>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_expect">Fausses attentes</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upgrading.htm#upgrade_faq">FAQ de mise à jour</a></li>\n';
doc_toc += '      <li><a href="upgrading.htm#downgrading">Retour de cpg1.5.x vers une version plus ancienne</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="start.htm">Démarrage</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="start.htm#getting_concepts">Concepts de Base</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_initial_configuration">Configuration initiale</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_structure">Structure des catégories/albums/fichiers</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_resizing">Images redimensionnées</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="start.htm#getting_resizing_thumbnails">Vignettes</a></li>\n';
doc_toc += '          <li><a href="start.htm#getting_resizing_intermediate">Images intermédiaires</a></li>\n';
doc_toc += '          <li><a href="start.htm#getting_resizing_original">Originales</a></li>\n';
doc_toc += '          <li><a href="start.htm#getting_resizing_recommended">Réglages recommandés pour le redimensionnement</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="start.htm#getting_resizing_recommended_nofullsize">pas d\'images de grande taille dans une fenêtre pop-up</a></li>\n';
doc_toc += '              <li><a href="start.htm#getting_resizing_recommended_nointermediate">Autoriser les images de grande taille en préservant le maximum d\'espace</a></li>\n';
doc_toc += '              <li><a href="start.htm#getting_resizing_recommended_regular">Réglages &quot;standards&quot; avec utilisation modérée de l\'espace</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="start.htm#getting_admin_account">Votre compte administrateur</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_check_uploads">Vérification des téléchargements</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_consider_bridging">Penser à l\'intégration</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_interaction">Qu\'est ce que vos visiteurs sont autorisés à faire ?</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_design">Changez l\'aspect de votre galerie Coppermine</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_typical">Réglages typiques</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="start.htm#getting_typical_monolithic">Téléchargeur unique sans interaction d\'utilisateur (galerie monolithique)</a></li>\n';
doc_toc += '          <li><a href="start.htm#getting_typical_single_uploader_community">Téléchargeur unique avec interaction des utilisateurs</a></li>\n';
doc_toc += '          <li><a href="start.htm#getting_typical_multiple_uploader_closed">Téléchargeurs multiples sans nouvelles inscriptions (groupe fermé)</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="faq.htm">FAQ (Questions fréquemment posées)</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="faq.htm#faq_setup">Réglages / Configuration</a></li>\n';
doc_toc += '      <li><a href="faq.htm#hacks">Ajouts / Modifications / Hacks</a></li>\n';
doc_toc += '      <li><a href="faq.htm#support_board">Forum d\'aide de Coppermine</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="theme.htm">Thèmes</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="theme.htm#theme_builtin">Thèmes livrés avec Coppermine</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_curve">Curve</a></li>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_eyeball">Eyeball</a></li>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_hardwired">Hardwired</a></li>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_rainy_day">Rainy Day</a></li>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_sample">Sample</a></li>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_waterdrop">Waterdrop</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme.htm#theme_upgrading">Mise à jour de votre thème personnalisé</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_upgrade_14x-15x.htm">Convertir un thème de cpg1.4.x pour cpg1.5.x</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_upgrade_14x-15x.htm#theme_convert_style">Modifier style.css</a></li>\n';
doc_toc += '              <li><a href="theme_upgrade_14x-15x.htm#theme_convert_template">Modifier template.html</a></li>\n';
doc_toc += '              <li><a href="theme_upgrade_14x-15x.htm#theme_convert_theme">Modifier theme.php</a></li>\n';
doc_toc += '              <li><a href="theme_upgrade_14x-15x.htm#theme_convert_validation">Méthode de validation</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme.htm#theme_files">Contenu d\'un thème</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_template.htm#theme_template_html">Modifier template.html</a>\n';
doc_toc += '              <ul>\n';
doc_toc += '                  <li><a href="theme_template.htm#theme_template_token">Conteneurs (tokens) du thème</a></li>\n';
doc_toc += '                  <li><a href="theme_template.htm#theme_template_important">Important</a></li>\n';
doc_toc += '                  <li><a href="theme_template.htm#theme_template_token_list">Liste des conteneurs (tokens) dans template.html</a></li>\n';
doc_toc += '              </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="theme_style_css.htm#theme_style_css">Modifier style.css</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_tools">Outils</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="theme_style_css.htm#theme_style_css_tools_webdev">Utilisation de la barre d\'outils Web Developer</a></li>\n';
doc_toc += '                  <li><a href="theme_style_css.htm#theme_style_css_tools_editor">Éditeur</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_list">Liste des classes dans style.css</a></li>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_overall">Feuille de style additionnelle</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="theme_theme_php.htm#theme_create_theme_php">Modifiez theme.php</a>\n';
doc_toc += '              <ul>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_php_types">Types d\'éléments</a></li>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_sample">Le thème sample - un thème pour copier/coller</a></li>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_php_method">Méthode</a></li>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_php_scope">Champ d\'application</a></li>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_php_list">Liste des éléments de theme.php</a></li>\n';
doc_toc += '                  <li><a href="theme_examples.htm#theme_examples">Exemple de thèmes</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="theme_examples.htm#theme_examples_content">Contenu additionnel</a>\n';
doc_toc += '                        <ul>\n';
doc_toc += '                          <li><a href="theme_examples.htm#theme_examples_content_thumbnail">Contenu additionnel dans la page des vignettes</a>\n';
doc_toc += '                            <ul>\n';
doc_toc += '                              <li><a href="theme_examples.htm#theme_examples_content_thumbnail_extra_row">Nouvelle ligne entre les lignes de vignettes</a></li>\n';
doc_toc += '                              <li><a href="theme_examples.htm#theme_examples_content_thumbnail_cell">Nouvelle cellule de table sur chaque page de vignettes</a></li>\n';
doc_toc += '                            </ul>\n';
doc_toc += '                          </li>\n';
doc_toc += '                          <li><a href="theme_examples.htm#theme_examples_content_displayimage">Contenu additionnel sur la page des images intermédiaires</a>\n';
doc_toc += '                            <ul>\n';
doc_toc += '                              <li><a href="theme_examples.htm#theme_examples_content_displayimage_image">Directement après les images intermédiaires</a></li>\n';
doc_toc += '                              <li><a href="theme_examples.htm#theme_examples_content_displayimage_filmstrip">Directement à côté du négatif de film</a></li>\n';
doc_toc += '                            </ul>\n';
doc_toc += '                          </li>\n';
doc_toc += '                          <li><a href="theme_examples.htm#theme_examples_content_fullsize">Contenu aditionnel de la fenêtre pop-up des images originales</a></li>\n';
doc_toc += '                          <li><a href="theme_examples.htm#theme_examples_content_menu">Additional menu items</a>\n';
doc_toc += '                            <ul>\n';
doc_toc += '                              <li><a href="theme_examples.htm#theme_examples_content_menu">Structure de menu entier défini dans un bloc</a></li>\n';
doc_toc += '                            </ul>\n';
doc_toc += '                          </li>\n';
doc_toc += '                        </ul>\n';
doc_toc += '                      </li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_php_summary">Sommaire</a></li>\n';
doc_toc += '              </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme.htm#theme_engine">Comment fonctionne le moteur de thèmes</a></li>\n';
doc_toc += '      <li><a href="theme_user-contributions.htm#theme_user-contributions">Thèmes: contribution des utilisateurs</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_preview">Prévisualisation des contributions de thèmes d\'utilisateurs</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_download">Télécharger des contributions de thèmes d\'utilisateurs</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_install">Installer des thèmes provenant de contributions d\'utilisateurs</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_copyrights">Droits d\'auteur des thèmes provenant de contributions d\'utilisateurs</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_support">Demande d\'aide pour les thèmes provenant de contributions d\'utilisateurs</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_contributing">Contribuer avec votre propre thème</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme_create.htm#theme_create">Création de votre thème personnalisé</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_create.htm#theme_create_rename">Commencez par renommer votre thème</a></li>\n';
doc_toc += '          <li><a href="theme_create.htm#theme_create_tipps">Trucs &amp; astuces</a></li>\n';
doc_toc += '          <li><a href="theme_create.htm#theme_create_wysiwyg">Utilisation d\'éditeurs WYSIWYG</a></li>\n';
doc_toc += '          <li><a href="theme_create.htm#theme_create_colors">Changer les couleurs et le design</a></li>\n';
doc_toc += '          <li><a href="theme_create_matching_page_tutorial.htm#theme_matching">Créer un thème pour Coppermine qui reprend l\'aspect général de votre site</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_intro">Introduction</a></li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_pre-requisites">Pré-requis</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_pre-requisites_tools">Outils</a></li>\n';
doc_toc += '                  <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_pre-requisites_skills">Connaissances</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_examples">Exemple</a></li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_pick_similar">Prenez d\'abord un thème similaire</a></li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_start">Commencez à modifier votre thème</a></li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_placeholder_replace">Remplacer le contenu de l\'exemple avec les appels aux conteneurs (Tokens)</a></li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_style">Adapter le style</a></li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_test1">Test initial</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="theme_template.htm#theme_template_html">Modifier template.html</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_template.htm#theme_template_token">Conteneurs (tokens) du thème</a></li>\n';
doc_toc += '              <li><a href="theme_template.htm#theme_template_important">Important</a></li>\n';
doc_toc += '              <li><a href="theme_template.htm#theme_template_token_list">Liste des conteneurs (tokens) dans template.html</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="theme_theme_php.htm#theme_php">Modifiez theme.php</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_theme_php.htm#theme_php_types">Types d\'éléments</a></li>\n';
doc_toc += '              <li><a href="theme_theme_php.htm#theme_sample">Le thème sample - un thème pour copier/coller</a></li>\n';
doc_toc += '              <li><a href="theme_theme_php.htm#theme_php_method">Méthode</a></li>\n';
doc_toc += '              <li><a href="theme_theme_php.htm#theme_php_scope">Champ d\'application</a></li>\n';
doc_toc += '              <li><a href="theme_theme_php.htm#theme_php_list">Liste des éléments de theme.php</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="theme_style_css.htm#theme_style_css">Modifier style.css</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_tools">Outils</a></li>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_list">Liste des classes dans style.css</a></li>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_overall">Feuille de style additionnelle</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme_examples.htm#theme_examples">Exemples de thèmes</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_examples.htm#theme_examples_summary">Sommaire</a></li>\n';
doc_toc += '          <li><a href="theme_examples.htm#theme_examples_content">Contenu additionnel</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_examples.htm#theme_examples_content_thumbnail">Contenu additionnel dans la page des vignettes<</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="theme_examples.htm#theme_examples_content_thumbnail_extra_row">Nouvelle ligne entre les lignes de vignettes</a></li>\n';
doc_toc += '                  <li><a href="theme_examples.htm#theme_examples_content_thumbnail_cell">Nouvelle cellule de table sur chaque page de vignettes</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="theme_examples.htm#theme_examples_content_displayimage">Contenu additionnel sur la page des images intermédiaires</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="theme_examples.htm#theme_examples_content_displayimage_image">Directement après les images intermédiaires</a></li>\n';
doc_toc += '                  <li><a href="theme_examples.htm#theme_examples_content_displayimage_filmstrip">Directement à côté du négatif de film</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="theme_examples.htm#theme_examples_content_fullsize">Contenu additionnel sur la fenêtre pop-up des images originales</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme_copyright.htm">Affichage des droits d\'auteurs et clause de non responsabilité dans le pied de page</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_copyright.htm#theme_copyright_fair_use">Utilisation acceptable</a>\n';
doc_toc += '          <li><a href="theme_copyright.htm#theme_copyright_unfair_use">Utilisation inacceptable</a>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="php-content.htm">Contenu Dynamique (piloté par PHP)</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="php-content.htm#php-content_anycontent">Utiliser anycontent.php</a></li>\n';
doc_toc += '          <li><a href="php-content.htm#php-content_header_footer">Haut de page et pied de page personnalisés</a></li>\n';
doc_toc += '          <li><a href="php-content.htm#php-content_theme">Contenu dynamique basé sur le thème (theme.php)</a></li>\n';
doc_toc += '          <li><a href="php-content.htm#php-content_core">Modifier les fichiers du noyau</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme_graphics.htm">Ressources graphiques concernant les thèmes</a>\n';
doc_toc += '          <ul>\n';
doc_toc += '              <li><a href="theme_graphics.htm#theme_graphics_menu_icons">Icônes de menu</a></li>\n';
doc_toc += '              <li><a href="theme_graphics.htm#theme_graphics_nav_bar">Images de la barre de navigation</a></li>\n';
doc_toc += '              <li><a href="theme_graphics.htm#theme_graphics_rating">Images de notation</a></li>\n';
doc_toc += '              <li><a href="theme_graphics.htm#theme_graphics_film_strip">Image du négatif de film</a></li>\n';
doc_toc += '              <li><a href="theme_graphics.htm#theme_graphics_progress">Image de progression (chargement)</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="administration.htm">Administration</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="admin_menu.htm">Eléments du menu Administrateur</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="admin_menu.htm#admin_user_mode">Activer/Désactiver les contôles administrateurs</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#upload_approval">Fichiers à valider</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#config">Configuration</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#categories">Catégories</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#albums">Albums</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#sort_my_pictures">Tri des images</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#groups">Groupes</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#users">Utilisateurs</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#ban">Bannir des utilisateurs</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#my_profile">Mon profil</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#review_comments">Voir les commentaires</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#ecard_log">Afficher les e-cartes</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#batch_add">Ajout d\'images par lot (FTP)</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#admin_tools">Outils administrateur (redimensionnements des images)</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#keyword_manager">Gestionnaire de mots-clés</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#plugin_manager">Gestionnaire de plugins</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#bridge_manager">Gestionnaire d\'intégration</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#view_log">Voir les logs</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#stats">Statistiques générales</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#versioncheck">Vérificateur de version</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#update_database">Mise à jour de la base de données</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#export">Export</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#phpinfo">phpinfo</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#show_news">Montrer les news</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#documentation">Documentation</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#admin_mode_regular_users">Mode administrateur pour les utilisateurs normaux</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#user_menu_items">Eléments de menu administrateur pour les utilisateurs normaux</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="banning.htm#banning">Bannissement</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="banning.htm#banning_whats_new">Quoi de neuf ?</a></li>\n';
doc_toc += '          <li><a href="banning.htm#banning_scope">Point de vue</a></li>\n';
doc_toc += '          <li><a href="banning.htm#bannig_how_it_works">Comment fonctionne le bannissement</a></li>\n';
doc_toc += '          <li><a href="banning.htm#banning_by_ip_address_no_good">Pourquoi le bannissement par adresse IP n\'est pas recommandé</a></li>\n';
doc_toc += '          <li><a href="banning.htm#banning_page">Contrôles de la Page</a></li>\n';
doc_toc += '          <li><a href="banning.htm#banning_bridged">Pas de bannissement s\'il y a une passerelle</a></li>\n';
doc_toc += '          <li><a href="banning.htm#banning_todo">A faire</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="configuration.htm">Configuration</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="configuration.htm#admin_general">Paramètres généraux</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_language">Paramètres de langue &amp; de jeu de caractères</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_theme">Paramètres des thèmes</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_album_list">Affichage de la liste des albums</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_thumbnail_view">Affichage des vignettes</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_image_comment">Affichage des images</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_comment_start">Paramètres des commentaires</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_contact_start">Paramètres du formulaire de contacts</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_thumb_start">Paramètres des vignettes</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_picture_thumbnail">Paramètres des fichiers</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_watermarking">Filigrane d\'image</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_registration">Enregistrement</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_user">Paramètres des utilisateurs</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_custom">Champs personnalisés pour le profil utilisateur</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_custom_image">Champs personnalisés pour la description d\'images</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_cookie">Paramètres du cookie</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_email">Paramètres des courriels</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_logging">Logging &amp; statistiques</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_misc">Paramètres de maintenance</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_config_usage">Utilisation de cette page</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_reset_entire_config">Restaure les paramètres par défaut</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="groups.htm">Groupes</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="groups.htm#group_cp">Le panneau d\'administration des groupes</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_names">Noms des groupes</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_types">Type de groupes</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_quota">Quotas</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_permissions">Droits (Note/Cartes électronique/Commentaires)</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_public">Téléchargement dans les albums publics</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_personal">Galerie personnelle</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_upload_method">Méthode de téléchargement</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_assigned">Albums assignés</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_create">Création de groupes personnalisés</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_delete">Suppression de groupes personnalisés</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_sync">Déclenchement de synchronisation (passerelle avec une autre application uniquement)</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_more_than_one_group">Membre dans plus d\'un groupe</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="users.htm">Utilisateurs</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="users.htm#user_cp">Le panneau de contrôle des utilisateurs</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="users.htm#user_cp_page">Gestion d\’utilisateurs</a></li>\n';
doc_toc += '              <li><a href="users.htm#user_cp_search">rechercher un/des utilisateur(s)</a></li>\n';
doc_toc += '              <li><a href="users.htm#user_cp_new">Créer de nouveaux utilisateurs</a></li>\n';
doc_toc += '              <li><a href="users.htm#user_cp_edit">Modifier les utilisateurs</a></li>\n';
doc_toc += '              <li><a href="users.htm#user_cp_group">Appartenance à un groupe</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="users.htm#lost_password">Mot de passe perdu</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="users.htm#lost_password_cpg_user_account">Mot de passe de compte d\'utilisateur de Coppermine</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="users.htm#lost_password_cpg_user_account_standalone">Coppermine en mode autonome</a></li>\n';
doc_toc += '                  <li><a href="users.htm#lost_password_cpg_user_account_bridged">Coppermine avec une passerelle</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="users.htm#lost_password_cpg_user_account">Mot de passe du compte MySQL</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="categories.htm">Catégories</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="categories.htm#cat_cp">Le panneau de gestion des catégories</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="categories.htm#cat_cp_page_controls">Panneau de contrôle</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="categories.htm#cat_cp_page_controls_sort">Partie haute &quot;Tri aplphabétique des catégories&quot;</a></li>\n';
doc_toc += '                  <li><a href="categories.htm#cat_cp_page_controls_categories">Section centrale &quot;Gestion des catégories&quot;</a></li>\n';
doc_toc += '                  <li><a href="categories.htm#cat_cp_page_controls_create">Section basse &quot;Mettre à jour / Créer des catégories&quot;</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="categories.htm#cat_user_galleries">Catégorie spéciale &quot;Galerie des utilisateurs (User galleries)&quot;</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="albums.htm">Albums</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="albums.htm#albmgr">Le gestionnaire d\'albums</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="albums.htm#albmgr_create">Créer des albums</a></li>\n';
doc_toc += '              <li><a href="albums.htm#albmgr_rename">Renommer des albums</a></li>\n';
doc_toc += '              <li><a href="albums.htm#albmgr_order">Changer l\'ordre des albums</a></li>\n';
doc_toc += '              <li><a href="albums.htm#albmgr_delete">Effacer des albums</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="albums.htm#modif_alb_pics">Modifier les albums/fichiers</a></li>\n';
doc_toc += '          <li><a href="albums.htm#album_prop">Propriétés des albums</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="albums.htm#album_prop_reset_start">Restauration des propriétés des albums</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="albums.htm#album_admin_user">Administrateur vs. utilisateur</a></li>\n';
doc_toc += '          <li><a href="albums.htm#album_faq">FAQ des albums</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="files.htm">Fichiers</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="files.htm#edit_pics">Editer les fichiers</a></li>\n';
doc_toc += '          <li><a href="files.htm#edit_vids">Editer les vidéos</a></li>\n';
doc_toc += '          <li><a href="files.htm#cust_thmb">Vignettes personnalisées</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_order">Ordre des vignettes</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_types">Types de vignettes</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_upload">Télécharger des vignettes personnalisées</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_how">Comment ça marche</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_how_naming">Schéma de nommage</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_why">Pourquoi Coppermine ne peut pas créer des vignettes pour les vidéos ?</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_step">Instructions pas à pas</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_faq">FAQ pour les vignettes personnalisées</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="keywords.htm">Mots-clés</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="keywords.htm#keywords_assign">Attribuer les mots-clés</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="keywords.htm#keywords_assign_separator">Séparateur ou délimiteur de mots-clés</a></li>\n';
doc_toc += '              <li><a href="keywords.htm#keywords_assign_edit">Modifier/ajouter des mots-clés</a></li>\n';
doc_toc += '              <li><a href="keywords.htm#keywords_manager">Gestionnaire de mots-clés</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="keywords.htm#keywords_album">Mots-clés d\'albums</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="bbcode.htm">BBCODE</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="bbcode.htm#bbcode_purpose">But</a></li>\n';
doc_toc += '          <li><a href="bbcode.htm#bbcode_available">Balises BBCode disponibles</a></li>\n';
doc_toc += '          <li><a href="bbcode.htm#bbcode_dangers">Dangers</a></li>\n';
doc_toc += '          <li><a href="bbcode.htm#bbcode_control">Plus de contrôles</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="exif.htm">Métadonnées EXIF</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="exif.htm#exif_what">Que sont les métadonnées EXIF</a></li>\n';
doc_toc += '          <li><a href="exif.htm#exif_makers">Différentes versions</a></li>\n';
doc_toc += '          <li><a href="exif.htm#exif_how_it_works">Comment ça marche</a></li>\n';
doc_toc += '          <li><a href="exif.htm#exif_image_libraries">Pas de suppot des Exifs sur le serveur</a></li>\n';
doc_toc += '          <li><a href="exif.htm#exif_limitations">Limites</a></li>\n';
doc_toc += '          <li><a href="exif.htm#exif_manager">Gestionnaire d\'EXIF</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="plugins.htm">Plugins</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_definition">Qu\est ce qu\'un plugin?</a></li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_api">L\'API plugin</a></li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_obtain">Ou truver des plugins?</a></li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_bundled">Plugins fournis avec Coppermine</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_link_target">Cible du lien (link_target)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_onlinestats">Qui est en ligne ? (onlinestats)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_opensearch">OpenSearch (opensearch)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_sample">Sample Plugin (sample)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_usergal_alphatabs">User Gallery Alphabetic Tabbing (Onglets alphabétiques pour les galeries utilisateurs) (usergal_alphatabs)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_visiblehookpoints">Visible HookPoints (visiblehookpoints)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_sef_url">SEF_URLS plugin</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_manager">Le gestionnaire de plugins</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_manager_upload">Télécharger un plugin</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_manager_install">Installer un plugin</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_manager_configuration">Configurer un Plugin</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_manager_uninstall"> Désinstaller un plugin</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_writing">Ecrire des plugins</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="performance.htm#perf_tips">Performance</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="performance.htm#perf_config">Paramètres de configuration</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="performance.htm#perf_config_general">Géneral</a></li>\n';
doc_toc += '              <li><a href="performance.htm#perf_config_spikes">Dopage</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="performance.htm#perf_server">Paramètres serveur</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="performance.htm#perf_config_spikes">Paramètres PHP</a></li>\n';
doc_toc += '              <li><a href="performance.htm#perf_server_mysql">Paramètres MySQL</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="performance.htm#perf_tools">Outils externes</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="performance.htm#perf_yslow">YSlow</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="admin-tools.htm#admin_tools">Utilitaires d\'administration</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="admin-tools.htm#admin_tools_options">Outils disponibles</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_rebuild">Mettre à jour les Vignettes et/ou les photos redimensionnées</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_filename_filetitle">Nom du fichier &rarr; Titre de l\'image</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_delete_titles">Supprimer le titre des photos</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_delete_original">Supprimer les photos dans leur taille d\'origine</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_intermediate">Supprimer les images intermédiaires</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_delete_older_files">Effacer les fichiers plus anciens qu\'un nombre de jours déterminé</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_delete_comments">Supprimer les commentaires orphelins (fonctionne pour tous les albums)</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_delete_original_backup">Effacer la copie de l\'image originale (Mod filigrane)</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_reload_dimensions">Recharger les informations de poids et de taille</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_reset_views">Réinitialisation du compteur de vues</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_keyword_convert">Convertir le séparteur de mots-clés</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="admin-tools.htm#admin_tools_usage">Utilisation</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="errors.htm#errors">Erreurs</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="errors.htm#errors_types">Types d\'erreurs</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="errors.htm#errors_soft">Erreurs légères</a></li>\n';
doc_toc += '              <li><a href="errors.htm#errors_hard">Erreurs graves</a></li>\n';
doc_toc += '              <li><a href="errors.htm#errors_unhandled">Erreurs non traitées</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="errors.htm#errors_fatal">Erreur Fatale</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="errors.htm#errors_debug_mode_config">Activer le mode de débogage dans la configuration</a></li>\n';
doc_toc += '              <li><a href="errors.htm#errors_debug_mode_manual">Activer manuellement le mode de débogage</a></li>\n';
doc_toc += '              <li><a href="errors.htm#errors_debug_mode_off">Désactiver le mode de débogage</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="errors.htm#errors_messages">Messages d\'erreurs communs</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="errors.htm#errors_messages_database">Messages d\'erreur relatifs à la base de données</a></li>\n';
doc_toc += '              <li><a href="errors.htm#commonPHPerrors">Erreurs PHP communes</a></li>\n';
doc_toc += '              <li><a href="errors.htm#errors_messages_upload">Messages d\'erreur relatifs aux téléchargements</a></li>\n';
doc_toc += '              <li><a href="errors.htm#errors_messages_webserver">Codes réponses des serveurs</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="export.htm#backup_move">Sauvegarde &amp; Déplacement</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="export.htm#backup">Sauvegarder votre galerie</a>\n';
doc_toc += '        	<ul>\n';
doc_toc += '          	  <li><a href="export.htm#backup_file">Sauvegarde des fichiers</a>\n';
doc_toc += '          	    <ul>\n';
doc_toc += '              	  <li><a href="export.htm#backup_file_complete">Sauvegarde complète des fichiers</a></li>\n';
doc_toc += '                  <li><a href="export.htm#backup_file_partial">Sauvegarde partielle des fichiers</a></li>\n';
doc_toc += '          	      <li><a href="export.htm#backup_file_incremental">Sauvegarde incrémentielle</a></li>\n';
doc_toc += '      	        </ul>\n';
doc_toc += '     	      </li>\n';
doc_toc += '       	      <li><a href="export.htm#backup_database">Sauvegarde de la base de données</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '        	      <li><a href="export.htm#backup_database_what">Ce qui doit être sauvegardé</a></li>\n';
doc_toc += '      	          <li><a href="export.htm#backup_database_tools">Outils de sauvegarde de la base de données</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="export.htm#backup_database_tools_phpmyadmin">phpMyAdmin</a></li>\n';
doc_toc += '                      <li><a href="export.htm#backup_database_tools_mysqldumper">mySqlDumper</a></li>\n';
doc_toc += '                      <li><a href="export.htm#backup_database_tools_shell_mysqldump">mysqldump</a></li>\n';
doc_toc += '                      <li><a href="export.htm#backup_database_tools_shell_mysqlhotcopy">mysqlhotcopy</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="export.htm#backup_database_after">Sauvegarde de la base de données: qu’est-ce qui doit être sauvegardé ?</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="export.htm#moving">Déplacement de votre galerie</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="export.htm#moving_folder">Déplacement au sein de votre serveur</a></li>\n';
doc_toc += '              <li><a href="export.htm#moving_server">Déplacement d\'un serveur à un autre</a></li>\n';
doc_toc += '              <li><a href="export.htm#moving_disadvantages">Inconvénients du renommage</a></li>\n';
doc_toc += '              <li><a href="export.htm#moving_config_url">Changer l\'URL de Coppermine dans la configuration</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="watermarking.htm#watermark">Filigrane d\'images</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="watermarking.htm#watermark_alternatives">Alternatives</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="watermarking.htm#watermark_alternatives_no_right_click">Interdire le clic droit</a></li>\n';
doc_toc += '              <li><a href="watermarking.htm#watermark_alternatives_registered_only">N\'afficher votre précieux contenu qu\'aux visiteurs légitimes</a></li>\n';
doc_toc += '              <li><a href="watermarking.htm#watermark_alternatives_overlay">Afficher un recouvrement</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="watermarking.htm#watermark_client_sided">Filigrane côté client</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="uploading.htm">Téléchargement</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="uploading_batch-add.htm#batch_add_pics">Téléchargement des images par FTP / Ajout les images par lot</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="uploading_batch-add.htm#batch_add_pics_what">Ce que fait le téléchargement par lot</a></li>\n';
doc_toc += '          <li><a href="uploading_batch-add.htm#batch_add_pics_how">Comment fonctionne le téléchargement par lot</a></li>\n';
doc_toc += '          <li><a href="uploading_batch-add.htm#batch_add_common_mistakes">Érreurs communes</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_common_mistakes_doesnt_work">L\'ajout par lot ne fonctionne pas comme prévu</a></li>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_common_mistakes_broken_files">Les fichiers semblent corrompus</a></li>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_common_mistakes_rename">Ne les renommez pas</a></li>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_common_mistakes_delete">Ne les effacez pas</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="uploading_batch-add.htm#batch_add_sort">Tri</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_sort_capitalization">Importance des majuscules</a></li>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_sort_numbers">Les ordinateurs voient les nombres différemment</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="uploading_http.htm#upload_http">Téléchargement par HTTP</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="uploading_http.htm#upload_http_interface">Interface de téléchargement</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="uploading_http.htm#upload_http_interface_flash">Interface de téléchargement de fichiers multiples géré par Flash</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="uploading_http.htm#upload_http_interface_flash_usage">Utilisation</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="uploading_http.htm#upload_http_interface_html">Interface de téléchargement de fichier unique par HTML</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="uploading_http.htm#upload_http_interface_html_usage">Utilisation</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="uploading_xp-publisher.htm#xp">Assistant Windows XP Web Publisher</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_requirements">Requis</a></li>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_setup">Installation</a></li>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_upload">Téléchargement d\'images</a></li>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_upload">Structure des fichiers</a></li>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_remove">Suppression / Désinstallation</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upload_troubleshooting.htm#upload_trouble">Dépannage du téléchargement</a>\n';
doc_toc += '         <ul>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_trouble_permission">Droits</a></li>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_trouble_enable_settings">Activer les paramètres de dépannage</a></li>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_support">Demander de l\'aide pour des problèmes de téléchargement</a>\n';
doc_toc += '             <ul>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_support_step-by-step">Guide pas à pas de demande d\'aide</a>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_support_example">Exemple de support d\'aide</a>\n';
doc_toc += '             </ul>\n';
doc_toc += '           </li>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_error_messages">Messages d\'erreur</a>\n';
doc_toc += '             <ul>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_error_messages_cant_move">Failed to create stream: Operation not permitted</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_error_messages_impossible_to_move">Impossible to move x to y</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_error_messages_failed_to_open_dir">failed to open dir: No such file or directory</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_error_messages_no_album">Sorry there is no album where you are allowed to upload files</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_error_messages_allowed_memory_size">Allowed memory size of X bytes exhausted</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_error_messages_exec_disabled">Exec() has been disabled</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_error_messages_not_gd_extension">Not a GD extension</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_error_messages_imagemagick127">Error executing ImageMagick - Return value 127</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_error_messages_no_gd_support">PHP running on your server does not support the GD image library</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_error_messages_no_file_uploaded">No file was uploaded ! If you have really selected a file to upload, check that the server allows file uploads</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_error_messages_destination_not_writable">Destination directory x is not writable by the script</a></li>\n';
doc_toc += '             </ul>\n';
doc_toc += '           </li>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_trouble_server-sided_restrictions">Restrictions côté serveur</a>\n';
doc_toc += '             <ul>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_trouble_server-sided_restrictions_php_ini">Le fichier de configuration de PHP php.ini</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_trouble_server-sided_restrictions_check">Les choses à vérifier</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_trouble_methods">Mécanismes/méthodes de téléchargement</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_trouble_memory_usage">Utilisation de la mémoire pendant le redimensionnement</a></li>\n';
doc_toc += '             </ul>\n';
doc_toc += '           </li>\n';
doc_toc += '         </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="comments.htm">Commentaires</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="comments.htm#comments_allow">Permettre les commentaires</a></li>\n';
doc_toc += '      <li><a href="comments.htm#comments_options">Commentaires options</a></li>\n';
doc_toc += '      <li><a href="comments.htm#comments_options_spam">Questions spam</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="comments.htm#comments_options_spam_captcha">Captcha</a></li>\n';
doc_toc += '          <li><a href="comments.htm#comments_options_spam_approval">Approbation</a></li>\n';
doc_toc += '          <li><a href="comments.htm#comments_options_spam_akismet">Akismet</a></li>\n';
doc_toc += '          <li><a href="comments.htm#comments_options_spam_resume">Résumé</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="comments.htm#comments_review">Vérifier les commentaires</a></li>\n';
doc_toc += '      <li><a href="comments.htm#comments_individual">Commentaires individuels</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="bridging.htm">Intégration/Passerelle</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_bridge_purpose">Ce que fait l\'intégration</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_bridge_start">Fichiers d\'intégration disponibles</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_prerequisites_start">Pré-requis</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_cookie_start">Authentification par cookie</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_standalone_start">Version autonome d\'abord</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_users_start">Les utilisateurs, groupes et fichiers téléchargés par les utilisateurs sont perdus lors de l\'intégration</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_backup_start">Sauvegarde</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_steps_start">Etapes de l\'intégration</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_start">Utiliser le gestionnaire d\'intégration</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_app_start">Choisir l\'application à intégrer</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_path_start">Chemin(s) utilisés par votre application intégrée</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="bridging.htm#bridge_manager_path_full_forum_url">URL de l\'application intégrée</a></li>\n';
doc_toc += '              <li><a href="bridging.htm#bridge_manager_path_relative_path_of_forum_from_webroot">Chemin absolu de l\'application intégrée</a></li>\n';
doc_toc += '              <li><a href="bridging.htm#bridge_manager_path_relative_path_to_config_file">Chemin relatif vers le fichier de configuration de votre application intégrée</a></li>\n';
doc_toc += '              <li><a href="bridging.htm#bridge_manager_path_cookie_prefix">Préfixe du cookie</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_specific_start">Paramètres spécifiques de l\'application intégrée</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="bridging.htm#bridge_manager_specific_groups">Utiliser les groupes personnalisés de l\'application intégrée ?</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_enable_start">Activer/Désactiver l\'intégration</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="bridging.htm#bridge_manager_recover_start">Restauration après l\'échec de l\'intégration</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_steps_sync_start">Synchronisation des groupes de l\'application intégrée avec ceux de Coppermine</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_support_start">Aide sur l\'intégration</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_config_options_start">Certaines options de configuration sont désactivées</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_files_start">Fichiers d\'intégration</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_bridge_file_creating_start">Créer un fichier d\'intégration personnalisé</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_philosophy_start">Philosophie de l\'intégration</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_individual_bridge_issues_start">Problèmes d\'intégrations particulières</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_individual_bridge_issues_phpbb3">phpBB3</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_individual_bridge_issues_punbb115">PunBB1.1.5</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_individual_bridge_issues_punbb12">PunBB1.2</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_individual_bridge_issues_xmb">XMB</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_subdomain">Problèmes de sous-domaines</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_subdomain_file_system">Système de fichiers</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_subdomain_cookie">Cookies</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_subdomain_www">Sous-domaine www</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="dev.htm">Documentation des développeurs</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="dev_files.htm">Ajout/renommage/effacement de fichiers</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_target_audience">Cible visée</a></li>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_scope">But</a></li>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_naming">Conventions de nommage</a></li>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_adding">Ajouts de fichiers</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_files.htm#dev_files_adding_language">Fichiers langues</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_renaming">Rennomage de fichiers</a></li>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_deleting">Effacement de fichiers</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_coding.htm">Guide et règles de codage</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_target_audience">Public ciblé</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_scope">But</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_indentation">Indentation</a></li>\n';
doc_toc += '          <li><a href="dev_coding_encoding">Encodage</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_general">Règles générales</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_php">Code PHP</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_formatting">Formatage</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_control_structures">Structures de contrôle</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_function_calls">Appel des fonctions</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_function_definitions">Définition des fonctions</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_php_tags">Balise de code PHP</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_nesting">HTML imbriqué dans PHP</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_linebreaks">Fin de ligne</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_naming_conventions">Conventions de nommage</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_database">Requêtes de base de données</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_documentation">Documentation</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_html_output">Sortie HTML</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_output_images">Balise image dans les sorties HTML</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_output_dev_coding_html_output_links">Liens dans les sorties HTML</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_output_form">Eléments de formulaires dans les sorties HTML</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_output_deprecated">Balises dépréciées</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_prefered_tags">Balises populaires</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_credits">Credits pour les règles de codage</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_usability">Facilités d\'utilisation</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_usability_forms">Formulaires</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_config.htm">Option de configuration</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_config.htm#dev_config_add_target_audience">Cible de cette page</a></li>\n';
doc_toc += '          <li><a href="dev_config.htm#dev_config_history">Historique</a></li>\n';
doc_toc += '          <li><a href="dev_config.htm#dev_config_new_features">Nouvelles fonctions</a></li>\n';
doc_toc += '          <li><a href="dev_config.htm#dev_config_step_by_step">Pas à pas</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_config.htm#dev_config_step_basiq_sql">Basic.sql</a></li>\n';
doc_toc += '              <li><a href="dev_config.htm#dev_config_step_update_sql">Update.sql</a></li>\n';
doc_toc += '              <li><a href="dev_config.htm#dev_config_step_array">Admin.inc.php</a></li>\n';
doc_toc += '              <li><a href="dev_config.htm#dev_config_step_language_file">Fichier langue</a></li>\n';
doc_toc += '              <li><a href="dev_config.htm#dev_config_step_documentation">Documentation</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_config.htm#dev_config_todo">A faire</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_database.htm">Database schema</a>\n';
doc_toc += '          <ul>\n';
doc_toc += '              <li><a href="dev_database.htm#db_config_file">Configuration file</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_reference within_code">Database reference within coppermine code</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_albums">cpg15x_albums</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_banned">cpg15x_banned</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_bridge">cpg15x_bridge</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_categories">cpg15x_categories</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_categorymap">cpg15x_categorymap</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_comments">cpg15x_comments</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_config">cpg15x_config</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_dict">cpg15x_dict</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_ecards">cpg15x_ecards</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_exif">cpg15x_exif</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_favpics">cpg15x_favpics</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_filetypes">cpg15x_filetypes</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_hit_stats">cpg15x_hit_stats</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_languages">cpg15x_languages</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_pictures">cpg15x_pictures</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_plugins">cpg15x_plugins</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_sessions">cpg15x_sessions</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_temp_messages">cpg15x_temp_messages</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_usergroups">cpg15x_usergroups</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_users">cpg15x_users</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_votes">cpg15x_votes</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_vote_stats">cpg15x_vote_stats</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_documentation.htm">Editing the documentation</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_target_audience">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_edit_existing">Edit existing documents</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_add">Add new documents</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_move">Moving content from one document to the other</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_hidden_feature">Hidden features</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_database_structure">Database structure</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_header_block">Header &amp; footer blocks</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_i18n">Documentation internationalization</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_detail">Expandable/collapsible "detail"-blocks</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_help">Help</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_help_start_end">Start and end anchors needed</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_heading_anchors">Adding anchors to headings</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_code">Code</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_css_code">CSS class &quot;code&quot;</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_html_pre">HTML-tag &quot;pre&quot;</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_css_cpg_code">CSS class &quot;cpg_code&quot;</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_css_smallcode">CSS class &quot;smallcode&quot;</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_html_textarea">HTML-tag &quot;textarea&quot;</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_combining">Combining HTML tags and CSS classes</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_syntaxhighlighting">No syntax highlighting</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_javascript.htm">Javascript in Coppermine</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_target_audience">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_files_location">Javascript files location and organization</a></li>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_files_location_todo">TODO</a></li>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_include_files">How to include javascript files</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_javascript.htm#dev_javascript_include_files_plugin">How to include JavaScript files in plugins</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_php_vars">How to pass PHP variables to included javascript</a></li>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_autostart">Autostart JavaScript</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_package.htm#packaging">Packaging a new release</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_package.htm#packaging_target_audience">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_package.htm#packaging_subversion">Subversion repository</a></li>\n';
doc_toc += '          <li><a href="dev_package.htm#packaging_steps">Steps</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_checkout">Check out</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_loop_through_files"></a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#">Replace version number in all files</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_loop_through_files_linux">Linux</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_loop_through_files_windows">Windows</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_bom">Remove Byte Order Marks</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#">Prepare an announcement thread</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_write_announcement_thread"></a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_docs_upgrade">Edit the upgrade section of the docs</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_changelog">Edit the changelog</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_version_number">Edit the version number</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_svn_commit">Commit your changes</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_versioncheck">Update the versioncheck data</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_versioncheck_complete">Completeness</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_versioncheck_update">Update revision numbers and hashes</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_xml_webspace">Update cpg15x.files.xml on the Coppermine home page</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_svn_export">Export from subversion</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_rapidsvn">RapidSVN</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_tortoisesvn">Tortoise SVN</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_create_tag">Create a tag in subversion</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_create_tag_rapidsvn">RapidSVN</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_create_tag_tortoisesvn">Tortoise SVN</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_create_zip">Create the archive</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_upload_zip">Upload the archive</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_move_announcement">Publish announcement thread</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_news">Create news items</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_news_sf">News item on sf.net</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_news_forum">News item on forum</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_news_homepage">News item on home page</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_news_embedded">News embedded into existing galleries</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_demo">Update the demo</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_plugins.htm">Plugin Writing for Coppermine</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing">Quick Start Guide</a></li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_target_audience">Intended Audience</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_target_audience_yes">People who should read this documentation</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_target_audience_no">People who do not need to read this documentation</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_why_write">Why write plugins?</a></li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_preparation">Preparations</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_name">Choose a name</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_translation">Consider translations</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_config">Consider a config screen</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_db">Database changes</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_support">Support issues</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_versions">Plugin versions</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_core_files">Core files</a></li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_naming_conventions">Naming conventions</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_naming_conventions_folders">Folders</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_naming_conventions_files">Files</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_naming_conventions_archives">Archives</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_naming_conventions_coding">Coding</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_globals">Use of Superglobals</a></li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_database">Database access</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_database_direct_queries">Direct queries</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_database_tables_access">Accessing database tables</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_database_tables_create">Creating database tables</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_database_tables_delete">Deleting database tables</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_database_config">Storing your plugin\'s config values</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_types">Plugin Types</a></li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_includes">Using includes</a></li>\n';
doc_toc += '          <li><a href="dev_plugin_api.htm">Plugin Writing: Tutorial, API</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_overview_who">Intended Audience</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_overview_skills">Required Skills &amp; Knowledge</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_overview_tools">Recommended Software &amp; Support Forums</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_tutorial">"Hello, world" Plugin Tutorial</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_first">My First Plugin</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_installconfig">Installation, Configuration, and Clean-Up</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_installsimple">Installation with Simple Configuration</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_install">Installation with Configuration Parameters</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_config">Adding a config section to your plugin</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_cleanup">Uninstallation &amp; Clean-Up</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>  \n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_linking">Linking to Custom Plugin Scripts</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_button">Adding a Button to Coppermine</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_button_admin_menu">Adding a Button to the admin menu</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_button_overall_menu">Adding a Button to the overall menu</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_js">Adding JavaScript to plugins</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_lang">Multi-language Support</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_distrib">Distributing Your Plugin</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_hooks">Plugin Hooks</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_plugin_class">Plugin Class Properties &amp; Methods</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_globals">Global Variables &amp; Constants</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugin_steps.htm">Creating plugins: step by step</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugin_steps.htm#steps_template_plugin">Getting started with the plugin template</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_extract_template">1. Extract the plugin template</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_pick_name">2. Choose a name</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_rename_folder">3. Rename the folder</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_rename_file_content">4. Rename the placeholders inside the files</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_copy_to_target">5. Copy the new plugin folder to the target</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_plugin_steps.htm#steps_config">Creating a config record for your plugin</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_option_type">1. Decide for an option type</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_name">2. Choose a record name</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_install">3. Create the record during plugin install</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_uninstall">4. Create the uninstall query</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_defaults">5. Specify the scope of your config record</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_form_options">6. Populate form options</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_rows">7. Output the form elements (rows)</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_steps.htm#steps_config_rows_checkbox">a. Checkbox</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_steps.htm#steps_config_rows_radio">b. Radio button</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_steps.htm#steps_config_rows_dropdown">c. Dropdown (select/option list)</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_steps.htm#steps_config_rows_textinput">d. Text input field (one line), both for numerical input (integers) as well as any other textual input</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_steps.htm#steps_config_rows_textarea">e. Text input field (multiple lines, aka textarea)</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_language">8. Create the needed translation strings</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugin_hooks.htm">Reference list of plugin hooks</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_target_audience">Target audience</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_choosing">Choosing Plugin Hooks</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_finding">Finding Plugin Hooks</a></li>\n';
//doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_using">Using Plugin Hooks</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_filename">Plugin Hooks by File Name</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_ind_php">Script: index.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_ind_anyc">Filter: \'anycontent\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_ind_ucp">Filter: \'user_caption_params\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_ind_pb">Filter: \'plugin_block\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_di_php">Script: displayimage.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_di_fi">Filter: \'file_info\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_di_pbc">Filter: \'post_breadcrumb\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_thumb_php">Script: thumbnails.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_thumb_pbc">Filter: \'post_breadcrumb\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_php">Script: functions.inc.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_ghgf">Filters: \'gallery_header\' and \'gallery_footer\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_td">Filter: \'thumb_data\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_th">Filter: \'template_html\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_pm">Filter: \'page_meta\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_tc">Filters: \'thumb_caption\' and all derivatives</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_th_php">Script: themes.inc.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_th_fd">Filter: \'file_data\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_um_php">Script: usermgr.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_um_umh">Filter: \'usermgr_header\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_um_umf">Filter: \'usermgr_footer\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_pm_php">Script: pluginmgr.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_pm_pcon">Filter: \'plugin_configure\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_pm_pcl">Filter: \'plugin_cleanup\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_php">Script: plugin_api.inc.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_ph">Filter: \'page_html\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_pe">Filter: \'page_end\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_pi">Filter: \'plugin_install\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_pu">Filter: \'plugin_uninstall\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_pw">Filter: \'plugin_wakeup\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_ps">Filter: \'plugin_sleep\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_init_php">Script: init.inc.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_init_ps">Filter: \'page_start\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_picm_php">Script: picmgmt.inc.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_picm_afd">Filter: \'add_file_data\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_alphabetically">Plugin Hooks Alphabetically</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_hooktype">Plugin Hooks by Hook Type</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hook_examples">Plugin Hook Examples</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                    <li><a href="dev_plugin_hooks.htm#plugin_hook_example_upload_method">Adding an upload method</a></li>\n';
doc_toc += '                    <li><a href="dev_plugin_hooks.htm#plugin_hook_example_theme_display_thumbnails">Add tags for thumbnails display</a></li>\n';
doc_toc += '                </ul></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_superglobals.htm">Sanitization of Superglobals using Inspekt</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_target_audience">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_whats_new">What\'s new?</a></li>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_reason">Reason</a></li>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_about_inspekt">What Inspekt does</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_inspekt_accessor_methods">Inspekt accessor methods</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_howto">How to use Inspekt with Coppermine Photo Gallery</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_howto_using">Using Inspekt</a></li>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_howto_inspekt_in_coppermine">Inspekt in Coppermine</a></li>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_howto_consider_methods">Consider the methods to use</a></li>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_howto_examples">Examples</a></li>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_howto_regex">Regular Expressions</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_links">Links</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_subversion.htm">Subversion</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_target_audience">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_caveat">Caveats</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_definition">What is subversion?</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_hosting">Where is the subversion repository hosted?</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_software">Recommended software</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_websvn">Alternative access using Web SVN</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_repository_structure">Repository structure</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_repository_structure_trunk">Coppermine core files</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_repository_structure_plugins">Plugins</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_checking_out">Checking out</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_checking_out_entire">Checking out the entire repository</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_checking_out_particular_package">Checking out a particular Package</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_checking_out_particular_file">Checking out a particular file</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_checking_out_refering">Refering to files downloaded from the subversion repository</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_download">Is there no single package that I could download instead?</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_download_tarball">Download Tarball archives</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_dev-only">Developers-only</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_checkout_checkin">Check out before checking in</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_commit">Committing your code</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_changelog">Changelog</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_write_access">Obtaining write access</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_step-by-step">Step by step</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_client-download">Download the client application</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_initial_checkout">Initial checkout</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_revision">Revisions</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_fileheaders">Subversion file headers</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_tools.htm">Tools recommended by the devs</a>\n';
doc_toc += '          <ul>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_database">Database manipulation</a></li>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_ftp_client">FTP clients</a></li>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_web_development">Web development</a></li>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_editor">Text editors</a></li>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_picture_editors">Picture Editors</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_update.htm">Mise à jour</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_update.htm#dev_update_target_audience">Public visé</a></li>\n';
doc_toc += '          <li><a href="dev_update.htm#dev_update_hidden_feature">Fonctionnalité cachée</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_vars.htm#vars_constants">Variables &amp; constantes</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_vars.htm#vars_constants_system">Système des variables globales</a></li>\n';
doc_toc += '          <li><a href="dev_vars.htm#vars_constants_constants">Constantes de Coppermine</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_versioncheck.htm">Vérificateur de version</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_versioncheck.htm#dev_versioncheck_hidden_features">Fonctionnalité cachée</a></li>\n';
doc_toc += '          <li><a href="dev_versioncheck.htm#dev_versioncheck_xml">XML structure</a></li>\n';
doc_toc += '          <li><a href="dev_versioncheck.htm#dev_versioncheck_todo">Liste des choses à faire</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '</ul>\n';
doc_toc += '</div>\n';
$('#toc').replaceWith('<div id="toc">' + doc_toc + '</div>');
}



function cpgDocHeader() {
	// Only display the header if the docs are not included
	if (getUrlParameters('hide_nav') == 1) {
		return;
	}
	$('#docheader').text('Coppermine Photo Gallery v1.5.10: Documentation et manuel');
	$('#docheader').after('<br clear="all" />\n<a name="top"></a>');
	$('#docheader').before('<img src="../images/coppermine-logo.png" alt="Coppermine Photo Gallery - Your Online Photo Gallery" align="left" />\n');
}

function cpgDocSearch() {
	// Only display the header if the docs are not included
	if (getUrlParameters('hide_nav') == 1) {
		return;
	}
	var doc_search = '';
	doc_search += '  <div id="doc_search" style="display:none;">\n';
	doc_search += '    <form action="http://www.google.com/cse" id="cse-search-box">\n';
	doc_search += '      <input type="hidden" name="cx" value="009353514429642786404:keefjtiy3lo" />\n';
	doc_search += '      <input type="text" name="q" size="25" />\n';
	doc_search += '      <input type="submit" name="sa" value="search docs" style="font-size:9px;" />\n';
	doc_search += '    </form>\n';
	doc_search += '    <script type="text/javascript" src="http://www.google.com/coop/cse/brand?form=cse-search-box&lang=en"></script>\n';
	doc_search += '  </div>\n';
	$('#toc').append(doc_search);
}

function cpgDocFooter() {
  var overall_doc_footer = '';
  overall_doc_footer += '</div>';
  overall_doc_footer += '<div class="backtotop">';
  overall_doc_footer += '<a href="#top">Back to Top</a>';
  overall_doc_footer += '</div>';
  $('#doc_footer').append(overall_doc_footer);
}



function dateRevision() {
  // strip the unneeded data from last_changed and revision fields
  var lastChangeDate = $('#doc_last_changed').text();
  var lastChangeDate = lastChangeDate.replace('$', '');
  var lastChangeDate = lastChangeDate.replace('$', '');
  var lastChangeDate = lastChangeDate.replace('LastChangedDate: ', '');
  var lastChangeDate = lastChangeDate.replace(/Date: /g, '');
  $('#doc_last_changed').text('About this document: ' + 'last changed on ' + lastChangeDate);

  var revisionNumber = $('#doc_revision').text();
  var revisionNumber = revisionNumber.replace('$', '');
  var revisionNumber = revisionNumber.replace('$', '');
  var revisionNumber = revisionNumber.replace(/Revision: /g, '');
  $('#doc_revision').text(', SVN revision ' + revisionNumber);
}

function getUrlParameters(name)
{
  // Taken from http://www.netlobo.com/url_query_string_javascript.html
  name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  var regexS = "[\\?&]"+name+"=([^&#]*)";
  var regex = new RegExp(regexS);
  var results = regex.exec(window.location.href);
  if(results == null) {
    return '';
  } else {
    return results[1];
  }
}

function cpgDocTranslationWarning() {
  $('#doc_en_only').replaceWith('<div class="cpg_message_validation"><h1>Pas encore de Traduction</h1><p>Cette page n\'a pas été traduite pour l\'instant et apparait donc en Anglais.</p><p>Recherche de Traducteurs: jetez un oeil à cette page - ça ne semble pas trop compliqué, non ? Si vous êtes persuhadés que vous pouvez traduite cette page, merci de visiter le site officiel de Coppermine; nous sommes en attente de votre contribution.</div>');
  $('#doc_en_partial').replaceWith('<div class="cpg_message_warning"><h1>Traduction partielle</h1><p>Cette page n\'est pas encore traduite complètement et s\'affiche partiellement dans votre langue et partiellement en Anglais.</p><p>Recherche de Traducteurs: jetez un oeil à cette page - ça ne semble pas trop compliqué, non ? Si vous êtes persuhadés que vous pouvez traduite cette page, merci de visiter le site officiel de Coppermine; nous sommes en attente de votre contribution.</div>');
}

$(document).ready(function()
{
	var $_GET = {};
	document.location.search.replace(/\??(?:([^=]+)=([^&]*)&?)/g, function () {
		function decode(s) {
			return decodeURIComponent(s).replace(/\+/g, " ");
		}
		$_GET[decode(arguments[1])] = decode(arguments[2]);
	});
	//hide all elements with class detail_body
	$(".detail_body").hide();
	if ($_GET["expand_all"] == 1) { // Show all details and get rid of the details toggle if the GET parameter expand_all is set
		$('.detail_body').show();
		//$('.detail_head_collapsed').replaceWith('');
	}
	//toggle the component with class detail_body
	$(".detail_head_collapsed").click(function()
	{
		$(this).toggleClass("detail_head_expanded").next(".detail_body").slideToggle(600);
	});
	$(".detail_expand_all").click(function()
	{
		$(".detail_body").slideDown(1200);
		$(".detail_head_collapsed").toggleClass("detail_head_expanded");
		$(".detail_expand_all").hide();
		$(".detail_collapse_all").show();

	});
	$(".detail_collapse_all").click(function()
	{
		$(".detail_body").slideUp(1200);
		$(".detail_head_collapsed").toggleClass("detail_head_expanded");
		$(".detail_expand_all").show();
		$(".detail_collapse_all").hide();

	});
	$(".detail_toggle_all").click(function()
	{
		$(".detail_body").slideToggle(600);
		$(".detail_head_collapsed").toggleClass("detail_head_expanded");
	});
	cpgDocHeader();
	cpgDocTranslationWarning();
	cpgDocToc();
	$("#tree").treeview({
        collapsed: true,
        unique: true,
        animated: "slow",
        persist: "location"
    });
	cpgDocSearch();
	cpgDocFooter();
	dateRevision();
    $("a.nolink").click(function(){
      return false;
    });
    // Fade the toc in if it is needed
	$("#toc").bind("mouseenter",function(){
		$("#toc_collapsed").hide();
		$("#toc_expanded").fadeIn('slow');
		$("#doc_search").show();
	});
	// Fade the toc out if it isn't used
	$("#toc").bind("mouseleave",function(){
		$("#toc_expanded").fadeOut('slow');
		$("#toc_collapsed").show();
		$("#doc_search").hide();
	});
	
});