<?php
/* 
 *******************************************
 plugin JUpload for Coppermine Photo Gallery
 *******************************************

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 ********************************************
 $Revision: 185 $
 $Author: etienne_sf $
 $Date: 2008-03-12 20:26:16 +0100 (mer., 12 mars 2008) $
 ********************************************
 *
 * Allows easy upload to the gallery, through a java applet. 
 * 
 * Up to date version of this script can be retrieved with the full JUpload package, here:
 * 
 * http://etienne.sf.free.fr/wiki
 * 
 * Directly here:
 * http://forum.coppermine-gallery.net/index.php/board,100.0.html
 * 
 * Support is available on this forum:
 * http://coppermine-gallery.net/forum/index.php?topic=43432
 * 
 * The applet is published on sourceforge:
 * http://jupload.sourceforge.net
 * 
 */

if (!defined('IN_COPPERMINE')) { die('Not in Coppermine...');}
if (!defined('JUPLOAD_PHP')) { die('Not in Jupload...');}



//This file is included within a function (see codebase.php: jupload_plugin_wakeup)
//So, we need to declare all variables that must be global, as such:
global $USER, $CONFIG, $JUPLOAD_CONFIG, $lang_jupload_php, $bJuploadTranslactionExist, $juploadRootDirectory;
global $superCage, $userLang, $userLangFile, $juploadParameterPrefix;



//####################################################################################################
//#################################  GLOBAL FUNCTIONS  ###############################################
//####################################################################################################

/**
 * Indicates whether or not the debug is active.
 */
function isDebugActive() {
	global $JUPLOAD_CONFIG;
	return (	$JUPLOAD_CONFIG['debug']=='true' 
		||  ($JUPLOAD_CONFIG['debug']=='admin' && GALLERY_ADMIN_MODE)
		||  (isset($_GET['action']) && $_GET['action'] == 'upload_picture')
		); 
}

/**
 * Log a line, if debug is active. 
 * 
 * Caution: This line will be displayed within the HTML page. 
 */
function logDebug($msg) {	
	if (isDebugActive()) {
		// output is commented, so that it works also with the ajas pages.
		echo "//[DEBUG] $msg<BR>\r\n";
	}
}


/**
 * jupload_cpg_die supersedes the cpg_die functions, for the next functions in this package. It allows
 * to just return a value, or create an HTML error page, depending on the value of the $callCpgDie global var.
 * 
 */
function jupload_cpg_die($msg_code, $msg_text,  $error_file, $error_line, $output_buffer = false) {
	global $callCpgDie, $ERROR;

	//If we forgot to initialize $callCpgDie, or if it's true, we do it the standard way.	
	if (!isset($callCpgDie)) {
		$callCpgDie = true;
	}
	
	if ($msg_text == '') {
		$ERROR = "$msg_code\r\n";
	}else{
		$ERROR = "($msg_code) $msg_text\r\n";
	}
	//Removes line feeds
	$ERROR = str_replace('<br />', ' ', $ERROR);
	//Encode properly, so that 'strange' characters display normally, once in the applet.
	$ERROR = 'ERROR: ' . strip_tags($ERROR);
	if (function_exists('mb_convert_encoding')) {
			$ERROR = mb_convert_encoding($ERROR, "UTF-8");
	}				
	
	if ($callCpgDie) {
		return cpg_die($msg_code, $msg_text,  $error_file, $error_line, $output_buffer);
	} else {
		//In an upload controled by the applet, we just want the error text in the output. The applet will then 
		//interpret this string, which sould be 'SUCCESS' or 'ERROR: msg'.
		die($ERROR);
	}
}



/**
 * Prepares a string so that is can be stored ... in a js string
 */
function prepare_js_string($str) {
	return 	
		str_replace("\r", "",
			str_replace("\n", "\\n",
				str_replace(
					"'", 
					"\\'",
					html_entity_decode($str, ENT_QUOTES)
				)
			)
		);
}


function getSuperCageString($name) {
	global $superCage;
	if ($superCage->post->keyExists($name)) {
		return $superCage->post->getRaw($name);
	} else if ($superCage->get->keyExists($name)) {
		return $superCage->get->getRaw($name);
	} else {
		return '';
	}  
}
function getSuperCageInt($name, $default = -1) {
	global $superCage;
	if ($superCage->post->keyExists($name)) {
		return $superCage->post->getInt($name);
	} else if ($superCage->get->keyExists($name)) {
		return $superCage->get->getInt($name);
	} else {
		return $default;
	}  
}



//####################################################################################################
//#############################  COPPERMINE VERSION MANAGEMENT #######################################
//####################################################################################################


//The following constants are also used to define the path to the jupload include specific files for
//this Coppermine version. The include path is then: 'plugins/jupload/include' . JUPLOAD_CPG_VERSION . '/'
define('JUPLOAD_CPG_1_4', '1.4');
define('JUPLOAD_CPG_1_5', '1.5');
// Check the current Coppermine version.
if (isset($superCage)) {
	logDebug('The current Coppermine version is 1.5.x');
	define('JUPLOAD_CPG_VERSION', JUPLOAD_CPG_1_5);
} else {
	logDebug('The current Coppermine version is 1.4.x');
	define('JUPLOAD_CPG_VERSION', JUPLOAD_CPG_1_4);
}



// The $juploadParameterPrefix string will be added at the beginning of each parameter name, before insertion
//into the Coppermine configuration table. 
$juploadParameterPrefix = "jupload_";

$juploadRootDirectory = 'plugins/jupload/';
$juploadIncludeDirectory = 'plugins/jupload/include/';
$juploadIncludeDirectoryVersionCpg = 'plugins/jupload/include' . JUPLOAD_CPG_VERSION . '/';

require_once($juploadIncludeDirectory . 'config.inc.php');
//require_once($juploadIncludeDirectory . 'session.inc.php');
 

//####################################################################################################
//#################################  GLOBAL FUNCTIONS  ###############################################
//####################################################################################################



//####################################################################################################
//#################################    RIGHT CONTROL  ################################################
//####################################################################################################

// Check to see if user can upload pictures.  Quit with an error if he cannot.
//The rules are described on the JUpload configuration page. You can see their text explanation
//in the plugins/jupload/include/config.inc.php page.
global $jupload_may_see_jupload_link, $jupload_user_may_use_jupload, $USER_DATA;

//Default to no access. Initialization should be useless. Just to be sure.
$jupload_may_see_jupload_link = false;
$jupload_user_may_use_jupload = false;

//USER_CAN_CREATE_ALBUMS: means that the user may have its own gallery (and is not an admin)
//USER_CAN_UPLOAD_PICTURES: means that the user may upload picture to public albums (to be confirmed)
if (USER_IS_ADMIN) {
	$jupload_may_see_jupload_link = true;
	$jupload_user_may_use_jupload = true;	
} else {
	switch ($JUPLOAD_CONFIG['alwaysVisible']) {
		case '0':
			$jupload_may_see_jupload_link = USER_CAN_UPLOAD_PICTURES || USER_CAN_CREATE_ALBUMS;
			$jupload_user_may_use_jupload = $jupload_may_see_jupload_link;
			break;
		case '1':
			$jupload_may_see_jupload_link = true;
			$jupload_user_may_use_jupload = USER_CAN_UPLOAD_PICTURES || USER_CAN_CREATE_ALBUMS;
			break;
		case '2':
			$jupload_may_see_jupload_link = false;
			$jupload_user_may_use_jupload = false;
			break;
		default:
			if ($JUPLOAD_CONFIG['alwaysVisible'] == $USER_DATA['group_name']) {
				$jupload_may_see_jupload_link = true;
				$jupload_user_may_use_jupload = USER_CAN_UPLOAD_PICTURES || USER_CAN_CREATE_ALBUMS;
			} else {
				$jupload_may_see_jupload_link = false;
				$jupload_user_may_use_jupload = false;
			}
	}
}


//####################################################################################################
//##############################     LANGUAGE       ##################################################
//####################################################################################################



//Localisation. Handled from specific files, to make upgrade of coppermine easier:
//First: we load the default text (english)
$lang_jupload_php = array();
require("$juploadRootDirectory/lang/english.php");

//Then, you overload with the choosen language, for existing translations.
//$bJuploadTranslactionExist is used later, in page_upload.php, to display a message indicating that
//the translation for the current language doesn't exist ... and to give the link to the page where all
//the text to translate is written (part of text is in the applet, not in the php code).

//$CONFIG is not set, when called from ./plugins/jupload/configuration.php
$userLang = (isset($CONFIG)) ? $CONFIG['lang'] : '';
if (isset($USER['lang'])) {
	$userLang = $USER['lang'];
}
$userLangFile = "$juploadRootDirectory/lang/$userLang.php";


$bJuploadTranslactionExist = file_exists($userLangFile);

if ($userLang == 'english'  ||  $userLang == 'english_gb') {
	//We already included (required) the jupload english.php file
	$bJuploadTranslactionExist = true;  //Was not true for english_gb, one line before ...   ;-)
} else if ($bJuploadTranslactionExist) {
    include($userLangFile);
}


//Let's create a 'default' version number, for my internal tests
$JUPLOAD_CONFIG['version']='[not packaged]'; 
//This internal version number should be replaced by the next line, added during packaging
//Ok, this could be better. But it works, that's a point !    ;-)

$JUPLOAD_CONFIG['version']='4.0.0rc3';

		