<?php
/* 
 *******************************************
 plugin JUpload for Coppermine Photo Gallery
 *******************************************

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 ********************************************
 $Revision: 185 $
 $Author: etienne_sf $
 $Date: 2008-03-12 20:26:16 +0100 (mer., 12 mars 2008) $
 ********************************************
 *
 * Allows easy upload to the gallery, through a java applet. 
 * 
 * Up to date version of this script can be retrieved with the full JUpload package, here:
 * 
 * http://etienne.sf.free.fr/wiki
 * 
 * Directly here:
 * http://etienne.sf.free.fr/wiki/doku.php?id=jupload_coppermine_download_gb
 * 
 * Support is available on this forum:
 * http://coppermine-gallery.net/forum/index.php?topic=43432
 * 
 * The applet is published on sourceforge:
 * http://jupload.sourceforge.net
 * 
 */

/*
 * This include is meant to add additional functions, for script that need to manage pictures.
 * 
 * It is based on the folowing facts:
 * 1) A lot of scripts have specific internal functions to manage the incoming file. 
 *   At least these scripts: db_input, upload, jupload, addpic, xp_publish.
 * 2) Each are slightly different, which means: it's not possible to directly reuse them in another script
 * 3) As these scripts also do input (mix between code that produce output and code that should be included), it's
 *   not possible to include them in another one to reuse code.
 * 4) If a bug exists (especially if it involve security), it's possible that several correction have to be done.
 * 5) Changing anything in the picture management system may become difficult, because many functions can have to be
 * modified.
 * 
 * 
 * 
 * 
 * This picmgmt.inc.php lacks these functions, that should be centralized and reused in all other scripts:
 * a) handle_one_uploaded_file()
 *   There are at least three scripts that manage uploaded pictures. By upload, I mean sent by an HTTP upload request.
 * b) add_physical_file()
 *   Should be called by handle_one_uploaded_file(), or, for instance, by a script that would unzip an incoming zip file. This 
 *   script should manage strange characters, and make any checks that lacks in add_picture, then call add_picture.
 * c) after_upload()
 *   This function should be called after each successful upload. Currently, it only send a mail if the gallery
 *   is configured to do it.
 * 
 *   The aim of this script is to provide these additional functions. Perhaps it will be incorporated into the
 * picmgmt.inc.php file ...
 *  
 */


if (!defined('IN_COPPERMINE')) { die('Not in Coppermine...');}
if (!defined('JUPLOAD_PHP')) { die('Not in Jupload...');}

logDebug("In j_picmgmt.inc.php (20)");
include_once("include/iptc.inc.php");
logDebug("In j_picmgmt.inc.php (30)");



define("GIS_GIF", 1);
define("GIS_JPG", 2);
define("GIS_PNG", 3);

logDebug("In j_upload_management.cpg1.5.inc.php");

/**
 * Handle a file received by upload. This function is an extraction of the SW upload code, from the upload.php file.
 * 
 * Returns: the function ends (by calling jupload_cpg_die) when an error occurs. If it returns, then it means: success !
 */
function handle_uploaded_files($upload_name) {
	global $CONFIG, $superCage, $lang_upload_php, $lang_db_input_php, $escrow_array, $file_failure_array, $jupload_original_file_name;
	global $uploaded_pic, $lang_upload_php, $jupload_original_file_name;
	
	logDebug("[handle_uploaded_files 1.5] Entering function");
	
	// We note the actual uploaded name for the file, for the add_file_data JUpload hook. 
	$jupload_original_file_name = $superCage->files->getRaw('/Filedata/name'); 
	

	// The return string ... by default, it's a success (an empty error message)
	
	/*
	 * These lines are mainly a copy/paste from the cpg 1.5 upload.php script.
	 * 
	 */ 

    $error_code = $superCage->files->getInt("/Filedata/error");
    
    logDebug('content of error_code: ');
    foreach ($error_code as $value) {
    	echo($value);
    }

    // Check for upload errors
    if (!($error_code == '0')) {
    	logDebug("Received error_code: $error_code");
        // PHP has detected a file upload error.
        if ($error_code == '1') {
            jupload_cpg_die($lang_upload_php['exc_php_ini']);
        } elseif ($error_code == '2') {
            jupload_cpg_die($lang_upload_php['exc_file_size']);
        } elseif ($error_code == '3') {
            jupload_cpg_die($lang_upload_php['partial_upload']);
        } elseif ($error_code == '4') {
            jupload_cpg_die($lang_upload_php['no_upload']);
        } else {
            jupload_cpg_die("${lang_upload_php['unknown_code']}: $error_code");
        }
    }

    if (!($superCage->files->getRaw('/Filedata/name'))) {
		logDebug("[handle_uploaded_files 1.5] 5: " . $lang_upload_php . '|' . $lang_upload_php['no_name']);
        jupload_cpg_die($lang_upload_php['no_name']);
    }
	logDebug("[handle_uploaded_files 1.5] 10");

    if (!$superCage->files->getRaw('/Filedata/tmp_name')) {
        jupload_cpg_die($lang_upload_php['no_tmp_name']);
    }
	logDebug("[handle_uploaded_files 1.5] 20");

    // Check to make sure the file was uploaded via POST.
    if (!is_uploaded_file($superCage->files->getRaw("/Filedata/tmp_name"))) {
        // We reject the file, and return the error.
        jupload_cpg_die($lang_upload_php['no_post']);
    }

	logDebug("[handle_uploaded_files 1.5] 100");

    // Check filename and extension:
    // Check that the file uploaded has a valid name and extension, and replace forbidden chars with underscores.
    // Initialise the $matches array.
    $matches = array();
    // If magic quotes is on, remove the slashes it added to the file name.
    if (get_magic_quotes_gpc()) {
        //Using getRaw() as we have custom sanitization code below
        $picture_name = stripslashes($superCage->files->getRaw("/Filedata/name"));
    } else {
        $picture_name = $superCage->files->getRaw("/Filedata/name");
    }

    // Create the holder $picture_name by translating the file name. Translate any forbidden character into an underscore.
    $picture_name = replace_forbidden($picture_name);

	logDebug("[handle_uploaded_files 1.5] 200");

    // Analyze the file extension using regular expressions.
    if (!preg_match("/(.+)\.(.*?)\Z/", $picture_name, $matches)) {

        // The file name is invalid.
        $matches[1] = 'invalid_fname';

        // Make a bogus file extension to trigger Coppermine's defenses.
        $matches[2] = 'xxx';
    }

    // If there is no extension, or if the extension is unknown/not permitted by Coppermine, zap the intruder.
    if ($matches[2] == '' || !is_known_filetype($matches)) {
        // We reject the file, and make a note of the error.
        jupload_cpg_die("${lang_db_input_php['err_invalid_fext']} (${CONFIG['allowed_file_extensions']})");
    }

    $error_code = $superCage->files->getInt("/Filedata/error");
    // Check for upload errors
    if (!($error_code == '0')) {
        // PHP has detected a file upload error.
        if ($error_code == '1') {
            $error_message = $lang_upload_php['exc_php_ini'];
        } elseif ($error_code == '2') {
            $error_message = $lang_upload_php['exc_file_size'];
        } elseif ($error_code == '3') {
            $error_message = $lang_upload_php['partial_upload'];
        } elseif ($error_code == '4') {
            $error_message = $lang_upload_php['no_upload'];
        } else {
            $error_message = $lang_upload_php['unknown_code'];
        }

        //Make a note in the error array.
        jupload_cpg_die($error_message);
    }

	logDebug("[handle_uploaded_files 1.5] 300");

    // Now we need to move the file into the /edit directory.
    // We need specify the path for the transitory file.
    // Create a prefix for easier human recognition.
    $prefix = "mHTTP_temp_";

    //Set the correct file extension.
    $suffix = $matches[2];

    // Generate the unique name. Keep generating new names until one that is not in use is found.
    do {

        // Create a random seed by taking the first 8 characters of an MD5 hash of a concatenation of the current UNIX epoch time and the current server process ID.
        $seed = substr(md5(uniqid("")), 0, 8);

        // Assemble the file path.
        $path_to_image = './'.$CONFIG['fullpath'].'edit/'. $prefix . $seed . '.' . $suffix;

    } while (file_exists($path_to_image));

    // Create a holder called $tempname.
    $tempname = $prefix . $seed . '.' . $suffix;

    //Now we upload the file.
    if (!(move_uploaded_file($superCage->files->getRaw("/Filedata/tmp_name"), $path_to_image))) {
        // The file upload has failed.
        jupload_cpg_die($lang_upload_php['impossible']);
    }

	logDebug("[handle_uploaded_files 1.5] 400");


    // Change file permission
    @chmod($path_to_image, octdec($CONFIG['default_file_mode'])); //silence the output in case chmod is disabled

    // Create a testing alias.
    $picture_alias = $matches[1].".".$matches[2];

			//////////////////////////////////////////////////////////////////////////////////////////
			// JUpload modification start: if it's a chunk, we concatenate it with the any previously chunk
			// for this picture.
			global $chunkedUpload, $jupart, $jufinal, $USER;
			if ($chunkedUpload) {
				logDebug("[handle_uploaded_files 1.5] in chunk mode");
				//We are in chunk mode.
				 
				//Here is a upload filename unique, and stable for our upload. This suppose that files are
				//uploaded one by one (otherwise, two files with the same name could be uploaded in one step, 
				//for instance if they come from two different directory on the source computer).
				$finalFilename = $USER['ID'] . '_' . $picture_alias;				
				$path_to_reconstructed_file =  './'.$CONFIG['fullpath'].'edit/' . $finalFilename; 
				
				if ($jupart == 1) {
					logDebug("[handle_uploaded_files 1.5] First chunk received");
					//This is the first chunk: we just move this first chunk to our final temp file. Its filename
					//must be stable and unique, so that we can find it in the next upload.
					//First: we remove the file, if it alredy exist from a previous try.
					if (file_exists($path_to_reconstructed_file)) {
						unlink($path_to_reconstructed_file);
					}
					rename($path_to_image, $path_to_reconstructed_file);
				} else {
					//The first chunk is managed by the standard code available above. For next chunks, we have
					//to concatenate the current chunk, with the already uploaded part(s).
					$fwrite = fopen($path_to_reconstructed_file, 'a');
					$fread = fopen($path_to_image, 'r');
					
					while (  ($buff=fread($fread, 1000)) != '') {
						fwrite($fwrite, $buff);
					}
					fclose($fread);
					fclose($fwrite);
				}
				//The following of this function should use the new path_to_image:
				//This is really useful only when we receive the last chunk.
				$path_to_image = $path_to_reconstructed_file;
				
				if ($jufinal) {
					logDebug("[handle_uploaded_files 1.5] Last chunk received");
					//Ok, let's indicate the reconstructed file
					$tempname = $finalFilename;
				} else {
					logDebug("[handle_uploaded_files 1.5] Current chunk is not the last one");
					//If we've not read the last chunk, the is_image must return wrong, otherwise, it will
					//try to work on a partial file.
					$picture_alias = "this file is chunked and.is_not_a_picture_yet";
					//Let's end the current work here.
					die("SUCCESS\r\n");
				}
			}//if($chunkedUpload)
			// JUpload modification end.
			//////////////////////////////////////////////////////////////////////////////////////////


    // Check if user selected an album to upload picture to. If not, die with error.
    // added by frogfoot
    $album = $superCage->post->getInt('album');

    // If no album was select then give an error
    if (!$album) {
        jupload_cpg_die($lang_db_input_php['album_not_selected']);
    }

    // Check if the album id provided is valid
    if (!GALLERY_ADMIN_MODE) {
        $result = cpg_db_query("SELECT category FROM {$CONFIG['TABLE_ALBUMS']} WHERE aid='$album' and (uploads = 'YES' OR category = '" . (USER_ID + FIRST_USER_CAT) . "' OR owner = '" . USER_ID . "')");
        if (mysql_num_rows($result) == 0) {
            jupload_cpg_die($lang_db_input_php['unknown_album']);
        }
        $row = mysql_fetch_array($result);
        mysql_free_result($result);
        $category = $row['category'];
    } else {
        $result = cpg_db_query("SELECT category FROM {$CONFIG['TABLE_ALBUMS']} WHERE aid='$album'");
        if (mysql_num_rows($result) == 0) {
            jupload_cpg_die($lang_db_input_php['unknown_album']);
        }
        $row = mysql_fetch_array($result);
        mysql_free_result($result);
        $category = $row['category'];
    }

    // Pictures are moved in a directory named 10000 + USER_ID
    if (USER_ID && $CONFIG['silly_safe_mode'] != 1) {
        $filepath = $CONFIG['userpics'] . (USER_ID + FIRST_USER_CAT);
        $dest_dir = $CONFIG['fullpath'] . $filepath;
        if (!is_dir($dest_dir)) {
            mkdir($dest_dir, octdec($CONFIG['default_dir_mode']));
            if (!is_dir($dest_dir)) {
                jupload_cpg_die("${lang_db_input_php['err_mkdir']} ($dest_dir)");
            }
            @chmod($dest_dir, octdec($CONFIG['default_dir_mode'])); //silence the output in case chmod is disabled
            $fp = fopen($dest_dir . '/index.html', 'w');
            fwrite($fp, ' ');
            fclose($fp);
        }
        $dest_dir .= '/';
        $filepath .= '/';
    } else {
        $filepath = $CONFIG['userpics'];
        $dest_dir = $CONFIG['fullpath'] . $filepath;
    }

    // Check that target dir is writable
    if (!is_writable($dest_dir)) {
        jupload_cpg_die("${lang_db_input_php['dest_dir_ro']} ($dest_dir)");
    }

    //Add the Perl regex to break the actual name.
    preg_match("/(.+)\.(.*?)\Z/", $picture_alias, $matches);


	logDebug("[handle_uploaded_files 1.5] 500");

    // Create a unique name for the uploaded file
    $nr = 0;
    $picture_name = $matches[1] . '.' . $matches[2];
    while (file_exists($dest_dir . $picture_name)) {
        $picture_name = $matches[1] . '~' . $nr++ . '.' . $matches[2];
    }

    // Create path for final location.
    $uploaded_pic = $dest_dir . $picture_name;

    // Form path to temporary image.
    $path_to_image = './'.$CONFIG['fullpath'].'edit/'.$tempname;

    // prevent moving the edit directory...
    if (is_dir($path_to_image)) {
        jupload_cpg_die("${lang_upload_php['failure']} - '$path_to_image'");
    }


	logDebug("[handle_uploaded_files 1.5] 600");

    // Move the picture into its final location
    if (rename($path_to_image, $uploaded_pic)) {

        // Change file permission
        @chmod($uploaded_pic, octdec($CONFIG['default_file_mode'])); //silence the output in case chmod is disabled
        $CURRENT_PIC_DATA = array();
        // Create thumbnail and intermediate image and add the image into the DB
        $result = jupload_add_picture($album, $filepath, $picture_name, 0, '', '', '', '', '', '', '', $category);
        logDebug("[handle_uploaded_files 1.5] 650 (jupload_add_picture returned $result)");

        if ($result !== true) {
            // The file could not be placed.
            logDebug("[handle_uploaded_files 1.5] 651 (file_placement = 'no')");
            $file_placement = 'no';
        } else {
            $CURRENT_PIC_DATA['url_prefix'] = 0;
            // The file was placed successfully.
            $file_placement = 'yes';
            $thumb_url = get_pic_url($CURRENT_PIC_DATA, 'thumb');
            logDebug("[handle_uploaded_files 1.5] 655 (file_placement = 'yes')");
        }
    } else {
        // The file was not placed successfully.
        $file_placement = 'no';
        logDebug("[handle_uploaded_files 1.5] 660 (file_placement = 'no')");
    }

    if ($file_placement == 'yes') {
        // The previous picture was placed successfully.
        // We write it, and let go on for next steps. 
        logDebug("[handle_uploaded_files 1.5] 660 (SUCCESS)");
        echo("SUCCESS\r\n");
    } else {
        // The previous image placement failed.
        if (isset($result['error'])) {
            if (isset($result['halt_upload'])) {
                jupload_cpg_die("${result['error']} (${result['halt_upload']})");
        } else {
                jupload_cpg_die($result['error']);
            }
        } else {
            jupload_cpg_die($lang_upload_php['no_place']);
        }
    }
    logDebug("[handle_uploaded_files 1.5] End of function");
}

logDebug("In j_picmgmt.inc.php (120)");



/**
 * after_upload execute any global required action after a successfull upload. Currently, one action can be done:
 * - Send a notification to the admin, depending on the current upload (see $PIC_NEED_APPROVAL) and on the 
 *   configuration status (see $CONFIG['upl_notify_admin_email']).
 * 
 * A call to this method should be added in the following scripts:
 * - xp_publish.php (no mail is sent after a successful upload)
 * - db_input.php (a mail is sent after a successful upload)    
 *
function after_upload() {
	
Now useless, with cpg 1.5 ?

	global $CONFIG, $PIC_NEED_APPROVAL;
	
	//The lines below are a copy/paste of lines 2334 to 2346 from the upload.php

	if (  ($CONFIG['upl_notify_admin_email']) and ($PIC_NEED_APPROVAL)  ) {
	    // Encapsulate so included lang file doesn't interfere with global one
	    //etienne_sf: this could propably be simplified, now that it's in  specific function.
	    function cpg_send_upload_notification() {
	        global $CONFIG;
	        $lang_db_input_php = cpg_get_default_lang_var('lang_db_input_php');
	        // Get the mail files.
	        include_once('include/mailer.inc.php');
	
	        // Send the message.
	        cpg_mail('admin', sprintf($lang_db_input_php['notify_admin_email_subject'], $CONFIG['gallery_name']), sprintf($lang_db_input_php['notify_admin_email_body'], USER_NAME,  $CONFIG['ecards_more_pic_target']. (substr( $CONFIG["ecards_more_pic_target"], -1) == '/' ? '' : '/') .'editpics.php?mode=upload_approval' ));
	    }
	    
	    cpg_send_upload_notification();
	}
}

*/