<?php
/*
 *******************************************
 plugin JUpload for Coppermine Photo Gallery
 *******************************************

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 ********************************************
 $Revision: 185 $
 $Author: etienne_sf $
 $Date: 2008-03-12 20:26:16 +0100 (mer., 12 mars 2008) $
 ********************************************
 *
 * Allows easy upload to the gallery, through a java applet. 
 * 
 * Up to date version of this script can be retrieved with the full JUpload package, here:
 * 
 * http://etienne.sf.free.fr/wiki
 * 
 * Directly here:
 * http://forum.coppermine-gallery.net/index.php/board,100.0.html
 * 
 * Support is available on this forum:
 * http://coppermine-gallery.net/forum/index.php?topic=43432
 * 
 * The applet is published on sourceforge:
 * http://jupload.sourceforge.net
 * 
 */


/*
 * This script allow to edit the properties of the uploaded pictures:
 * - All pictures uploaded by the last JUpload will be displayed, and only them.
 * - For each pictures, it is possible to edit the title, the description and the key words.
 * 
 * This script is based on the editpics.php script. It is called by the /jupload.php script.
 * 
 */


if (!defined('IN_COPPERMINE')) { die('Not in Coppermine...');}
if (!defined('JUPLOAD_PHP')) { die('Not in Jupload...');}

//If the user may not upload pictures, there is no reason for him to go on this page.
//USER_CAN_CREATE_ALBUMS: seems to indicate that the user may have its personnal gallery (at least for the admin)
if (!USER_CAN_UPLOAD_PICTURES && !USER_CAN_CREATE_ALBUMS) {
	$msg = str_replace('$1', 'login.php?referer=plugins/jupload/jupload.php', $lang_jupload_php['perm_denied']);

	cpg_die(ERROR, $msg, __FILE__, __LINE__);
}

define('UPLOAD_APPROVAL_MODE', isset($_GET['mode']));
define('EDIT_PICTURES_MODE', !isset($_GET['mode']));

//A message will be dsplayed, if this script is called to update the picture properties.
//Default is no message
$message_update_status = '';

$THUMB_ROWSPAN=5;
if ($CONFIG['user_field1_name'] != '') $THUMB_ROWSPAN++;
if ($CONFIG['user_field2_name'] != '') $THUMB_ROWSPAN++;
if ($CONFIG['user_field3_name'] != '') $THUMB_ROWSPAN++;
if ($CONFIG['user_field4_name'] != '') $THUMB_ROWSPAN++;




/**
 * Let's get the pictures uploaded by the last JUpload.
 * 
 * Particular global variables:
 * $nb_pictures: nb pictures uploaded. Transmitted as a GET parameter, by the applet.
 * $pic_count: total nb pictures. Used by the original CPG editpics.php script. It get the value of $nb_pictures.
 * $start: first picture of this set, to be retrieve by the returned resultset.
 * $count: Nb of pictures to  be returned by the returned resultset.
 * 
 */
function get_pictures() {
	global $lang_errors, $since_time, $CONFIG, $album, $start, $count;
	global $pic_count, $nb_pictures, $form_target, $help;
	
    $user_id = USER_ID;
	$pic_count = $nb_pictures;
	
    //TODO: only select the pictures relevant to the last upload. This is not so easy, as the
    //applet must get the oldest ctime, corresponding to the first file uploaded. A first call
    //to the server would easily do that. 
    //Note: if two uploads are done in the same time by the same login on the same album: it will be hard
    //to distinguish these two uploads. Pictures properties will just be edited by both connected users.
    //
    //Security note: $album is forced as an int, in this script. This should make the call below remain secure.
    $where_clause = " p.aid = $album and p.owner_id = $user_id "; //and ctime > $since_time 


	$sql = "SELECT count(*) FROM {$CONFIG['TABLE_PICTURES']} as p WHERE $where_clause";
	//logDebug("[edit_uploaded_pics.php] In get_pictures() getCountPicture ($sql)");
    $result=cpg_db_query($sql);
    $nbEnr = mysql_fetch_array($result);
    $pic_count_album = $nbEnr[0]; 
	//logDebug("[edit_uploaded_pics.php] In get_pictures() ($sql) pic_count: $pic_count_album");
    mysql_free_result($result);

    
    // $nb_first_pic identifies the first pic to display on this page, amongst this albums's pictures. So it starts with the 
    // current upload, and take into account the offset of the page to display ($start) within the list of uploaded pictures.
    $nb_first_pic =  $pic_count_album - $nb_pictures + $start;
    
    $sql = "SELECT p.*,a.category FROM {$CONFIG['TABLE_PICTURES']} as p ".
               "INNER JOIN {$CONFIG['TABLE_ALBUMS']} as a ".
               "ON a.aid=p.aid ".
               "WHERE $where_clause ".
               "ORDER BY p.ctime LIMIT $nb_first_pic, $count";  //Mangement of next/previous: LIMIT $start, $count
    //logDebug("[edit_uploaded_pics.php] In get_pictures() Before ($sql) : nb_pictures: $nb_pictures, pic_count: $pic_count, start: $start, count: $count");
    $resultset_pictures = cpg_db_query($sql);

	if (!mysql_num_rows($resultset_pictures)) {
		cpg_die(INFORMATION, $lang_errors['no_img_to_display'], __FILE__, __LINE__);
	}

    //$form_target = $_SERVER['PHP_SELF'].'?album='.$album.'&amp;action=edit_uploaded_pics&amp;start='.$start.'&amp;count='.$count;
    $form_target = '';
    $help = '&nbsp;'.cpg_display_help('f=index.htm&amp;as=edit_pics&amp;ae=edit_pics_end&amp;top=1', '800', '500');
    
    return $resultset_pictures;
} 



if (JUPLOAD_CPG_VERSION == JUPLOAD_CPG_1_5) {
	include('plugins/jupload/include1.5/edit_uploaded_pics.inc.php');
} else {
	require_once('plugins/jupload/include/gui.inc.php');
	include('plugins/jupload/include1.4/edit_uploaded_pics.inc.php');
}
