<?php
/*
 *******************************************
 plugin JUpload for Coppermine Photo Gallery
 *******************************************

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 ********************************************
 $Revision: 185 $
 $Author: etienne_sf $
 $Date: 2008-03-12 20:26:16 +0100 (mer., 12 mars 2008) $
 ********************************************
 *
 * Allows easy upload to the gallery, through a java applet. 
 * 
 * Up to date version of this script can be retrieved with the full JUpload package, here:
 * 
 * http://etienne.sf.free.fr/wiki
 * 
 * Directly here:
 * http://forum.coppermine-gallery.net/index.php/board,100.0.html
 * 
 * Support is available on this forum:
 * http://coppermine-gallery.net/forum/index.php?topic=43432
 * 
 * The applet is published on sourceforge:
 * http://jupload.sourceforge.net
 * 
 */


if (!defined('IN_COPPERMINE')) {
	die('Not in Coppermine...');
}
if (!defined('JUPLOAD_PHP')) {
	die('Not in Jupload...');
}

require_once('plugins/jupload/include/gui.inc.php');
require ('plugins/jupload/include/j_catmgr.inc.php');

//If the user may not upload pictures, there is no reason for him to go on this page.
//USER_CAN_CREATE_ALBUMS: seems to indicate that the user may have its personnal gallery (at least for the admin)
if (!USER_CAN_UPLOAD_PICTURES && !USER_CAN_CREATE_ALBUMS) {
	$msg = str_replace('$1', 'login.php?referer=plugins/jupload/jupload.php', $lang_jupload_php['perm_denied']);

	cpg_die(ERROR, $msg, __FILE__, __LINE__);
}


//####################################################################################################
//##############################  LOCAL VARIABLES   ##################################################
//####################################################################################################


// Configure the jarPath
$appletHeight = $JUPLOAD_CONFIG['appletHeight'];
$appletWidth = $JUPLOAD_CONFIG['appletWidth'];
$jarPath = $JUPLOAD_CONFIG['jarPath'] . "wjhk.jupload.jar";
if (	$JUPLOAD_CONFIG['debug']=='true' 
	||  ($JUPLOAD_CONFIG['debug']=='admin' && GALLERY_ADMIN_MODE)
	) {
	$showLogWindow = 'true';
	$debugLevel = 100;
} else {
	$showLogWindow = 'false';
	$debugLevel = 99;
}

// Configure the filename attribute, that will be used in the HTTP request
if (JUPLOAD_CPG_VERSION == JUPLOAD_CPG_1_4) {
	$httpUploadParameterName = "userpicture";
	$httpUploadParameterType = "array";
} else {
	$httpUploadParameterName="Filedata";
	$httpUploadParameterType = "oneFile";
}


//Configure the site URL
$URL = $CONFIG['site_url'] . 'index.php?file=jupload/jupload&action=upload_picture';
if ($JUPLOAD_CONFIG[JUPLOAD_CONFIG_onError] != JUPLOAD_CONFIG_onError_doNothing) {
	$paramUrlToSendErrorTo =
		"	<PARAM NAME='urlToSendErrorTo' VALUE='" . $CONFIG['site_url'] . 'index.php?file=jupload/jupload&action=log_error' . "'>\r\n" 
		;
}

// Get the picture quality
$highQualityPicture = ($JUPLOAD_CONFIG['highQualityPreview'] ? 'true' : 'false');

//Should we display here a first list with the category list, then an ajax to load the album list
//for this category ?
//Current mode: activated only for admin mode.
//To come: activation of this function for standard user, depending on JUpload configuration.
$distinctListForCategoryAndAlbum = true; //GALLERY_ADMIN_MODE;

//Should we give a realMaxPictureWidth and realMaxPictureHeight to the applet ?
$maxNonTransformedPictureSize = ($JUPLOAD_CONFIG['maxNonTransformedPictureSize'] < 0) ? $CONFIG['max_upl_width_height'] : $JUPLOAD_CONFIG['maxNonTransformedPictureSize'];

//In PHP, we are limited to int, so maxChunkSize and maxFileSize are in kb. 
//In Java, these parameters are managed as long. So we transform these parameters to bytes
//Let's say that a kb is 1000 bytes ....
$maxFileSize = $JUPLOAD_CONFIG['maxFileSize'] . '000';
if ($JUPLOAD_CONFIG['maxChunkSize'] == '') {
	//The default chunk size is the maximum file size.
	$maxChunkSize = $JUPLOAD_CONFIG['maxFileSize'] . '000';
} else {
	$maxChunkSize = $JUPLOAD_CONFIG['maxChunkSize'] . '000';
}

//The language code coming from Coppermine seems to be different from the Java one.
//e.g.: zh-cn for zh_CN (where I'm not really sure about CN)
$localLang = $lang_translation_info['lang_country_code'];

$nbPart = preg_match('/(..).(..)/', $localLang, $matches);
if ($nbPart == 1) {
	//If we arrive here, we have both a language code, and a country code. The correct syntax, in java, is:
	//ll_CC :
	$localLang = $matches[1] . '_' . strtoupper($matches[2]);
}
if ($localLang == 'gb') {
	$localLang = 'en';
} else if ($localLang == 'he_IL') {
	$localLang = 'il';
}

//Manage cookies (including cookies that may be unavailable from javascript, in bridge mode)
//Manage Basic HTTP Authentication
if ($JUPLOAD_CONFIG['basicHttpAuthentication']) {
	$specificHeaders .= 'Authorization: Basic ';
	$specificHeaders .= base64_encode($JUPLOAD_CONFIG['basicHttpAuthentication']);
} else {
	$specificHeaders = '';
}
//Now we're ready to send our specific headers to the applet.  
$specificHeaders = "	<PARAM NAME='specificHeaders' VALUE='$specificHeaders'>";


//Get number of albums per category, where the user may upload files..
//This number of albums is displaed after the category name, in the category list.
if (GALLERY_ADMIN_MODE) {
	$albums_count = cpg_db_query(
				" SELECT category, count(1) nb " .
				" FROM {$CONFIG['TABLE_ALBUMS']} " .
				" WHERE category < " . FIRST_USER_CAT .
				" OR category = " . (FIRST_USER_CAT + USER_ID) .
				" GROUP BY category ");
} else {
	$albums_count = cpg_db_query(
				" SELECT category, count(1) nb  " .
				" FROM {$CONFIG['TABLE_ALBUMS']} " .
				" WHERE (" .
				"           category < " . FIRST_USER_CAT .
				"       AND uploads='YES' " .
				"       AND (visibility = '0' OR visibility IN " . USER_GROUP_SET . ")" .
				"		AND " . (USER_CAN_UPLOAD_PICTURES ? "1=1" : "1=2") .
				"       ) " .
				"  OR " .
				"     ( " .
				" 		category ='" . (FIRST_USER_CAT + USER_ID) . "'" . 
				"		AND " . (USER_CAN_CREATE_ALBUMS ? "1=1" : "1=2") .
				"      ) " .
				" GROUP BY category ");
}
//Let's store this number of albums per category.
while ($row = mysql_fetch_array($albums_count)) {
	$albumsCountPerCategory[$row['category']] = $row['nb'];
}

// Get public albums.
if (GALLERY_ADMIN_MODE) {
	$public_albums = cpg_db_query(
				" SELECT aid, title, description  " .
				" FROM {$CONFIG['TABLE_ALBUMS']} " .
				" WHERE category < " . FIRST_USER_CAT .
				" ORDER BY UPPER(title)");
} else {
	$public_albums = cpg_db_query(
				" SELECT aid, title, description  " .
				" FROM {$CONFIG['TABLE_ALBUMS']} " .
				" WHERE category < " . FIRST_USER_CAT .
				" AND uploads='YES' AND (visibility = '0' OR visibility IN " . USER_GROUP_SET . ") " .
				" ORDER BY UPPER(title)");
}
if (mysql_num_rows($public_albums)) {
	$public_albums_list = cpg_db_fetch_rowset($public_albums);
} else {
	$public_albums_list = array ();
}

// Get private albums. Valid now for all admin users.
//if (USER_ID) {
	$user_albums = cpg_db_query(
				" SELECT aid, title, description " .
				" FROM {$CONFIG['TABLE_ALBUMS']} " .
				" WHERE category='" . (FIRST_USER_CAT + USER_ID) . "' " .
				" ORDER BY UPPER(title)");
	if (mysql_num_rows($user_albums)) {
		$user_albums_list = cpg_db_fetch_rowset($user_albums);
	} else {
		$user_albums_list = array ();
	}
/*} else {
	$user_albums_list = array ();
}*/

if ($album_name == '' && $album > 0) {
	//Let's get the album name and description for the selected album. 
	$found = false;
	foreach ($user_albums_list as $a) {
		if ($a['aid'] == $album) {
			$found = true;
			$album_name = $a['title'];
			$album_description = $a['description'];
		}
	}
	if (!$found) {
		foreach ($public_albums_list as $a) {
			if ($a['aid'] == $album) {
				$found = true;
				$album_name = $a['title'];
				$album_description = $a['description'];
			}
		}
	}
}

//####################################################################################################
//###################  An empty applet, to check that java is installed on the navigator  ############
//####################################################################################################
/**
 * This is an empty applet, correctly converted by the java  html converter. It will prompt a message
 * to the user when Java is not installed on its computer, as Java is needed for this page.
 * The effective APPLET tag that loaded the real JUpload applet remains a simple APPLET tag, and 
 * is not converted by htmlConverter, to be easy to update.
 */
$emptyConvertedApplet = <<<EOS
<!--"CONVERTED_APPLET"-->
<!-- HTML CONVERTER -->
<script language="JavaScript" type="text/javascript"><!--
    var _info = navigator.userAgent;
    var _ns = false;
    var _ns6 = false;
    var _ie = (_info.indexOf("MSIE") > 0 && _info.indexOf("Win") > 0 && _info.indexOf("Windows 3.1") < 0);
//--></script>
    <comment>
        <script language="JavaScript" type="text/javascript"><!--
        var _ns = (navigator.appName.indexOf("Netscape") >= 0 && ((_info.indexOf("Win") > 0 && _info.indexOf("Win16") < 0 && java.lang.System.getProperty("os.version").indexOf("3.5") < 0) || (_info.indexOf("Sun") > 0) || (_info.indexOf("Linux") > 0) || (_info.indexOf("AIX") > 0) || (_info.indexOf("OS/2") > 0) || (_info.indexOf("IRIX") > 0)));
        var _ns6 = ((_ns == true) && (_info.indexOf("Mozilla/5") >= 0));
//--></script>
    </comment>

<script language="JavaScript" type="text/javascript"><!--
    if (_ie == true) document.writeln('<object classid="clsid:8AD9C840-044E-11D1-B3E9-00805F499D93" WIDTH = "0" HEIGHT = "0" NAME="EmptyApplet"  codebase="http://java.sun.com/update/1.5.0/jinstall-1_5-windows-i586.cab#Version=5,0,0,3"><noembed><xmp>');
    else if (_ns == true && _ns6 == false) document.writeln('<embed ' +
	    'type="application/x-java-applet;version=1.5" \
            CODE = "wjhk.jupload2.EmptyApplet" \
            ARCHIVE = "$jarPath" \
            NAME="EmptyApplet" \
            WIDTH = "0" \
            HEIGHT = "0" \
            type ="application/x-java-applet;version=1.6" \
            scriptable ="false" ' +
	    'scriptable=false ' +
	    'pluginspage="http://java.sun.com/products/plugin/index.html#download"><noembed><xmp>');
//--></script>
<applet  CODE = "wjhk.jupload2.EmptyApplet" ARCHIVE = "$jarPath" WIDTH = "0" HEIGHT = "0" NAME="EmptyApplet"></xmp>
    <PARAM NAME = CODE VALUE = "wjhk.jupload2.EmptyApplet" >
    <PARAM NAME = ARCHIVE VALUE = "$jarPath" >
    <PARAM NAME = NAME VALUE = "EmptyApplet" >
    <param name="type" value="application/x-java-applet;version=1.5">
    <param name="scriptable" value="false">
    <PARAM NAME="type" VALUE="application/x-java-applet;version=1.6">
    <PARAM NAME="scriptable" VALUE="false">

</xmp>
    
Java 1.5 or higher plugin required.
</applet>
</noembed>
</embed>
</object>

<!--
<APPLET CODE = "wjhk.jupload2.EmptyApplet" ARCHIVE = "$jarPath" WIDTH = "0" HEIGHT = "0" NAME="EmptyApplet">
	<PARAM NAME="type" VALUE="application/x-java-applet;version=1.6">
	<PARAM NAME="scriptable" VALUE="false">
	</xmp>
Java 1.5 or higher plugin required.
</APPLET>
-->
<!--"END_CONVERTED_APPLET"-->

EOS
;

//####################################################################################################
//#################################    FUNCTIONS    ##################################################
//####################################################################################################

//////////////////////////////////////////////////////////////////////////////////////
//Insert an album into database, if the user is allowed to.
//The category is given into $cat. It's mandatory if the galery is in admin mode.
//////////////////////////////////////////////////////////////////////////////////////
function create_album($album, $album_name, $album_description, $cat = 0) {
	global $lang_errors, $CONFIG, $USER_DATA, $lang_jupload_php;
	
	logDebug("create_album: receveive category n�$cat<BR>");
	
	if (!(GALLERY_ADMIN_MODE || USER_ADMIN_MODE)) {
		cpg_die(ERROR, $lang_errors['access_denied'], __FILE__, __LINE__);
	}

	if ($album_name == '') {
		cpg_die(ERROR, $lang_errors['param_missing'] . ' (album)', __FILE__, __LINE__);
	}

	if (GALLERY_ADMIN_MODE) {		
		//$cat is mandatory in admin mode. It must be between (inclusive) 0 and FIRST_USER_CAT + USER_ID.
		//Otherwise: this is an 'attack'. 
		//If the admin may has a personnal gallery, he may also have a (FIRST_USER_CAT + USER_ID) category
		if (  ! (  (0 <= $cat) && ($cat<(FIRST_USER_CAT + USER_ID) )
			||  ($USER_DATA['can_create_albums'] && $cat == (FIRST_USER_CAT + USER_ID))
			)) {
			cpg_die(ERROR, $lang_errors['param_missing'] . ' (category)', __FILE__, __LINE__);
		}
		//JUpload(int)$_POST['cat'];
	} else {
		//Otherwise, the category must be the user's gallery.
		//If not, then: this is an 'attack'. The message should be more precise.
		if ($cat != FIRST_USER_CAT + USER_ID) {
			cpg_die(ERROR, $lang_errors['param_missing'] . ' (category denied)', __FILE__, __LINE__);
		}
	}

	//Ok, the given $cat parameter is a valid category.
	$category = $cat;

	//We first check that the user doesn't already own an album with this name in this category:
	$vQuery = "
		SELECT count(*) nb 
		FROM {$CONFIG['TABLE_ALBUMS']}
		WHERE category = '$category'
		AND   title = '" . addslashes($album_name) . "'"
		;
	$vRes = cpg_db_query($vQuery);
	$vRes = mysql_fetch_array($vRes);
	if ($vRes['nb'] > 0)
		cpg_die(ERROR, $lang_jupload_php['error_album_already_exists'], __FILE__, __LINE__);

	//Let's insert the new album.
	$query = "INSERT INTO {$CONFIG['TABLE_ALBUMS']} (category, title, description, uploads, pos) " . 
			" SELECT '$category', '" . addslashes($album_name) . "', '" . addslashes($album_description) . "', 'NO',  IFNULL(MAX(pos),101) " . 
			" FROM {$CONFIG['TABLE_ALBUMS']} WHERE category = '$category' ";
	cpg_db_query($query);

	//Now, we select its id, to redirect the user to this album.
	$vQuery =	"SELECT aid " . 
				" FROM {$CONFIG['TABLE_ALBUMS']} " . 
				" WHERE category = '$category'" . 
				" AND   title = '" . addslashes($album_name) . "'";
	$vRes = cpg_db_query($vQuery);
	$vRes = mysql_fetch_array($vRes);

	jupload_message_success("upload_page", $vRes['aid'], $cat);
} //create_album

//////////////////////////////////////////////////////////////////////////////////////
//Update an album into database, if the user is allowed to.
//////////////////////////////////////////////////////////////////////////////////////
function update_album($album, $album_name, $album_description) {
	global $lang_errors, $CONFIG, $lang_jupload_php, $lang_db_input_php, $category;

	//The gallery must in USER mode or ADMIN mode.
	if (USER_ADMIN_MODE) {
		//The user may only update its own albums. We force the category to its gallery.
		$category = FIRST_USER_CAT + USER_ID;
	} else if (! GALLERY_ADMIN_MODE){
		cpg_die(ERROR, $lang_errors['access_denied'], __FILE__, __LINE__);
	}

	//Check that the given category and album is correct. 
	$res_category = cpg_db_query("SELECT 1 FROM ${CONFIG['TABLE_ALBUMS']} WHERE aid=$album AND category=$category");
	if (mysql_num_rows($res_category) != 1) {
		cpg_die(ERROR, $lang_db_input_php['unknown_album'], __FILE__, __LINE__);
	}

	//Then, check that the user doesn't already own an album with this name
	$vQuery = "
	  		SELECT count(*) nb
	  		FROM {$CONFIG['TABLE_ALBUMS']}
	  		WHERE category = '$category'
	    	AND   title = '" . addslashes($album_name) . "'
	    	AND   aid != $album
			";
	$vRes = cpg_db_query($vQuery);
	$vRes = mysql_fetch_array($vRes);
	if ($vRes['nb'] > 0)
		cpg_die(ERROR, $lang_jupload_php['error_album_already_exists'], __FILE__, __LINE__);

	$query = " 
		UPDATE {$CONFIG['TABLE_ALBUMS']} 
		SET title='" . addslashes($album_name) . "', 
			description='" . addslashes($album_description) . "' 
		WHERE aid=$album 
		LIMIT 1
	";
	cpg_db_query($query);
	jupload_message_success("upload_page", $album, $category);
} //update_album

/**
 * displays a string description[album_id] = 'album_desc';  on the standard output.
 * This is used to store all album descriptions in a javascript array. 
 * See below.
 */
function echo_jsarray_description($album_list) {
	foreach ($album_list as $a) {
		echo ("  description[{$a['aid']}] = '" . prepare_js_string($a['description']) . "';\n");
	} //foreach
} //echo_jsarray_description

/**
 * This function initialize the relevant information, so that the user may change of category and album
 * without resubmitting the form.
 * Submitting is bad as ... it reloads the applet, erasing any work done by the user (as selecting and rotating
 * pictures).
 */
function echo_jsarray_category_albums() {
	//This function put all he site arborescence in the JavaScript. It's allowed only in GALLERY_ADMIN_MODE.
	if (!GALLERY_ADMIN_MODE) {
		//This should not arrive, as this function is only called if we are in this mode, so this is just a 
		//double-check and I directly call the cpg_die method. 
		cpg_die("Internal error in echo_jsarray_category_albums");
	}

	$sql = "SELECT category, aid, title " .
	"FROM {$CONFIG['TABLE_ALBUMS']} " .
	"WHERE parent = '$parent' " .
	"ORDER BY pos";
	$result = cpg_db_query($sql);
	$rowset = cpg_db_fetch_rowset($result);
	foreach ($rowset as $subcat) {
		if (!isset ($next_indice[$rowset['category']])) {
			$next_indice[$rowset['category']] = 0;
		} else {
			$next_indice[$rowset['category']] += 1;
		}
		echo ("category_to_album[${rowset['category']}][" . $next_indice[$rowset['category']] . "]  =  ${rowset['aid']};\n");
		echo ("album_title[{$rowset['aid']}] = '" . prepare_js_string($rowset['title']) . "';\n");
	} //foreach
} //echo_jsarray_category_albums

///////////////////////////////////////////////////////////////////////
/////////////////   ALBUM MANAGEMENT (if post data)  //////////////////
///////////////////////////////////////////////////////////////////////

switch ($action) {
	case 'update_album' :
		update_album($album, $album_name, $album_description, $category);
		break;
	case 'create_album';
		create_album($album, $album_name, $album_description, $category);
		break;
}

///////////////////////////////////////////////////////////////////////
/////////////////   GENERATING THE HTML CONTENT    ////////////////////
///////////////////////////////////////////////////////////////////////

pageheader($lang_jupload_php['link_title']);

///////////////////////////////////////////////////////////////////////
//First part : some local javascript
///////////////////////////////////////////////////////////////////////

//Initialization, let's prepare the creation of the desc array : what's the bigguest album number ?
$max = 0;
foreach ($user_albums_list as $a) {
	if ($a['aid'] >= $max) {
		$max = $a['aid'] + 1;
	}
} //foreach
foreach ($public_albums_list as $a) {
	if ($a['aid'] >= $max) {
		$max = $a['aid'] + 1;
	}
} //foreach

//Some error messages, that can be displayed from the javascript functions.
//addslashes do not do the same work depending on both magic_quotes_gpc and magic_quotes_sybase parameter.
//So, we replace manually any slash in the text. 
$error_select_album = str_replace('\'', '\\\'', $lang_jupload_php['error_select_album']);	
$error_album_name = str_replace('\'', '\\\'', $lang_jupload_php['error_album_name']);
$error_select_category = str_replace('\'', '\\\'', $lang_albmgr_php['select_category']);
$error_create_album_in_this_category = str_replace('\'', '\\\'', $lang_errors['perm_denied']);



//The controls to run deppends whether the user is the gallery or not.
if (GALLERY_ADMIN_MODE) {
	$js_checkFunctions = <<<EOS
		//The admin may create/update albums in any category.
		function check_createAlbumIsAllowed() {
			return true;	
		}
EOS
;
} else {
	$userCategory = FIRST_USER_CAT + USER_ID;
	$js_checkFunctions = <<<EOS
		//Non-admin users may only create/update albums in their own gallery.
		function check_createAlbumIsAllowed() {
			if (document.form_category.category.value == $userCategory) {
				return true;
			}
			return false;
		}
EOS
;
}

echo <<<EOS
  <script language="javascript" src="plugins/jupload/resources/anaa.js">
  </script>
  
  <script language="javascript"> 

$js_checkFunctions
  
  //Called when the user changes of category 
  function ajax_load_a_category() {
  	//First: display the wait animated gif.
	document.images.album_wait.width = 16;
	document.images.album_wait.height = 16;

  	//The dummy parameter is necessary, as the "?nocache=13124" will be added to the URL. 
  	var y = AARead(
				"index.php?file=jupload/jupload&action=ajax_list_album_of_a_category&category="
					+ document.form_category.category.value
					+ "&dummy=1", 
				ajax_after_load_a_category, 
				document.getElementById('span_ajax_test')
				);

  }
  
  function ajax_after_load_a_category(data, element) {
		//element.innerHTML = data;
		//KO: nothing happens.alert('texte:' + texte);  (texte is not intialized)
		//KO: the call to the function salut(), coming in the ajax script, doesn't work
		//So, we now receive 'pur' Javascript:
		//alert(data);
		eval(data);
		
		//Let's manage the unselection of the album
		onAlbumChange();
		
	  	//To finish: mask the wait animated gif.
		document.images.album_wait.width = 0;
		document.images.album_wait.height = 0;
	}

	function submitForm(url, storageID, viewedID) { 
		var y = AALoadHTML(url, processHTML, storageID, viewedID);
	} 

  
	//Check if an album is selected. 
	//The first line may be the 'select an album'
  
	//What should we do, when the user selects another album ?
	function onAlbumChange() {
		if (document.form_album.album.value == '') {
			//First: clear the albumID in the applet.
			document.applets['JUploadApplet'].setProperty('albumId', '');
			//Then: the input fields on the HTML form
			document.form_album.album_name.value = '';
			document.form_album.album_description.value = '';
		} else {
			//First: set the albumID in the applet.
			document.applets['JUploadApplet'].setProperty('albumId', document.form_album.album.value);
			//Then: the input fields on the HTML form
			document.form_album.album_name.value = document.form_album.album.options[document.form_album.album.selectedIndex].text;
			document.form_album.album_description.value = description[document.form_album.album.value];
		}
	}
	
	function juploadAddPicture() {
		if (document.form_album.album.value == '') {
			alert(unescape('{$error_select_album}'));
		} else {
			window.location='#applet';
		}
		//In any case, the  submit must be refused.
		return false;
	}

	function juploadCreateAlbum() {
		if (!check_createAlbumIsAllowed()) {
			alert(unescape('{$error_create_album_in_this_category} (' 
				+ '{$lang_catmgr_php['category']}: '
				+  document.form_category.category.options[document.form_category.category.selectedIndex].text
				+ ')'))
				return false;
		} else if (document.form_category.category.selectedIndex < 0) {
			//No selection in the category list.
			alert(unescape('{$error_select_category}'));
			return false;
		} else if (document.form_album.album_name.value == '') {
			alert(unescape('{$error_album_name}'));
			return false;
		} else {	
			document.form_album.action.value = 'create_album';
			return true;
		}	    
	}
	
	function juploadUpdateAlbum() {
		if (!check_createAlbumIsAllowed()) {
			alert(unescape('{$error_create_album_in_this_category} (' 
				+ '{$lang_catmgr_php['category']}: '
				+  document.form_category.category.options[document.form_category.category.selectedIndex].text
				+ ')'))
				return false;
		} else if (document.form_album.album.value == '') {
			alert(unescape('{$error_select_album}'));
			return  false;
		} else if (document.form_album.album_name.value == '') {
			alert(unescape('{$error_album_name}'));
			return false;
		} else {
			document.form_album.action.value = 'update_album';
			return true;
		}
	}

	//Function coming from standard upload: basic limitation of the max ength for a textarea. 
    function textCounter(field, maxlimit) {
            if (field.value.length > maxlimit) // if too long...trim it!
            field.value = field.value.substring(0, maxlimit);
    }
    
  //Creation of the album description aray.
  description = new Array($max);

EOS
;

//Initialization, let's prepare the creation of the desc array
$max = 0;
echo_jsarray_description($user_albums_list);
echo_jsarray_description($public_albums_list);

//If the page is refreshed, the navigator may keep the current album selection in the list,
//but the album is not selected in the applet. Let's deselect the album in the list, when running this
//page. I'll find a better solution, later.
echo<<<EOS
  </script>

EOS
;

///////////////////////////////////////////////////////////////////////
//Second part : the selection of the category or album
///////////////////////////////////////////////////////////////////////

//Let's start the real page content.
starttable("100%", $lang_jupload_php['select_album'], 2);

//Some lobying message about translation.
if (!$bJuploadTranslactionExist) {
	form_statement('<B><I>The JUpload translation for this language doesn\'t exist. </B>' . 'If you want to create it, please go to the <a href="http://etienne.sf.free.fr/wiki/doku.php?id=jupload_translation">JUpload translation page</a>.</I>');
}
form_statement($lang_jupload_php['album_presentation']);

///////////////////////////////////////////////////////////////////////
// The user must first choose the category.
if ($distinctListForCategoryAndAlbum) {
	j_get_subcat_data(0);
	form_html('<form method="get" ' 
			. 'name="form_category" ' 
			. "action='${JUPLOAD_VAR['SELF']}'>" 
			. "<input type='hidden' name='file' value='jupload/jupload'>" 
			. "<input type='hidden' name='action' value='upload_page'>" 
			. j_cat_list_box() 
			. '</form>', 
		$lang_cat_list['category']);
}

//////////////////////////////////////////////////////////////////////////
//Start of the main HTML form.
form_html("\n<form method='post' name='form_album' enctype='multipart/form-data' action='index.php?file=jupload/jupload&action=upload_page'>" .
"\n<input type='hidden' name='category' value='$category'>");

if (isset ($category)) {
	form_cat_alb_list_box($category, $album, $lang_jupload_php['album'], "album", 'onChange="onAlbumChange()"');
}
hidden_input('action', 'no action');

//Now, the album title and description input areas... if allowed to 
//(see albumShowEditFields configuration parameter description)
if ($JUPLOAD_CONFIG['albumShowEditFields'] || USER_ADMIN_MODE || GALLERY_ADMIN_MODE) {
	text_box_input($lang_jupload_php['album_name'], 'album_name', 255, 1, (($album > 0) ? $album_name : ''));
	text_area_input($lang_jupload_php['album_description'], 'album_description', 2000, (($album > 0) ? $album_description : ''));
} else {
	//Otherwise, we write fake album_name and album_description, so that javacript functions work as before:
	//these fields are filled when the user selects an album, or when the album list is filled by javascript
	//functions.
	form_hidden('album_name', (($album > 0) ? $album_name : ''));
	form_hidden('album_description', (($album > 0) ? $album_description : ''));
}
$submit_buttons = array (
	array (
		'value' => $lang_jupload_php['add_pictures'],
		'js' => 'onClick="return juploadAddPicture()"'
	)
);
//In USER_ADMIN_MODE, the user may create albums: the creation will be in its own gallery.
//In GALLERY_ADMIN_MODE, the user must have choosen a category before creating a new album.
//
//The buttons are also invalidated in javascript (with the ajax category albums loading)
if (USER_ADMIN_MODE || GALLERY_ADMIN_MODE) {
	$submit_buttons[] = array (
		'value' => $lang_jupload_php['button_update_album'],
		'js' => 'onClick="return juploadUpdateAlbum()"'
	);
	$submit_buttons[] = array (
		'value' => $lang_jupload_php['button_create_album'],
		'js' => 'onClick="return juploadCreateAlbum()"'
	);
}
submit_button($submit_buttons);
//Let's display to the user how much of his/her quota he/she is using.
jupload_startquotadata();

endtable();
echo ("</form>");


///////////////////////////////////////////////////////////////////////
//Third part : the upload applet
///////////////////////////////////////////////////////////////////////

starttable("100%", '<a name="applet"></a>' . $lang_jupload_php['add_pictures'], 2);

form_label($lang_jupload_php['max_upload_size'], $maxFileSize / 1000);
form_statement($lang_jupload_php['upload_presentation']);

//////////////////////////////////////////////////////////////////////////
//A form, to allow the user to enter picture data once, for all pictures that will be uploaded.
//form_html("\n<form method='post' name='picture_data'>");
//Now, the album title and description input areas.
$text = $lang_jupload_php['picture_data_explanation'];
$section = 0;
echo <<<EOS
	<tr>
		<td class="tableh2" colspan="2" onclick="show_section('section{$section}')">
			<span style="cursor:pointer">
				<img src="images/descending.gif" border="0" width="9" height="9" alt="" 
					 title="{$lang_admin_php['click_expand']}" /> 
				<b>$text</b>
			</span>
		</td>
	</tr>
EOS
;
			//text_box_input($lang_editpics_php['title'], 'title', 255, 1, '');

echo <<<EOS
	<tr>
		<td colspan="2">
  <form method='post' name='picture_data'>
  <table align="center" cols="2" width="100%" cellspacing="1" cellpadding="0" class="maintable" 
  		 id="section{$section}" border="0">
                <tr>
                		<!-- 
                			A dummy line, that containts a dummy column for firefox. Otherwise, the
                			text and inut fields use only 40% of the total widht.
                			If any one has a good solution ...
                		-->
                        <td width="50%" class="tableb"></td>
                        <td width="50%" class="tableb" valign="top"></td>
                        <td class="tableb" width="10%"> </td> 
        </tr>
EOS
;

			text_box_input($lang_editpics_php['title'], 'title', 255, 1, '');
			text_area_input($lang_editpics_php['desc'], 'caption', 2000, '');
			text_box_input($lang_editpics_php['keywords'], 'keywords', 255, 1, '');
			if ($CONFIG['user_field1_name'] != '') {
				text_box_input($CONFIG['user_field1_name'], 'user1', 255, 1, '');
			}
			if ($CONFIG['user_field2_name'] != '') {
				text_box_input($CONFIG['user_field2_name'], 'user2', 255, 1, '');
			}
			if ($CONFIG['user_field3_name'] != '') {
				text_box_input($CONFIG['user_field3_name'], 'user3', 255, 1, '');
			}
			if ($CONFIG['user_field4_name'] != '') {
				text_box_input($CONFIG['user_field4_name'], 'user4', 255, 1, '');
			}

echo <<<EOS
  </table>
  </form>
		</td>
	</tr>
EOS
;
 
/*
 * Below : use of the standard applet tag for the JUpload real applet. A dummy emptyApplet is generated 
 * before (see here upper). This applet has been 'converted', so that the navigator asks the user to 
 * install Java, if it's not already done.  
 */
form_statement(<<<EOS
  	<CENTER>
$emptyConvertedApplet
<APPLET CODE="wjhk.jupload2.JUploadApplet" ARCHIVE="$jarPath" WIDTH="$appletWidth" HEIGHT="$appletHeight" NAME="JUploadApplet" MAYSCRIPT>
	<PARAM NAME="albumId" VALUE="$album">
	<PARAM NAME="allowedFileExtensions" VALUE="${CONFIG['allowed_file_extensions']}">
	<PARAM NAME="allowHttpPersistent" VALUE="false">
	<PARAM NAME="browsingDirectory" VALUE="${JUPLOAD_CONFIG['browsingDirectory']}">
	<PARAM NAME="debugLevel" VALUE="$debugLevel">
	<PARAM NAME="fileChooserIconFromFileContent" VALUE="${JUPLOAD_CONFIG['fileChooserIconFromFileContent']}">
	<PARAM NAME="fileChooserIconSize" VALUE="${JUPLOAD_CONFIG['fileChooserIconSize']}">
	<PARAM NAME="formData" VALUE="picture_data">
	<PARAM NAME="httpUploadParameterName" VALUE="$httpUploadParameterName">
	<PARAM NAME="httpUploadParameterType" VALUE="$httpUploadParameterType">
	<PARAM NAME="lang" VALUE="$localLang">
	<PARAM NAME="highQualityPreview" VALUE="$highQualityPicture">
	<PARAM NAME="maxFileSize" VALUE="$maxFileSize">
	<PARAM NAME="maxChunkSize" VALUE="$maxChunkSize">
	<PARAM NAME="maxPicHeight" VALUE="$maxNonTransformedPictureSize">
	<PARAM NAME="maxPicWidth" VALUE="$maxNonTransformedPictureSize">
	<PARAM NAME="nbFilesPerRequest" VALUE="1">
	<PARAM NAME="pictureCompressionQuality" VALUE="${JUPLOAD_CONFIG['pictureCompressionQuality']}">
	<PARAM NAME="pictureTransmitMetadata"  VALUE="${JUPLOAD_CONFIG['pictureTransmitMetadata']}">
	<PARAM NAME="readCookieFromNavigator" VALUE="true">
	<PARAM NAME="realMaxPicHeight" VALUE="${CONFIG['max_upl_width_height']}">
	<PARAM NAME="realMaxPicWidth" VALUE="${CONFIG['max_upl_width_height']}">
	<PARAM NAME="postURL" VALUE="$URL">
	<PARAM NAME="showLogWindow" VALUE="$showLogWindow">
	<PARAM NAME="uploadPolicy" VALUE="CoppermineUploadPolicy">
$specificHeaders
$paramUrlToSendErrorTo
<!-- End of applet parameters -->

Java 1.5 or higher plugin required.

</APPLET>
   </CENTER>

EOS
);

form_statement('<CENTER><A HREF="http://forum.coppermine-gallery.net/index.php/board,100.0.html">'
		. "JUpload plugin for Coppermine</a> v ${JUPLOAD_CONFIG['version']}</CENTER>");

endtable();

//Some controls, to be done at the end of the page generation.
echo ("
<script language='javascript'>
//First: let's hide the area where the user can entre title, caption (...) for uploaded pictures.
onload = hideall;
//Let's try to display some debug info.
try {
	document.applets['JUploadApplet'].displayInfo('JUpload plugin for coppermine version ${JUPLOAD_CONFIG['version']}');
} catch (e) {
	// We just ignore this error.
}
</script>
");

pagefooter();
