<?php 
/*************************
  Coppermine Photo Gallery
  ************************
  Copyright (c) 2003-2008 Dev Team
  v1.1 originally written by Gregory DEMAR

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 3
  as published by the Free Software Foundation.
  
  ********************************************
  Coppermine version: 1.4.19
  $HeadURL: https://coppermine.svn.sourceforge.net/svnroot/coppermine/trunk/cpg1.4.x/themes/classic/theme.php $
  $Revision: 4392 $
  $Author: gaugau $
  $Date: 2008-04-16 09:25:35 +0200 (Mi, 16 Apr 2008) $
**********************************************/

//define('THEME_IS_XHTML10_TRANSITIONAL',1);
define('THEME_HAS_FILM_STRIP_GRAPHIC', 1); 

// These parameters overide what the user inputs in the Configuration setup to prevent the theme from breaking.
$CONFIG['max_film_strip_items'] = 5; //overrides the number of thumbnails.
$CONFIG['thumbcols'] = 4; //overrides the number of columns for thumbnails.
$CONFIG['main_table_width'] = '100%'; //overrides the Width of the main table (pixels or %).
$CONFIG['picture_table_width'] = '100%'; //overrides the Width of the table for file display (pixels or %).
$CONFIG['album_list_cols'] = 2; // sets "Number of columns for the album list = 2"
$CONFIG['first_level'] = 1; //sets "Show first level album thumbnails in categories = no".

// HTML template for template sys_menu spacer
$template_sys_menu_spacer ="&#8226;";

// HTML template for sub_menu
$template_sub_menu = <<<EOT
<div align="center">
<!-- BEGIN custom_link -->
     <a href="{CUSTOM_LNK_TGT}" title="{CUSTOM_LNK_TITLE}"><span>{CUSTOM_LNK_LNK}</span></a> &#8226;
<!-- END custom_link -->
<!-- BEGIN album_list -->
     <a href="{ALB_LIST_TGT}" title="{ALB_LIST_TITLE}"><span>{ALB_LIST_LNK}</span></a> &#8226;
<!-- END album_list -->
	<a href="{LASTUP_TGT}"><span>{LASTUP_LNK}</span></a> &#8226;
	<a href="{LASTCOM_TGT}"><span>{LASTCOM_LNK}</span></a> &#8226;
	<a href="{TOPN_TGT}"><span>{TOPN_LNK}</span></a> &#8226;
	<a href="{TOPRATED_TGT}"><span>{TOPRATED_LNK}</span></a> &#8226;
	<a href="{FAV_TGT}"><span>{FAV_LNK}</span></a> &#8226;
	<a href="{SEARCH_TGT}"><span>{SEARCH_LNK}</span></a>
</div>
EOT;

// HTML template for gallery admin menu
$template_gallery_admin_menu = <<<EOT

                <div align="center">
                <table cellpadding="0" cellspacing="1">
                        <tr>
<!-- BEGIN admin_approval -->
                                <td class="admin_menu" id="admin_menu_anim"><a href="editpics.php?mode=upload_approval" title="{UPL_APP_TITLE}">{UPL_APP_LNK}</a></td>
<!-- END admin_approval -->
                                <td class="admin_menu"><a href="admin.php" title="{ADMIN_TITLE}">{ADMIN_LNK}</a></td>
                                <td class="admin_menu"><a href="catmgr.php" title="{CATEGORIES_TITLE}">{CATEGORIES_LNK}</a></td>
                                <td class="admin_menu"><a href="albmgr.php{CATL}" title="{ALBUMS_TITLE}">{ALBUMS_LNK}</a></td>
                                <td class="admin_menu"><a href="groupmgr.php" title="{GROUPS_TITLE}">{GROUPS_LNK}</a></td>
                                <td class="admin_menu"><a href="usermgr.php" title="{USERS_TITLE}">{USERS_LNK}</a></td>
                                <td class="admin_menu"><a href="banning.php" title="{BAN_TITLE}">{BAN_LNK}</a></td>
                                <td class="admin_menu"><a href="reviewcom.php" title="{COMMENTS_TITLE}">{COMMENTS_LNK}</a></td>
<!-- BEGIN log_ecards -->
                                <td class="admin_menu"><a href="db_ecard.php" title="{DB_ECARD_TITLE}">{DB_ECARD_LNK}</a></td>
<!-- END log_ecards -->
                                <td class="admin_menu"><a href="picmgr.php" title="{PICTURES_TITLE}">{PICTURES_LNK}</a></td>
                                <td class="admin_menu"><a href="searchnew.php" title="{SEARCHNEW_TITLE}">{SEARCHNEW_LNK}</a></td>
                                <td class="admin_menu"><a href="util.php" title="{UTIL_TITLE}">{UTIL_LNK}</a></td>
                                <td class="admin_menu"><a href="profile.php?op=edit_profile" title="{MY_PROF_TITLE}">{MY_PROF_LNK}</a></td>
<!-- BEGIN documentation -->
                                <td class="admin_menu"><a href="{DOCUMENTATION_HREF}" title="{DOCUMENTATION_TITLE}" target="cpg_documentation">{DOCUMENTATION_LNK}</a></td>
<!-- END documentation -->
                        </tr>
                </table>
                </div>

EOT;

// HTML template for user admin menu
$template_user_admin_menu = <<<EOT

                <div align="center">
                <table cellpadding="0" cellspacing="1">
                        <tr>
                                <td class="admin_menu"><a href="albmgr.php" title="{ALBMGR_TITLE}">{ALBMGR_LNK}</a></td>
                                <td class="admin_menu"><a href="modifyalb.php" title="{MODIFYALB_TITLE}">{MODIFYALB_LNK}</a></td>
                                <td class="admin_menu"><a href="profile.php?op=edit_profile" title="{MY_PROF_TITLE}">{MY_PROF_LNK}</a></td>
                                <td class="admin_menu"><a href="picmgr.php" title="{PICTURES_TITLE}">{PICTURES_LNK}</a></td>
                        </tr>
                </table>
                </div>

EOT;

// HTML template for the breadcrumb
$template_breadcrumb = <<<EOT
<!-- BEGIN breadcrumb -->
	<table class="tablebg breadcrumb" width="100%" cellspacing="0" cellpadding="0" style="margin-top: 5px;">
	<tr>
		<td class="row1">
			<p class="breadcrumbs">
			
          {BREADCRUMB}
		  
            </p>
		</td>
	</tr>
	</table>
<!-- END breadcrumb -->
<!-- BEGIN breadcrumb_user_gal -->
	<tr>
		<td class="row1">
			<p class="breadcrumbs">
			
                <table width="100%" cellpadding="0" cellspacing="0" border="0">
                <tr>
                        <td align="left"><span class="statlink"><b>{BREADCRUMB}</b></span></td>
                        <td align="right"><span class="statlink"><b>{STATISTICS}</b></span></td>
                </tr>
                </table>
		  
            </p>
		</td>
	</tr>
	</table>
<!-- END breadcrumb_user_gal -->

EOT;

// HTML template for title row of the thumbnail view (album title + sort options)
$template_thumb_view_title_row = <<<EOT

	<table width="100%" cellpadding="0" cellspacing="0" style="margin-top: -20px;">
	<tr>
			<td width="100%" class="statlink"><h2>{ALBUM_NAME}</h2></td>
			<td><img src="images/spacer.gif" width="1" alt="" /></td>
			<td class="sortorder_cell">
					<table cellpadding="0" cellspacing="0">
					<tr>
							<td class="sortorder_options">{TITLE}</td>
							<td class="sortorder_options"><span class="statlink"><a href="thumbnails.php?album={AID}&amp;page={PAGE}&amp;sort=ta" title="{SORT_TA}">&nbsp;+&nbsp;</a></span></td>
							<td class="sortorder_options"><span class="statlink"><a href="thumbnails.php?album={AID}&amp;page={PAGE}&amp;sort=td" title="{SORT_TD}">&nbsp;-&nbsp;</a></span></td>
					</tr>
					<tr>
							<td class="sortorder_options">{NAME}</td>
							<td class="sortorder_options"><span class="statlink"><a href="thumbnails.php?album={AID}&amp;page={PAGE}&amp;sort=na" title="{SORT_NA}">&nbsp;+&nbsp;</a></span></td>
							<td class="sortorder_options"><span class="statlink"><a href="thumbnails.php?album={AID}&amp;page={PAGE}&amp;sort=nd" title="{SORT_ND}">&nbsp;-&nbsp;</a></span></td>
					</tr>
					<tr>
							<td class="sortorder_options">{DATE}</td>
							<td class="sortorder_options"><span class="statlink"><a href="thumbnails.php?album={AID}&amp;page={PAGE}&amp;sort=da" title="{SORT_DA}">&nbsp;+&nbsp;</a></span></td>
							<td class="sortorder_options"><span class="statlink"><a href="thumbnails.php?album={AID}&amp;page={PAGE}&amp;sort=dd" title="{SORT_DD}">&nbsp;-&nbsp;</a></span></td>
					</tr>
					<tr>
							<td class="sortorder_options">{POSITION}</td>
							<td class="sortorder_options"><span class="statlink"><a href="thumbnails.php?album={AID}&amp;page={PAGE}&amp;sort=pa" title="{SORT_PA}">&nbsp;+&nbsp;</a></span></td>
							<td class="sortorder_options"><span class="statlink"><a href="thumbnails.php?album={AID}&amp;page={PAGE}&amp;sort=pd" title="{SORT_PD}">&nbsp;-&nbsp;</a></span></td>
					</tr>
					</table>
			</td>
	</tr>
	</table>

EOT;

// HTML template for thumbnails display
$template_thumbnail_view = <<<EOT

<!-- BEGIN header -->
        <tr>
<!-- END header -->
<!-- BEGIN thumb_cell -->
        <td valign="top" class="thumbnails" width ="{CELL_WIDTH}" align="center">
		
<table class="tablebg" cellspacing="0" width="100%" style="margin-bottom: 5px;">
  <tr>
    <td valign="top">
      <caption style="margin-bottom: -5px;">
      <div class="cap-left">
        <div class="cap-right">&nbsp;&nbsp;</div>
      </div>
      </caption>
    </td>
  </tr>
  <tr class="row1">
    <td class="row1">
    <table class="tablebg" cellspacing="1" width="100%">
        <tr class="row1">
          <td align="center" valign="top">
		
                <table width="100%" cellpadding="0" cellspacing="0">
                        <tr>
                                <td align="center">
                                        <a href="{LINK_TGT}">{THUMB}<br /></a>
                                        {CAPTION}
                                        {ADMIN_MENU}
                                </td>
                        </tr>
                </table>
           
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>

       </td>
<!-- END thumb_cell -->
<!-- BEGIN empty_cell -->
                <td valign="top" class="thumbnails" align="center">&nbsp;</td>
<!-- END empty_cell -->
<!-- BEGIN row_separator -->
        </tr>
        <tr>
<!-- END row_separator -->
<!-- BEGIN footer -->
        </tr>
<!-- END footer -->
<!-- BEGIN tabs -->
        <tr>
                <td colspan="{THUMB_COLS}" style="padding: 0px;">
                        <table width="100%" cellspacing="0" cellpadding="0">
                                <tr>
                                       {TABS}
                                </tr>
                        </table>
                </td>
        </tr>
<!-- END tabs -->
<!-- BEGIN spacer -->
        <img src="images/spacer.gif" width="1" height="7" border="" alt="" /><br />
<!-- END spacer -->

EOT;

// HTML template for the image rating box
$template_image_rating = <<<EOT
<table class="tablebg" cellspacing="0" width="100%" style="margin-bottom: 5px;">
  <tr>
    <td valign="top">
      <caption style="margin-bottom: -5px;">
      <div class="cap-left">
        <div class="cap-right"><b>{TITLE}</b> {VOTES}</div>
      </div>
      </caption>
    </td>
  </tr>
  <tr class="row1">
    <td class="row1">
    <table class="tablebg" cellspacing="1" width="100%">
        <tr class="row1">
          <td align="center" valign="top">
          
<table align="center" width="{WIDTH}" cellspacing="1" cellpadding="0" class="maintable">
        <tr>
                <td class="tableb_compact" width="17%" align="center"><a href="{RATE0}" title="{RUBBISH}" rel="nofollow"><img src="{LOCATION}images/rating0.gif" border="0" alt="{RUBBISH}" /><br /></a></td>
                <td class="tableb_compact" width="17%" align="center"><a href="{RATE1}" title="{POOR}" rel="nofollow"><img src="{LOCATION}images/rating1.gif" border="0" alt="{POOR}" /><br /></a></td>
                <td class="tableb_compact" width="17%" align="center"><a href="{RATE2}" title="{FAIR}" rel="nofollow"><img src="{LOCATION}images/rating2.gif" border="0" alt="{FAIR}" /><br /></a></td>
                <td class="tableb_compact" width="17%" align="center"><a href="{RATE3}" title="{GOOD}" rel="nofollow"><img src="{LOCATION}images/rating3.gif" border="0" alt="{GOOD}" /><br /></a></td>
                <td class="tableb_compact" width="17%" align="center"><a href="{RATE4}" title="{EXCELLENT}" rel="nofollow"><img src="{LOCATION}images/rating4.gif" border="0" alt="{EXCELLENT}" /><br /></a></td>
                <td class="tableb_compact" width="17%" align="center"><a href="{RATE5}" title="{GREAT}" rel="nofollow"><img src="{LOCATION}images/rating5.gif" border="0" alt="{GREAT}" /><br /></a></td>
        </tr>
</table>
          
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>
EOT;

// HTML template for the display of comments
$template_image_comments = <<<EOT
<table class="tablebg" cellspacing="0" width="100%" style="margin-bottom: 5px;">
  <tr>
    <td valign="top">
      <caption style="margin-bottom: -5px;">
      <div class="cap-left">
        <div class="cap-right">&nbsp;&nbsp;</div>
      </div>
      </caption>
    </td>
  </tr>
  <tr class="row1">
    <td class="row1">
    <table class="tablebg" cellspacing="1" width="100%">
        <tr class="row1">
          <td align="center" valign="top">
          
<table align="center" width="{WIDTH}" cellspacing="1" cellpadding="0" class="maintable">

        <tr>
                <td>
                        <table width="100%" cellpadding="0" cellspacing="0">
                           <tr>
                                <td class="tableh2_compact" nowrap="nowrap">
                                        <b>{MSG_AUTHOR}</b><a name="comment{MSG_ID}"></a>&nbsp;
<!-- BEGIN ipinfo -->
                                                                                 ({IP})
<!-- END ipinfo -->
</td>


                                <td class="tableh2_compact" align="right" width="100%">
<!-- BEGIN report_comment_button -->
     <a href="report_file.php?pid={PID}&amp;msg_id={MSG_ID}&amp;what=comment" title="{REPORT_COMMENT_TITLE}"><img src="images/report.gif" width="16" height="16" border="0" align="middle" alt="{REPORT_COMMENT_TITLE}" /></a>
<!-- END report_comment_button -->


<!-- BEGIN buttons -->
                                        <a href="javascript:;" onclick="blocking('cbody{MSG_ID}','', 'block'); blocking('cedit{MSG_ID}','', 'block'); return false;" title="{EDIT_TITLE}"><img src="images/edit.gif" border="0" align="middle" /></a>
                                        <a href="delete.php?msg_id={MSG_ID}&what=comment"  onclick="return confirm('{CONFIRM_DELETE}');"><img src="images/delete.gif" border="0" align="middle" /></a>
<!-- END buttons -->
                                </td>
                                <td class="tableh2_compact" align="right" nowrap="nowrap">
                                        <span class="comment_date">[{MSG_DATE}]</span>
                                </td></tr>
                        </table>
                </td>
        </tr>
        <tr>
                <td class="tableb_compact">
                        <div id="cbody{MSG_ID}" style="display:block">
                                {MSG_BODY}
                        </div>
                        <div id="cedit{MSG_ID}" style="display:none">
<!-- BEGIN edit_box_smilies -->
                                <table width="100%" cellpadding="0" cellspacing="0">

                                                <form name="f{MSG_ID}" method="POST" action="db_input.php">
                                                <input type="hidden" name="event" value="comment_update" />
                                                <input type="hidden" name="msg_id" value="{MSG_ID}" />
                                                <tr>
                                                <td>
                                                   <input type="text" name="msg_author" value="{MSG_AUTHOR}" class="textinput" size="25" />
                                                </td><td>
                                                </tr>
                                                <tr>
                                                <td width="80%">
                                                        <textarea cols="40" rows="2" class="textinput" name="msg_body" onselect="storeCaret_f{MSG_ID}(this);" onclick="storeCaret_f{MSG_ID}(this);" onkeyup="storeCaret_f{MSG_ID}(this);" style="width: 100%;">{MSG_BODY_RAW}</textarea>
                                                </td>
                                                <td class="tableb_compact">
                                                </td>
                                                <td>
                                                        <input type="submit" class="comment_button" name="submit" value="{OK}" />
                                                </td>
                                                </form>
                                        </tr>
                                        <tr>
                                                <td colspan="3"><img src="images/spacer.gif" width="1" height="2" /><br /></td>
                                        </tr>
                                </table>
                                {SMILIES}
<!-- END edit_box_smilies -->
<!-- BEGIN edit_box_no_smilies -->
                                <table width="100%" cellpadding="0" cellspacing="0">
                                        <tr>
                                                <form name="f{MSG_ID}" method="POST" action="db_input.php">
                                                <input type="hidden" name="event" value="comment_update" />
                                                <input type="hidden" name="msg_id" value="{MSG_ID}" />
                                                <td>
                                                <input type="text" name="msg_author" value="{MSG_AUTHOR}" class="textinput" size="25" />
                                                </td>
                                        </tr>
                                        <tr>
                                                <td width="100%">
                                                        <textarea cols="40" rows="2" class="textinput" name="msg_body" style="width: 100%;">{MSG_BODY_RAW}</textarea>
                                                </td>
                                                <td class="tableb_compact">
                                                </td>
                                                <td>
                                                        <input type="submit" class="comment_button" name="submit" value="{OK}" />
                                                </td>
                                                </form>
                                        </tr>
                                        <tr>
                                                <td colspan="3"><img src="images/spacer.gif" width="1" height="2" /><br /></td>
                                        </tr>
                                </table>
<!-- END edit_box_no_smilies -->
                        </div>
                </td>
        </tr>
</table>
          
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>
EOT;

// HTML template for the form to add comments
$template_add_your_comment = <<<EOT
        <form method="post" name="post" action="db_input.php">
		
<table class="tablebg" cellspacing="0" width="100%" style="margin-bottom: 5px;">
  <tr>
    <td valign="top">
      <caption style="margin-bottom: -5px;">
      <div class="cap-left">
        <div class="cap-right">{ADD_YOUR_COMMENT}</div>
      </div>
      </caption>
    </td>
  </tr>
  <tr class="row1">
    <td class="row1">
    <table class="tablebg" cellspacing="1" width="100%">
        <tr class="row1">
          <td align="center" valign="top">
          
                <table align="center" width="{WIDTH}" cellspacing="1" cellpadding="0" class="maintable">
                        <tr>
                <td colspan="1">
                        <table width="100%" cellpadding="0" cellspacing="0">

<!-- BEGIN user_name_input -->
                                                        <tr>
                                                                <td class="tableb_compact">
                                        {NAME}
                                </td>
                                <td class="tableb_compact">
                                        <input type="text" class="textinput" name="msg_author" size="10" maxlength="20" value="{USER_NAME}" />
                                </td>
<!-- END user_name_input -->
<!-- BEGIN input_box_smilies -->
                                <td class="tableb_compact">
                                {COMMENT}
                                                                </td>
                                <td width="100%" class="tableb_compact">
                                <input type="text" class="textinput" id="message" name="msg_body" onselect="storeCaret_post(this);" onclick="storeCaret_post(this);" onkeyup="storeCaret_post(this);" maxlength="{MAX_COM_LENGTH}" style="width: 100%;" />
                                                                </td>
<!-- END input_box_smilies -->
<!-- BEGIN input_box_no_smilies -->
                                <td class="tableb_compact">
                                {COMMENT}
                                                                </td>
                                <td width="100%" class="tableb_compact">
                                <input type="text" class="textinput" id="message" name="msg_body"  maxlength="{MAX_COM_LENGTH}" style="width: 100%;" />
                                </td>
<!-- END input_box_no_smilies -->
                                <td class="tableb_compact">
                                <input type="hidden" name="event" value="comment" />
                                <input type="hidden" name="pid" value="{PIC_ID}" />
                                <input type="submit" class="comment_button" name="submit" value="{OK}" />
                                </td>
                                                        </tr>
                        </table>
                </td>
        </tr>
<!-- BEGIN smilies -->
        <tr>
                <td width="100%" class="tableb_compact">
                        {SMILIES}
                </td>
        </tr>
<!-- END smilies -->
                </table>
          
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>
				
        </form>
EOT;

// HTML template for intermediate image display
if (!isset($template_display_media)) { //{THEMES}
$template_display_media = <<<EOT
                <td align="center" valign="top" height="{CELL_HEIGHT}" style="padding: 0px;">
				
<table class="tablebg" cellspacing="0" width="100%" style="margin-bottom: 5px;">
  <tr>
    <td valign="top">
      <caption style="margin-bottom: -5px;">
      <div class="cap-left">
        <div class="cap-right">&nbsp;&nbsp;</div>
      </div>
      </caption>
    </td>
  </tr>
  <tr class="row1">
    <td class="row1">
    <table class="tablebg" cellspacing="1" width="100%">
        <tr class="row1">
          <td align="center" valign="top">
		
                        <table cellspacing="2" cellpadding="0" class="imageborder">
                               <tr>
                                        <td align="center">
                                                {IMAGE}
                                                {ADMIN_MENU}
                                        </td>
                               </tr>
                        </table>
<!-- BEGIN img_desc -->
                        <table cellpadding="0" cellspacing="0" class="tableb">
<!-- BEGIN title -->
                                <tr>
                                        <td class="tableb"><center><b>
                                                {TITLE}
                                        </b></center></td>
                                </tr>
<!-- END title -->
<!-- BEGIN caption -->
                                <tr>
                                        <td class="tableb"><center>
                                                {CAPTION}
                                        </center></td>
                                </tr>
<!-- END caption -->
                        </table>
<!-- END img_desc -->
          
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>
		
                </td>
EOT;
}  //{THEMES}

// HTML template for filmstrip display
if (!isset($template_film_strip)) { //{THEMES}
$template_film_strip = <<<EOT
<tr><td>
				
	<table width="100%" cellspacing="0" cellpadding="0">			
		<tr>
		<td valign="top" style="background-image: url({TILE1});"><img src="{TILE1}" alt="" border="0" /></td>
		<td>
         	{THUMB_STRIP}
		</td> 
		<td valign="top" style="background-image: url({TILE2});"><img src="{TILE2}" alt="" border="0" /></td>
        	</tr>
	</table>
		
</td></tr>
<!-- BEGIN thumb_cell -->
			<table width="100%" cellspacing="0" cellpadding="0">
			<tr>
				<td align="center" valign="bottom">
				<a href="{LINK_TGT}">{THUMB}</a>
				</td>
			</tr>
			</table>
			{CAPTION}
			{ADMIN_MENU}
<!-- END thumb_cell -->
<!-- BEGIN empty_cell -->
                <td valign="top" align="center">&nbsp;</td>
<!-- END empty_cell -->

EOT;
}  //{THEMES}

// Added to display film_strip
function theme_display_film_strip(&$thumb_list, $nbThumb, $album_name, $aid, $cat, $pos, $sort_options, $mode = 'thumb')
{
    global $CONFIG, $THEME_DIR;
    global $template_film_strip, $lang_film_strip;

    static $template = '';
    static $thumb_cell = '';
    static $empty_cell = '';
    static $spacer = '';

    if ((!$template)) {
        $template = $template_film_strip;
        $thumb_cell = template_extract_block($template, 'thumb_cell');
        $empty_cell = template_extract_block($template, 'empty_cell');
    }

    $cat_link = is_numeric($aid) ? '' : '&cat=' . $cat;

    $thumbcols = $CONFIG['thumbcols'];
    $cell_width = ceil(100 / $CONFIG['max_film_strip_items']) . '%';

    $i = 0;
    $thumb_strip = '';
    foreach($thumb_list as $thumb) {
        $i++;
        if ($mode == 'thumb') {
            $params = array('{CELL_WIDTH}' => $cell_width,
                '{LINK_TGT}' => "displayimage.php?album=$aid$cat_link&pos={$thumb['pos']}",
                '{THUMB}' => $thumb['image'],
                '{CAPTION}' => '',
                '{ADMIN_MENU}' => ''
                );
        } else {
            $params = array('{CELL_WIDTH}' => $cell_width,
                '{LINK_TGT}' => "index.php?cat={$thumb['cat']}",
                '{THUMB}' => $thumb['image'],
                '{CAPTION}' => '',
                '{ADMIN_MENU}' => ''
                );
        }
        $thumb_strip .= template_eval($thumb_cell, $params);
    }

    if (defined('THEME_HAS_FILM_STRIP_GRAPHICS')) {
        $tile1 = $THEME_DIR . 'images/tile1.gif';
        $tile2 = $THEME_DIR . 'images/tile2.gif';
    } elseif (defined('THEME_HAS_FILM_STRIP_GRAPHIC')) {
        $tile1=$tile2=$THEME_DIR . 'images/tile.gif';
    } else {
        $tile1=$tile2= 'images/tile.gif';
    }

    $params = array('{THUMB_STRIP}' => $thumb_strip,
        '{COLS}' => $i,
        '{TILE1}' => $tile1,
        '{TILE2}' => $tile2,
        );

    ob_start();
    starttable('');
      echo template_eval($template, $params);
    endtable();
    $film_strip = ob_get_contents();
    ob_end_clean();

    return $film_strip;
}

if (!function_exists('theme_display_image')) {  //{THEMES}
function theme_display_image($nav_menu, $picture, $votes, $pic_info, $comments, $film_strip)
{
    global $HTTP_COOKIE_VARS, $CONFIG;

    starttable();
	    echo $nav_menu;
    endtable();
	
    starttable();
    if ($CONFIG['display_film_strip'] == 1) {
		echo "<tr><td width='200' class='tableb' valign='middle'><!-- gb before film_strip -->";
	        echo $film_strip;
		echo "</td><!-- gb after film_strip -->";
    }
		echo "<td class='tableb' valign='middle'><!-- gb before picture -->";
    		echo $picture;
		echo "</td></tr><!-- gb after picture -->";
    endtable();

    $picinfo = isset($HTTP_COOKIE_VARS['picinfo']) ? $HTTP_COOKIE_VARS['picinfo'] : ($CONFIG['display_pic_info'] ? 'block' : 'none');
    starttable();
    	echo $pic_info;
    endtable();

    	echo $votes;

    	echo $comments;
}
}  //{THEMES}

// Function to start a 'standard' table
function starttable($width = '-1', $title = '', $title_colspan = '1')
{
    global $CONFIG;

    if ($width == '-1') $width = $CONFIG['picture_table_width'];
    if ($width == '100%') $width = $CONFIG['main_table_width'];
    echo <<<EOT

<!-- Start standard table -->
<table class="tablebg" cellspacing="0" width="100%" style="margin-bottom: 5px;">
  <tr>
    <td valign="top">
      <caption style="margin-bottom: -5px;">
      <div class="cap-left">
        <div class="cap-right">
		
EOT;
    if ($title) {
        echo <<<EOT
		<span colspan="$title_colspan">$title</span>
EOT;
    }

	echo <<<EOT
		
		</div>
      </div>
      </caption>
    </td>
  </tr>
  <tr class="row1">
    <td class="row1">
    <table class="tablebg" cellspacing="1" width="100%">
        <tr style="background: #191919;">
          <td align="center" valign="top">
          
<table align="center" width="$width" cellspacing="1" cellpadding="0">
  <tr>
    <td valign="top">

EOT;
}

// Function to end a 'standard' table
function endtable()
{
    echo <<<EOT
    </td>
  </tr>
</table>
          
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>
<!-- End standard table -->

EOT;
}

?>