<?php
define('THEME_HAS_FILM_STRIP_GRAPHICS', 1);
define('THEME_HAS_RATING_GRAPHICS', 1);
define('THEME_HAS_NAVBAR_GRAPHICS', 1);


// These parameters override what the user inputs in the Configuration setup to prevent the theme from breaking.
$CONFIG['max_film_strip_items'] = 5; //overrides the number of thumbnails.
$CONFIG['thumbcols'] = 5; //overrides the number of columns for thumbnails.
$CONFIG['main_table_width'] = '630'; //overrides the Width of the main table (pixels or %).
$CONFIG['picture_table_width'] = '630'; //overrides the Width of the table for file display (pixels or %).
$CONFIG['album_list_cols'] = 1; // sets "Number of columns for the album list = 2"
$CONFIG['first_level'] = 0 ; //sets "Show first level album thumbnails in categories = no".

// HTML template for template sys_menu spacer
$template_sys_menu_spacer ="<br />";

// HTML template for gallery admin menu
$template_gallery_admin_menu = <<<EOT

<!-- BEGIN admin_approval -->
<span id="admin_menu_anim"><a href="editpics.php?mode=upload_approval" title="{UPL_APP_TITLE}">{UPL_APP_LNK}</a></span>
<!-- END admin_approval -->
<a href="admin.php" title="{ADMIN_TITLE}">{ADMIN_LNK}</a><br />
<a href="catmgr.php" title="{CATEGORIES_TITLE}">{CATEGORIES_LNK}</a><br />
<a href="albmgr.php{CATL}" title="{ALBUMS_TITLE}">{ALBUMS_LNK}</a><br />
<a href="groupmgr.php" title="{GROUPS_TITLE}">{GROUPS_LNK}</a><br />
<a href="usermgr.php" title="{USERS_TITLE}">{USERS_LNK}</a><br />
<a href="banning.php" title="{BAN_TITLE}">{BAN_LNK}</a><br />
<a href="reviewcom.php" title="{COMMENTS_TITLE}">{COMMENTS_LNK}</a><br />
<!-- BEGIN log_ecards -->
<a href="db_ecard.php" title="{DB_ECARD_TITLE}">{DB_ECARD_LNK}</a><br />
<!-- END log_ecards -->
<a href="picmgr.php" title="{PICTURES_TITLE}">{PICTURES_LNK}</a><br />
<a href="searchnew.php" title="{SEARCHNEW_TITLE}">{SEARCHNEW_LNK}</a><br />
<a href="util.php" title="{UTIL_TITLE}">{UTIL_LNK}</a>
<a href="profile.php?op=edit_profile" title="{MY_PROF_TITLE}">{MY_PROF_LNK}</a><br />
<!-- BEGIN documentation -->
<a href="{DOCUMENTATION_HREF}" title="{DOCUMENTATION_TITLE}" target="cpg_documentation">{DOCUMENTATION_LNK}</a>
<!-- END documentation -->

EOT;
function pagefooter()
{
    //global $HTTP_GET_VARS, $HTTP_POST_VARS, $HTTP_SERVER_VARS;
    global $USER, $USER_DATA, $ALBUM_SET, $CONFIG, $time_start, $query_stats, $queries;;
    global $template_footer;

    $custom_footer = cpg_get_custom_include($CONFIG['custom_footer_path']);

    if ($CONFIG['debug_mode']==1 || ($CONFIG['debug_mode']==2 && GALLERY_ADMIN_MODE)) {
    cpg_debug_output();
    }

    $template_vars = array(
        '{SYS_MENU}' => theme_main_menu('sys_menu'),
        '{SUB_MENU}' => theme_main_menu('sub_menu'),
        '{ADMIN_MENU}' => theme_admin_mode_menu(),
        '{CUSTOM_FOOTER}' => $custom_footer,
        '{VANITY}' => (defined('THEME_IS_XHTML10_TRANSITIONAL') && $CONFIG['vanity_block']) ? theme_vanity() : '',
    );

    echo template_eval($template_footer, $template_vars);
}

// HTML template for the category list
$template_cat_list = <<<EOT
<!-- BEGIN header -->
        <tr>
                <td class="tableh1" width="80%" align="left"><b>{CATEGORY}</b></td>
                <td class="tableh1" width="10%" align="center"><b>{ALBUMS}</b></td>
                <td class="tableh1" width="10%" align="center"><b>{PICTURES}</b></td>
        </tr>
<!-- END header -->
<!-- BEGIN catrow_noalb -->
        <tr>
                <td class="catrow_noalb" colspan="3"><table border="0"><tr><td align="left" valign="middle"><img src="themes/beauty_of_nature/images/folder.gif" border="0" width="5" height="5" alt="" align="left" />{CAT_THUMB}</td><td align="left"><span class="catlink"><b>{CAT_TITLE}</b></span>{CAT_DESC}</td></tr></table></td>
        </tr>
<!-- END catrow_noalb -->
<!-- BEGIN catrow -->
        <tr>
                <td class="catrow" align="left"><table border="0"><tr><td valign="middle"><img src="themes/beauty_of_nature/images/folder.gif" border="0" width="5" height="5" alt="" align="left" />{CAT_THUMB}</td><td><span class="catlink"><b>{CAT_TITLE}</b></span>{CAT_DESC}</td></tr></table></td>
                <td class="catrow" align="center">{ALB_COUNT}</td>
                <td class="catrow" align="center">{PIC_COUNT}</td>
        </tr>
        <tr>
            <td class="tableb" colspan="3">{CAT_ALBUMS}</td>
        </tr>
<!-- END catrow -->
<!-- BEGIN footer -->
        <tr>
                <td colspan="3" class="tableh1" align="center"><span class="statlink"><b>{STATISTICS}</b></span></td>
        </tr>
<!-- END footer -->
<!-- BEGIN spacer -->
        <img src="images/spacer.gif" width="1" height="7" border="" alt="" /><br />
<!-- END spacer -->

EOT;
?>