<?
	// ************************************************************* //
	// ADMIN SETTINGS       **************************************** //
	
	// YOU REALLY SHOULD CHANGE THIS:
	$adminpassword = '123456';  // admin password
	// (or - better - delete this file after database is converted)
	
	// ************************************************************* //
	// ************************************************************* //

	$INIfileName = "guestbook.ini";
	$configFromINI = parse_ini_file($INIfileName, true);
	$dbname = $configFromINI['Files']['guestbookFile'];
	$delimiter = $configFromINI['General']['delimiter'];
	$targetCharset = 'UTF-8';
	$gb = "<br/><a href=\"index.php\">Return to guestbook</a>";

	if( file_exists("$dbname.bak" ) ) {
		print "Backup file $dbname.bak already exists, cannot proceed.$gb";
		exit;
	}

	$content = file($dbname);
	$numberofposts = count($content);
	if( $numberofposts <= 0 ) {
		print "Guestbook is empty, no conversion needed.$gb";
		exit;
	}

	if( !isset($_GET['charset']) || !isset($_GET['password']) || $_GET["password"] != $adminpassword ) {
		$title = 'flatPHPbook DB Charset Conversion Tool';
		$a = split($delimiter, $content[0]);
		$old_db = trim($content[0]) != "" && !preg_match('/^\d+$/', $a[3]);
?>
		<html><head><title><?=$title?></title></head><body onload="javascript:f.password.focus();">
		<h2><?=$title?></h2>
		<form action="<?=$_SERVER['PHP_SELF']?>" method="get" name="f">
		<p>Secret word: <input type="text" size="15" name="password"><br/>
		Current database charset: <select name="charset">
			<option value="ISO-8859-1" selected>Western European (Latin-1)</option>
			<option value="ISO-8859-15">Western European (Latin-9)</option>
			<option value="cp1252">Western European (Windows-1252)</option>
			<option value="cp1251">Cyrillic (Windows-1251)</option>
			<option value="KOI8-R">Cyrillic (KOI8-R)</option>
			<option value="BIG5">Traditional Chinese</option>
			<option value="GB2312">Simplified Chinese</option>
			<option value="SJIS">Japanese (Shift-JIS)</option>
			<option value="UTF-8">UTF-8</option>
			<option value=".">(no, thanks)</option>
		</select><br/>
		Database will be converted to <b><?=$targetCharset?></b>.<br/>
		<input type="checkbox" name="upgrade" value="1" <?=$old_db?'checked':''?>/>&nbsp;upgrade DB from v0.9.x<br/>
		<input type="submit" value="Convert"></p>
		</form>
		<p><?=$gb?></p>
		</body></html>
<?
		exit;
	}

	$sourceDBCharset = $_GET['charset'];
	if( !copy($dbname, "$dbname.bak") && !isset($_GET['backupoverride']) ) {
		print "Could not create $dbname.bak, is it <a href=\""
			.$_SERVER['PHP_SELF']."?charset=$sourceDBCharset&password=".$_GET['password']
			.(isset($_GET['upgrade']) && $_GET['upgrade'] == "1" ? '&upgrade=1' : '')
			."&backupoverride=1\">ok</a> to proceed? Did you make backup of <tt>guestbook.db</tt> yourself?$gb";
		exit;
	}

	$bookInputStream = fopen($dbname, "w");
	fseek($bookInputStream, 0);

	for ($i = 0; $i < $numberofposts; $i++)	{
		$result = $content[$i];
		if( $sourceDBCharset != "." ) {
			$input = str_replace('&nbsp;<br />', '[[newlinenbsp]]', $result);
			$input = str_replace('<', '[[bracket_left]]', $input);
			$input = str_replace('>', '[[bracket_right]]', $input);
			if( $sourceDBCharset == 'UTF-8' && function_exists('iconv') )
				$input = iconv('UTF-8', 'UTF-8//IGNORE', $input);
			$input = html_entity_decode($input, ENT_QUOTES, $sourceDBCharset);
			if( function_exists("mb_convert_encoding") )
				$input = mb_convert_encoding($input,$targetCharset,$sourceDBCharset);
			else {
				print "Warning: <tt>mbstring</tt> package is not <a href=\"http://www.php.net/manual/en/mbstring.installation.php\">installed</a>, double-check your guestbook after conversion!<br/>\n";
				$tmp = htmlentities($input, ENT_QUOTES, $sourceDBCharset);
				$input = html_entity_decode_fix($tmp, ENT_QUOTES, $targetCharset);
			}
			$result = htmlentities($input, ENT_QUOTES, $targetCharset);
			$result = str_replace('[[bracket_left]]', '<', $result);
			$result = str_replace('[[bracket_right]]', '>', $result);
			$result = str_replace('[[newlinenbsp]]', '&nbsp;<br />', $result);
		}
		if( isset($_GET['upgrade']) && $_GET['upgrade'] == "1" ) {
			$oldarray = split($delimiter, $result);
			$result = $oldarray[0].$delimiter.$oldarray[1].$delimiter.$oldarray[2].$delimiter.strtotime($oldarray[3]." ".$oldarray[4]).$delimiter.$oldarray[5].$delimiter.$oldarray[6];
		}
		fwrite($bookInputStream, trim($result)."\n");
	}
	             	
	fclose($bookInputStream);
	print "OK.$gb";

	function html_entity_decode_fix($text, $flag, $charset) {
		$version = PHP_VERSION;
		if( strtolower($charset) != 'utf-8' || $version[0] != '4' ) 
			return html_entity_decode($text, $flag, $charset);
		else {
			$trans = array_flip(get_html_translation_table(HTML_ENTITIES, $flag));
			// thanks to chris at php.net for this
			$add = array('&ndash;'=>'&#8211;', '&mdash;'=>'&#8212;', '&lsquo;'=>'&#8216;', '&rsquo;'=>'&#8217;', '&sbquo;'=>'&#8218;',
				'&ldquo;'=>'&#8220;', '&rdquo;'=>'&#8221;', '&bdquo;'=>'&#8222;', '&dagger;'=>'&#8224;', '&Dagger;'=>'&#8225;',
				'&bull;'=>'&#8226;', '&hellip;'=>'&#8230;', '&permil;'=>'&#8240;', '&prime;'=>'&#8242;', '&Prime;'=>'&#8243;',
				'&lsaquo;'=>'&#8249;', '&rsaquo;'=>'&#8250;', '&oline;'=>'&#8254;', '&frasl;'=>'&#8260;', '&euro;'=>'&#8364;');
			return strtr($text, array_merge($trans, $add));
		}
	}
?>