<?php
	// flatPHPbook Plus version 2.1
	// Released date: November 25, 2009
	//
	// flatPHPbook script (c) 2003 by Thomas Hettenhausen.
	// http://flatphpbook.sourceforge.net
	// http://www.hettenhausen.net
	//
	// This PHP guestbook script was written by Thomas Hettenhausen and 
	// it updated by Vincenzo Capuano since 2006.
	// http://www.sitoserio.it
	//
	// Later this script was updated by Ilya Zverev in 2009.
	//
	//
	// LICENSE:
	// This program is free software; you can redistribute it and/or modify it
	// under the terms of the GNU General Public License as published by the 
	// Free Software Foundation; either version 2 of the License, or (at your 
	// option) any later version.
	// This program is distributed in the hope that it will be useful, but 
	// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
	// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
	// more details.
	// You should have received a copy of the GNU General Public License along 
	// with this program; if not, write to the Free Software Foundation, Inc., 
	// 675 Mass Ave, Cambridge, MA 02139, USA.

	
	// ************************************************************* //
	// ADMIN SETTINGS       **************************************** //
	
	// YOU REALLY SHOULD CHANGE THESE:
	$adminusername = "admin"; // the administrator username who can delete posts
	$adminpassword = "123456"; // the corresponding password
	
	// ************************************************************* //
	// ************************************************************* //
	
	
	
	////////////////////////////////////////////////////////////////////////
	///////////////////   DO NOT CHANGE FROM HERE     //////////////////////
	////////////////////////////////////////////////////////////////////////
	
	// set adminmode to 0 for security reasons
	$adminmode = 0; // DO NOT CHANGE THIS

	$cookieExpireTime = time() + 3600*24*31*12; // 1 year
	
	// reading the configuration from the INI file
	$INIfileName = "guestbook.ini";
	$configFromINI = parse_ini_file($INIfileName, true);
	$configFromINI['General']['version'] = 'Plus 2.1'; // overriding config version (for upgrades)
	handleUpdate102();
	handleUpdatePlus10();
	handleUpdatePlus11();
	handleUpdatePlus21();

	readLanguageStrings();

	// checking for additional files
	if( !is_file($configFromINI['Files']['bannedWordsFile']) )
		$configFromINI['Behaviour']['wordFilter'] = "0";
	if( !is_file('button.php') )
		$configFromINI['General']['useAntiSpam'] = "0";

	if ($configFromINI['General']['useCookies'] != "1")	{
		session_start();
		header("Cache-control: private"); // IE 6 Fix, needed for using the "Back" button with sessions and forms
	}

	// open external links in another window?
	if ($configFromINI['Behaviour']['externalLinksTarget'] != "")
		$externalLinksTargetCode = ' target="'.$configFromINI['Behaviour']['externalLinksTarget'].'"';
	else
		$externalLinksTargetCode = "";

	// reading in the banned words file, if enabled
	$bannedWords = $configFromINI['Behaviour']['wordFilter'] == "1" ? file($configFromINI['Files']['bannedWordsFile']) : "";

	// initializing all variables that might otherwise not get set
	$customFields = "";

	if (trim($configFromINI['Behaviour']['customFieldNames']) != "")
		$customFieldNames = explode(",", $configFromINI['Behaviour']['customFieldNames']);
	else
		$customFieldNames = array();


	//////////////////////////////////////////////////////////////////////////
	//                              FUNCTIONS                               //
	//////////////////////////////////////////////////////////////////////////

	// insert new key values and set them to appropriate defaults
	function handleUpdatePlus21() {
		global $configFromINI;
		if( !array_key_exists('maxLinksPerPost', $configFromINI['General']) )
			$configFromINI['General']['maxLinksPerPost'] = "5";
		if( !array_key_exists('entriesPerHistoryPage', $configFromINI['Behaviour']) )
			$configFromINI['Behaviour']['entriesPerHistoryPage'] = $configFromINI['Behaviour']['entriesPerPage'];
		if( !array_key_exists('entriesInRSS', $configFromINI['Behaviour']) )
			$configFromINI['Behaviour']['entriesInRSS'] = "15";
		if( !array_key_exists('forcePreview', $configFromINI['Behaviour']) )
			$configFromINI['Behaviour']['forcePreview'] = "0";
		if( !array_key_exists('displayHomepage', $configFromINI['Behaviour']) )
			$configFromINI['Behaviour']['displayHomepage'] = "1";
		if( !array_key_exists('configDescFile', $configFromINI['Files']) )
			$configFromINI['Files']['configDescFile'] = "configdesc.ini";
	}

	function handleUpdatePlus11() {
		global $configFromINI;
		if( !array_key_exists('allowAnonymous', $configFromINI['General']) )
			$configFromINI['General']['allowAnonymous'] = "0";
		if( !array_key_exists('readOnly', $configFromINI['General']) )
			$configFromINI['General']['readOnly'] = "0";
		if( !array_key_exists('nbspBr', $configFromINI['General']) )
			$configFromINI['General']['nbspBr'] = "1";
		if( !array_key_exists('signAfterView', $configFromINI['Behaviour']) )
			$configFromINI['Behaviour']['signAfterView'] = "0";
		if( !array_key_exists('alternateSignLink', $configFromINI['Behaviour']) )
			$configFromINI['Behaviour']['alternateSignLink'] = "0";
		if( !array_key_exists('displayEmails', $configFromINI['Behaviour']) )
			$configFromINI['Behaviour']['displayEmails'] = "0";
	}

	function handleUpdatePlus10() {
		global $configFromINI;
		if( !array_key_exists('useAntiSpam', $configFromINI['General']) )
			$configFromINI['General']['useAntiSpam'] = "1";
		if( !array_key_exists('useMultiLanguage', $configFromINI['General']) )
			$configFromINI['General']['useMultiLanguage'] = "0";
		if( !array_key_exists('Language_1', $configFromINI) ) {
			$languages = array('english','german','french','italian','russian','spanish','dutch','polish');
			for( $i = 1; $i <= count($languages); $i++ ) {
				$configFromINI["Language_$i"] = array();
				$configFromINI["Language_$i"][$i."_File"] = $languages[$i-1].".lang";
				$configFromINI["Language_$i"][$i."_Icon"] = $languages[$i-1].".gif";
				$configFromINI["Language_$i"][$i."_Title"] = ucfirst($languages[$i-1]);
				$configFromINI["Language_$i"][$i."_welcomeMsg"] = $configFromINI['Files']['welcomeMessage'];
			}
		}
	}

	function handleUpdate102() {
		global $configFromINI;
		if( !array_key_exists('useCookies', $configFromINI['General']) )
			$configFromINI['General']['useCookies'] = "1";
		if( !array_key_exists('disableMSSmartTags', $configFromINI['General']) )
			$configFromINI['General']['disableMSSmartTags'] = "1";

		if( !array_key_exists('welcomeMessage', $configFromINI['Files']) )
			$configFromINI['Files']['welcomeMessage'] = "welcomeMessage.html";
		if( !array_key_exists('customHeader', $configFromINI['Files']) )
			$configFromINI['Files']['customHeader'] = "customHeader.inc.html";
		if( !array_key_exists('customFooter', $configFromINI['Files']) )
			$configFromINI['Files']['customFooter'] = "customFooter.inc.html";
		if( !array_key_exists('bannedWordsFile', $configFromINI['Files']) )
			$configFromINI['Files']['bannedWordsFile'] = "bannedWords.txt";
		if( !array_key_exists('languageFile', $configFromINI['Files']) )
			$configFromINI['Files']['languageFile'] = array_key_exists('LanguageFile', $configFromINI['Files']) ? $configFromINI['Files']['LanguageFile'] : "english.lang";

		if( !array_key_exists('timeOffsetOnSave', $configFromINI['Behaviour']) )
			$configFromINI['Behaviour']['timeOffsetOnSave'] = "0";
		if( !array_key_exists('tableLayout', $configFromINI['Behaviour']) )
			$configFromINI['Behaviour']['tableLayout'] = "classic";
		if( !array_key_exists('externalLinksTarget', $configFromINI['Behaviour']) )
			$configFromINI['Behaviour']['externalLinksTarget'] = "_top";
		if( !array_key_exists('customFieldNames', $configFromINI['Behaviour']) )
			$configFromINI['Behaviour']['customFieldNames'] = "";
		if( !array_key_exists('moderatedPosts', $configFromINI['Behaviour']) )
			$configFromINI['Behaviour']['moderatedPosts'] = "0";
		if( !array_key_exists('wordFilter', $configFromINI['Behaviour']) )
			$configFromINI['Behaviour']['wordFilter'] = "0";

		if( !array_key_exists('Email', $configFromINI) ) {
			$configFromINI['Email'] = array();
			$configFromINI['Email']['sendEmail'] = "0";
			$configFromINI['Email']['fromAddress'] = "Email@NotSet";
			$configFromINI['Email']['toAddress'] = "Email@NotSet";
			$configFromINI['Email']['SMTP'] = "SMTP-SERVER";
			$configFromINI['Email']['overrideLocalhost'] = "0";
		}
		
		if( !array_key_exists('BBcode', $configFromINI) ) {
			$configFromINI['BBcode'] = array();
			$configFromINI['BBcode']['displayButtons'] = "1";
			$configFromINI['BBcode']['displayWebButtons'] = "1";
			$configFromINI['BBcode']['displayFormatButtons'] = "1";
			$configFromINI['BBcode']['displayColorButton'] = "1";
			$configFromINI['BBcode']['displaySizeButton'] = "1";
			$configFromINI['BBcode']['displayImageButton'] = "0";
			$configFromINI['BBcode']['displayCodeButton'] = "0";
		}
	}


	// reading the language-specific content
	function readLanguageStrings() {
		global $configFromINI, $languageStrings, $lingua;

		$lfile = $configFromINI['Files']['languageFile'];
		if (($configFromINI['General']['useCookies'] == "1")&&($configFromINI['General']['useMultiLanguage'] == "1")) {
			if (isset($_GET['lingua'])) {
				setcookie("lingua", $_GET['lingua'], $cookieExpireTime);
				$lingua = $_GET['lingua'];
			} elseif( isset($_COOKIE['lingua']) )
				$lingua = $_COOKIE['lingua'];

			if (isset($lingua) && preg_match('/^\d$/', $lingua))
				$lfile = $configFromINI["Language_" . $lingua][$lingua . "_File"];
		}
		$prefix = is_file("lang/$lfile") ? 'lang/' : (is_file($lfile) ? '' : '.');
		$languageStrings = $prefix == '.'? array() : parse_ini_file("$prefix$lfile");
	}


	// safe version of htmlentities
	function safehtmlentities($input) {
		$input = htmlentities(stripslashes($input), ENT_QUOTES, getDBCharset());
		$input = str_replace('&amp;#', '&#', $input); // fixes strange html charset behaviour
		return $input;
	}


	// removes HTML tags and the delimiters used in the db file from the input
	function safeHTML($input)	{
		global $configFromINI;
		$input = htmlentities(stripslashes($input), ENT_QUOTES, getDBCharset());
		$input = str_replace('&amp;#', '&#', $input); // fixes strange html charset behaviour
		$input = preg_replace("/(\015\012)|(\015)|(\012)/", $configFromINI['General']['nbspBr'] ? "&nbsp;<br />" : "<br />", $input); // exchanges CR, LF and CRLF with <br />
		$input = ereg_replace($configFromINI['General']['delimiter'], "[[delimiter]]", $input);
		$input = ereg_replace("----", "[[apprkey]]", $input);
		return $input;
	}

	function unsafeHTML($input) {
		global $configFromINI;
		$input = str_replace("[[delimiter]]", $configFromINI['General']['delimiter'], $input);		// put the real delimiter back into the string
		$input = str_replace("[[apprkey]]", "----", $input);
		$input = str_replace($configFromINI['General']['nbspBr'] ? "&nbsp;<br />" : "<br />", "\015\012", $input);
		$input = html_entity_decode_fix($input, ENT_QUOTES, getDBCharset());
		return $input;
	}

	function html_entity_decode_fix($text, $flag, $charset) {
		$version = PHP_VERSION;
		if( strtolower($charset) != 'utf-8' || $version[0] != '4' ) 
			return html_entity_decode($text, $flag, $charset);
		else {
			$trans = array_flip(get_html_translation_table(HTML_ENTITIES, $flag));
			// thanks to chris at php.net for this
			$add = array('&ndash;'=>'&#8211;', '&mdash;'=>'&#8212;', '&lsquo;'=>'&#8216;', '&rsquo;'=>'&#8217;', '&sbquo;'=>'&#8218;',
				'&ldquo;'=>'&#8220;', '&rdquo;'=>'&#8221;', '&bdquo;'=>'&#8222;', '&dagger;'=>'&#8224;', '&Dagger;'=>'&#8225;',
				'&bull;'=>'&#8226;', '&hellip;'=>'&#8230;', '&permil;'=>'&#8240;', '&prime;'=>'&#8242;', '&Prime;'=>'&#8243;',
				'&lsaquo;'=>'&#8249;', '&rsaquo;'=>'&#8250;', '&oline;'=>'&#8254;', '&frasl;'=>'&#8260;', '&euro;'=>'&#8364;');
			return strtr($text, array_merge($trans, $add));
		}
	}


	// here the BBcode for formatting, links and images is replaced with the real HTML tags
	// together with any incidentally used delimiter in the database file (because a visitor wanted to use it in his text) -
	// they were exchanged by the safeHTML() function and are now reinserted for display
	function recreateUserInput($input)	{
		global $configFromINI, $languageStrings, $externalLinksTargetCode;
		$input = str_replace("[[delimiter]]", $configFromINI['General']['delimiter'], $input);		// put the real delimiter back into the string
		$input = str_replace("[[apprkey]]", "----", $input);
		$input = preg_replace("/(\[\[comment\]\])(.+?)(\[\[\/comment\]\])/i", "<br /><br /><i><b>".$languageStrings['AdminComment'].":</b><br />\\2</i>", $input);
		$input = preg_replace("/(\[b\])(.+?)(\[\/b\])/i", "<span style=\"font-weight: bold;\">\\2</span>",  $input);
		$input = preg_replace("/(\[i\])(.+?)(\[\/i\])/i", "<span style=\"font-style: italic;\">\\2</span>", $input);
		$input = preg_replace("/(\[u\])(.+?)(\[\/u\])/i", "<span style=\"text-decoration: underline;\">\\2</span>", $input);
		$input = preg_replace("/(\[pre\])(.+?)(\[\/pre\])/i", "<pre>\\2</pre>", $input);
		$input = preg_replace("/(\[img\])(.+?)(\[\/img\])/i", '<img src="\\2" alt="\\2">', $input);
		$input = preg_replace("/(\[color=(\w{3,9}|#[\w\d]{3,6})\])(.+?)(\[\/color\])/i", "<span style=\"color: \\2\">\\3</span>", $input);
		$input = preg_replace("/(\[size=(1?\d\d)\])(.+?)(\[\/size\])/i", "<span style=\"font-size: \\2%;\">\\3</span>", $input);
		$input = preg_replace("/(\[email\])(.+?)(\[\/email\])/i", "<a href=\"mailto:\\2\">\\2 </a>", $input);
		$input = preg_replace("/(\[email=(.+?)\])(.+?)(\[\/email\])/i", "<a href=\"mailto:\\2\">\\3</a>", $input);
		$input = preg_replace("/\[url\]http\:\/\//i", "[url]", $input);
		$input = preg_replace("/\[url=http\:\/\//i", "[url=", $input);
		$input = preg_replace("/(\[url=?\])(.+?)(\[\/url\])/i", "<a href=\"http://\\2\"".$externalLinksTargetCode.">http://\\2</a>", $input);
		$input = preg_replace("/(\[\[url=(.+?)\]\])(.+?)(\[\/url\])/i", "<a href=\"http://\\2\"".$externalLinksTargetCode.">\\3</a>", $input);
		$input = preg_replace("/(\[url=(.+?)\])(.+?)(\[\/url\])/i", "<a href=\"http://\\2\"".$externalLinksTargetCode.">\\3</a>", $input);
		$input = preg_replace('/(^|\/>|\s)(http:\/\/(?:[a-z0-9_-]+)(?:\.[a-z0-9_-]+)*(?:\.[a-z]{2,4})(?::\d{2,5})?(?:\/[a-z0-9_!~.()?&$@#,%*\'-]+)+\/?\.(?:gif|png|jpg|jpeg))(\s|\<b|&nbsp;|$)/i', "\\1<img src=\"\\2\" alt=\"\\2\">\\3", $input);
		$input = preg_replace('/(^|\/>|\s)(http:\/\/(?:[a-z0-9_-]+)(?:\.[a-z0-9_-]+)*(?:\.[a-z]{2,4})(?::\d{2,5})?(?:\/?|(?:\/[a-z0-9_!~.()?&$@#,%*\'-]+)+\/?))(\s|\<b|&nbsp;|$)/i', "\\1<a href=\"\\2\"".$externalLinksTargetCode.">\\2</a>\\3", $input);
		$input = str_replace('<br />', '<br>', $input);
		return $input;
	}


	function displayEmptyInputForm() {
		displayInputForm("", "", "", "", "", "");
	}


	// displays the input fields for a new post: name, email, you name it
	function displayInputForm($Nickname, $Emailaddress, $Homepage, $Message, $forgotten, $customFields) {
		global $configFromINI, $languageStrings, $adminmode, $customFieldNames;

		// replacing the stored HTML new line tag <br /> with a line feed for displaying it in a readable form
		$Message = safehtmlentities(rtrim($Message));

		// splitting the message into the real user-submitted message and a possible admin comment already made before this date
		$commentPattern = "/\[\[comment\]\](.+?)\[\[\/comment\]\]/is";
		if( preg_match($commentPattern, $Message, $matches) > 0 ) {
			$Comment = $matches[1];
			$Message = preg_replace($commentPattern, "", $Message);
		} else
			$Comment = "";

		$whichpost = $adminmode == 1 && isset($_POST["whichpost"]) && !isset($_POST['cancel']) ? $_POST["whichpost"] : -1;
		$posttime = $adminmode == 1 && isset($_POST["posttime"]) && !isset($_POST['cancel']) ? $_POST["posttime"] : 0;

		// restoring nickname from cookies
		if( $Nickname == "" && $whichpost < 0 && $configFromINI['General']['useCookies'] == "1" && isset($_COOKIE['nickname']) ) {
			$Nickname = safehtmlentities($_COOKIE['nickname']);
		}

		// determines if an input field was forgotten and highlites its title in red
		$forgottenOpen = "<span class=\"forgotten\"><B>*&nbsp;";
		$forgottenClose = "</B></span>";

		$highliteNickOpen = strpos($forgotten, 'n') !== false ? $forgottenOpen : "";
		$highliteNickClose = strpos($forgotten, 'n') !== false ? $forgottenClose : "";
		$highliteMessageOpen = strpos($forgotten, 'm') !== false || strpos($forgotten, 'l') !== false ? $forgottenOpen : "";
		$highliteMessageClose = strpos($forgotten, 'm') !== false || strpos($forgotten, 'l') !== false ? $forgottenClose : "";
		$highliteAntiSpamOpen = strpos($forgotten, 's') !== false ? $forgottenOpen : "";
		$highliteAntiSpamClose = strpos($forgotten, 's') !== false ? $forgottenClose : "";

		echo "\n\t\t\t<div class=\"gbinput\">";
		echo "\n\t\t\t\t<table>\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t<form name=\"inputform\" method=\"post\" action=\"".$_SERVER['PHP_SELF']."\">\n";
		echo "\t\t\t\t\t\t\t\t<table border=\"0\">\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td>".$highliteNickOpen.$languageStrings['YourName'].$highliteNickClose.":<br>";
		echo "<input type=\"text\" name=\"NickName\" size=\"26\" value=\"".$Nickname."\"></td>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<td>".$languageStrings['YourEmail'].":<br>";
		echo "<input type=\"text\" name=\"EmailAddress\" size=\"36\" value=\"".$Emailaddress."\"></td>";
		if ($configFromINI['Behaviour']['displayHomepage'] == "1")	{
			echo "\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td colspan=\"2\">".$languageStrings['YourHomepage'].":<br>";
			echo "<input type=\"text\" name=\"Homepage\" size=\"67\" value=\"".$Homepage."\"></td>\n\t\t\t\t\t\t\t\t\t</tr>";
		}
		for ($field = 0; $field < count($customFieldNames); $field++)
		{
			echo "\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td colspan=\"2\">".$customFieldNames[$field].":<br>\n";
			echo "\t\t\t\t\t\t\t\t\t\t<input type=\"text\" name=\"customField".$field."\" size=\"67\" value=\"".$customFields[$field]."\"><td>\n\t\t\t\t\t\t\t\t\t</tr>";
		}
		echo "\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td colspan=\"2\">".$highliteMessageOpen.$languageStrings['YourMessage'].$highliteMessageClose.":<br>\n";
		echo "\t\t\t\t\t\t\t\t\t\t\t<textarea rows=\"5\" cols=\"50\" id=\"messagebox\" name=\"Message\">".$Message."</textarea>\n\t\t\t\t\t\t\t\t\t\t\t<br>\n";
		// disables BBcodebuttons if so desired
		if ($configFromINI['BBcode']['displayButtons'] == "1")	{
			if ($configFromINI['BBcode']['displayWebButtons'] == "1")	{
				echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"button\" accesskey=\"h\" value=\"".$languageStrings['ButtonWWW']."\" onClick=\"addHyperlink('".$languageStrings['jsWWWurl']."', '".$languageStrings['jsWWWname']."')\" onMouseOver=\"helpHyperlink('".$languageStrings['jsHelpWWW']."')\" onMouseOut=\"clearHelp()\">\n";
				echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"button\" accesskey=\"e\" value=\"".$languageStrings['ButtonEmail']."\" onClick=\"addEmail('".$languageStrings['jsEmailAddress']."', '".$languageStrings['jsEmailName']."')\" onMouseOver=\"helpEmail('".$languageStrings['jsHelpEmail']."')\" onMouseOut=\"clearHelp()\">\n";
			}
			if ($configFromINI['BBcode']['displayFormatButtons'] == "1")	{
				echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"button\" accesskey=\"b\" value=\"".$languageStrings['ButtonBold']."\" style=\"font-weight: bold;\" onClick=\"addBold('".$languageStrings['jsBold']."', '".$languageStrings['jsYourTextGoesHere']."')\" onMouseOver=\"helpBold('".$languageStrings['jsHelpBold']."')\" onMouseOut=\"clearHelp()\">\n";
				echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"button\" accesskey=\"i\" value=\"".$languageStrings['ButtonItalic']."\" style=\"font-style: italic;\" onClick=\"addItalics('".$languageStrings['jsItalic']."', '".$languageStrings['jsYourTextGoesHere']."')\" onMouseOver=\"helpItalics('".$languageStrings['jsHelpItalic']."')\" onMouseOut=\"clearHelp()\">\n";
			}
			if ($configFromINI['BBcode']['displayColorButton'] == "1")	{
				echo "\t\t\t\t\t\t\t\t\t\t\t<select name=\"colorselect\" size=\"1\" onChange=\"addColor('".$languageStrings['jsColor']."', '".$languageStrings['jsYourTextGoesHere']."')\" onMouseOver=\"helpColor('".$languageStrings['jsHelpColor']."')\" onMouseOut=\"clearHelp()\">\n";
				echo "\t\t\t\t\t\t\t\t\t\t\t\t<option selected=\"selected\">".$languageStrings['ButtonColor']."</option><option value=\"#ff0000\" style=\"color: #ff0000;\">".$languageStrings['red']."</option><option value=\"#ff8800\" style=\"color: #ff8800;\">".$languageStrings['orange']."</option><option value=\"#ffff00\" style=\"color: #ffff00;\">".$languageStrings['yellow']."</option>\n";
				echo "\t\t\t\t\t\t\t\t\t\t\t\t<option value=\"#884400\" style=\"color: #884400;\">".$languageStrings['brown']."</option><option value=\"#008800\" style=\"color: #008800;\">".$languageStrings['green']."</option><option value=\"#00ffff\" style=\"color: #00ffff;\">".$languageStrings['turquoise']."</option><option value=\"#0000ff\" style=\"color: #0000ff;\">".$languageStrings['blue']."</option>\n";
				echo "\t\t\t\t\t\t\t\t\t\t\t\t<option value=\"#8800ff\" style=\"color: #8800ff;\">".$languageStrings['violet']."</option><option value=\"#ff00ff\" style=\"color: #ff00ff;\">".$languageStrings['pink']."</option><option value=\"#ffffff\" style=\"color: #ffffff;\">".$languageStrings['white']."</option>\n\t\t\t\t\t\t\t\t\t\t\t</select>\n";
			}
			if ($configFromINI['BBcode']['displaySizeButton'] == "1")	{
				echo "\t\t\t\t\t\t\t\t\t\t\t<select name=\"sizeselect\" size=\"1\" onChange=\"addSize('".$languageStrings['jsSize']."', '".$languageStrings['jsYourTextGoesHere']."')\" onMouseOver=\"helpSize('".$languageStrings['jsHelpSize']."')\" onMouseOut=\"clearHelp()\">";
				echo "\n\t\t\t\t\t\t\t\t\t\t\t\t<option value=\"size\" selected=\"selected\">".$languageStrings['ButtonSize']."</option><option value=\"60\">".$languageStrings['tiny']."</option><option value=\"80\">".$languageStrings['small']."</option><option value=\"100\">".$languageStrings['normal']."</option><option value=\"120\">".$languageStrings['large']."</option><option value=\"140\">".$languageStrings['huge']."</option>";
				echo "\n\t\t\t\t\t\t\t\t\t\t\t</select>\n";
			}
			if ($configFromINI['BBcode']['displayImageButton'] == "1")	{
				echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"button\" value=\"".$languageStrings['ButtonImage']."\" onClick=\"addImage('".$languageStrings['jsImage']."')\" onMouseOver=\"helpImage('".$languageStrings['jsHelpImage']."')\" onMouseOut=\"clearHelp()\">\n";
			}
			if ($configFromINI['BBcode']['displayCodeButton'] == "1")	{
				echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"button\" value=\"".$languageStrings['ButtonCode']."\" style=\"font-family: monospaced;\" onClick=\"addCode('".$languageStrings['jsCode']."', '".$languageStrings['jsYourTextGoesHere']."')\" onMouseOver=\"helpCode('".$languageStrings['jsHelpCode']."')\" onMouseOut=\"clearHelp()\">\n";
			}
		}
		echo "\t\t\t\t\t\t\t\t\t\t\t<div id=\"jsHelpLine\" class=\"jsHelpLine\">&nbsp;<br></div>\n";

		if ($adminmode == 0 && $configFromINI['General']['useAntiSpam'] == "1")
		{
			// ANTISPAM
			echo "\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t</tr>";
			echo "\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td colspan=\"2\">\n\t\t\t\t\t\t\t\t\t\t\t<div align=\"left\">";
			echo "\n\t\t\t\t\t\t\t\t\t\t\t<b>".$highliteAntiSpamOpen.$languageStrings['AntiSpam'].$highliteAntiSpamClose."</b><br>\n";
			echo "\t\t\t\t\t\t\t\t\t\t\t<img width=120 height=30 src=\"button.php\" border=\"1\">&nbsp;&nbsp;&nbsp;<input MAXLENGTH=5 SIZE=5 name=\"userdigit\" type=\"text\" value=\"\">\n";
			echo "\t\t\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t</tr>";
			//-----//
		}

		echo "\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td colspan=\"2\">";

		$submitButtonTitle = 'SubmitPost';
		$submitButtonName = 'submit';
		if( $whichpost >= 0 ) {
			echo $languageStrings['AdminComment'].":<br>\n";
			echo "\t\t\t\t\t\t\t\t\t\t\t<textarea rows=\"2\" cols=\"50\" id=\"commentbox\" name=\"Comment\">".$Comment."</textarea>\n\t\t\t\t\t\t\t\t\t\t\t<br>\n";
			echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"hidden\" name=\"whichpost\" value=\"".$whichpost."\">\n";
			echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"hidden\" name=\"posttime\" value=\"".$posttime."\">";
			echo "\n\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td colspan=\"2\">";
			$submitButtonTitle = 'SaveChanges';
			$submitButtonName = 'edited';
		}
		echo "\n\t\t\t\t\t\t\t\t\t\t\t<div align=\"left\">\n";
		if( $configFromINI['Behaviour']['forcePreview'] != "1" || (isset($_POST['preview']) && $forgotten == "") || $whichpost >= 0 )
			echo "\t\t\t\t\t\t\t\t\t\t\t\t<input type=\"submit\" name=\"$submitButtonName\" value=\"".$languageStrings[$submitButtonTitle]."\">&nbsp;\n";
		echo "\t\t\t\t\t\t\t\t\t\t\t\t<input type=\"submit\" name=\"preview\" value=\"".$languageStrings['PreviewPost']."\">&nbsp;\n";

		if (isset($_POST['preview']) || isset($_POST['submit']) || $whichpost >= 0 || isset($_GET['signgb']) )
			echo "\t\t\t\t\t\t\t\t\t\t\t\t<input type=\"submit\" name=\"cancel\" value=\"".$languageStrings['Cancel']."\">\n";

		echo "\t\t\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t</form>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>";
		echo "\n\t\t\t</div>";
	}


	// charset for html
	function getCharset() {
		return 'utf-8';
	}

	// charset for htmlentities() function (see php manual)
	function getDBCharset() {
		return 'UTF-8';
	}


	// determining the format used to display date and time
	function getTimeFormat() {
		global $configFromINI;
		if ($configFromINI['Behaviour']['timeNotation'] == "american")	{
			$timeFormat = "m-d-Y, g:i a";
		}
		elseif ($configFromINI['Behaviour']['timeNotation'] == "german")	{
			$timeFormat = "d.m.Y, H:i";
		}
		elseif ($configFromINI['Behaviour']['timeNotation'] == "italian")	{
			$timeFormat = "d/m/Y, H:i";
		}
		else	{
			// falling back to ISO norm
			$timeFormat = "d-m-Y, H:i";
		}
		return $timeFormat;
	}

	// displays the recurring html header that is the same on every page (page title, style sheet, JavaScript, meta tags...)
	function displayHTMLHeader()	{
		global  $configFromINI;
		
		$CharSet = getCharset();
		header("Content-Type: text/html; charset=$CharSet");
		
		echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n\n";
		echo "<html>\n\t<head>\n\t\n";
		echo "\t\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=".$CharSet."\">\n";
		echo "\t\t<meta name=\"generator\" content=\"flatPHPbook ".$configFromINI['General']['version']."\">\n";
		if ($configFromINI['General']['disableMSSmartTags'] == "1")	{
			echo "\t\t<meta name=\"MSSmartTagsPreventParsing\" content=\"TRUE\">\n";
		}
		echo "\t\t<title>" . $configFromINI['General']['gbName'] . "</title>\n";
		echo "\t\t<link rel=\"stylesheet\" type=\"text/css\" href=\"" . $configFromINI['Files']['stylesheetFile'] . "\">\n";
		if( $configFromINI['Behaviour']['entriesInRSS'] > 0 )
			echo "\t\t<link rel=\"alternate\" href=\"".$_SERVER['PHP_SELF']."?rss\" type=\"application/rss+xml\" title=\"RSS\">\n";
		echo "\t\t<script language=\"JavaScript\" type=\"text/javascript\" src=\"" . $configFromINI['Files']['javascriptFile'] . "\"></script>\n";
		echo "\t</head>\n\t<body>\n";
		if (is_file($configFromINI['Files']['customHeader']))
		{
			include_once($configFromINI['Files']['customHeader']);
		}
	}


	// displays the html footer (the link to my homepage, and the required closing tags that are the same on all pages
	function displayHTMLFooter()	{
		global  $configFromINI;
		if (is_File($configFromINI['Files']['customFooter']))
		{
			include_once($configFromINI['Files']['customFooter']);
		}
		echo "\t\t<div class=\"htmlFooter\">\n\t\t\t<a href=\"http://sourceforge.net/projects/flatphpbook/\">flatPHPbook ".$configFromINI['General']['version']."</a>\n\t\t\n\t\t</div>";
		echo "\n\t</body>\n</html>";
	}


	// displays the appropriate link to either login to or logout from admin mode
	function displayAdminLinks()	{
		global $adminmode, $languageStrings;
		if ($adminmode == 1)	{
			echo "\t\t<div class=\"adminlink\"><a href=\"" . $_SERVER['PHP_SELF'] . "?logout=1\">".$languageStrings['AdminLogout']."</a></div>\n";
		}
		else {
			echo "\t\t<div class=\"adminlink\"><a href=\"" . $_SERVER['PHP_SELF'] . "?adminlogin=1\">".$languageStrings['AdminLogin']."</a></div>\n";
		}
	}


	function displayGuestbookPost($postnumber, $postnumber1, $nickname, $email, $homepage, $posttime, $ip, $message, $customFields, $notapproved) {
		global $configFromINI, $languageStrings, $adminmode, $customFieldNames;

		// open external links in another window?
		if ($configFromINI['Behaviour']['externalLinksTarget'] != "")
			$externalLinksTargetCode = " target=\"".$configFromINI['Behaviour']['externalLinksTarget']."\"";
		else
			$externalLinksTargetCode = "";

		if ($homepage != "" && !(preg_match("/^http:\/\//", $homepage)))
			$homepage = "http://" . $homepage;

		$emailIcon = is_file($configFromINI['Files']['emailIcon']) ? "<img src=\"".$configFromINI['Files']['emailIcon']."\" alt=\"email\">" : 'E-Mail';
		$homepageIcon = is_file($configFromINI['Files']['homepageIcon']) ? "<img src=\"" . $configFromINI['Files']['homepageIcon'] . "\" alt=\"homepage\">" : 'WWW';

       		if ($configFromINI['Behaviour']['tableLayout'] == "classic")
       		{
    			// first line of post: dark background;left cell: "nickname", right cell: "date, time"
    			echo "\t\t\t<tr class=\"layouttr\">\n\t\t\t\t<td class=\"posttopleft\" valign=\"top\">";
			echo "\n\t\t\t\t\t<span class=\"nickname\"><a name=\"post$postnumber1\" href=\"".$_SERVER['PHP_SELF']."?post=$postnumber1#post$postnumber1\" class=\"navigation\">$postnumber1</a>.&nbsp;$nickname</span>\n\t\t\t\t</td>\n";
			echo "\t\t\t\t<td class=\"posttopright\"  valign=\"top\">\n\t\t\t\t\t<span class=\"dateandtime\">".date(getTimeFormat(), $posttime);
			// show ip for admin
			if( $adminmode == 1 && $ip != '' ) {
				echo ",&nbsp;IP:&nbsp;$ip";
			}
			// custom fields get displayed here
			for ($field = 0; $field < count($customFieldNames); $field++)
				if (trim($customFields[$field]))
					echo ",&nbsp;".$customFieldNames[$field].":&nbsp;".trim($customFields[$field]);
			echo "</span>\n\t\t\t\t</td>\n\t\t\t</tr>\n";

			// second line of post: light background; left cell: "homepage, email", right cell: "message"
			echo "\t\t\t<tr>\n\t\t\t\t<td class=\"postbottomleft\" valign=\"top\">";
			if ($email != "" && ($adminmode == 1 || $configFromINI['Behaviour']['displayEmails'] == "1"))	{
				echo "\n\t\t\t\t\t<a href=\"mailto:$email\">$emailIcon</a>&nbsp;";
				if ($homepage == "")	{
					echo "\n\t\t\t\t";
				}
			}

			if ($homepage != "")	{
				echo "\n\t\t\t\t\t<a href=\"$homepage\"".$externalLinksTargetCode.">$homepageIcon</a>";
			}

			// displaying button to delete the entry if logged in as admin
			if ($adminmode == 1 && $postnumber >= 0) {
				echo "\n\t\t\t\t\t<form method=\"POST\" action=\"".$_SERVER['PHP_SELF']."\"><input type=\"hidden\" name=\"whichpost\" value=\"$postnumber\"><input type=\"hidden\" name=\"posttime\" value=\"$posttime\"><input type=\"submit\" value=\"".$languageStrings['AdminDelete']."\" name=\"delete\" class=\"deleteButton\"></form>";
				echo "\n\t\t\t\t\t<form method=\"POST\" action=\"".$_SERVER['PHP_SELF']."\"><input type=\"hidden\" name=\"whichpost\" value=\"$postnumber\"><input type=\"hidden\" name=\"posttime\" value=\"$posttime\"><input type=\"submit\" value=\"".$languageStrings['AdminEdit']."\" name=\"edit\" class=\"deleteButton\"></form>";
				// button for approval of posts
				if (($configFromINI['Behaviour']['moderatedPosts'] == 1) && ($notapproved == 1))
				{
					echo "\n\t\t\t\t\t<form method=\"POST\" action=\"".$_SERVER['PHP_SELF']."\"><input type=\"hidden\" name=\"whichpost\" value=\"$postnumber\"><input type=\"hidden\" name=\"posttime\" value=\"$posttime\"><input type=\"submit\" value=\"".$languageStrings['AdminApprove']."\" name=\"approve\" class=\"deleteButton\"></form>";
				}
			}
			echo "\n\t\t\t\t</td>\n\t\t\t\t<td class=\"postbottomright\" valign=\"top\">";
			echo "\n\t\t\t\t\t".recreateUserInput($message)."\t\t\t\t</td>\n\t\t\t</tr>\n";
		}
		elseif ($configFromINI['Behaviour']['tableLayout'] == "simple")
		{
			// first line of post: dark background, "nickname, "homepage, "email", "date, time"
			echo "\t\t\t<tr class=\"layouttr\">\n\t\t\t\t<td class=\"posttop\" valign=\"top\">";
			echo "\n\t\t\t\t\t<span class=\"nickname\"><a name=\"post$postnumber1\" href=\"".$_SERVER['PHP_SELF']."?post=$postnumber1#post$postnumber1\" class=\"navigation\">$postnumber1</a>.&nbsp;$nickname</span>";
			if ($email != "")	{
				echo "&nbsp;&nbsp;<a href=\"mailto:".$email."\">$emailIcon</a>";
				if ($homepage == "")	{
					echo "&nbsp;";
				}
			}
			if ($homepage != "")	{
				if ($email == "")	{
					echo "&nbsp;&nbsp;";
				}
				echo "&nbsp;<a href=\"$homepage\"".$externalLinksTargetCode.">$homepageIcon</a>&nbsp;";
			}
			echo "<br>\n\t\t\t\t\t<span class=\"simpleDateandtime\">".date(getTimeFormat(), $posttime);
			// show ip for admin
			if( $adminmode == 1 && $ip != '' ) {
				echo ",&nbsp;IP:&nbsp;$ip";
			}
			// custom fields get displayed here
			for ($field = 0; $field < count($customFieldNames); $field++)
				if ($customFields[$field])
					echo ",&nbsp;".$customFieldNames[$field].":&nbsp;".$customFields[$field];
			echo "</span>\n\t\t\t\t</td>\n\t\t\t</tr>\n";
			// second line of post: light background: "message"
			echo "\t\t\t<tr>\n\t\t\t\t<td class=\"postbottom\" valign=\"top\">";
			echo "\n\t\t\t\t\t".recreateUserInput($message);
			// displaying button to delete the entry if logged in as admin
			if ($adminmode == 1 && $postnumber >= 0) {
				echo "\t\t\t\t\t\t<form method=\"POST\" action=\"".$_SERVER['PHP_SELF']."\"><input type=\"hidden\" name=\"whichpost\" value=\"".$postnumber."\"><input type=\"hidden\" name=\"posttime\" value=\"$posttime\"><input type=\"submit\" value=\"".$languageStrings['AdminDelete']."\" name=\"delete\" class=\"deleteButton\"></form>";
				echo "\n\t\t\t\t\t<form method=\"POST\" action=\"".$_SERVER['PHP_SELF']."\"><input type=\"hidden\" name=\"whichpost\" value=\"".$postnumber."\"><input type=\"hidden\" name=\"posttime\" value=\"$posttime\"><input type=\"submit\" value=\"".$languageStrings['AdminEdit']."\" name=\"edit\" class=\"deleteButton\"></form>";
				if (($configFromINI['Behaviour']['moderatedPosts'] == 1) && (substr($gbentryline, 0, 4) == "----"))
				{
					echo "\n\t\t\t\t\t<form method=\"POST\" action=\"".$_SERVER['PHP_SELF']."\"><input type=\"hidden\" name=\"whichpost\" value=\"".$postnumber."\"><input type=\"hidden\" name=\"posttime\" value=\"$posttime\"><input type=\"submit\" value=\"".$languageStrings['AdminApprove']."\" name=\"approve\" class=\"deleteButton\"></form>";
				}
			}
			echo "\n\t\t\t\t</td>\n\t\t\t</tr>\n";
		}
	}


	// called when displaying posts on more than one page
	// adds the page navigation that looks like "< [1] 2 3 >"
	function displayPostNavigation($numberofposts, $offset)	{
		global $configFromINI;
		$entriesPerPage = $configFromINI['Behaviour']['entriesPerPage']; // NB: just for the first page
		$entriesPerHistoryPage = $configFromINI['Behaviour']['entriesPerHistoryPage'];

		if (($numberofposts > 0) && ($numberofposts > $entriesPerPage))	{
			$numberofpages = 1 + ceil(($numberofposts - $entriesPerPage) / $entriesPerHistoryPage); // one post more than entries per page -> new page
			$isFirstPage = $offset < $entriesPerPage;
			$pageoffset = $isFirstPage ? 0 : $offset - ($offset - $entriesPerPage) % $entriesPerHistoryPage;
			echo "\n\t\t<!-- navigation between the pages -->";
			echo "\n\t\t<div class=\"pageNavigation\">\n\t\t\t<p>";
			if( $offset == 0 ) echo "\n\t\t\t\t&laquo;";
			else echo "\n\t\t\t\t<a href=\"" . $_SERVER['PHP_SELF'] . "?offset=" . max($offset > $pageoffset ? $pageoffset : ($offset == $entriesPerPage ? 0 : $offset - $entriesPerHistoryPage), 0) . "\" class=\"navigation\">&laquo;</a>";
			$thispageOffset = 0;
			for ($thispage = 1; $thispage <= $numberofpages; $thispage++) {
				$thispagePosts = $thispage == 1 ? $entriesPerPage : $entriesPerHistoryPage;
				if ($offset >= $thispageOffset && $offset < $thispageOffset + $thispagePosts)
					echo "&nbsp;[" . $thispage . "]";
				else
					echo "&nbsp;<a href=\"" . $_SERVER['PHP_SELF'] . "?offset=$thispageOffset\" class=\"navigation\">$thispage</a>";
				$thispageOffset += $thispagePosts;
			}
			$pageoffset += $pageoffset == 0 ? $entriesPerPage : $entriesPerHistoryPage;
			if( $offset >= $thispageOffset - $thispagePosts ) echo "&nbsp;&raquo;\n";
			else echo "&nbsp;<a href=\"" . $_SERVER['PHP_SELF'] . "?offset=" . min($offset < $pageoffset ? $pageoffset : ($offset == 0 ? $entriesPerPage : $offset + $entriesPerHistoryPage), $numberofposts - 1) . "\" class=\"navigation\">&raquo;</a>\n";
			echo "\t\t\t</p>\n\t\t</div>\n\n";
		}
	}

	// displays the current guestbook entries
	function displayGuestbook()	{
		global $configFromINI, $languageStrings, $adminmode;

		// reading the content of the guestbook file ($guestbookFile) and creating an array ($content) out of it
		//
		// if the file does not exist, create it for further use
		if (!file_exists($configFromINI['Files']['guestbookFile']))	{
			touch($configFromINI['Files']['guestbookFile']);
		}
		$content = file($configFromINI['Files']['guestbookFile']);
		$numberofposts = count($content);

		$entriesPerPage = $configFromINI['Behaviour']['entriesPerPage']; // NB: just for the first page
		$entriesPerHistoryPage = $configFromINI['Behaviour']['entriesPerHistoryPage'];
		$newestFirst = $configFromINI['Behaviour']['displayNewestFirst'] == "1";

		// prepare the check whether whole guestbook or current entry is empty (either if it is the last or if there accidentally got an empty line into the database file)
		$emptyCounter = 0;
		$moderatedCounter = 0;
		for ($emptyCounting = 0; $emptyCounting < $numberofposts; $emptyCounting++)
		{
			if ((trim($content[$emptyCounting])) == "" )
				$emptyCounter++;
			elseif (($configFromINI['Behaviour']['moderatedPosts'] == 1) && (substr($content[$emptyCounting], 0, 4) == "----") && $adminmode == 0)
				$moderatedCounter++;
		}
		$postcount = $numberofposts - $emptyCounter - $moderatedCounter;

		// checking if we are displaying posts starting with the first one or if we start somewhere else when using multiple pages
		$offset = isset($_GET["offset"]) ? $_GET["offset"] : 0;
		if( $offset == 0 && isset($_GET['post']) && $entriesPerPage != 0 ) {
			$postn = !$newestFirst ? $_GET['post'] - 1 : $postcount - $_GET['post'];
			if( $postn < 1 ) $postn = 1; elseif( $postn > $postcount) $postn = $postcount;
			$offset = $postn < $entriesPerPage ? 0 : $postn - ($postn - $entriesPerPage) % $entriesPerHistoryPage;
		}
		if( $offset < 0 ) $offset = 0; elseif( $offset >= $postcount) $offset = $postcount - 1;
		$postsOnPage = $offset < $entriesPerPage ? $entriesPerPage : $entriesPerHistoryPage;

		// displaying the total number of posts in the guestbook if wanted
		if( $postcount == 0 )
			echo "\t\t<div id=\"totalnumber\">\n\t\t\t<p>\n\t\t\t\t".$languageStrings['GuestbookIsEmpty']. "\n\t\t\t</p>\n\t\t</div>\n";
		elseif ($configFromINI['Behaviour']['showTotalNumber'] == 1 ) {
			$lastpost = !$newestFirst ? $postcount : 1;
			$lastpage = $entriesPerPage == 0 || $postcount <= $entriesPerPage ? 0 : $postcount - 1 - ($postcount - 1 - $entriesPerPage) % $entriesPerHistoryPage;
			echo "\n\t\t<!-- displaying the total number of posts in the guestbook -->\n";
			echo "\t\t<div id=\"totalnumber\">\n\t\t\t<p>\n\t\t\t\t".$languageStrings['TotalNumberOfPosts']."<a href=\"".$_SERVER['PHP_SELF']."?offset=$lastpage#post$lastpost\">$postcount</a>\n\t\t\t</p>\n\t\t</div>\n";
		}


		// if splitting the posts onto several pages, display navigation links
		if ($entriesPerPage > 0)
			displayPostNavigation($postcount, $offset);

		// creating array out of guestbook entry
		echo "\n\t\t<!-- beginning of the display of the guestbook entries -->\n";
		echo "\n\t\t<table class=\"gbdisplay\" cellpadding=\"0\" cellspacing=\"0\">\n";


		// looping over the posts and displaying the table rows for each one
		$emptyCounter = 0;
		for ($rpostnumber = 0; $rpostnumber < $numberofposts; $rpostnumber++)	{
			$postnumber = !$newestFirst ? $rpostnumber : $numberofposts-$rpostnumber-1;
			$gbentryline = $content[$postnumber];
			$postnumber1 = !$newestFirst ? $rpostnumber - $emptyCounter + 1 : $postcount - $rpostnumber + $emptyCounter;

			// the current post might be empty
			if (trim($gbentryline) != "") {
				if ($entriesPerPage == 0 || ($entriesPerPage != 0 && $rpostnumber-$emptyCounter >= $offset && $rpostnumber-$emptyCounter < $offset + $postsOnPage)) {
					// checking to see whether post need to be approved and if this one is approved
					if (($configFromINI['Behaviour']['moderatedPosts'] == 1) && (substr($gbentryline, 0, 4) == "----") && $adminmode == 0)
					{
						// this post has not yet been approved by the moderator
						$emptyCounter++;
						continue;
					}
					// if we are here, we can display the current post
					// creating an array of each line in the guestbook file
					$gbentry = split($configFromINI['General']['delimiter'], $gbentryline);

					echo "\n\t\t\t<!-- post number $postnumber1 -->\n";
					if (($configFromINI['Behaviour']['moderatedPosts'] == 1) && (substr($gbentryline, 0, 4) == "----"))
						$nickname = recreateUserInput(substr($gbentry[0], 4));
					else
						$nickname = recreateUserInput($gbentry[0]);

					$customFields = array();
					for( $i = 6; $i < count($gbentry); $i++ )
						$customFields[$i-6] = recreateUserInput($gbentry[$i]);

					displayGuestbookPost($postnumber, $postnumber1, $nickname,
						$gbentry[1], $gbentry[2], $gbentry[3], $gbentry[4], $gbentry[5],
						$customFields, substr($gbentryline, 0, 4) == "----" ? 1 : 0);
				}
			} else
				$emptyCounter++;
		}
		echo "\t\t</table>\n";

		// if splitting the posts onto several pages, display navigation links
		if ($entriesPerPage > 0)
			displayPostNavigation($postcount, $offset);
	}


	// displays the current guestbook entries
	function displayRSS()	{
		global $configFromINI, $languageStrings, $adminmode;

		echo "<?xml version=\"1.0\" encoding=\"".getCharset()."\"?>\n";
		echo "<rss version=\"2.0\">\n";
		echo "<channel>\n";
		echo "\t<title>".$configFromINI['General']['gbName']."</title>\n";
		echo "\t<link>http://".$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']."</link>\n";
		echo "\t<description></description>\n";
		echo "\t<ttl>5</ttl>\n\n";

		$content = file($configFromINI['Files']['guestbookFile']);
		$numberofposts = count($content);
		$postcount = $numberofposts;
		for ($emptyCounting = 0; $emptyCounting < $numberofposts; $emptyCounting++)
		{
			if ((trim($content[$emptyCounting])) == "" )
				$postcount--;
			elseif (($configFromINI['Behaviour']['moderatedPosts'] == 1) && (substr($content[$emptyCounting], 0, 4) == "----") && $adminmode == 0)
				$postcount--;
		}

		$emptyCounter = 0;
		for ($rpostnumber = 0; $rpostnumber < $numberofposts; $rpostnumber++)	{
			$postnumber = $numberofposts-$rpostnumber-1;
			$gbentryline = $content[$postnumber];
			$postnumber1 = $postcount - $rpostnumber + $emptyCounter;

			// the current post might be empty
			if (trim($gbentryline) != "") {
				if ($rpostnumber-$emptyCounter >= $configFromINI['Behaviour']['entriesInRSS'])
					continue;

				// checking to see whether post need to be approved and if this one is approved
				if ($configFromINI['Behaviour']['moderatedPosts'] == 1 && substr($gbentryline, 0, 4) == "----")
				{
					// this post has not yet been approved by the moderator
					$emptyCounter++;
					continue;
				}
				// if we are here, we can display the current post
				// creating an array of each line in the guestbook file
				$gbentry = split($configFromINI['General']['delimiter'], $gbentryline);

				$nickname = recreateUserInput($gbentry[0]);
				$customFields = array();
				for( $i = 6; $i < count($gbentry); $i++ )
					$customFields[$i-6] = recreateUserInput($gbentry[$i]);

				echo "\t<item>\n";
				echo "\t\t<title>$postnumber1. ".htmlentities($nickname, ENT_QUOTES, getDBCharset())."</title>\n";
				echo "\t\t<link>http://".$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']."?post=$postnumber1#post$postnumber1</link>\n";
				echo "\t\t<pubDate>".date("r", $gbentry[3])."</pubDate>\n";
				echo "\t\t<description>".htmlentities(recreateUserInput(trim($gbentry[5])), ENT_QUOTES, getDBCharset())."</description>\n";
				echo "\t</item>\n";
			} else
				$emptyCounter++;
		}

		echo "</channel>\n";
		echo "</rss>\n";
	}


	// display redirect message
	function redirectWithMessage($message)
	{
		global $configFromINI, $languageStrings;

		$refresh = $configFromINI['Behaviour']['refreshWaitingTime'];
		if( $refresh <= 0 )
			header('Location: '.$_SERVER['HTTP_ROOT'].$_SERVER['PHP_SELF']);
		else {
			header("Refresh: $refresh; url= ".$_SERVER["PHP_SELF"]);
			displayHTMLHeader();
			echo "\t\t<h1>\n\t\t\t".$configFromINI['General']['gbName']."\n\t\t</h1>\n\t\t<div class=\"gbinputarea\">\n";
			echo "\t\t\t<p>".$languageStrings[$message]."</p>\n";
			echo "\t\t\t<p>" . $languageStrings['YouWillBeTaken1'] . $refresh . $languageStrings['YouWillBeTaken2'] . "</p>\n";
			echo "\t\t\t<a href=\"" . $_SERVER["PHP_SELF"] . "\">" . $languageStrings['ClickInsteadOfWaiting'] . "</a>\n\t\t</div>";
			displayHTMLFooter();
		}
		die;
	}


	// writes the guestbook data back to the file after editing or such
	function writeGuestbookToDB($modifiedGuestbookArray)
	{
		global $configFromINI;
		$bookInputStream = fopen($configFromINI['Files']['guestbookFile'], "w");
		fseek($bookInputStream, 0);
		foreach ($modifiedGuestbookArray as $guestbookEntry)
		{
			fwrite($bookInputStream, trim($guestbookEntry)."\n");
		}
		fclose($bookInputStream);
	}


	function checkForBannedWords($stringToAnalyze)
	{
		global $configFromINI, $languageStrings, $bannedWords;
		$messagearray = preg_split('/\W/', $stringToAnalyze, -1, PREG_SPLIT_NO_EMPTY);
		for ($i=0; $i < count($messagearray); $i++)
			{		$messagearray[$i] = strtolower(trim($messagearray[$i]));		}
		for ($i=0; $i < count($bannedWords); $i++)
			{		$bannedWords[$i] = strtolower(trim($bannedWords[$i]));		}

		if (array_intersect($messagearray, $bannedWords))
			redirectWithMessage('PostRejectedBannedWords');
	}

	function displayInputFormArea($top) {
		global $configFromINI, $languageStrings;
		$separateViewFromSign = $configFromINI['Behaviour']['separateViewFromSign'] == "1";
		$alternateSignLink = $configFromINI['Behaviour']['alternateSignLink'] == "1";
		$bottom = $top ? '0' : '1';
		$top = $top ? '1' : '0';

		if ($configFromINI['General']['readOnly'] != "1" && ($configFromINI['Behaviour']['signAfterView'] == $bottom || $alternateSignLink)) {
			if( $bottom == '1' )
				echo "\t\t<!-- html input form for guestbook -->\n\t\t<div class=\"gbinputarea\">\n\t\t\t";

			// all the "if ((separateViewFromSign == 1) ... etc make sure the right parts are displayed according to the mode:
			// either everything on one page, but no links, or either the form fields or the old entries together with navigation links ("Click to view" or "Click to sign").
			if (!isset($_GET['signgb']) && ($separateViewFromSign
				|| ($configFromINI['Behaviour']['signAfterView'] == $top && $alternateSignLink))) {
				$link = !$separateViewFromSign ? "#inputform" : $_SERVER['PHP_SELF']."?signgb=1";
				echo "<p align=\"center\"><a href=\"$link\">".$languageStrings['ClickHereToSign']."</a></p>";
			}

			if ($configFromINI['Behaviour']['signAfterView'] == $bottom)
			// calling the function which displays the long form with the input text fields and buttons
			// parameters are empty here, they are used for the preview page so that the fields can be filled with already submitted values
			if ((isset($_GET['signgb']) && ($_GET['signgb'] == 1)) || !$separateViewFromSign) {
				echo "\t\t<a name=\"inputform\"></a>\n";
				displayEmptyInputForm();
			}

			if( $bottom == '1' )
				echo "\n\t\t</div>\n";
		}
	}


	///////////////////////////////////////////////////////////////////////
	//                    MAIN BODY OF THE SCRIPT                        //
	///////////////////////////////////////////////////////////////////////


	// FIRST: Are we admin? This is needed for e.g. deleting and configuring. *****************************************************************************************************

	// checking if LOGGING INTO admin mode, setting the appropriate PHP session variables
	$adminhash = md5($adminpassword);
	if (isset($_POST["Login"]) && ($_POST["adminuser"] == $adminusername) && ($_POST["adminpass"] == $adminpassword))	{
		$adminmode = 1;
		if ($configFromINI['General']['useCookies'] == "1")	{
			setcookie('adminmode', $adminhash);
		}
		else	{
			// using PHP sessions if useCookies = 0
			session_register('adminmode');
			$_SESSION['adminmode'] = $adminhash;
		}
	}

	// CHECK IF ALREADY in admin mode via cookies or PHP session
	if ($configFromINI['General']['useCookies'] == "1")	{
		if ((isset($_COOKIE['adminmode'])) && ($_COOKIE['adminmode'] == $adminhash))	{
			$adminmode = 1;
		}
	}

	elseif ($configFromINI['General']['useCookies'] == "0")	{
		if ((isset($_SESSION['adminmode'])) && ($_SESSION['adminmode'] == $adminhash))	{
			$adminmode = 1;
		}
	}

	// LOGGING OUT of admin mode and destroying the associated cookie or PHP session
	if (isset($_GET['logout']))	{
		$adminmode = 0;
		if ($configFromINI['General']['useCookies'] == "1")	{
			setcookie('adminmode');
		}
		elseif ($configFromINI['General']['useCookies'] == "0")	{
			session_unset();
			session_destroy();
		}
	}
		
	// SECOND all the special cases: previewing, submitting, logging in as admin ************************************************


	// previewing and submitting a post, checking if all fields required were filled in
	if ((isset($_POST['preview'])) || isset($_POST['submit']))	{
		if ($adminmode == 0 && $configFromINI['General']['readOnly'] == "1")
			redirectWithMessage('ReadOnlyMode');

		// set the strings
		$Nickname = safeHTML($_POST["NickName"]);
		$Emailaddress = safeHTML($_POST["EmailAddress"]);
		$messageString = safeHTML($_POST["Message"]);

		if (($_POST["Homepage"] == "http://") || ($_POST["Homepage"]) == "")	{
			$Homepage = "";
		}
		else	{
			$Homepage = safeHTML($_POST["Homepage"]);
		}
		for ($field = 0; $field < count($customFieldNames); $field++)
			$customFields[$field] = safeHTML($_POST['customField'.$field]);

		if ($adminmode == 0 && $configFromINI['General']['useAntiSpam'] == "1" && isset($_POST["submit"]))
		{
			// ANTISPAM
			session_start();
			$digit = $_SESSION['digit'];
			$userdigit = $_POST['userdigit'];
			unset($_SESSION['digit']);
			$spam = ($digit == $userdigit) && ($digit > 1) ? 1 : 0;
		} else
			$spam = 1;
		
		if (($Nickname == "") && ($configFromINI['General']['allowAnonymous'] == "1")) {
			$Nickname = $languageStrings['Anonymous'];
		}

		$linksCount = preg_match_all('/http:\/\//', $messageString, $nevermind);

		// check omitted required fields
		$forgotten = '';
		if( $Nickname == "" )
			$forgotten .= 'n';
		if( $messageString == "" )
			$forgotten .= 'm';
		if( $spam == 0 )
			$forgotten .= 's';
		if( $adminmode == 0 && $linksCount > $configFromINI['General']['maxLinksPerPost'] )
			$forgotten .= 'l';

		// banned words in nickname or message?
		if ($configFromINI['Behaviour']['wordFilter'] == "1")
		{
			checkForBannedWords(unsafeHTML($messageString));
			checkForBannedWords(unsafeHTML($Nickname));
			checkForBannedWords(unsafeHTML($Homepage));
			checkForBannedWords(unsafeHTML($Emailaddress));
			for ($field = 0; $field < count($customFieldNames); $field++)
				checkForBannedWords(unsafeHTML($customFields[$field]));
		}

		if ((isset($_POST["submit"]) && ($forgotten != "")) || (isset($_POST["preview"])))
		{
			$messageString = preg_replace('/\[\[comment\]\]/','[[ comment ]]',$messageString);
			if( isset($_POST["Comment"]) && $_POST['Comment'] != '' )
				$messageString .= "[[comment]]".safeHTML($_POST["Comment"])."[[/comment]]";

			$Nickname = safehtmlentities($_POST['NickName']);
			$Emailaddress = safehtmlentities($_POST["EmailAddress"]);
			for ($field = 0; $field < count($customFieldNames); $field++)
				$customFields[$field] = safehtmlentities($_POST['customField'.$field]);

			// displaying the single entry with the new data
			displayHTMLHeader();
			
			if ($forgotten != "")	{
				if( $forgotten != 'l' || !isset($languageStrings['TooManyLinks']) )
					echo "\t\t<h1>".$configFromINI['General']['gbName']." &mdash; ".$languageStrings['IncompletePost']."</h1>";
				else
					echo "\t\t<h1>".$configFromINI['General']['gbName']." &mdash; ".$languageStrings['TooManyLinks']."</h1>";
			}

			if ($forgotten == "")
			{
				echo "\t\t<h1>".$configFromINI['General']['gbName']." &mdash; ". $languageStrings['PreviewPost']."</h1>";
				echo "\t\t<table class=\"gbdisplay\" cellpadding=\"0\" cellspacing=\"0\">\n";
				displayGuestbookPost(-1, 0, $Nickname, $Emailaddress, $Homepage,
					time()+($configFromINI['Behaviour']['timeOffsetOnSave']*3600), '',
					$messageString, $customFields, 0);
				echo "\t\t</table>\n\t\t<p>&nbsp;</p>\n";
			}

			// administrator comment
			$Message = isset($_POST["Message"]) ? $_POST['Message'] : "";
			$Message = preg_replace('/\[\[comment\]\]/','[[ comment ]]',$Message);
			if( isset($_POST["Comment"]) && $_POST['Comment'] != '' )
				$Message .= "[[comment]]".$_POST["Comment"]."[[/comment]]";

			// displaying the form fields with the data inserted, too
			echo "\t\t<div class=\"gbinputarea\">";
			displayInputForm($Nickname, $Emailaddress, $Homepage, $Message, $forgotten, $customFields);
			echo "\n\t\t</div>";
		}

		// new post is being submitted and nothing was omitted
		elseif (isset($_POST["submit"]) && ($forgotten == ""))	{
			// IP address: real unless trackUserIP is set to 0, then "0.0.0.0"
			if ($configFromINI['Behaviour']['trackUserIP'] == "1")	{
				$userIP = $_SERVER['REMOTE_ADDR'];
			}
			else	{
				$userIP = "0.0.0.0";
			}

			// protection from double posting
			$content = file($configFromINI['Files']['guestbookFile']);
			$lastentry = count($content) == 0 ? array('','','','','','') : split($configFromINI['General']['delimiter'], $content[count($content)-1]);
			if( count($content) == 0 || count($lastentry) < 6 || ($lastentry[4].trim($lastentry[5])) != ($userIP.trim($messageString)) ) {

			if( preg_match('/:$/', $Nickname) ) $Nickname .= ' ';
			if( preg_match('/:$/', $Emailaddress) ) $Emailaddress .= ' ';
			if( preg_match('/:$/', $Homepage) ) $Homepage .= ' ';
			if( preg_match('/:$/', $messageString) ) $messageString .= ' ';

			$newguestbookline = $Nickname.$configFromINI['General']['delimiter'].$Emailaddress.$configFromINI['General']['delimiter'].$Homepage.$configFromINI['General']['delimiter'].(time()+($configFromINI['Behaviour']['timeOffsetOnSave']*3600)).$configFromINI['General']['delimiter'].$userIP.$configFromINI['General']['delimiter'].$messageString;
			for ($field = 0; $field < count($customFieldNames); $field++)
				$newguestbookline .= $configFromINI['General']['delimiter'].$customFields[$field];

			if ($configFromINI['Behaviour']['moderatedPosts'] == "1")
			{
				$newguestbookline = "----" . $newguestbookline;
			}

			$newguestbookline .= "\n";

			// adding the stuff to the guestbook file (simply adding a new line at the end due to design of the data structure)
			$bookInputStream = fopen($configFromINI['Files']['guestbookFile'], "a");
			fwrite($bookInputStream, $newguestbookline);
			fclose($bookInputStream);

			// email notification
			// if run on a Windows server or else desired, override SMTP setting from php.ini
			if ($configFromINI['Email']['sendEmail'] == "1")	{
				if ((strpos(PHP_OS, "WIN") >= 0)	|| ($configFromINI['Email']['overrideLocalhost'] == "1"))	{
					ini_set("SMTP", $configFromINI['Email']['SMTP']);
					ini_set("sendmail_from", $configFromINI['Email']['fromAddress']);
				}
				mail($configFromINI['Email']['toAddress'], "flatPHPbook: ".$languageStrings['NewPost'], $Nickname.$languageStrings['EmailNewPost'], "From: ".$configFromINI['Email']['fromAddress']."\r\nX-Mailer: PHP/".phpversion());
			}
			}

			// save nickname to cookies
			if ($configFromINI['General']['useCookies'] == "1")	{
				setcookie('nickname', $_POST['NickName'], $cookieExpireTime);
			}

			redirectWithMessage('ThanksForPosting');
		}
		displayHTMLFooter();
		die;
	}


	// DELETING an entry
	if (isset($_POST['delete']) && ($adminmode == 1))	{
		// obviously, a post is to be deleted

		// need to load the database file, build an array, remove the corresponding field, and write the array back to the database file
		$content = file($configFromINI['Files']['guestbookFile']);
		$posttobedeleted = $_POST["whichpost"];
//		$posttobedeleted = count($content) - $_POST["whichpost"] - 1;
		// preparing the double-checking: need to read the posttime filed from the database later on
		$gbentry = split($configFromINI['General']['delimiter'], $content[$posttobedeleted]);

		// double-checking: the post number and time the post was made have to be correct
		// if someone posts between clicking the Delete button and the reloading of the page
		// the post numbers are screwed - in that case, nothing will be deleted
		if ($_POST["posttime"] == $gbentry[3])	{
			// now, $content is our array, need to remove the appropriate one
			$index_nb_elements = count($content) - 1;
			switch($posttobedeleted)
			{
				case 0:
					$content = array_slice($content, 1);
					break;
				case $index_nb_elements:
					$content = array_slice($content, 0, -1);
					break;
				default:
					$array_start = array_slice($content, 0, $posttobedeleted);
					$array_end = array_slice($content, $posttobedeleted + 1);
					$content = array_merge ($array_start, $array_end);
					break;
			}
			writeGuestbookToDB($content);
			redirectWithMessage('SavedSuccessfully');
		}
	}


	// APPROVING of a post
	if (isset($_POST['approve']) && ($adminmode == 1))
	{
		// need to find the post in the database
		$content = file($configFromINI['Files']['guestbookFile']);
		$posttobeapproved = $_POST["whichpost"];
//		$posttobeapproved = count($content) - $_POST["whichpost"] - 1;

		// preparing the double-checking: need to read the posttime filed from the database later on
		$gbentry = split($configFromINI['General']['delimiter'], $content[$posttobeapproved]);

		if ($_POST["posttime"] == $gbentry[3])
		{
			switch($posttobeapproved)
			{
				case 0:
					$array_start;
					$array_end = array_slice($content, 1);
					break;
				case $index_nb_elements:
					$array_start = array_slice($content, 0, -1);
					$array_end;
					break;
				default:
					$array_start = array_slice($content, 0, $posttobeapproved);
					$array_end = array_slice($content, $posttobeapproved + 1);
					break;
			}
			if (substr($gbentry[0], 0, 4) == "----")
			{
				$approvedNickname = substr(trim($gbentry[0]), 4);
			}
			else
			{
				$approvedNickname = trim($gbentry[0]);
			}
			$approvedPost = $approvedNickname . $configFromINI['General']['delimiter'] . trim($gbentry[1]);
			$approvedPost .= $configFromINI['General']['delimiter'] . trim($gbentry[2]) . $configFromINI['General']['delimiter'] . trim($gbentry[3]);
			$approvedPost .= $configFromINI['General']['delimiter'] . trim($gbentry[4]) . $configFromINI['General']['delimiter'] . trim($gbentry[5]);
			for ($field = 0; $field < count($customFieldNames); $field++)
				$approvedPost .= $configFromINI['General']['delimiter'].trim($gbentry[6 + $field]);
			$content = array_merge($array_start, (array)$approvedPost, $array_end);
		}
		writeGuestbookToDB($content);
		redirectWithMessage('SavedSuccessfully');
	}


	// if the Edit button is pressed, a new page is displayed that contains the input form fields again
	// filled with the appropriate entries from the post, plus a "comment" field.
	// The text in the comment field later gets appended to the message body, though formatted.
	if (isset($_POST['edit']) && ($adminmode == 1))	{
		// getting the values to fill into the fields, these are the old parts of the post
		$content = file($configFromINI['Files']['guestbookFile']);
		$postToBeEdited = $_POST["whichpost"];
//		$postToBeEdited = count($content) - $_POST["whichpost"] - 1;
		$gbentry = split($configFromINI['General']['delimiter'], $content[$postToBeEdited]);

		$customFields = array();
		for ($field = 0; $field < count($customFieldNames); $field++)
			$customFields[$field] = unsafeHTML($gbentry[6 + $field]);

		displayHTMLHeader();
		echo "\t\t<h1>".$configFromINI['General']['gbName']." &mdash; ". $languageStrings['EditPost']."</h1>";
		echo "\t\t<div class=\"gbinputarea\">";
		displayInputForm(unsafeHTML($gbentry[0]), $gbentry[1], $gbentry[2], unsafeHTML($gbentry[5]), '', $customFields);
		echo "\n\t\t\t</div>\n";
		displayHTMLFooter();
		die;
	}

	if (isset($_POST['edited']) && ($adminmode == 1))	{
		$content = file($configFromINI['Files']['guestbookFile']);
		$postToBeEdited = $_POST["whichpost"];

		// preparing the double-checking: need to read the posttime filed from the database later on
		$gbentry = split($configFromINI['General']['delimiter'], $content[$postToBeEdited]);

		// double-checking: the post number and time the post was made have to be correct
		// if someone posts between clicking the Edit button and the reloading of the page
		// the post numbers are screwed - in that case, nothing will be edited
		if ($_POST["posttime"] == $gbentry[3])	{
			// now, $content is our array, need to create new variables:
			// one holding all possible entries before the one being edited, one holding those after, and the post being edited itself
			$index_nb_elements = count($content) - 1;
			switch($postToBeEdited)
			{
				case 0:
					$array_start = array();
					$array_end = array_slice($content, 1);
					break;
				case $index_nb_elements:
					$array_start = array_slice($content, 0, -1);
					$array_end = array();
					break;
				default:
					$array_start = array_slice($content, 0, $postToBeEdited);
					$array_end = array_slice($content, $postToBeEdited + 1);
					break;
			}
		}
		if (($_POST["Homepage"] == "http://") || ($_POST["Homepage"]) == "")	{
			$Homepage = "";
		}
		else	{
			$Homepage = safeHTML($_POST["Homepage"]);
		}

		if ($_POST["Comment"] != "")
		{
			$Comment = "[[comment]]".safeHTML($_POST["Comment"])."[[/comment]]";
		}
		else
		{
			$Comment = "";
		}

		$editedPost = safeHTML($_POST["NickName"]).$configFromINI['General']['delimiter'].safeHTML($_POST["EmailAddress"]).$configFromINI['General']['delimiter'].$Homepage.$configFromINI['General']['delimiter'];
		$editedPost .= $gbentry[3].$configFromINI['General']['delimiter'].$gbentry[4].$configFromINI['General']['delimiter'].safeHTML($_POST["Message"]).$Comment;
		for ($field = 0; $field < count($customFieldNames); $field++)
			$editedPost .= $configFromINI['General']['delimiter'].safeHTML($_POST['customField'.$field]);
		$content = array_merge($array_start, (array)$editedPost, $array_end);
		writeGuestbookToDB($content);
		redirectWithMessage('SavedSuccessfully');
	}


	// the admin mode login, displaying a form field for entering username and passwort,
	// then directing the user to the admin mode guestbook
	if (isset($_GET["adminlogin"]))
	{
		displayHTMLHeader();
		echo "\t\t<h1>".$configFromINI['General']['gbName']." &mdash; ".$languageStrings['AdminTitle']."</h1>\n";
		echo "\t\t<div class=\"gbinputarea\">\n";
		echo "\t\t\t<form method=\"POST\" action=\"".$_SERVER['PHP_SELF']."\">\n";
		echo "\t\t\t\t<table>\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>".$languageStrings['AdminUserName'].":</td>\n\t\t\t\t\t\t<td><input type=\"text\" name=\"adminuser\"></td>\n\t\t\t\t\t</tr>\n";
		echo "\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>".$languageStrings['AdminPassword'].":</td>\n\t\t\t\t\t\t<td><input type=\"password\" name=\"adminpass\"></td>\n\t\t\t\t\t</tr>\n";
		echo "\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>\n\n\t\t\t\t\t\t\t<input type=\"submit\" name=\"Login\" value=\"".$languageStrings['AdminLogin']."\">\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n";
		echo "\t\t\t</form>\n\t\t</div>\n";
		displayHTMLFooter();
		die();
	}

	// CONFIGURATION - displaying the page with the web interface for editing the INI values
	if (isset($_GET['configure']) && ($adminmode == 1))	{
		$configDesc = parse_ini_file($configFromINI['Files']['configDescFile'], true);
		displayHTMLHeader();
		echo "\t\t<h1>".$configFromINI['General']['gbName']." &mdash; ".$languageStrings['ConfigurationPage']."</h1>\n\t\t\t<div class=\"gbinputarea\">\n";
		if( !is_writable($INIfileName) )
			echo "\t\t<p style=\"color: red; font-weight: bold;\">".sprintf($languageStrings['FileIsNotWritable'], $INIfileName)."</p>\n";
		echo "\t\t\t\t<form method=\"POST\" action=\"".$_SERVER['PHP_SELF']."\">\n\t\t\t\t\t<table>";
		foreach ($configFromINI as $section => $sectionContents)	{
			echo "\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<td colspan=\"2\"><b>$section:</b></td>\n\t\t\t\t\t\t</tr>";
			foreach ($sectionContents as $key => $value)	{
				$desc = ($configDesc === false) ? '' : $configDesc[$section][$key];
				if (($key == "version") || ($key == "delimiter"))	{
					echo "\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<td>".$key.":</td>";
					echo "\n\t\t\t\t\t\t\t<td><input style=\"background-color: #f0f0f0; color: #606060;\" type=\"text\" name=\"".$key."\" value=\"".$value."\" readonly=\"readonly\" size=\"60\"></td>";
				}
				else
				{
					echo "\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<td>".$key.":</td>\n\t\t\t\t\t\t\t<td>";
					if( isset($desc) && ($desc == "1" || $desc == "0") )
						echo "<input type=\"checkbox\" name=\"".$key."\" value=\"1\" ".($value == "1" ? "checked" : "").">";
					elseif( isset($desc) && strlen($desc) > 3 && strpos($desc, ',') ) {
						$variants = split(",", $desc);
						echo "<select name=\"".$key."\">";
						foreach( $variants as $v )
							echo "<option value=\"$v\" ".(strcasecmp($value, $v) == 0 ? "selected" : "").">$v</option>";
						echo "</select>";
					} else
						echo "<input type=\"text\" name=\"".$key."\" value=\"".$value."\" size=\"60\">";
					if( $key == "guestbookFile" && is_file("charconv.php") )
						echo "&nbsp;(<a href=\"charconv.php\">conversion tool</a>)";
					echo "</td>";
				}
			}
		}
		echo "\n\t\t\t\t\t\t</tr>";
		echo "\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<td colspan=\"2\"><input type=\"submit\" name=\"saveChangesINI\" value=\"".$languageStrings['SaveChanges']."\">&nbsp;";
		echo "<input type=\"submit\" name=\"cancel\" value=\"".$languageStrings['Cancel']."\">\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t</tr>\n\t\t\t\t\t</table>\n\t\t\t\t</form>\n\t\t\t</div>\n";
		displayHTMLFooter();
		die;
	}


	// CONFIGURATION - saving the changes to the INI made via the web interface
	if ((isset($_POST['saveChangesINI'])) && ($_POST['saveChangesINI']) && ($adminmode == 1))	{
		//empty new string that will become the content of the new INI file
		$newINI = "";

		// loop over all lines in the INI file, requires double loop because it is a nested array
		$configDesc = parse_ini_file($configFromINI['Files']['configDescFile'], true);
		foreach ($configFromINI as $section => $sectionContents)	{
			if ($newINI != "")	{
				$newINI .= "\n";
			}

			$newINI .= "[".$section."]\n";

			foreach ($sectionContents as $INIkey => $INIvalue)	{
				// loop over all submitted POST variables
				$found = $INIvalue == "1" ? "0" : $INIvalue;
				foreach ($_POST as $postKey => $postValue) {
					if (strstr($INIkey, $postKey))	{
						$found = $postValue;
					}
				}
				$b = preg_match('/^[a-zA-Z0-9]*$/', $found) ? '' : '"';
				$newINI .= "$INIkey = $b$found$b\n";
			}
		}

		$INIoutputStream = fopen($INIfileName, "w");
		fwrite($INIoutputStream, $newINI);
		fclose($INIoutputStream);

		// these next to have to be re-set since the INI was just saved with new values
		$configFromINI = parse_ini_file($INIfileName, true);
		readLanguageStrings();
		redirectWithMessage('SavedSuccessfully');
	}


	// RSS
	if( isset($_GET['rss']) ) {
		displayRSS();
		die;
	}


	// now beginning the REGULAR GUESTBOOK DISPLAY ************************************************************************************************************************
	displayHTMLHeader();
	echo "\t\t<h1>".$configFromINI['General']['gbName']." ".$languageStrings['MainPage']."</h1>\n\n";
	echo "\t\t<!-- html input form for guestbook -->\n\t\t<div class=\"gbinputarea\">\n\t\t\t";
	if( !is_writable($configFromINI['Files']['guestbookFile']) )
		echo "\t\t<p style=\"color: red; font-weight: bold;\">".sprintf($languageStrings['FileIsNotWritable'], $configFromINI['Files']['guestbookFile'])."</p>\n";

	// multi-language setting
	if (($configFromINI['General']['useCookies'] == "1")&&($configFromINI['General']['useMultiLanguage'] == "1"))	{
		echo "\t\t<p>\n";
		for( $i = 1; $i <= 8; $i++ ) {
			$prefix = is_file('lang/'.$configFromINI["Language_$i"][$i.'_File']) ? 'lang/' :
				(is_file($configFromINI["Language_$i"][$i.'_File']) ? '' : '.');
			if ($prefix != '.') {
				$ltitle = isset($configFromINI["Language_$i"][$i.'_Title']) ? $configFromINI["Language_$i"][$i.'_Title'] : ucfirst(substr($configFromINI["Language_$i"][$i.'_File'],0,strpos($configFromINI["Language_$i"][$i.'_File'], '.')));
				$licon = isset($configFromINI["Language_$i"][$i.'_Icon']) ? $configFromINI["Language_$i"][$i.'_Icon'] : substr($configFromINI["Language_$i"][$i.'_File'],0,strrpos($configFromINI["Language_$i"][$i.'_File'], '.'));
				$liconlink = is_file($prefix.$licon) ? "<img src=\"$prefix$licon\" alt=\"$ltitle\" hspace=\"0\" vspace=\"2\">" : "<span class=\"langlink\">$ltitle</span>";
				echo "\t\t<a title=\"$ltitle\" href=\"".$_SERVER['PHP_SELF']."?lingua=$i\">$liconlink</a>&nbsp;&nbsp;\n";
			}
		}
		echo "\t\t</p>\n";
	}

	// this includes the content of welcomeMessage.html as if it was here in this file
	// this is useful for having your own welcome message
	$welcomeMessageFile = $configFromINI['Files']['welcomeMessage'];
	if (($configFromINI['General']['useCookies'] == "1")&&($configFromINI['General']['useMultiLanguage'] == "1"))	{	
		if (isset($lingua))	{
			// use typical welcomeMessage
			$myLan = "Language_$lingua";
			$welcomeMessageFile = $configFromINI[$myLan][$lingua . "_welcomeMsg"];
		}
	}
	if (is_file($welcomeMessageFile))
		include_once($welcomeMessageFile);
		
	displayInputFormArea(true);
	echo "\n\t\t</div>\n";

	if ($adminmode == 1)	{
		echo "\n\t\t<!-- this is the link that opens the configuration page -->";
		echo "\n\t\t<div id=\"editConfigLink\">\n\t\t\t<p align=\"center\">\n\t\t\t\t<a class=\"adminmode\" href=\"".$_SERVER['PHP_SELF']."?configure=1\">".$languageStrings['ClickToEditConfig']."</a>\n\t\t\t</p>\n\t\t</div>";
	}

	if (!isset($_GET['signgb']) || $configFromINI['Behaviour']['separateViewFromSign'] != "1")
		displayGuestbook();

	displayInputFormArea(false);

	displayAdminLinks();
	displayHTMLFooter();
?>
