/*
 * Decompiled with CFR 0.152.
 */
package com.idata.config.annotation;

import com.idata.config.annotation.ConfigElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MappingUtil<T> {
    private XPath xpath;

    public List decodeNodeList(Class<?> cls, NodeList nodes) throws Exception {
        ArrayList<T> list = new ArrayList<T>(0);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            T obj = this.decodeElemeent(cls, node);
            list.add(obj);
        }
        return list;
    }

    public T decodeElemeent(Class<?> cls, Node node) throws Exception {
        Field[] fields;
        Object obj = cls.newInstance();
        for (Field field : fields = cls.getDeclaredFields()) {
            ConfigElement element = field.getAnnotation(ConfigElement.class);
            String value = null;
            if (element.type() == 0) {
                value = this.xpath.evaluate(element.name() + "/text()", node);
            } else if (element.type() == 1) {
                value = this.xpath.evaluate("@" + element.name(), node);
            } else if (element.type() == 2) {
                NodeList children = (NodeList)this.xpath.evaluate(element.name(), node, XPathConstants.NODESET);
                this.decodeNodeList(field.getType().getComponentType(), children);
            }
            String s = field.getName().substring(0, 1);
            Method method = cls.getMethod("set" + field.getName().replaceFirst(s, s.toUpperCase()), field.getType());
            if ("".equalsIgnoreCase(value)) continue;
            if (field.getType().equals(Integer.TYPE)) {
                Integer p = Integer.valueOf(value);
                method.invoke(obj, p);
                continue;
            }
            if (field.getType().equals(String.class)) {
                method.invoke(obj, value);
                continue;
            }
            if (!field.getType().equals(Date.class)) continue;
            method.invoke(obj, Date.parse(value));
        }
        return (T)obj;
    }

    public MappingUtil(XPath xpath) {
        this.xpath = xpath;
    }

    public XPath getXpath() {
        return this.xpath;
    }

    public void setXpath(XPath xpath) {
        this.xpath = xpath;
    }
}

