/*
 * Decompiled with CFR 0.152.
 */
package com.idata.core.dataset;

import com.idata.core.dataset.DataUtil;
import com.idata.core.meta.db.DataItem;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CommDataUtil
implements DataUtil {
    protected StringReader convertReader(Reader reader) throws IOException {
        StringWriter writer = new StringWriter();
        if (reader == null) {
            return null;
        }
        char[] buffer = new char[8192];
        int c = 0;
        while (c != -1) {
            writer.write(buffer, 0, c);
            c = reader.read(buffer);
        }
        StringReader stringReader = new StringReader(writer.getBuffer().toString());
        return stringReader;
    }

    protected InputStream convertInputStream(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (in == null) {
            return null;
        }
        byte[] buffer = new byte[8192];
        int c = 0;
        while (c != -1) {
            out.write(buffer, 0, c);
            c = in.read(buffer);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(out.toByteArray());
        return bais;
    }

    @Override
    public Object getValue(ResultSet rs, DataItem item) throws SQLException, IOException {
        String name = item.getName();
        String javatype = item.getDefaultJavaTypeName();
        if ("java.io.Reader".equalsIgnoreCase(javatype)) {
            return this.convertReader(rs.getCharacterStream(name));
        }
        if ("java.io.InputStream".equalsIgnoreCase(javatype)) {
            return this.convertInputStream(rs.getBinaryStream(name));
        }
        return this.getObject(rs, javatype, name);
    }

    @Override
    public void setValue(PreparedStatement pstm, int colIndex, DataItem e, Object obj) throws SQLException {
        if (obj == null) {
            if (e.getDefaultJavaTypeName().equalsIgnoreCase("java.lang.Byte[]")) {
                pstm.setNull(colIndex, -3);
            } else {
                pstm.setNull(colIndex, 12);
            }
        } else if (obj instanceof Reader) {
            pstm.setCharacterStream(colIndex, (Reader)obj);
        } else if (obj instanceof InputStream) {
            pstm.setBinaryStream(colIndex, (InputStream)obj);
        } else {
            pstm.setObject(colIndex, obj);
        }
    }

    protected Object getObject(ResultSet rs, String className, String columnLabel) throws SQLException {
        if (rs.getObject(columnLabel) == null) {
            return null;
        }
        if ("java.sql.Date".equalsIgnoreCase(className)) {
            return rs.getDate(columnLabel);
        }
        if ("java.sql.Timestamp".equalsIgnoreCase(className)) {
            return rs.getTimestamp(columnLabel);
        }
        if ("java.lang.String".equalsIgnoreCase(className)) {
            return rs.getString(columnLabel);
        }
        if ("java.lang.Double".equalsIgnoreCase(className)) {
            return rs.getDouble(columnLabel);
        }
        if ("java.lang.Character".equalsIgnoreCase(className)) {
            return rs.getString(columnLabel);
        }
        if ("java.lang.Float".equalsIgnoreCase(className)) {
            return Float.valueOf(rs.getFloat(columnLabel));
        }
        if ("java.lang.Long".equalsIgnoreCase(className)) {
            return rs.getLong(columnLabel);
        }
        if ("java.lang.Short".equalsIgnoreCase(className)) {
            return rs.getShort(columnLabel);
        }
        if ("java.math.BigInteger".equalsIgnoreCase(className)) {
            return rs.getLong(columnLabel);
        }
        if ("java.lang.BigDecimal".equalsIgnoreCase(className)) {
            return rs.getBigDecimal(columnLabel);
        }
        if ("java.lang.Byte[]".equalsIgnoreCase(className)) {
            return rs.getBytes(columnLabel);
        }
        if ("java.lang.Byte".equalsIgnoreCase(className)) {
            return rs.getByte(columnLabel);
        }
        if ("java.lang.Boolean".equalsIgnoreCase(className)) {
            return rs.getBoolean(columnLabel);
        }
        return rs.getObject(columnLabel);
    }
}

