/*
 * Decompiled with CFR 0.152.
 */
package com.idata.core.meta.db;

import com.idata.core.dataset.DataUtil;
import com.idata.core.dataset.DataUtilFactory;
import com.idata.core.meta.db.DataItem;
import java.util.ArrayList;
import java.util.List;

public abstract class MetaData {
    protected String provider;
    protected String schema;
    protected String name;
    protected String fullName;
    protected ArrayList<DataItem> dataItems = new ArrayList(0);
    protected ArrayList<String> primaryKey = new ArrayList(0);

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<DataItem> getDataItems() {
        return this.dataItems;
    }

    public void remove(int i) {
        this.dataItems.remove(1);
    }

    public DataItem get(int i) {
        return this.dataItems.get(i);
    }

    public DataItem get(String name) {
        DataItem item = null;
        for (DataItem e : this.dataItems) {
            if (!e.getName().equalsIgnoreCase(name)) continue;
            item = e;
        }
        return item;
    }

    public void remove(String name) {
        int i = 0;
        for (i = 0; i < this.dataItems.size() && !this.dataItems.get(i).getName().equalsIgnoreCase(name); ++i) {
        }
        this.dataItems.remove(i);
    }

    public void setDataItems(ArrayList<DataItem> dataItems) {
        this.dataItems = dataItems;
    }

    public ArrayList<String> getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(ArrayList<String> primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void addPrimaryKey(String name) {
        this.primaryKey.add(name);
    }

    public void add(DataItem item) {
        this.dataItems.add(item);
    }

    public String getFullName() {
        this.fullName = this.schema == null || "".equalsIgnoreCase(this.schema) ? this.name : this.schema + "." + this.name;
        this.fullName = this.fullName.toUpperCase();
        return this.fullName;
    }

    public void setFullName(String fullname) {
        this.fullName = fullname;
    }

    public DataUtil createDataUtil() {
        return DataUtilFactory.newInstance().createDataUtil(this.provider);
    }
}

