/*
 * Decompiled with CFR 0.152.
 */
package com.idata.core.meta.db;

import com.idata.config.db.DBProvider;
import com.idata.config.db.TypeConfigException;
import com.idata.config.db.TypeConfiguration;
import com.idata.config.db.TypeConfigurationFactory;
import com.idata.core.meta.db.DataItem;
import com.idata.core.meta.db.DestinationMetaData;
import com.idata.core.meta.db.MetaData;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

public class SourceMetaData
extends MetaData {
    public DestinationMetaData createDestinationMetaData(Connection dest) throws TypeConfigException, SQLException {
        String provider = DBProvider.getProvider(dest);
        return this.createDestinationMetaData(provider);
    }

    public DestinationMetaData createDestinationMetaData(String providerName) throws TypeConfigException {
        TypeConfigurationFactory factory = TypeConfigurationFactory.createInstance();
        TypeConfiguration config = factory.readProviderConfig(providerName);
        ArrayList<DataItem> destItems = new ArrayList<DataItem>(0);
        DestinationMetaData dest = new DestinationMetaData();
        dest.setProvider(providerName);
        dest.setName(this.name);
        dest.setSchema(this.schema);
        for (DataItem item : this.dataItems) {
            destItems.add(config.convertDateType(item));
        }
        dest.setDataItems(destItems);
        return dest;
    }

    public DestinationMetaData createDestinationMetaData() throws TypeConfigException {
        return this.createDestinationMetaData(this.provider);
    }

    public int size() {
        return this.dataItems.size();
    }
}

