/*
 * Decompiled with CFR 0.152.
 */
package com.idata.db2;

import com.idata.core.meta.db.DestinationMetaData;
import com.idata.core.meta.db.SourceMetaData;
import com.idata.core.meta.db.oracle.CommonTableHelper;
import com.idata.db2.DB2Connction;
import com.idata.etl.QueryDataSource;
import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.junit.Assert;
import org.junit.Test;

public class SourceMetaDataTest
extends DB2Connction {
    @Test
    public void testDataBaseMeta() throws SQLException {
        Assert.assertEquals((Object)this.db2.getMetaData().getDatabaseProductName(), (Object)"DB2/NT");
    }

    @Test
    public void createTable() throws Exception {
        QueryDataSource qds = new QueryDataSource(this.db2, "select * from all_dbtype");
        SourceMetaData smd = qds.getSourceMetaData();
        DestinationMetaData dmd = smd.createDestinationMetaData();
        dmd.setSchema("db2admin");
        dmd.setName("target_table");
        CommonTableHelper helper = new CommonTableHelper(dmd, this.db2);
        if (helper.exist()) {
            helper.drop();
        }
        helper.create();
    }

    @Test
    public void insertData() throws SQLException {
        PreparedStatement pstm = this.db2.prepareStatement("insert into all_dbtype(smallint_col, varchar_col, vargraphic_col,real_col, long_varchar_col, long_vargraphic_col, dbclob_col, clob_col, blob_col, time_col, date_col,timestamp_col) values(?,?,?,?,?,?,?,?,?,?,?,?)");
        pstm.setShort(1, Short.valueOf("233"));
        pstm.setString(2, "varchar_col");
        byte[] bytes = new byte[]{1, 2, 3, 4, 5, 29, 99, 124, 45, 78};
        pstm.setString(3, String.valueOf(bytes));
        pstm.setDouble(4, 4875.9);
        pstm.setString(5, "long_varchar_col with string");
        StringReader gra = new StringReader("inser long_vargraphic_col via inputstream object");
        pstm.setCharacterStream(6, gra);
        StringReader reader = new StringReader("inser dbblob data with string reader");
        pstm.setCharacterStream(7, reader);
        pstm.setCharacterStream(8, reader);
        ByteArrayInputStream is = new ByteArrayInputStream("inser blob column via inputstream object".getBytes());
        pstm.setBinaryStream(9, is);
        pstm.setTime(10, new Time(System.currentTimeMillis()));
        pstm.setDate(11, new Date(System.currentTimeMillis()));
        pstm.setTimestamp(12, new Timestamp(System.currentTimeMillis()));
        pstm.executeUpdate();
    }

    @Test
    public void insertBytes() throws SQLException {
        PreparedStatement pstm = this.db2.prepareStatement("insert into all_dbtype(varchar_col, vargraphic_col) values (?,?)");
        byte[] x = new byte[]{38, 2, 2, 3, 3, 9, 127, 90};
        pstm.setBytes(1, x);
        pstm.setBytes(2, x);
        pstm.execute();
    }
}

