/*
 * Decompiled with CFR 0.152.
 */
package com.idata.etl;

import com.idata.config.db.TypeConfigException;
import com.idata.core.meta.db.SourceMetaData;
import com.idata.etl.Fetcher;
import com.idata.etl.ParseException;
import com.idata.log.IDataLogger;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class DataSource {
    protected Connection connection;
    protected SourceMetaData sourceMetaData;
    protected String catalog;
    protected String schema;
    protected String tableName;
    protected String fetchQuery;
    protected IDataLogger logger;

    public DataSource(Connection connection, String catalog, String schema, String tableName) {
        this.connection = connection;
        this.catalog = catalog;
        this.schema = schema;
        this.tableName = tableName;
    }

    public SourceMetaData getSourceMetaData() {
        return this.sourceMetaData;
    }

    protected SourceMetaData getSourceMetaData(String sql) throws SQLException, ParseException, TypeConfigException {
        if (this.sourceMetaData == null) {
            this.initMetaData();
        }
        return this.sourceMetaData;
    }

    public abstract void initMetaData() throws SQLException, ParseException, TypeConfigException;

    public abstract Fetcher createFetcher() throws SQLException, ParseException, TypeConfigException;

    public DataSource(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public String getFetchQuery() {
        return this.fetchQuery;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSourceMetaData(SourceMetaData sourceMetaData) {
        this.sourceMetaData = sourceMetaData;
    }

    public IDataLogger getIDataLogger() {
        return this.logger;
    }

    public void setIDataLogger(IDataLogger logger) {
        this.logger = logger;
    }
}

