/*
 * Decompiled with CFR 0.152.
 */
package com.idata.etl.fetcher;

import com.idata.core.dataset.TabularDataSegment;
import com.idata.core.meta.db.DataItem;
import com.idata.core.meta.db.SourceMetaData;
import com.idata.core.meta.db.oracle.CommonTableHelper;
import com.idata.etl.DataSource;
import com.idata.etl.fetcher.NativePagingFetcher;
import java.sql.SQLException;
import java.util.ArrayList;

public class FlatTablePagingFetcher
extends NativePagingFetcher {
    public FlatTablePagingFetcher(DataSource dataSource, SourceMetaData sourceMetaData) {
        super(dataSource, sourceMetaData);
    }

    @Override
    public void init() throws SQLException {
        CommonTableHelper cth = new CommonTableHelper(this.dataSource.getConnection(), this.sourceMetaData);
        this.stm = this.dataSource.getConnection().createStatement();
        String q = cth.selectScript();
        this.logger.info(q);
        this.rs = this.stm.executeQuery(q);
        this.logger.info("initialized FlatTablePagingFetcher.");
    }

    @Override
    public void close() throws SQLException {
        this.rs.close();
        this.stm.close();
    }

    @Override
    public TabularDataSegment fetch() throws Exception {
        TabularDataSegment tds = new TabularDataSegment();
        tds.setSourceMetaData(this.sourceMetaData);
        if (!this.rs.isClosed()) {
            for (int i = 0; i < 500 && this.rs.next(); ++i) {
                ArrayList<Object> rowset = new ArrayList<Object>(this.sourceMetaData.size());
                for (DataItem e : this.sourceMetaData.getDataItems()) {
                    rowset.add(this.du.getValue(this.rs, e));
                }
                tds.addRowSet(rowset);
            }
            this.logger.info("fetch TDS: " + tds + " @ rows " + tds.size());
        }
        return tds;
    }
}

