/*
 * Decompiled with CFR 0.152.
 */
package com.idata.etl.impl;

import com.idata.core.dataset.DataUtil;
import com.idata.core.dataset.TabularDataSegment;
import com.idata.core.meta.db.DataItem;
import com.idata.core.meta.db.DestinationMetaData;
import com.idata.core.meta.db.oracle.CommonTableHelper;
import com.idata.etl.Deliver;
import com.idata.etl.PreAction;
import com.idata.log.IDataLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;

public class SimpleDeliver
implements Deliver {
    protected IDataLogger logger;
    protected int deliverModel;
    protected DestinationMetaData destinationMetaData;
    protected Connection connection;
    protected DataUtil dataUtil;
    protected ArrayList<PreAction> actions = new ArrayList();
    protected ArrayList<Integer> colRef;
    protected PreparedStatement preparedStatement;

    public SimpleDeliver(DestinationMetaData destinationMetaData, Connection connection) {
        this.destinationMetaData = destinationMetaData;
        this.connection = connection;
        this.dataUtil = destinationMetaData.createDataUtil();
    }

    @Override
    public void prepare() throws Exception {
        this.connection.setAutoCommit(false);
        CommonTableHelper helper = new CommonTableHelper(this.destinationMetaData, this.connection);
        this.preparedStatement = this.connection.prepareStatement(helper.insertScript());
    }

    public void executePreActions() throws Exception {
        for (PreAction a : this.actions) {
            a.execute();
        }
    }

    @Override
    public void close() throws Exception {
        this.preparedStatement.close();
        this.connection.setAutoCommit(true);
    }

    @Override
    public void deliver(TabularDataSegment tds) throws SQLException {
        this.connection.setAutoCommit(false);
        ArrayList<Object> rowset = null;
        for (int i = 0; i < tds.getRowsets().size(); ++i) {
            rowset = tds.getRowsets().get(i);
            for (int c = 0; c < this.colRef.size(); ++c) {
                DataItem e = this.destinationMetaData.getDataItems().get(c);
                this.dataUtil.setValue(this.preparedStatement, c + 1, e, rowset.get(this.colRef.get(c)));
            }
            this.preparedStatement.executeUpdate();
        }
        this.connection.commit();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public int getDeliverModel() {
        return this.deliverModel;
    }

    public DestinationMetaData getDestinationMetaData() {
        return this.destinationMetaData;
    }

    @Override
    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setDeliverModel(int deliverModel) {
        this.deliverModel = deliverModel;
    }

    @Override
    public void setDestinationMetaData(DestinationMetaData destinationMetaData) {
        this.destinationMetaData = destinationMetaData;
    }

    @Override
    public void setDilverModel(int model) {
        this.deliverModel = model;
    }

    public DataUtil getDataUtil() {
        return this.dataUtil;
    }

    @Override
    public void setDataUtil(DataUtil dataUtil) {
        this.dataUtil = dataUtil;
    }

    @Override
    public void addPreAction(PreAction action) {
        this.actions.add(action);
    }

    public ArrayList<PreAction> getActions() {
        return this.actions;
    }

    public void setActions(ArrayList<PreAction> actions) {
        this.actions = actions;
    }

    public ArrayList<Integer> getColRef() {
        return this.colRef;
    }

    @Override
    public void setColRef(ArrayList<Integer> colRef) {
        this.colRef = colRef;
    }

    public IDataLogger getIDataLogger() {
        return this.logger;
    }

    @Override
    public void setIDataLogger(IDataLogger logger) {
        this.logger = logger;
    }
}

