/*
 * Decompiled with CFR 0.152.
 */
package com.idata.etl.impl;

import com.idata.core.dataset.TabularDataSegment;
import com.idata.core.meta.MetaDataException;
import com.idata.core.meta.db.DataItem;
import com.idata.core.meta.db.DestinationMetaData;
import com.idata.core.meta.db.oracle.CommonTableHelper;
import com.idata.etl.TransferSession;
import com.idata.etl.impl.DeliverFactory;
import com.idata.log.IDataLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SimpleTransferSession
extends TransferSession {
    private String schema;
    private String targetName;
    private String query;
    private DestinationMetaData destinationMetaData;
    private CommonTableHelper commonTableHelper;
    private long total = 0L;

    public SimpleTransferSession() {
    }

    public SimpleTransferSession(long sessionID, String sessionName) {
        super(sessionID, sessionName);
    }

    @Override
    public void execute() throws Exception {
        this.fetcher.init();
        TabularDataSegment ds = null;
        while ((ds = this.fetcher.fetch()).size() > 0) {
            this.deliver.deliver(ds);
            this.logger.info("deliver rows @ " + ds.size());
            this.total += (long)ds.size();
        }
        this.fetcher.close();
        this.deliver.close();
        this.logger.info("totally deliver rows @ " + this.total);
    }

    public void simpleExecute() throws Exception {
        this.init();
        this.validate();
        this.deliver.deliver(this.fetcher.fetch());
    }

    public String getQuery() {
        return this.query;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public DestinationMetaData getDestinationMetaData() {
        return this.destinationMetaData;
    }

    public void setDestinationMetaData(DestinationMetaData destinationMetaData) {
        this.destinationMetaData = destinationMetaData;
    }

    @Override
    public void init() throws Exception {
        this.logger = new IDataLogger(this.sessionName, this.sessionID);
        this.srcConnection = this.dataSource.getConnection();
        this.dataSource.setIDataLogger(this.logger);
        this.commonTableHelper = new CommonTableHelper(this.destinationMetaData, this.destConnection);
        this.commonTableHelper.setIDataLogger(this.logger);
        this.fetcher = this.dataSource.createFetcher();
        this.fetcher.setIDataLogger(this.logger);
        this.deliver = DeliverFactory.getInstance().createDeliver(this.destinationMetaData, this.destConnection);
        this.deliver.setIDataLogger(this.logger);
        this.deliver.setColRef(this.mapColRef());
        this.logger.info("initalized the session:" + this.sessionName + "-" + this.sessionID);
    }

    private ArrayList<Integer> mapColRef() throws MetaDataException {
        ArrayList<Integer> colRef = new ArrayList<Integer>();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List<DataItem> smdItems = this.dataSource.getSourceMetaData().getDataItems();
        for (int i = 0; i < smdItems.size(); ++i) {
            map.put(smdItems.get(i).getName(), i);
        }
        List<DataItem> dmdItems = this.destinationMetaData.getDataItems();
        for (DataItem e : dmdItems) {
            Integer i = (Integer)map.get(e.getName());
            if (i != null) {
                colRef.add(i);
                continue;
            }
            throw new MetaDataException(e);
        }
        return colRef;
    }

    @Override
    public boolean validate() throws Exception {
        if (!this.commonTableHelper.exist()) {
            this.commonTableHelper.create();
            return true;
        }
        return this.commonTableHelper.validate();
    }

    public CommonTableHelper getCommonTableHelper() {
        return this.commonTableHelper;
    }

    public void setCommonTableHelper(CommonTableHelper commonTableHelper) {
        this.commonTableHelper = commonTableHelper;
    }
}

